/*M!999999\- enable the sandbox mode */ 

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `accept_estimates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `accept_estimates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `estimate_id` int(10) unsigned NOT NULL,
  `full_name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `signature` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accept_estimates_company_id_foreign` (`company_id`),
  KEY `accept_estimates_estimate_id_foreign` (`estimate_id`),
  CONSTRAINT `accept_estimates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `accept_estimates_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accept_estimates` WRITE;
/*!40000 ALTER TABLE `accept_estimates` DISABLE KEYS */;
/*!40000 ALTER TABLE `accept_estimates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `appreciations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `appreciations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `award_id` bigint(20) unsigned NOT NULL,
  `award_to` int(10) unsigned NOT NULL,
  `award_date` date NOT NULL,
  `image` varchar(191) DEFAULT NULL,
  `summary` text DEFAULT NULL,
  `added_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `appreciations_company_id_foreign` (`company_id`),
  KEY `appreciations_award_id_foreign` (`award_id`),
  KEY `appreciations_award_to_foreign` (`award_to`),
  KEY `appreciations_added_by_foreign` (`added_by`),
  CONSTRAINT `appreciations_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_award_id_foreign` FOREIGN KEY (`award_id`) REFERENCES `awards` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_award_to_foreign` FOREIGN KEY (`award_to`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `appreciations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `appreciations` WRITE;
/*!40000 ALTER TABLE `appreciations` DISABLE KEYS */;
/*!40000 ALTER TABLE `appreciations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendance_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendance_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `auto_clock_in` enum('yes','no') NOT NULL DEFAULT 'no',
  `auto_clock_in_location` enum('office','home') NOT NULL DEFAULT 'office',
  `office_start_time` time NOT NULL,
  `office_end_time` time NOT NULL,
  `halfday_mark_time` time DEFAULT NULL,
  `late_mark_duration` tinyint(4) NOT NULL,
  `clockin_in_day` int(11) NOT NULL DEFAULT 1,
  `employee_clock_in_out` enum('yes','no') NOT NULL DEFAULT 'yes',
  `office_open_days` varchar(191) NOT NULL DEFAULT '[1,2,3,4,5]',
  `ip_address` text DEFAULT NULL,
  `radius` int(11) DEFAULT NULL,
  `radius_check` enum('yes','no') NOT NULL DEFAULT 'no',
  `ip_check` enum('yes','no') NOT NULL DEFAULT 'no',
  `alert_after` int(11) DEFAULT NULL,
  `alert_after_status` tinyint(1) NOT NULL DEFAULT 1,
  `save_current_location` tinyint(1) NOT NULL DEFAULT 0,
  `default_employee_shift` bigint(20) unsigned DEFAULT 1,
  `week_start_from` varchar(191) NOT NULL DEFAULT '1',
  `allow_shift_change` tinyint(1) NOT NULL DEFAULT 1,
  `show_clock_in_button` enum('yes','no') NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `monthly_report` tinyint(1) NOT NULL DEFAULT 0,
  `monthly_report_roles` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `attendance_settings_company_id_foreign` (`company_id`),
  KEY `attendance_settings_default_employee_shift_foreign` (`default_employee_shift`),
  CONSTRAINT `attendance_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `attendance_settings_default_employee_shift_foreign` FOREIGN KEY (`default_employee_shift`) REFERENCES `employee_shifts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendance_settings` WRITE;
/*!40000 ALTER TABLE `attendance_settings` DISABLE KEYS */;
INSERT INTO `attendance_settings` VALUES
(1,1,'no','office','09:00:00','18:00:00',NULL,20,1,'yes','[1,2,3,4,5]','[null]',NULL,'no','no',5,1,0,2,'1',1,'yes','2023-05-30 16:31:56','2023-06-02 04:06:55',0,'null');
/*!40000 ALTER TABLE `attendance_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `attendances`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `attendances` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `location_id` bigint(20) unsigned DEFAULT NULL,
  `clock_in_time` datetime NOT NULL,
  `clock_out_time` datetime DEFAULT NULL,
  `clock_in_ip` varchar(191) NOT NULL,
  `clock_out_ip` varchar(191) DEFAULT NULL,
  `working_from` varchar(191) DEFAULT 'office',
  `late` enum('yes','no') NOT NULL DEFAULT 'no',
  `half_day` enum('yes','no') NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  `shift_start_time` datetime DEFAULT NULL,
  `shift_end_time` datetime DEFAULT NULL,
  `employee_shift_id` bigint(20) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `work_from_type` enum('home','office','other') NOT NULL DEFAULT 'other',
  `overwrite_attendance` enum('yes','no') NOT NULL DEFAULT 'no',
  PRIMARY KEY (`id`),
  KEY `attendances_company_id_foreign` (`company_id`),
  KEY `attendances_user_id_foreign` (`user_id`),
  KEY `attendances_location_id_foreign` (`location_id`),
  KEY `attendances_clock_in_time_index` (`clock_in_time`),
  KEY `attendances_clock_out_time_index` (`clock_out_time`),
  KEY `attendances_added_by_foreign` (`added_by`),
  KEY `attendances_last_updated_by_foreign` (`last_updated_by`),
  KEY `attendances_employee_shift_id_foreign` (`employee_shift_id`),
  CONSTRAINT `attendances_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `attendances_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_location_id_foreign` FOREIGN KEY (`location_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `attendances_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `attendances` WRITE;
/*!40000 ALTER TABLE `attendances` DISABLE KEYS */;
INSERT INTO `attendances` VALUES
(7,1,12,1,'2025-02-24 07:00:00','2025-02-24 17:00:00','91.162.130.130','91.162.130.130',NULL,'no','no',12,12,NULL,NULL,NULL,NULL,2,NULL,NULL,'office','no');
/*!40000 ALTER TABLE `attendances` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `award_icons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `award_icons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) NOT NULL,
  `icon` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `award_icons` WRITE;
/*!40000 ALTER TABLE `award_icons` DISABLE KEYS */;
INSERT INTO `award_icons` VALUES
(1,'Trophy','trophy','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(2,'Thumbs Up','hand-thumbs-up','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(3,'Award','award','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(4,'Book','book','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(5,'Gift','gift','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(6,'Watch','watch','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(7,'Cup','cup-hot','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(8,'Puzzle','puzzle','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(9,'Plane','airplane','2023-05-30 16:31:54','2023-05-30 16:31:54'),
(10,'Money','piggy-bank','2023-05-30 16:31:54','2023-05-30 16:31:54');
/*!40000 ALTER TABLE `award_icons` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `awards`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `awards` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `award_icon_id` bigint(20) unsigned DEFAULT NULL,
  `summary` text DEFAULT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `color_code` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `awards_company_id_foreign` (`company_id`),
  KEY `awards_award_icon_id_foreign` (`award_icon_id`),
  CONSTRAINT `awards_award_icon_id_foreign` FOREIGN KEY (`award_icon_id`) REFERENCES `award_icons` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `awards_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `awards` WRITE;
/*!40000 ALTER TABLE `awards` DISABLE KEYS */;
/*!40000 ALTER TABLE `awards` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bank_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(191) DEFAULT NULL,
  `bank_name` varchar(191) DEFAULT NULL,
  `account_name` varchar(191) DEFAULT NULL,
  `account_number` varchar(191) DEFAULT NULL,
  `account_type` varchar(191) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `contact_number` varchar(191) DEFAULT NULL,
  `opening_balance` double(15,2) DEFAULT NULL,
  `bank_logo` varchar(191) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `bank_balance` double(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_accounts_company_id_foreign` (`company_id`),
  KEY `bank_accounts_currency_id_foreign` (`currency_id`),
  KEY `bank_accounts_added_by_foreign` (`added_by`),
  KEY `bank_accounts_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `bank_accounts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_accounts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bank_accounts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_accounts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_accounts` WRITE;
/*!40000 ALTER TABLE `bank_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `bank_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `bank_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `bank_account_id` int(10) unsigned DEFAULT NULL,
  `payment_id` int(10) unsigned DEFAULT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `expense_id` int(10) unsigned DEFAULT NULL,
  `amount` double(15,2) DEFAULT NULL,
  `type` enum('Cr','Dr') NOT NULL DEFAULT 'Cr',
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `memo` text DEFAULT NULL,
  `transaction_relation` varchar(191) DEFAULT NULL,
  `transaction_related_to` varchar(191) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `transaction_date` date DEFAULT NULL,
  `bank_balance` double(16,2) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_transactions_company_id_foreign` (`company_id`),
  KEY `bank_transactions_bank_account_id_foreign` (`bank_account_id`),
  KEY `bank_transactions_payment_id_foreign` (`payment_id`),
  KEY `bank_transactions_invoice_id_foreign` (`invoice_id`),
  KEY `bank_transactions_expense_id_foreign` (`expense_id`),
  KEY `bank_transactions_added_by_foreign` (`added_by`),
  KEY `bank_transactions_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `bank_transactions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_expense_id_foreign` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `bank_transactions_payment_id_foreign` FOREIGN KEY (`payment_id`) REFERENCES `payments` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `bank_transactions` WRITE;
/*!40000 ALTER TABLE `bank_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `bank_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `category_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `client_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_categories` WRITE;
/*!40000 ALTER TABLE `client_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_contacts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `contact_name` varchar(191) NOT NULL,
  `phone` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `title` varchar(191) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_contacts_company_id_foreign` (`company_id`),
  KEY `client_contacts_user_id_foreign` (`user_id`),
  KEY `client_contacts_added_by_foreign` (`added_by`),
  KEY `client_contacts_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_contacts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_contacts` WRITE;
/*!40000 ALTER TABLE `client_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `office` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `linkedin` varchar(191) DEFAULT NULL,
  `facebook` varchar(191) DEFAULT NULL,
  `twitter` varchar(191) DEFAULT NULL,
  `skype` varchar(191) DEFAULT NULL,
  `gst_number` varchar(191) DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `sub_category_id` bigint(20) unsigned DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `company_logo` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `quickbooks_client_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_details_company_id_foreign` (`company_id`),
  KEY `client_details_user_id_foreign` (`user_id`),
  KEY `client_details_category_id_foreign` (`category_id`),
  KEY `client_details_sub_category_id_foreign` (`sub_category_id`),
  KEY `client_details_added_by_foreign` (`added_by`),
  KEY `client_details_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `client_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_details_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_sub_category_id_foreign` FOREIGN KEY (`sub_category_id`) REFERENCES `client_sub_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_details` WRITE;
/*!40000 ALTER TABLE `client_details` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_docs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_docs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(200) NOT NULL,
  `filename` varchar(200) NOT NULL,
  `hashname` varchar(200) NOT NULL,
  `size` varchar(200) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_docs_company_id_foreign` (`company_id`),
  KEY `client_docs_user_id_foreign` (`user_id`),
  KEY `client_docs_added_by_foreign` (`added_by`),
  KEY `client_docs_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_docs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_docs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_docs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_docs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_docs` WRITE;
/*!40000 ALTER TABLE `client_docs` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_docs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `member_id` int(10) unsigned DEFAULT NULL,
  `is_client_show` tinyint(1) NOT NULL DEFAULT 0,
  `ask_password` tinyint(1) NOT NULL DEFAULT 0,
  `details` longtext NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_notes_company_id_foreign` (`company_id`),
  KEY `client_notes_client_id_foreign` (`client_id`),
  KEY `client_notes_member_id_foreign` (`member_id`),
  KEY `client_notes_added_by_foreign` (`added_by`),
  KEY `client_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `client_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `client_notes_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_notes` WRITE;
/*!40000 ALTER TABLE `client_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_sub_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_sub_categories` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  `category_name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_sub_categories_company_id_foreign` (`company_id`),
  KEY `client_sub_categories_category_id_foreign` (`category_id`),
  CONSTRAINT `client_sub_categories_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `client_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_sub_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_sub_categories` WRITE;
/*!40000 ALTER TABLE `client_sub_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_sub_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `client_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `client_user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `client_note_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `client_user_notes_company_id_foreign` (`company_id`),
  KEY `client_user_notes_user_id_foreign` (`user_id`),
  KEY `client_user_notes_client_note_id_foreign` (`client_note_id`),
  CONSTRAINT `client_user_notes_client_note_id_foreign` FOREIGN KEY (`client_note_id`) REFERENCES `client_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_user_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `client_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `client_user_notes` WRITE;
/*!40000 ALTER TABLE `client_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `client_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `companies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_name` varchar(191) NOT NULL,
  `app_name` varchar(191) DEFAULT NULL,
  `company_email` varchar(191) NOT NULL,
  `company_phone` varchar(191) NOT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `light_logo` varchar(191) DEFAULT NULL,
  `favicon` varchar(191) DEFAULT NULL,
  `auth_theme` enum('dark','light') NOT NULL DEFAULT 'light',
  `auth_theme_text` enum('dark','light') NOT NULL DEFAULT 'dark',
  `sidebar_logo_style` enum('square','full') NOT NULL DEFAULT 'square',
  `login_background` varchar(191) DEFAULT NULL,
  `address` text NOT NULL,
  `website` varchar(191) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `timezone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `date_format` varchar(20) NOT NULL DEFAULT 'd-m-Y',
  `date_picker_format` varchar(191) NOT NULL DEFAULT 'dd-mm-yyyy',
  `year_starts_from` varchar(191) NOT NULL DEFAULT '1',
  `moment_format` varchar(191) NOT NULL DEFAULT 'DD-MM-YYYY',
  `time_format` varchar(20) NOT NULL DEFAULT 'h:i a',
  `locale` varchar(191) NOT NULL DEFAULT 'en',
  `latitude` decimal(10,8) NOT NULL DEFAULT 26.91243360,
  `longitude` decimal(11,8) NOT NULL DEFAULT 75.78727090,
  `leaves_start_from` enum('joining_date','year_start') NOT NULL DEFAULT 'joining_date',
  `active_theme` enum('default','custom') NOT NULL DEFAULT 'default',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `google_map_key` varchar(191) DEFAULT NULL,
  `task_self` enum('yes','no') NOT NULL DEFAULT 'yes',
  `rounded_theme` tinyint(1) NOT NULL DEFAULT 1,
  `logo_background_color` varchar(191) NOT NULL DEFAULT '#ffffff',
  `header_color` varchar(191) NOT NULL DEFAULT '#1D82F5',
  `before_days` int(11) NOT NULL,
  `after_days` int(11) NOT NULL,
  `on_deadline` enum('yes','no') NOT NULL DEFAULT 'yes',
  `default_task_status` int(10) unsigned DEFAULT NULL,
  `dashboard_clock` tinyint(1) NOT NULL DEFAULT 1,
  `ticket_form_google_captcha` tinyint(1) NOT NULL DEFAULT 0,
  `lead_form_google_captcha` tinyint(1) NOT NULL DEFAULT 0,
  `taskboard_length` int(11) NOT NULL DEFAULT 10,
  `datatable_row_limit` int(11) NOT NULL DEFAULT 10,
  `allow_client_signup` tinyint(1) NOT NULL,
  `admin_client_signup_approval` tinyint(1) NOT NULL,
  `google_calendar_status` enum('active','inactive') NOT NULL DEFAULT 'inactive',
  `google_client_id` text DEFAULT NULL,
  `google_client_secret` text DEFAULT NULL,
  `google_calendar_verification_status` enum('verified','non_verified') NOT NULL DEFAULT 'non_verified',
  `google_id` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  `token` text DEFAULT NULL,
  `hash` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `rtl` tinyint(1) NOT NULL DEFAULT 0,
  `show_new_webhook_alert` tinyint(1) NOT NULL DEFAULT 0,
  `pm_type` varchar(191) DEFAULT NULL,
  `pm_last_four` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `companies_currency_id_foreign` (`currency_id`),
  KEY `companies_last_updated_by_foreign` (`last_updated_by`),
  KEY `companies_default_task_status_foreign` (`default_task_status`),
  CONSTRAINT `companies_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `companies_default_task_status_foreign` FOREIGN KEY (`default_task_status`) REFERENCES `taskboard_columns` (`id`) ON UPDATE CASCADE,
  CONSTRAINT `companies_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
INSERT INTO `companies` VALUES
(1,'Gym Lyon Métropole','Gym Lyon Métropole','contact@gymlyonmetropole.fr','04 78 24 57 46','fb8cef2332eb86b7314cd819c0218887.png','28bbefd7b818f3efac760701dfbd78c2.png','05bf54f58175f039fbb7480c28faa3fb.png','light','dark','square',NULL,'Your Company address here','https://gymlyonmetropole.fr/',3,'Europe/Paris','d-m-Y','dd-mm-yyyy','1','DD-MM-YYYY','H:i','fr',26.91243360,75.78727090,'joining_date','default','active',NULL,NULL,'yes',1,'#FFFFFF','#1D82F5',5,1,'yes',1,0,0,0,10,10,0,0,'active',NULL,NULL,'non_verified',NULL,NULL,NULL,'f630acd624acc0e69b978a66621278f2','2023-05-30 16:31:56','2024-03-03 07:03:33',NULL,0,0,NULL,NULL);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `company_addresses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `company_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `address` mediumtext NOT NULL,
  `is_default` tinyint(1) NOT NULL,
  `tax_number` varchar(191) DEFAULT NULL,
  `tax_name` varchar(191) DEFAULT NULL,
  `location` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `latitude` decimal(10,8) DEFAULT NULL,
  `longitude` decimal(11,8) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_addresses_company_id_foreign` (`company_id`),
  CONSTRAINT `company_addresses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `company_addresses` WRITE;
/*!40000 ALTER TABLE `company_addresses` DISABLE KEYS */;
INSERT INTO `company_addresses` VALUES
(1,1,'33 Rue Bossuet, 69006 Lyon',1,NULL,NULL,'Gym Lyon Métropole - LYON','2023-05-30 16:31:56','2023-06-01 09:51:40',NULL,NULL),
(2,1,'Bd du Raquin, 69680 Chassieu',0,NULL,NULL,'Gym Lyon Métropole - CHASSIEU','2023-06-01 09:52:47','2023-06-01 09:52:47',NULL,NULL);
/*!40000 ALTER TABLE `company_addresses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_discussions` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `contract_id` bigint(20) unsigned NOT NULL,
  `from` int(10) unsigned NOT NULL,
  `message` longtext NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_discussions_company_id_foreign` (`company_id`),
  KEY `contract_discussions_contract_id_foreign` (`contract_id`),
  KEY `contract_discussions_from_foreign` (`from`),
  KEY `contract_discussions_added_by_foreign` (`added_by`),
  KEY `contract_discussions_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `contract_discussions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_from_foreign` FOREIGN KEY (`from`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_discussions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_discussions` WRITE;
/*!40000 ALTER TABLE `contract_discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_discussions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `contract_id` bigint(20) unsigned NOT NULL,
  `filename` varchar(191) NOT NULL,
  `hashname` varchar(191) NOT NULL,
  `size` varchar(191) NOT NULL,
  `google_url` varchar(191) NOT NULL,
  `dropbox_link` varchar(191) NOT NULL,
  `external_link_name` varchar(191) NOT NULL,
  `external_link` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_files_company_id_foreign` (`company_id`),
  KEY `contract_files_user_id_foreign` (`user_id`),
  KEY `contract_files_contract_id_foreign` (`contract_id`),
  KEY `contract_files_added_by_foreign` (`added_by`),
  KEY `contract_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `contract_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_files_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_files` WRITE;
/*!40000 ALTER TABLE `contract_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_renews`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_renews` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `renewed_by` int(10) unsigned NOT NULL,
  `contract_id` bigint(20) unsigned NOT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_renews_company_id_foreign` (`company_id`),
  KEY `contract_renews_renewed_by_foreign` (`renewed_by`),
  KEY `contract_renews_contract_id_foreign` (`contract_id`),
  KEY `contract_renews_added_by_foreign` (`added_by`),
  KEY `contract_renews_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `contract_renews_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contract_renews_renewed_by_foreign` FOREIGN KEY (`renewed_by`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_renews` WRITE;
/*!40000 ALTER TABLE `contract_renews` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_renews` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_signs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_signs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `contract_id` bigint(20) unsigned NOT NULL,
  `full_name` varchar(191) NOT NULL,
  `email` varchar(191) NOT NULL,
  `signature` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `place` varchar(191) DEFAULT NULL,
  `date` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_signs_contract_id_foreign` (`contract_id`),
  KEY `contract_signs_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_signs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_signs_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_signs` WRITE;
/*!40000 ALTER TABLE `contract_signs` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_signs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contract_template_number` bigint(20) DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `subject` varchar(191) NOT NULL,
  `description` longtext DEFAULT NULL,
  `amount` varchar(191) NOT NULL,
  `contract_type_id` bigint(20) unsigned NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `contract_detail` longtext DEFAULT NULL,
  `added_by` int(11) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_templates_company_id_foreign` (`company_id`),
  KEY `contract_templates_contract_type_id_foreign` (`contract_type_id`),
  KEY `contract_templates_currency_id_foreign` (`currency_id`),
  CONSTRAINT `contract_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_templates_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `contract_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contract_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_templates` WRITE;
/*!40000 ALTER TABLE `contract_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contract_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contract_types` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_types_company_id_foreign` (`company_id`),
  CONSTRAINT `contract_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contract_types` WRITE;
/*!40000 ALTER TABLE `contract_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `contract_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `contracts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `contracts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `contract_number` bigint(20) DEFAULT NULL,
  `company_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `subject` varchar(191) NOT NULL,
  `amount` varchar(191) NOT NULL,
  `original_amount` decimal(15,2) NOT NULL,
  `contract_type_id` bigint(20) unsigned DEFAULT NULL,
  `start_date` date NOT NULL,
  `original_start_date` date NOT NULL,
  `end_date` date DEFAULT NULL,
  `original_end_date` date DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `contract_name` varchar(191) DEFAULT NULL,
  `alternate_address` varchar(191) DEFAULT NULL,
  `contract_note` text DEFAULT NULL,
  `cell` varchar(191) DEFAULT NULL,
  `office` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `contract_detail` longtext DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `hash` text DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `event_id` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `company_sign` varchar(191) DEFAULT NULL,
  `sign_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contracts_company_id_foreign` (`company_id`),
  KEY `contracts_client_id_foreign` (`client_id`),
  KEY `contracts_contract_type_id_foreign` (`contract_type_id`),
  KEY `contracts_added_by_foreign` (`added_by`),
  KEY `contracts_last_updated_by_foreign` (`last_updated_by`),
  KEY `contracts_currency_id_foreign` (`currency_id`),
  KEY `contracts_project_id_foreign` (`project_id`),
  CONSTRAINT `contracts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_contract_type_id_foreign` FOREIGN KEY (`contract_type_id`) REFERENCES `contract_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `contracts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `contracts_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `contracts` WRITE;
/*!40000 ALTER TABLE `contracts` DISABLE KEYS */;
/*!40000 ALTER TABLE `contracts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `conversation`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_one` int(10) unsigned NOT NULL,
  `user_two` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_company_id_foreign` (`company_id`),
  KEY `conversation_user_one_foreign` (`user_one`),
  KEY `conversation_user_two_foreign` (`user_two`),
  CONSTRAINT `conversation_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `conversation` WRITE;
/*!40000 ALTER TABLE `conversation` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `conversation_reply`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `conversation_reply` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `conversation_id` int(10) unsigned NOT NULL,
  `reply` text NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `conversation_reply_company_id_foreign` (`company_id`),
  KEY `conversation_reply_conversation_id_foreign` (`conversation_id`),
  KEY `conversation_reply_user_id_foreign` (`user_id`),
  CONSTRAINT `conversation_reply_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_reply_conversation_id_foreign` FOREIGN KEY (`conversation_id`) REFERENCES `conversation` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `conversation_reply_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `conversation_reply` WRITE;
/*!40000 ALTER TABLE `conversation_reply` DISABLE KEYS */;
/*!40000 ALTER TABLE `conversation_reply` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `iso` char(2) NOT NULL,
  `name` varchar(80) NOT NULL,
  `nicename` varchar(80) NOT NULL,
  `iso3` char(3) DEFAULT NULL,
  `numcode` smallint(6) DEFAULT NULL,
  `phonecode` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=254 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES
(1,'AF','AFGHANISTAN','Afghanistan','AFG',4,93),
(2,'AL','ALBANIA','Albania','ALB',8,355),
(3,'DZ','ALGERIA','Algeria','DZA',12,213),
(4,'AS','AMERICAN SAMOA','American Samoa','ASM',16,1684),
(5,'AD','ANDORRA','Andorra','AND',20,376),
(6,'AO','ANGOLA','Angola','AGO',24,244),
(7,'AI','ANGUILLA','Anguilla','AIA',660,1264),
(8,'AQ','ANTARCTICA','Antarctica',NULL,NULL,0),
(9,'AG','ANTIGUA AND BARBUDA','Antigua and Barbuda','ATG',28,1268),
(10,'AR','ARGENTINA','Argentina','ARG',32,54),
(11,'AM','ARMENIA','Armenia','ARM',51,374),
(12,'AW','ARUBA','Aruba','ABW',533,297),
(13,'AU','AUSTRALIA','Australia','AUS',36,61),
(14,'AT','AUSTRIA','Austria','AUT',40,43),
(15,'AZ','AZERBAIJAN','Azerbaijan','AZE',31,994),
(16,'BS','BAHAMAS','Bahamas','BHS',44,1242),
(17,'BH','BAHRAIN','Bahrain','BHR',48,973),
(18,'BD','BANGLADESH','Bangladesh','BGD',50,880),
(19,'BB','BARBADOS','Barbados','BRB',52,1246),
(20,'BY','BELARUS','Belarus','BLR',112,375),
(21,'BE','BELGIUM','Belgium','BEL',56,32),
(22,'BZ','BELIZE','Belize','BLZ',84,501),
(23,'BJ','BENIN','Benin','BEN',204,229),
(24,'BM','BERMUDA','Bermuda','BMU',60,1441),
(25,'BT','BHUTAN','Bhutan','BTN',64,975),
(26,'BO','BOLIVIA','Bolivia','BOL',68,591),
(27,'BA','BOSNIA AND HERZEGOVINA','Bosnia and Herzegovina','BIH',70,387),
(28,'BW','BOTSWANA','Botswana','BWA',72,267),
(29,'BV','BOUVET ISLAND','Bouvet Island',NULL,NULL,0),
(30,'BR','BRAZIL','Brazil','BRA',76,55),
(31,'IO','BRITISH INDIAN OCEAN TERRITORY','British Indian Ocean Territory',NULL,NULL,246),
(32,'BN','BRUNEI DARUSSALAM','Brunei Darussalam','BRN',96,673),
(33,'BG','BULGARIA','Bulgaria','BGR',100,359),
(34,'BF','BURKINA FASO','Burkina Faso','BFA',854,226),
(35,'BI','BURUNDI','Burundi','BDI',108,257),
(36,'KH','CAMBODIA','Cambodia','KHM',116,855),
(37,'CM','CAMEROON','Cameroon','CMR',120,237),
(38,'CA','CANADA','Canada','CAN',124,1),
(39,'CV','CAPE VERDE','Cape Verde','CPV',132,238),
(40,'KY','CAYMAN ISLANDS','Cayman Islands','CYM',136,1345),
(41,'CF','CENTRAL AFRICAN REPUBLIC','Central African Republic','CAF',140,236),
(42,'TD','CHAD','Chad','TCD',148,235),
(43,'CL','CHILE','Chile','CHL',152,56),
(44,'CN','CHINA','China','CHN',156,86),
(45,'CX','CHRISTMAS ISLAND','Christmas Island',NULL,NULL,61),
(46,'CC','COCOS (KEELING) ISLANDS','Cocos (Keeling) Islands',NULL,NULL,672),
(47,'CO','COLOMBIA','Colombia','COL',170,57),
(48,'KM','COMOROS','Comoros','COM',174,269),
(49,'CG','CONGO','Congo','COG',178,242),
(50,'CD','CONGO, THE DEMOCRATIC REPUBLIC OF THE','Congo, the Democratic Republic of the','COD',180,242),
(51,'CK','COOK ISLANDS','Cook Islands','COK',184,682),
(52,'CR','COSTA RICA','Costa Rica','CRI',188,506),
(53,'CI','COTE D\'IVOIRE','Cote D\'Ivoire','CIV',384,225),
(54,'HR','CROATIA','Croatia','HRV',191,385),
(55,'CU','CUBA','Cuba','CUB',192,53),
(56,'CY','CYPRUS','Cyprus','CYP',196,357),
(57,'CZ','CZECH REPUBLIC','Czech Republic','CZE',203,420),
(58,'DK','DENMARK','Denmark','DNK',208,45),
(59,'DJ','DJIBOUTI','Djibouti','DJI',262,253),
(60,'DM','DOMINICA','Dominica','DMA',212,1767),
(61,'DO','DOMINICAN REPUBLIC','Dominican Republic','DOM',214,1809),
(62,'EC','ECUADOR','Ecuador','ECU',218,593),
(63,'EG','EGYPT','Egypt','EGY',818,20),
(64,'SV','EL SALVADOR','El Salvador','SLV',222,503),
(65,'GQ','EQUATORIAL GUINEA','Equatorial Guinea','GNQ',226,240),
(66,'ER','ERITREA','Eritrea','ERI',232,291),
(67,'EE','ESTONIA','Estonia','EST',233,372),
(68,'ET','ETHIOPIA','Ethiopia','ETH',231,251),
(69,'FK','FALKLAND ISLANDS (MALVINAS)','Falkland Islands (Malvinas)','FLK',238,500),
(70,'FO','FAROE ISLANDS','Faroe Islands','FRO',234,298),
(71,'FJ','FIJI','Fiji','FJI',242,679),
(72,'FI','FINLAND','Finland','FIN',246,358),
(73,'FR','FRANCE','France','FRA',250,33),
(74,'GF','FRENCH GUIANA','French Guiana','GUF',254,594),
(75,'PF','FRENCH POLYNESIA','French Polynesia','PYF',258,689),
(76,'TF','FRENCH SOUTHERN TERRITORIES','French Southern Territories',NULL,NULL,0),
(77,'GA','GABON','Gabon','GAB',266,241),
(78,'GM','GAMBIA','Gambia','GMB',270,220),
(79,'GE','GEORGIA','Georgia','GEO',268,995),
(80,'DE','GERMANY','Germany','DEU',276,49),
(81,'GH','GHANA','Ghana','GHA',288,233),
(82,'GI','GIBRALTAR','Gibraltar','GIB',292,350),
(83,'GR','GREECE','Greece','GRC',300,30),
(84,'GL','GREENLAND','Greenland','GRL',304,299),
(85,'GD','GRENADA','Grenada','GRD',308,1473),
(86,'GP','GUADELOUPE','Guadeloupe','GLP',312,590),
(87,'GU','GUAM','Guam','GUM',316,1671),
(88,'GT','GUATEMALA','Guatemala','GTM',320,502),
(89,'GN','GUINEA','Guinea','GIN',324,224),
(90,'GW','GUINEA-BISSAU','Guinea-Bissau','GNB',624,245),
(91,'GY','GUYANA','Guyana','GUY',328,592),
(92,'HT','HAITI','Haiti','HTI',332,509),
(93,'HM','HEARD ISLAND AND MCDONALD ISLANDS','Heard Island and Mcdonald Islands',NULL,NULL,0),
(94,'VA','HOLY SEE (VATICAN CITY STATE)','Holy See (Vatican City State)','VAT',336,39),
(95,'HN','HONDURAS','Honduras','HND',340,504),
(96,'HK','HONG KONG','Hong Kong','HKG',344,852),
(97,'HU','HUNGARY','Hungary','HUN',348,36),
(98,'IS','ICELAND','Iceland','ISL',352,354),
(99,'IN','INDIA','India','IND',356,91),
(100,'ID','INDONESIA','Indonesia','IDN',360,62),
(101,'IR','IRAN, ISLAMIC REPUBLIC OF','Iran, Islamic Republic of','IRN',364,98),
(102,'IQ','IRAQ','Iraq','IRQ',368,964),
(103,'IE','IRELAND','Ireland','IRL',372,353),
(104,'IL','ISRAEL','Israel','ISR',376,972),
(105,'IT','ITALY','Italy','ITA',380,39),
(106,'JM','JAMAICA','Jamaica','JAM',388,1876),
(107,'JP','JAPAN','Japan','JPN',392,81),
(108,'JO','JORDAN','Jordan','JOR',400,962),
(109,'KZ','KAZAKHSTAN','Kazakhstan','KAZ',398,7),
(110,'KE','KENYA','Kenya','KEN',404,254),
(111,'KI','KIRIBATI','Kiribati','KIR',296,686),
(112,'KP','KOREA, DEMOCRATIC PEOPLE\'S REPUBLIC OF','Korea, Democratic People\'s Republic of','PRK',408,850),
(113,'KR','KOREA, REPUBLIC OF','Korea, Republic of','KOR',410,82),
(114,'KW','KUWAIT','Kuwait','KWT',414,965),
(115,'KG','KYRGYZSTAN','Kyrgyzstan','KGZ',417,996),
(116,'LA','LAO PEOPLE\'S DEMOCRATIC REPUBLIC','Lao People\'s Democratic Republic','LAO',418,856),
(117,'LV','LATVIA','Latvia','LVA',428,371),
(118,'LB','LEBANON','Lebanon','LBN',422,961),
(119,'LS','LESOTHO','Lesotho','LSO',426,266),
(120,'LR','LIBERIA','Liberia','LBR',430,231),
(121,'LY','LIBYAN ARAB JAMAHIRIYA','Libyan Arab Jamahiriya','LBY',434,218),
(122,'LI','LIECHTENSTEIN','Liechtenstein','LIE',438,423),
(123,'LT','LITHUANIA','Lithuania','LTU',440,370),
(124,'LU','LUXEMBOURG','Luxembourg','LUX',442,352),
(125,'MO','MACAO','Macao','MAC',446,853),
(126,'MK','MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF','Macedonia, the Former Yugoslav Republic of','MKD',807,389),
(127,'MG','MADAGASCAR','Madagascar','MDG',450,261),
(128,'MW','MALAWI','Malawi','MWI',454,265),
(129,'MY','MALAYSIA','Malaysia','MYS',458,60),
(130,'MV','MALDIVES','Maldives','MDV',462,960),
(131,'ML','MALI','Mali','MLI',466,223),
(132,'MT','MALTA','Malta','MLT',470,356),
(133,'MH','MARSHALL ISLANDS','Marshall Islands','MHL',584,692),
(134,'MQ','MARTINIQUE','Martinique','MTQ',474,596),
(135,'MR','MAURITANIA','Mauritania','MRT',478,222),
(136,'MU','MAURITIUS','Mauritius','MUS',480,230),
(137,'YT','MAYOTTE','Mayotte',NULL,NULL,269),
(138,'MX','MEXICO','Mexico','MEX',484,52),
(139,'FM','MICRONESIA, FEDERATED STATES OF','Micronesia, Federated States of','FSM',583,691),
(140,'MD','MOLDOVA, REPUBLIC OF','Moldova, Republic of','MDA',498,373),
(141,'MC','MONACO','Monaco','MCO',492,377),
(142,'MN','MONGOLIA','Mongolia','MNG',496,976),
(143,'MS','MONTSERRAT','Montserrat','MSR',500,1664),
(144,'MA','MOROCCO','Morocco','MAR',504,212),
(145,'MZ','MOZAMBIQUE','Mozambique','MOZ',508,258),
(146,'MM','MYANMAR','Myanmar','MMR',104,95),
(147,'NA','NAMIBIA','Namibia','NAM',516,264),
(148,'NR','NAURU','Nauru','NRU',520,674),
(149,'NP','NEPAL','Nepal','NPL',524,977),
(150,'NL','NETHERLANDS','Netherlands','NLD',528,31),
(151,'AN','NETHERLANDS ANTILLES','Netherlands Antilles','ANT',530,599),
(152,'NC','NEW CALEDONIA','New Caledonia','NCL',540,687),
(153,'NZ','NEW ZEALAND','New Zealand','NZL',554,64),
(154,'NI','NICARAGUA','Nicaragua','NIC',558,505),
(155,'NE','NIGER','Niger','NER',562,227),
(156,'NG','NIGERIA','Nigeria','NGA',566,234),
(157,'NU','NIUE','Niue','NIU',570,683),
(158,'NF','NORFOLK ISLAND','Norfolk Island','NFK',574,672),
(159,'MP','NORTHERN MARIANA ISLANDS','Northern Mariana Islands','MNP',580,1670),
(160,'NO','NORWAY','Norway','NOR',578,47),
(161,'OM','OMAN','Oman','OMN',512,968),
(162,'PK','PAKISTAN','Pakistan','PAK',586,92),
(163,'PW','PALAU','Palau','PLW',585,680),
(164,'PS','PALESTINIAN TERRITORY, OCCUPIED','Palestinian Territory, Occupied',NULL,NULL,970),
(165,'PA','PANAMA','Panama','PAN',591,507),
(166,'PG','PAPUA NEW GUINEA','Papua New Guinea','PNG',598,675),
(167,'PY','PARAGUAY','Paraguay','PRY',600,595),
(168,'PE','PERU','Peru','PER',604,51),
(169,'PH','PHILIPPINES','Philippines','PHL',608,63),
(170,'PN','PITCAIRN','Pitcairn','PCN',612,0),
(171,'PL','POLAND','Poland','POL',616,48),
(172,'PT','PORTUGAL','Portugal','PRT',620,351),
(173,'PR','PUERTO RICO','Puerto Rico','PRI',630,1787),
(174,'QA','QATAR','Qatar','QAT',634,974),
(175,'RE','REUNION','Reunion','REU',638,262),
(176,'RO','ROMANIA','Romania','ROM',642,40),
(177,'RU','RUSSIAN FEDERATION','Russian Federation','RUS',643,7),
(178,'RW','RWANDA','Rwanda','RWA',646,250),
(179,'SH','SAINT HELENA','Saint Helena','SHN',654,290),
(180,'KN','SAINT KITTS AND NEVIS','Saint Kitts and Nevis','KNA',659,1869),
(181,'LC','SAINT LUCIA','Saint Lucia','LCA',662,1758),
(182,'PM','SAINT PIERRE AND MIQUELON','Saint Pierre and Miquelon','SPM',666,508),
(183,'VC','SAINT VINCENT AND THE GRENADINES','Saint Vincent and the Grenadines','VCT',670,1784),
(184,'WS','SAMOA','Samoa','WSM',882,684),
(185,'SM','SAN MARINO','San Marino','SMR',674,378),
(186,'ST','SAO TOME AND PRINCIPE','Sao Tome and Principe','STP',678,239),
(187,'SA','SAUDI ARABIA','Saudi Arabia','SAU',682,966),
(188,'SN','SENEGAL','Senegal','SEN',686,221),
(189,'CS','SERBIA AND MONTENEGRO','Serbia and Montenegro',NULL,NULL,381),
(190,'SC','SEYCHELLES','Seychelles','SYC',690,248),
(191,'SL','SIERRA LEONE','Sierra Leone','SLE',694,232),
(192,'SG','SINGAPORE','Singapore','SGP',702,65),
(193,'SK','SLOVAKIA','Slovakia','SVK',703,421),
(194,'SI','SLOVENIA','Slovenia','SVN',705,386),
(195,'SB','SOLOMON ISLANDS','Solomon Islands','SLB',90,677),
(196,'SO','SOMALIA','Somalia','SOM',706,252),
(197,'ZA','SOUTH AFRICA','South Africa','ZAF',710,27),
(198,'GS','SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS','South Georgia and the South Sandwich Islands',NULL,NULL,0),
(199,'ES','SPAIN','Spain','ESP',724,34),
(200,'LK','SRI LANKA','Sri Lanka','LKA',144,94),
(201,'SD','SUDAN','Sudan','SDN',736,249),
(202,'SR','SURINAME','Suriname','SUR',740,597),
(203,'SJ','SVALBARD AND JAN MAYEN','Svalbard and Jan Mayen','SJM',744,47),
(204,'SZ','SWAZILAND','Swaziland','SWZ',748,268),
(205,'SE','SWEDEN','Sweden','SWE',752,46),
(206,'CH','SWITZERLAND','Switzerland','CHE',756,41),
(207,'SY','SYRIAN ARAB REPUBLIC','Syrian Arab Republic','SYR',760,963),
(208,'TW','TAIWAN, PROVINCE OF CHINA','Taiwan, Province of China','TWN',158,886),
(209,'TJ','TAJIKISTAN','Tajikistan','TJK',762,992),
(210,'TZ','TANZANIA, UNITED REPUBLIC OF','Tanzania, United Republic of','TZA',834,255),
(211,'TH','THAILAND','Thailand','THA',764,66),
(212,'TL','TIMOR-LESTE','Timor-Leste',NULL,NULL,670),
(213,'TG','TOGO','Togo','TGO',768,228),
(214,'TK','TOKELAU','Tokelau','TKL',772,690),
(215,'TO','TONGA','Tonga','TON',776,676),
(216,'TT','TRINIDAD AND TOBAGO','Trinidad and Tobago','TTO',780,1868),
(217,'TN','TUNISIA','Tunisia','TUN',788,216),
(218,'TR','TURKEY','Turkey','TUR',792,90),
(219,'TM','TURKMENISTAN','Turkmenistan','TKM',795,7370),
(220,'TC','TURKS AND CAICOS ISLANDS','Turks and Caicos Islands','TCA',796,1649),
(221,'TV','TUVALU','Tuvalu','TUV',798,688),
(222,'UG','UGANDA','Uganda','UGA',800,256),
(223,'UA','UKRAINE','Ukraine','UKR',804,380),
(224,'AE','UNITED ARAB EMIRATES','United Arab Emirates','ARE',784,971),
(225,'GB','UNITED KINGDOM','United Kingdom','GBR',826,44),
(226,'US','UNITED STATES','United States','USA',840,1),
(227,'UM','UNITED STATES MINOR OUTLYING ISLANDS','United States Minor Outlying Islands',NULL,NULL,1),
(228,'UY','URUGUAY','Uruguay','URY',858,598),
(229,'UZ','UZBEKISTAN','Uzbekistan','UZB',860,998),
(230,'VU','VANUATU','Vanuatu','VUT',548,678),
(231,'VE','VENEZUELA','Venezuela','VEN',862,58),
(232,'VN','VIET NAM','Viet Nam','VNM',704,84),
(233,'VG','VIRGIN ISLANDS, BRITISH','Virgin Islands, British','VGB',92,1284),
(234,'VI','VIRGIN ISLANDS, U.S.','Virgin Islands, U.s.','VIR',850,1340),
(235,'WF','WALLIS AND FUTUNA','Wallis and Futuna','WLF',876,681),
(236,'EH','WESTERN SAHARA','Western Sahara','ESH',732,212),
(237,'YE','YEMEN','Yemen','YEM',887,967),
(238,'ZM','ZAMBIA','Zambia','ZMB',894,260),
(239,'ZW','ZIMBABWE','Zimbabwe','ZWE',716,263),
(240,'RS','SERBIA','Serbia','SRB',688,381),
(241,'AP','ASIA PACIFIC REGION','Asia / Pacific Region','0',0,0),
(242,'ME','MONTENEGRO','Montenegro','MNE',499,382),
(243,'AX','ALAND ISLANDS','Aland Islands','ALA',248,358),
(244,'BQ','BONAIRE, SINT EUSTATIUS AND SABA','Bonaire, Sint Eustatius and Saba','BES',535,599),
(245,'CW','CURACAO','Curacao','CUW',531,599),
(246,'GG','GUERNSEY','Guernsey','GGY',831,44),
(247,'IM','ISLE OF MAN','Isle of Man','IMN',833,44),
(248,'JE','JERSEY','Jersey','JEY',832,44),
(249,'XK','KOSOVO','Kosovo','---',0,381),
(250,'BL','SAINT BARTHELEMY','Saint Barthelemy','BLM',652,590),
(251,'MF','SAINT MARTIN','Saint Martin','MAF',663,590),
(252,'SX','SINT MAARTEN','Sint Maarten','SXM',534,1),
(253,'SS','SOUTH SUDAN','South Sudan','SSD',728,211);
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_note_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_note_item_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `credit_note_item_id` int(10) unsigned NOT NULL,
  `filename` varchar(191) DEFAULT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_note_item_images_credit_note_item_id_foreign` (`credit_note_item_id`),
  CONSTRAINT `credit_note_item_images_credit_note_item_id_foreign` FOREIGN KEY (`credit_note_item_id`) REFERENCES `credit_note_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_note_item_images` WRITE;
/*!40000 ALTER TABLE `credit_note_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_note_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_note_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_note_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `credit_note_id` int(10) unsigned NOT NULL,
  `item_name` varchar(191) NOT NULL,
  `type` enum('item','discount','tax') NOT NULL DEFAULT 'item',
  `quantity` int(11) NOT NULL,
  `unit_price` double(8,2) NOT NULL,
  `amount` double(8,2) NOT NULL,
  `taxes` varchar(191) DEFAULT NULL,
  `hsn_sac_code` varchar(191) DEFAULT NULL,
  `item_summary` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_note_items_credit_note_id_foreign` (`credit_note_id`),
  KEY `credit_note_items_unit_id_foreign` (`unit_id`),
  KEY `credit_note_items_product_id_foreign` (`product_id`),
  CONSTRAINT `credit_note_items_credit_note_id_foreign` FOREIGN KEY (`credit_note_id`) REFERENCES `credit_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_note_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_note_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_note_items` WRITE;
/*!40000 ALTER TABLE `credit_note_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_note_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `credit_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `credit_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `cn_number` varchar(191) NOT NULL,
  `invoice_id` int(10) unsigned DEFAULT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `discount_type` enum('percent','fixed') NOT NULL DEFAULT 'percent',
  `sub_total` double(15,2) NOT NULL,
  `total` double(15,2) NOT NULL,
  `adjustment_amount` double(8,2) DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `status` enum('closed','open') NOT NULL DEFAULT 'open',
  `recurring` enum('yes','no') NOT NULL DEFAULT 'no',
  `billing_frequency` varchar(191) DEFAULT NULL,
  `billing_interval` int(11) DEFAULT NULL,
  `billing_cycle` int(11) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `file_original_name` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `credit_notes_company_id_foreign` (`company_id`),
  KEY `credit_notes_project_id_foreign` (`project_id`),
  KEY `credit_notes_client_id_foreign` (`client_id`),
  KEY `credit_notes_currency_id_foreign` (`currency_id`),
  KEY `credit_notes_added_by_foreign` (`added_by`),
  KEY `credit_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `credit_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `credit_notes_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `credit_notes` WRITE;
/*!40000 ALTER TABLE `credit_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `credit_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currencies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `currency_name` varchar(191) NOT NULL,
  `currency_symbol` varchar(191) DEFAULT NULL,
  `currency_code` varchar(191) NOT NULL,
  `exchange_rate` double DEFAULT NULL,
  `is_cryptocurrency` enum('yes','no') NOT NULL DEFAULT 'no',
  `usd_price` double DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `currency_position` enum('left','right','left_with_space','right_with_space') NOT NULL DEFAULT 'left',
  `no_of_decimal` int(10) unsigned NOT NULL,
  `thousand_separator` varchar(191) DEFAULT NULL,
  `decimal_separator` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currencies_company_id_foreign` (`company_id`),
  CONSTRAINT `currencies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currencies` WRITE;
/*!40000 ALTER TABLE `currencies` DISABLE KEYS */;
INSERT INTO `currencies` VALUES
(1,1,'Dollars','$','USD',1,'no',NULL,'2023-05-30 16:31:56','2023-05-30 16:31:56','left',2,',','.'),
(2,1,'Pounds','£','GBP',1,'no',NULL,'2023-05-30 16:31:56','2023-05-30 16:31:56','left',2,',','.'),
(3,1,'Euros','€','EUR',1,'no',NULL,'2023-05-30 16:31:56','2023-05-30 16:31:56','left',2,',','.'),
(4,1,'Rupee','₹','INR',1,'no',NULL,'2023-05-30 16:31:56','2023-05-30 16:31:56','left',2,',','.');
/*!40000 ALTER TABLE `currencies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `currency_format_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `currency_format_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `currency_position` enum('left','right','left_with_space','right_with_space') NOT NULL DEFAULT 'left',
  `no_of_decimal` int(10) unsigned NOT NULL,
  `thousand_separator` varchar(191) DEFAULT NULL,
  `decimal_separator` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `currency_format_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `currency_format_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `currency_format_settings` WRITE;
/*!40000 ALTER TABLE `currency_format_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `currency_format_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_field_groups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_field_groups` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_field_groups_company_id_foreign` (`company_id`),
  KEY `custom_field_groups_model_index` (`model`),
  CONSTRAINT `custom_field_groups_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_field_groups` WRITE;
/*!40000 ALTER TABLE `custom_field_groups` DISABLE KEYS */;
INSERT INTO `custom_field_groups` VALUES
(1,1,'Client','App\\Models\\ClientDetails'),
(2,1,'Employee','App\\Models\\EmployeeDetails'),
(3,1,'Project','App\\Models\\Project'),
(4,1,'Invoice','App\\Models\\Invoice'),
(5,1,'Estimate','App\\Models\\Estimate'),
(6,1,'Task','App\\Models\\Task'),
(7,1,'Expense','App\\Models\\Expense'),
(8,1,'Lead','App\\Models\\Lead'),
(9,1,'Product','App\\Models\\Product'),
(10,1,'Ticket','App\\Models\\Ticket'),
(11,1,'Time Log','App\\Models\\ProjectTimeLog'),
(12,1,'Contract','App\\Models\\Contract');
/*!40000 ALTER TABLE `custom_field_groups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `custom_field_group_id` int(10) unsigned DEFAULT NULL,
  `label` varchar(100) NOT NULL,
  `name` varchar(100) NOT NULL,
  `type` varchar(10) NOT NULL,
  `required` enum('yes','no') NOT NULL DEFAULT 'no',
  `values` varchar(5000) DEFAULT NULL,
  `export` tinyint(1) DEFAULT 0,
  `visible` enum('true','false') DEFAULT 'false',
  PRIMARY KEY (`id`),
  KEY `custom_fields_company_id_foreign` (`company_id`),
  KEY `custom_fields_custom_field_group_id_foreign` (`custom_field_group_id`),
  CONSTRAINT `custom_fields_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `custom_fields_custom_field_group_id_foreign` FOREIGN KEY (`custom_field_group_id`) REFERENCES `custom_field_groups` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields` WRITE;
/*!40000 ALTER TABLE `custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_fields_data`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_fields_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` int(10) unsigned NOT NULL,
  `model_id` int(10) unsigned NOT NULL,
  `model` varchar(191) DEFAULT NULL,
  `value` varchar(10000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_fields_data_custom_field_id_foreign` (`custom_field_id`),
  KEY `custom_fields_data_model_index` (`model`),
  CONSTRAINT `custom_fields_data_custom_field_id_foreign` FOREIGN KEY (`custom_field_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_fields_data` WRITE;
/*!40000 ALTER TABLE `custom_fields_data` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_fields_data` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `custom_link_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `custom_link_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `link_title` varchar(191) NOT NULL,
  `url` text NOT NULL,
  `can_be_viewed_by` varchar(191) DEFAULT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `custom_link_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `custom_link_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `custom_link_settings` WRITE;
/*!40000 ALTER TABLE `custom_link_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `custom_link_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `widget_name` varchar(191) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  `dashboard_type` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widgets_company_id_foreign` (`company_id`),
  CONSTRAINT `dashboard_widgets_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
INSERT INTO `dashboard_widgets` VALUES
(1,1,'total_clients',1,'admin-dashboard',NULL,NULL),
(2,1,'total_employees',1,'admin-dashboard',NULL,NULL),
(3,1,'total_projects',1,'admin-dashboard',NULL,NULL),
(4,1,'total_unpaid_invoices',1,'admin-dashboard',NULL,NULL),
(5,1,'total_hours_logged',1,'admin-dashboard',NULL,NULL),
(6,1,'total_pending_tasks',1,'admin-dashboard',NULL,NULL),
(7,1,'total_today_attendance',1,'admin-dashboard',NULL,NULL),
(8,1,'total_unresolved_tickets',1,'admin-dashboard',NULL,NULL),
(9,1,'recent_earnings',1,'admin-dashboard',NULL,NULL),
(10,1,'settings_leaves',1,'admin-dashboard',NULL,NULL),
(11,1,'new_tickets',1,'admin-dashboard',NULL,NULL),
(12,1,'overdue_tasks',1,'admin-dashboard',NULL,NULL),
(13,1,'pending_follow_up',1,'admin-dashboard',NULL,NULL),
(14,1,'project_activity_timeline',1,'admin-dashboard',NULL,NULL),
(15,1,'user_activity_timeline',1,'admin-dashboard',NULL,NULL),
(16,1,'timelogs',1,'admin-dashboard',NULL,NULL),
(17,1,'total_clients',1,'admin-client-dashboard',NULL,NULL),
(18,1,'total_leads',1,'admin-client-dashboard',NULL,NULL),
(19,1,'total_lead_conversions',1,'admin-client-dashboard',NULL,NULL),
(20,1,'total_contracts_generated',1,'admin-client-dashboard',NULL,NULL),
(21,1,'total_contracts_signed',1,'admin-client-dashboard',NULL,NULL),
(22,1,'client_wise_earnings',1,'admin-client-dashboard',NULL,NULL),
(23,1,'client_wise_timelogs',1,'admin-client-dashboard',NULL,NULL),
(24,1,'lead_vs_status',1,'admin-client-dashboard',NULL,NULL),
(25,1,'lead_vs_source',1,'admin-client-dashboard',NULL,NULL),
(26,1,'latest_client',1,'admin-client-dashboard',NULL,NULL),
(27,1,'recent_login_activities',1,'admin-client-dashboard',NULL,NULL),
(28,1,'total_paid_invoices',1,'admin-finance-dashboard',NULL,NULL),
(29,1,'total_expenses',1,'admin-finance-dashboard',NULL,NULL),
(30,1,'total_earnings',1,'admin-finance-dashboard',NULL,NULL),
(31,1,'total_pending_amount',1,'admin-finance-dashboard',NULL,NULL),
(32,1,'invoice_overview',1,'admin-finance-dashboard',NULL,NULL),
(33,1,'estimate_overview',1,'admin-finance-dashboard',NULL,NULL),
(34,1,'proposal_overview',1,'admin-finance-dashboard',NULL,NULL),
(35,1,'earnings_by_client',1,'admin-finance-dashboard',NULL,NULL),
(36,1,'earnings_by_projects',1,'admin-finance-dashboard',NULL,NULL),
(37,1,'total_unpaid_invoices',1,'admin-finance-dashboard',NULL,NULL),
(38,1,'total_leaves_approved',1,'admin-hr-dashboard',NULL,NULL),
(39,1,'total_new_employee',1,'admin-hr-dashboard',NULL,NULL),
(40,1,'total_employee_exits',1,'admin-hr-dashboard',NULL,NULL),
(41,1,'average_attendance',1,'admin-hr-dashboard',NULL,NULL),
(42,1,'department_wise_employee',1,'admin-hr-dashboard',NULL,NULL),
(43,1,'designation_wise_employee',1,'admin-hr-dashboard',NULL,NULL),
(44,1,'gender_wise_employee',1,'admin-hr-dashboard',NULL,NULL),
(45,1,'role_wise_employee',1,'admin-hr-dashboard',NULL,NULL),
(46,1,'leaves_taken',1,'admin-hr-dashboard',NULL,NULL),
(47,1,'late_attendance_mark',1,'admin-hr-dashboard',NULL,NULL),
(48,1,'headcount',1,'admin-hr-dashboard',NULL,NULL),
(49,1,'joining_vs_attrition',1,'admin-hr-dashboard',NULL,NULL),
(50,1,'birthday',1,'admin-hr-dashboard',NULL,NULL),
(51,1,'total_today_attendance',1,'admin-hr-dashboard',NULL,NULL),
(52,1,'total_project',1,'admin-project-dashboard',NULL,NULL),
(53,1,'total_hours_logged',1,'admin-project-dashboard',NULL,NULL),
(54,1,'total_overdue_project',1,'admin-project-dashboard',NULL,NULL),
(55,1,'status_wise_project',1,'admin-project-dashboard',NULL,NULL),
(56,1,'pending_milestone',1,'admin-project-dashboard',NULL,NULL),
(57,1,'total_tickets',1,'admin-ticket-dashboard',NULL,NULL),
(58,1,'total_unassigned_ticket',1,'admin-ticket-dashboard',NULL,NULL),
(59,1,'type_wise_ticket',1,'admin-ticket-dashboard',NULL,NULL),
(60,1,'status_wise_ticket',1,'admin-ticket-dashboard',NULL,NULL),
(61,1,'channel_wise_ticket',1,'admin-ticket-dashboard',NULL,NULL),
(62,1,'new_tickets',1,'admin-ticket-dashboard',NULL,NULL),
(63,1,'profile',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(64,1,'shift_schedule',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(65,1,'birthday',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(66,1,'notices',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(67,1,'tasks',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(68,1,'projects',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(69,1,'my_task',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(70,1,'my_calender',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(71,1,'week_timelog',0,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(72,1,'leave',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(73,1,'lead',0,'private-dashboard',NULL,'2023-06-04 07:39:48'),
(74,1,'work_from_home',0,'private-dashboard',NULL,'2023-06-04 07:39:48'),
(75,1,'appreciation',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(76,1,'work_anniversary',0,'private-dashboard',NULL,'2023-06-04 07:39:48'),
(77,1,'ticket',0,'private-dashboard',NULL,'2023-06-04 07:39:48'),
(78,1,'notice_period_duration',0,'private-dashboard',NULL,'2023-06-04 07:39:48'),
(79,1,'probation_date',1,'private-dashboard',NULL,'2023-06-04 07:40:19'),
(80,1,'contract_date',0,'private-dashboard',NULL,'2023-06-04 07:39:48'),
(81,1,'internship_date',1,'private-dashboard',NULL,'2023-06-04 07:40:19');
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `database_backup_cron_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `database_backup_cron_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` enum('active','inactive') NOT NULL DEFAULT 'inactive',
  `hour_of_day` time DEFAULT NULL,
  `backup_after_days` varchar(191) DEFAULT NULL,
  `delete_backup_after_days` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `database_backup_cron_settings` WRITE;
/*!40000 ALTER TABLE `database_backup_cron_settings` DISABLE KEYS */;
INSERT INTO `database_backup_cron_settings` VALUES
(1,'active','00:00:00','1','14');
/*!40000 ALTER TABLE `database_backup_cron_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `database_backups`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `database_backups` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `filename` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `database_backups` WRITE;
/*!40000 ALTER TABLE `database_backups` DISABLE KEYS */;
/*!40000 ALTER TABLE `database_backups` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `designations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `designations` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `designations_company_id_foreign` (`company_id`),
  KEY `designations_added_by_foreign` (`added_by`),
  KEY `designations_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `designations_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `designations_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `designations_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `designations` WRITE;
/*!40000 ALTER TABLE `designations` DISABLE KEYS */;
INSERT INTO `designations` VALUES
(1,1,'Manager general GLM',NULL,NULL,NULL,'2023-06-01 08:27:39','2024-03-03 07:12:37'),
(2,1,'Salarié GLM',NULL,NULL,NULL,'2023-06-02 03:36:49','2024-03-03 07:06:35'),
(3,1,'Développeur',NULL,NULL,NULL,'2023-06-02 07:54:41','2023-06-02 07:54:41'),
(4,1,'Président GLM',NULL,NULL,NULL,'2024-03-03 07:05:42','2024-03-03 07:05:42'),
(5,1,'Responsable secteur animation GLM',NULL,NULL,NULL,'2024-03-03 07:07:34','2024-03-03 07:07:34'),
(6,1,'Responsable secteur compétition GLM',NULL,NULL,NULL,'2024-03-03 07:08:08','2024-03-03 07:08:08'),
(7,1,'Responsable secteur fitness GLM',NULL,NULL,NULL,'2024-03-03 07:08:38','2024-03-03 07:08:38'),
(8,1,'Secrétaire GLM',NULL,NULL,NULL,'2024-03-03 07:11:18','2024-03-03 07:11:18'),
(9,1,'Trésorier GLM',NULL,NULL,NULL,'2024-03-03 07:11:41','2024-03-03 07:11:41'),
(10,1,'Vice-président GLM',NULL,NULL,NULL,'2024-03-03 07:12:12','2024-03-03 07:12:12');
/*!40000 ALTER TABLE `designations` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `order` int(11) NOT NULL DEFAULT 1,
  `name` varchar(191) NOT NULL,
  `color` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_categories` WRITE;
/*!40000 ALTER TABLE `discussion_categories` DISABLE KEYS */;
INSERT INTO `discussion_categories` VALUES
(1,1,1,'General','#3498DB','2023-05-30 16:31:56','2023-05-30 16:31:56');
/*!40000 ALTER TABLE `discussion_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `discussion_id` int(10) unsigned DEFAULT NULL,
  `discussion_reply_id` int(10) unsigned DEFAULT NULL,
  `filename` varchar(191) NOT NULL,
  `description` text DEFAULT NULL,
  `google_url` varchar(191) DEFAULT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `dropbox_link` varchar(191) DEFAULT NULL,
  `external_link_name` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_files_company_id_foreign` (`company_id`),
  KEY `discussion_files_user_id_foreign` (`user_id`),
  KEY `discussion_files_discussion_id_foreign` (`discussion_id`),
  KEY `discussion_files_discussion_reply_id_foreign` (`discussion_reply_id`),
  CONSTRAINT `discussion_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `discussions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_discussion_reply_id_foreign` FOREIGN KEY (`discussion_reply_id`) REFERENCES `discussion_replies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_files` WRITE;
/*!40000 ALTER TABLE `discussion_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussion_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussion_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussion_replies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `discussion_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `body` longtext NOT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussion_replies_discussion_id_foreign` (`discussion_id`),
  KEY `discussion_replies_user_id_foreign` (`user_id`),
  KEY `discussion_replies_company_id_foreign` (`company_id`),
  CONSTRAINT `discussion_replies_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_replies_discussion_id_foreign` FOREIGN KEY (`discussion_id`) REFERENCES `discussions` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussion_replies_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussion_replies` WRITE;
/*!40000 ALTER TABLE `discussion_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussion_replies` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `discussions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `discussions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `discussion_category_id` int(10) unsigned DEFAULT 1,
  `project_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `color` varchar(20) DEFAULT '#232629',
  `user_id` int(10) unsigned NOT NULL,
  `pinned` tinyint(1) NOT NULL DEFAULT 0,
  `closed` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `last_reply_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `best_answer_id` int(10) unsigned DEFAULT NULL,
  `last_reply_by_id` int(10) unsigned DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `discussions_discussion_category_id_foreign` (`discussion_category_id`),
  KEY `discussions_project_id_foreign` (`project_id`),
  KEY `discussions_user_id_foreign` (`user_id`),
  KEY `discussions_best_answer_id_foreign` (`best_answer_id`),
  KEY `discussions_last_reply_by_id_foreign` (`last_reply_by_id`),
  KEY `discussions_added_by_foreign` (`added_by`),
  KEY `discussions_last_updated_by_foreign` (`last_updated_by`),
  KEY `discussions_company_id_foreign` (`company_id`),
  CONSTRAINT `discussions_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_best_answer_id_foreign` FOREIGN KEY (`best_answer_id`) REFERENCES `discussion_replies` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussions_discussion_category_id_foreign` FOREIGN KEY (`discussion_category_id`) REFERENCES `discussion_categories` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_last_reply_by_id_foreign` FOREIGN KEY (`last_reply_by_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `discussions_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `discussions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `discussions` WRITE;
/*!40000 ALTER TABLE `discussions` DISABLE KEYS */;
/*!40000 ALTER TABLE `discussions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `email_notification_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `email_notification_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `slug` varchar(191) DEFAULT NULL,
  `setting_name` varchar(191) NOT NULL,
  `send_email` enum('yes','no') NOT NULL DEFAULT 'no',
  `send_slack` enum('yes','no') NOT NULL DEFAULT 'no',
  `send_push` enum('yes','no') NOT NULL DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `email_notification_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `email_notification_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `email_notification_settings` WRITE;
/*!40000 ALTER TABLE `email_notification_settings` DISABLE KEYS */;
INSERT INTO `email_notification_settings` VALUES
(1,1,'new-expenseadded-by-admin','New Expense/Added by Admin','yes','no','no',NULL,'2023-05-30 17:15:08'),
(2,1,'new-expenseadded-by-member','New Expense/Added by Member','yes','no','no',NULL,'2023-05-30 17:15:08'),
(3,1,'expense-status-changed','Expense Status Changed','yes','no','no',NULL,'2023-05-30 17:15:08'),
(4,1,'new-support-ticket-request','New Support Ticket Request','yes','no','no',NULL,'2023-05-30 17:15:08'),
(5,1,'new-leave-application','New Leave Application','yes','no','no',NULL,'2023-05-30 17:15:08'),
(6,1,'task-completed','Task Completed','yes','no','no',NULL,'2023-05-30 17:15:08'),
(7,1,'invoice-createupdate-notification','Invoice Create/Update Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(8,1,'discussion-reply','Discussion Reply','yes','no','no',NULL,'2023-05-30 17:15:08'),
(9,1,'new-product-purchase-request','New Product Purchase Request','yes','no','no',NULL,'2023-05-30 17:15:08'),
(10,1,'lead-notification','Lead notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(11,1,'order-createupdate-notification','Order Create/Update Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(12,1,'user-join-via-invitation','User Join via Invitation','yes','no','no',NULL,'2023-05-30 17:15:08'),
(13,1,'follow-up-reminder','Follow Up Reminder','yes','no','no',NULL,'2023-05-30 17:15:08'),
(14,1,'user-registrationadded-by-admin','User Registration/Added by Admin','yes','no','no',NULL,'2023-05-30 17:15:08'),
(15,1,'employee-assign-to-project','Employee Assign to Project','yes','no','no',NULL,'2023-05-30 17:15:08'),
(16,1,'new-notice-published','New Notice Published','yes','no','no',NULL,'2023-05-30 17:15:08'),
(17,1,'user-assign-to-task','User Assign to Task','yes','no','no',NULL,'2023-05-30 17:15:08'),
(18,1,'birthday-notification','Birthday notification','yes','yes','no',NULL,'2023-05-30 17:15:08'),
(19,1,'payment-notification','Payment Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(20,1,'appreciation-notification','Employee Appreciation','yes','no','no',NULL,'2023-05-30 17:15:08'),
(21,1,'clock-in-notification','Clock In Notification','no','no','no',NULL,NULL),
(22,1,'holiday-notification','Holiday Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(23,1,'estimate-notification','Estimate Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(24,1,'event-notification','Event Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(25,1,'message-notification','Message Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(26,1,'project-mention-notification','Project Mention Notification','yes','no','no',NULL,'2023-05-30 17:15:08'),
(27,1,'task-mention-notification','Task Mention','yes','no','no',NULL,'2023-05-30 17:15:08');
/*!40000 ALTER TABLE `email_notification_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `emergency_contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `emergency_contacts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(191) DEFAULT NULL,
  `email` varchar(191) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `relation` varchar(191) DEFAULT NULL,
  `address` varchar(191) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `emergency_contacts_company_id_foreign` (`company_id`),
  KEY `emergency_contacts_user_id_foreign` (`user_id`),
  KEY `emergency_contacts_added_by_foreign` (`added_by`),
  KEY `emergency_contacts_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `emergency_contacts_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `emergency_contacts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `emergency_contacts` WRITE;
/*!40000 ALTER TABLE `emergency_contacts` DISABLE KEYS */;
/*!40000 ALTER TABLE `emergency_contacts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_details` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `employee_id` varchar(191) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `hourly_rate` double DEFAULT NULL,
  `slack_username` varchar(191) DEFAULT NULL,
  `department_id` int(10) unsigned DEFAULT NULL,
  `designation_id` bigint(20) unsigned DEFAULT NULL,
  `joining_date` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_date` date DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `attendance_reminder` date DEFAULT NULL,
  `date_of_birth` date DEFAULT NULL,
  `calendar_view` text DEFAULT NULL,
  `about_me` text DEFAULT NULL,
  `reporting_to` int(10) unsigned DEFAULT NULL,
  `contract_end_date` date DEFAULT NULL,
  `internship_end_date` date DEFAULT NULL,
  `employment_type` varchar(191) DEFAULT NULL,
  `marriage_anniversary_date` date DEFAULT NULL,
  `marital_status` varchar(191) DEFAULT 'unmarried',
  `notice_period_end_date` date DEFAULT NULL,
  `notice_period_start_date` date DEFAULT NULL,
  `probation_end_date` date DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `employee_details_employee_id_company_id_unique` (`employee_id`,`company_id`),
  UNIQUE KEY `employee_details_slack_username_company_id_unique` (`slack_username`,`company_id`),
  KEY `employee_details_company_id_foreign` (`company_id`),
  KEY `employee_details_user_id_foreign` (`user_id`),
  KEY `employee_details_department_id_foreign` (`department_id`),
  KEY `employee_details_designation_id_foreign` (`designation_id`),
  KEY `employee_details_added_by_foreign` (`added_by`),
  KEY `employee_details_last_updated_by_foreign` (`last_updated_by`),
  KEY `employee_details_reporting_to_foreign` (`reporting_to`),
  CONSTRAINT `employee_details_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_details_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `teams` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_designation_id_foreign` FOREIGN KEY (`designation_id`) REFERENCES `designations` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_details_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_reporting_to_foreign` FOREIGN KEY (`reporting_to`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_details_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_details` WRITE;
/*!40000 ALTER TABLE `employee_details` DISABLE KEYS */;
INSERT INTO `employee_details` VALUES
(1,1,1,'1',NULL,NULL,NULL,2,3,'2023-05-29 22:00:00',NULL,NULL,1,'2025-12-02',NULL,'task,events,holiday,tickets,leaves',NULL,NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2023-05-30 16:35:23','2025-12-02 07:55:08'),
(2,1,2,'2','59 route de Saint Trivier 69580 Sathonay Village',NULL,NULL,1,1,'2022-08-15 22:00:00',NULL,1,2,'2025-12-02','1985-11-23','task,events,holiday,tickets,leaves',NULL,NULL,NULL,NULL,'full_time',NULL,'married',NULL,NULL,NULL,'2023-06-01 09:46:31','2025-12-02 07:55:08'),
(7,1,12,'3',NULL,NULL,NULL,4,2,'2025-02-23 23:00:00',NULL,12,2,'2025-12-02','1985-11-23','task,events,holiday,tickets,leaves',NULL,NULL,NULL,NULL,NULL,NULL,'unmarried',NULL,NULL,NULL,'2025-02-24 15:02:09','2025-12-02 07:55:08');
/*!40000 ALTER TABLE `employee_details` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_docs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_docs` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `name` varchar(200) NOT NULL,
  `filename` varchar(200) NOT NULL,
  `hashname` varchar(200) NOT NULL,
  `size` varchar(200) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_docs_company_id_foreign` (`company_id`),
  KEY `employee_docs_user_id_foreign` (`user_id`),
  KEY `employee_docs_added_by_foreign` (`added_by`),
  KEY `employee_docs_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `employee_docs_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_docs_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_docs` WRITE;
/*!40000 ALTER TABLE `employee_docs` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_docs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_leave_quotas`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_leave_quotas` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `leave_type_id` int(10) unsigned NOT NULL,
  `no_of_leaves` double NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_leave_quotas_user_id_foreign` (`user_id`),
  KEY `employee_leave_quotas_leave_type_id_foreign` (`leave_type_id`),
  CONSTRAINT `employee_leave_quotas_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_leave_quotas_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_leave_quotas` WRITE;
/*!40000 ALTER TABLE `employee_leave_quotas` DISABLE KEYS */;
INSERT INTO `employee_leave_quotas` VALUES
(7,1,4,10,'2023-06-01 10:52:55','2023-06-01 10:52:55'),
(8,2,4,10,'2023-06-01 10:52:55','2023-06-01 10:52:55'),
(9,1,5,0,'2023-06-01 10:54:04','2023-06-01 10:54:04'),
(10,2,5,0,'2023-06-01 10:54:04','2023-06-01 10:54:04'),
(13,1,7,0,'2023-06-01 10:55:34','2023-06-01 10:55:34'),
(14,2,7,0,'2023-06-01 10:55:34','2023-06-01 10:55:34'),
(15,1,8,0,'2023-06-01 10:55:46','2023-06-01 10:55:46'),
(16,2,8,0,'2023-06-01 10:55:46','2023-06-01 10:55:46'),
(17,1,9,0,'2023-06-01 10:56:00','2023-06-01 10:56:00'),
(18,2,9,0,'2023-06-01 10:56:00','2023-06-01 10:56:00'),
(24,1,10,5,'2023-06-02 05:15:48','2023-06-02 05:15:48'),
(25,2,10,5,'2023-06-02 05:15:48','2023-06-02 05:15:48'),
(45,12,4,30,'2025-02-24 15:02:09','2025-02-24 15:02:09'),
(46,12,5,0,'2025-02-24 15:02:09','2025-02-24 15:02:09'),
(47,12,7,0,'2025-02-24 15:02:09','2025-02-24 15:02:09'),
(48,12,8,0,'2025-02-24 15:02:09','2025-02-24 15:02:09'),
(49,12,9,0,'2025-02-24 15:02:09','2025-02-24 15:02:09'),
(50,12,10,0,'2025-02-24 15:02:09','2025-02-24 15:02:09');
/*!40000 ALTER TABLE `employee_leave_quotas` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shift_change_requests`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shift_change_requests` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `shift_schedule_id` bigint(20) unsigned NOT NULL,
  `employee_shift_id` bigint(20) unsigned NOT NULL,
  `status` enum('waiting','accepted','rejected') NOT NULL DEFAULT 'waiting',
  `reason` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shift_change_requests_company_id_foreign` (`company_id`),
  KEY `employee_shift_change_requests_shift_schedule_id_foreign` (`shift_schedule_id`),
  KEY `employee_shift_change_requests_employee_shift_id_foreign` (`employee_shift_id`),
  CONSTRAINT `employee_shift_change_requests_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_change_requests_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_change_requests_shift_schedule_id_foreign` FOREIGN KEY (`shift_schedule_id`) REFERENCES `employee_shift_schedules` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shift_change_requests` WRITE;
/*!40000 ALTER TABLE `employee_shift_change_requests` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_shift_change_requests` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shift_schedules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shift_schedules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `employee_shift_id` bigint(20) unsigned NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `shift_start_time` datetime DEFAULT NULL,
  `shift_end_time` datetime DEFAULT NULL,
  `remarks` text DEFAULT NULL,
  `file` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shift_schedules_user_id_foreign` (`user_id`),
  KEY `employee_shift_schedules_date_index` (`date`),
  KEY `employee_shift_schedules_employee_shift_id_foreign` (`employee_shift_id`),
  KEY `employee_shift_schedules_added_by_foreign` (`added_by`),
  KEY `employee_shift_schedules_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `employee_shift_schedules_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_employee_shift_id_foreign` FOREIGN KEY (`employee_shift_id`) REFERENCES `employee_shifts` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `employee_shift_schedules_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shift_schedules` WRITE;
/*!40000 ALTER TABLE `employee_shift_schedules` DISABLE KEYS */;
INSERT INTO `employee_shift_schedules` VALUES
(1,2,'2023-06-01',3,1,1,'2023-06-01 08:00:00','2023-06-01 18:00:00',NULL,'','2023-06-02 05:16:31','2023-06-02 05:16:31'),
(8,2,'2025-02-24',2,2,2,'2025-02-24 09:00:00','2025-02-24 18:00:00',NULL,'','2025-02-24 11:48:32','2025-02-24 11:48:32');
/*!40000 ALTER TABLE `employee_shift_schedules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_shifts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_shifts` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `shift_name` varchar(191) NOT NULL,
  `shift_short_code` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `office_start_time` time NOT NULL,
  `office_end_time` time NOT NULL,
  `halfday_mark_time` time DEFAULT NULL,
  `late_mark_duration` tinyint(4) NOT NULL,
  `clockin_in_day` tinyint(4) NOT NULL,
  `office_open_days` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `early_clock_in` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_shifts_company_id_foreign` (`company_id`),
  CONSTRAINT `employee_shifts_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_shifts` WRITE;
/*!40000 ALTER TABLE `employee_shifts` DISABLE KEYS */;
INSERT INTO `employee_shifts` VALUES
(1,1,'Day Off','DO','#E8EEF3','00:00:00','00:00:00',NULL,0,0,'','2023-05-30 16:31:56','2023-05-30 16:31:56',NULL),
(2,1,'Exemple','GS','#99C7F1','09:00:00','18:00:00','07:45:00',20,2,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2023-05-30 16:31:56','2023-06-02 03:49:36',NULL),
(3,1,'Bureau','BE','#16813D','08:00:00','18:00:00','12:00:00',15,2,'[\"1\",\"2\",\"3\",\"4\",\"5\"]','2023-06-02 03:49:17','2023-06-02 03:49:17','15');
/*!40000 ALTER TABLE `employee_shifts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_skills`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_skills` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `skill_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_skills_company_id_foreign` (`company_id`),
  KEY `employee_skills_user_id_foreign` (`user_id`),
  KEY `employee_skills_skill_id_foreign` (`skill_id`),
  CONSTRAINT `employee_skills_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_skills_skill_id_foreign` FOREIGN KEY (`skill_id`) REFERENCES `skills` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_skills_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_skills` WRITE;
/*!40000 ALTER TABLE `employee_skills` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_skills` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `employee_teams`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `employee_teams` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `team_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `employee_teams_company_id_foreign` (`company_id`),
  KEY `employee_teams_team_id_foreign` (`team_id`),
  KEY `employee_teams_user_id_foreign` (`user_id`),
  CONSTRAINT `employee_teams_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_teams_team_id_foreign` FOREIGN KEY (`team_id`) REFERENCES `teams` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `employee_teams_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `employee_teams` WRITE;
/*!40000 ALTER TABLE `employee_teams` DISABLE KEYS */;
/*!40000 ALTER TABLE `employee_teams` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_item_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `estimate_item_id` int(10) unsigned NOT NULL,
  `filename` varchar(191) NOT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_item_images_estimate_item_id_foreign` (`estimate_item_id`),
  CONSTRAINT `estimate_item_images_estimate_item_id_foreign` FOREIGN KEY (`estimate_item_id`) REFERENCES `estimate_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_item_images` WRITE;
/*!40000 ALTER TABLE `estimate_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `estimate_id` int(10) unsigned NOT NULL,
  `item_name` varchar(191) NOT NULL,
  `item_summary` text DEFAULT NULL,
  `type` enum('item','discount','tax') NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) DEFAULT NULL,
  `hsn_sac_code` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_items_estimate_id_foreign` (`estimate_id`),
  KEY `estimate_items_unit_id_foreign` (`unit_id`),
  KEY `estimate_items_product_id_foreign` (`product_id`),
  CONSTRAINT `estimate_items_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimate_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_items` WRITE;
/*!40000 ALTER TABLE `estimate_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_template_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_template_item_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `estimate_template_item_id` int(10) unsigned NOT NULL,
  `filename` varchar(191) NOT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_template_item_images_company_id_foreign` (`company_id`),
  KEY `estimate_template_item_images_estimate_template_item_id_foreign` (`estimate_template_item_id`),
  CONSTRAINT `estimate_template_item_images_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_template_item_images_estimate_template_item_id_foreign` FOREIGN KEY (`estimate_template_item_id`) REFERENCES `estimate_template_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_template_item_images` WRITE;
/*!40000 ALTER TABLE `estimate_template_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_template_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_template_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_template_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `estimate_template_id` bigint(20) unsigned NOT NULL,
  `hsn_sac_code` varchar(191) DEFAULT NULL,
  `item_name` varchar(191) NOT NULL,
  `type` enum('item','discount','tax') NOT NULL DEFAULT 'item',
  `quantity` tinyint(4) NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `item_summary` text DEFAULT NULL,
  `taxes` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_template_items_company_id_foreign` (`company_id`),
  KEY `estimate_template_items_estimate_template_id_foreign` (`estimate_template_id`),
  KEY `estimate_template_items_unit_id_foreign` (`unit_id`),
  KEY `estimate_template_items_product_id_foreign` (`product_id`),
  CONSTRAINT `estimate_template_items_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_template_items_estimate_template_id_foreign` FOREIGN KEY (`estimate_template_id`) REFERENCES `estimate_templates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_template_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimate_template_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_template_items` WRITE;
/*!40000 ALTER TABLE `estimate_template_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_template_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimate_templates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimate_templates` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `sub_total` double NOT NULL,
  `total` double NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `discount_type` enum('percent','fixed') NOT NULL,
  `discount` double NOT NULL,
  `invoice_convert` tinyint(1) NOT NULL DEFAULT 0,
  `status` enum('declined','accepted','waiting') NOT NULL DEFAULT 'waiting',
  `note` mediumtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') NOT NULL DEFAULT 'after_discount',
  `client_comment` text DEFAULT NULL,
  `signature_approval` tinyint(1) NOT NULL DEFAULT 1,
  `hash` text DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `estimate_templates_company_id_foreign` (`company_id`),
  KEY `estimate_templates_currency_id_foreign` (`currency_id`),
  KEY `estimate_templates_added_by_foreign` (`added_by`),
  KEY `estimate_templates_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `estimate_templates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimate_templates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimate_templates` WRITE;
/*!40000 ALTER TABLE `estimate_templates` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimate_templates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `estimates`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `estimates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned NOT NULL,
  `estimate_number` bigint(20) DEFAULT NULL,
  `valid_till` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `discount_type` enum('percent','fixed') NOT NULL DEFAULT 'percent',
  `total` double(16,2) NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `status` enum('declined','accepted','waiting','sent','draft','canceled') NOT NULL DEFAULT 'waiting',
  `note` mediumtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `send_status` tinyint(1) NOT NULL DEFAULT 1,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `hash` text DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `last_viewed` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `estimates_estimate_number_company_id_unique` (`estimate_number`,`company_id`),
  KEY `estimates_company_id_foreign` (`company_id`),
  KEY `estimates_client_id_foreign` (`client_id`),
  KEY `estimates_currency_id_foreign` (`currency_id`),
  KEY `estimates_added_by_foreign` (`added_by`),
  KEY `estimates_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `estimates_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `estimates_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `estimates_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `estimates` WRITE;
/*!40000 ALTER TABLE `estimates` DISABLE KEYS */;
/*!40000 ALTER TABLE `estimates` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `event_attendees`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_attendees` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `event_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_attendees_company_id_foreign` (`company_id`),
  KEY `event_attendees_user_id_foreign` (`user_id`),
  KEY `event_attendees_event_id_foreign` (`event_id`),
  CONSTRAINT `event_attendees_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_attendees_event_id_foreign` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_attendees_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `event_attendees` WRITE;
/*!40000 ALTER TABLE `event_attendees` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_attendees` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `event_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `event_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `event_id` int(10) unsigned NOT NULL,
  `filename` varchar(200) DEFAULT NULL,
  `hashname` varchar(200) DEFAULT NULL,
  `size` varchar(200) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `event_files_company_id_foreign` (`company_id`),
  KEY `event_files_event_id_foreign` (`event_id`),
  KEY `event_files_added_by_foreign` (`added_by`),
  KEY `event_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `event_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `event_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_files_event_id_foreign` FOREIGN KEY (`event_id`) REFERENCES `events` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `event_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `event_files` WRITE;
/*!40000 ALTER TABLE `event_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `event_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `events` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `event_name` varchar(191) NOT NULL,
  `label_color` varchar(191) NOT NULL,
  `where` varchar(191) NOT NULL,
  `description` mediumtext NOT NULL,
  `start_date_time` datetime NOT NULL,
  `end_date_time` datetime NOT NULL,
  `repeat` enum('yes','no') NOT NULL DEFAULT 'no',
  `repeat_every` int(11) DEFAULT NULL,
  `repeat_cycles` int(11) DEFAULT NULL,
  `repeat_type` enum('day','week','month','year') NOT NULL DEFAULT 'day',
  `send_reminder` enum('yes','no') NOT NULL DEFAULT 'no',
  `remind_time` int(11) DEFAULT NULL,
  `remind_type` enum('day','hour','minute') NOT NULL DEFAULT 'day',
  `event_link` varchar(191) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `event_id` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `events_company_id_foreign` (`company_id`),
  KEY `events_added_by_foreign` (`added_by`),
  KEY `events_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `events_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `events_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `events_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `events` WRITE;
/*!40000 ALTER TABLE `events` DISABLE KEYS */;
INSERT INTO `events` VALUES
(1,1,'Réunion de Bureau','#FF0000','Visio','','2024-02-27 12:30:00','2024-02-27 13:00:00','no',NULL,NULL,'day','no',NULL,'day',NULL,NULL,NULL,NULL,'2024-02-26 16:56:55','2024-02-26 16:56:55');
/*!40000 ALTER TABLE `events` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `item_name` varchar(191) NOT NULL,
  `purchase_date` date NOT NULL,
  `purchase_from` varchar(191) DEFAULT NULL,
  `price` double(16,2) NOT NULL,
  `currency_id` int(10) unsigned NOT NULL,
  `default_currency_id` int(10) unsigned DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `bill` varchar(191) DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` enum('pending','approved','rejected') NOT NULL DEFAULT 'pending',
  `can_claim` tinyint(1) NOT NULL DEFAULT 1,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `expenses_recurring_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `description` text DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `approver_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bank_account_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_company_id_foreign` (`company_id`),
  KEY `expenses_currency_id_foreign` (`currency_id`),
  KEY `expenses_user_id_foreign` (`user_id`),
  KEY `expenses_category_id_foreign` (`category_id`),
  KEY `expenses_expenses_recurring_id_foreign` (`expenses_recurring_id`),
  KEY `expenses_created_by_foreign` (`created_by`),
  KEY `expenses_added_by_foreign` (`added_by`),
  KEY `expenses_last_updated_by_foreign` (`last_updated_by`),
  KEY `expenses_approver_id_foreign` (`approver_id`),
  KEY `expenses_bank_account_id_foreign` (`bank_account_id`),
  KEY `expenses_default_currency_id_foreign` (`default_currency_id`),
  CONSTRAINT `expenses_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_approver_id_foreign` FOREIGN KEY (`approver_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `expenses_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_default_currency_id_foreign` FOREIGN KEY (`default_currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_expenses_recurring_id_foreign` FOREIGN KEY (`expenses_recurring_id`) REFERENCES `expenses_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_category` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `category_name` varchar(191) NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_category_company_id_foreign` (`company_id`),
  KEY `expenses_category_added_by_foreign` (`added_by`),
  KEY `expenses_category_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `expenses_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_category` WRITE;
/*!40000 ALTER TABLE `expenses_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_category_roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_category_roles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `expenses_category_id` bigint(20) unsigned DEFAULT NULL,
  `role_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_category_roles_company_id_foreign` (`company_id`),
  KEY `expenses_category_roles_expenses_category_id_foreign` (`expenses_category_id`),
  KEY `expenses_category_roles_role_id_foreign` (`role_id`),
  CONSTRAINT `expenses_category_roles_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_roles_expenses_category_id_foreign` FOREIGN KEY (`expenses_category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_category_roles_role_id_foreign` FOREIGN KEY (`role_id`) REFERENCES `roles` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_category_roles` WRITE;
/*!40000 ALTER TABLE `expenses_category_roles` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_category_roles` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `expenses_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `expenses_recurring` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `category_id` bigint(20) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `item_name` varchar(191) NOT NULL,
  `day_of_month` int(11) DEFAULT 1,
  `day_of_week` int(11) DEFAULT 1,
  `payment_method` varchar(191) DEFAULT NULL,
  `rotation` enum('monthly','weekly','bi-weekly','quarterly','half-yearly','annually','daily') NOT NULL,
  `billing_cycle` int(11) DEFAULT NULL,
  `issue_date` date NOT NULL,
  `next_expense_date` date DEFAULT NULL,
  `unlimited_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `price` double NOT NULL,
  `bill` varchar(191) DEFAULT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `description` text DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `purchase_from` varchar(191) DEFAULT NULL,
  `immediate_expense` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bank_account_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `expenses_recurring_company_id_foreign` (`company_id`),
  KEY `expenses_recurring_category_id_foreign` (`category_id`),
  KEY `expenses_recurring_currency_id_foreign` (`currency_id`),
  KEY `expenses_recurring_project_id_foreign` (`project_id`),
  KEY `expenses_recurring_user_id_foreign` (`user_id`),
  KEY `expenses_recurring_created_by_foreign` (`created_by`),
  KEY `expenses_recurring_added_by_foreign` (`added_by`),
  KEY `expenses_recurring_last_updated_by_foreign` (`last_updated_by`),
  KEY `expenses_recurring_bank_account_id_foreign` (`bank_account_id`),
  CONSTRAINT `expenses_recurring_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `expenses_category` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `expenses_recurring_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `expenses_recurring` WRITE;
/*!40000 ALTER TABLE `expenses_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `expenses_recurring` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) NOT NULL,
  `connection` text NOT NULL,
  `queue` text NOT NULL,
  `payload` longtext NOT NULL,
  `exception` longtext NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `file_storage`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_storage` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `path` varchar(191) NOT NULL,
  `filename` varchar(191) NOT NULL,
  `type` varchar(50) DEFAULT NULL,
  `size` int(10) unsigned NOT NULL,
  `storage_location` enum('local','aws_s3','digitalocean','wasabi') NOT NULL DEFAULT 'local',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `file_storage_company_id_foreign` (`company_id`),
  CONSTRAINT `file_storage_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `file_storage` WRITE;
/*!40000 ALTER TABLE `file_storage` DISABLE KEYS */;
/*!40000 ALTER TABLE `file_storage` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `file_storage_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `file_storage_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filesystem` varchar(191) NOT NULL,
  `auth_keys` text DEFAULT NULL,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'disabled',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `file_storage_settings` WRITE;
/*!40000 ALTER TABLE `file_storage_settings` DISABLE KEYS */;
INSERT INTO `file_storage_settings` VALUES
(1,'local',NULL,'enabled','2023-05-30 16:31:54','2023-05-30 16:31:54');
/*!40000 ALTER TABLE `file_storage_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `flags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `flags` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `capital` varchar(191) DEFAULT NULL,
  `code` varchar(191) DEFAULT NULL,
  `continent` varchar(191) DEFAULT NULL,
  `name` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=267 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `flags` WRITE;
/*!40000 ALTER TABLE `flags` DISABLE KEYS */;
INSERT INTO `flags` VALUES
(1,'Kabul','af','Asia','Afghanistan'),
(2,'Mariehamn','ax','Europe','Aland Islands'),
(3,'Tirana','al','Europe','Albania'),
(4,'Algiers','dz','Africa','Algeria'),
(5,'Pago Pago','as','Oceania','American Samoa'),
(6,'Andorra la Vella','ad','Europe','Andorra'),
(7,'Luanda','ao','Africa','Angola'),
(8,'The Valley','ai','North America','Anguilla'),
(9,'','aq','','Antarctica'),
(10,'St. John\'s','ag','North America','Antigua and Barbuda'),
(11,'Buenos Aires','ar','South America','Argentina'),
(12,'Yerevan','am','Asia','Armenia'),
(13,'Oranjestad','aw','South America','Aruba'),
(14,'Georgetown','ac','Africa','Ascension Island'),
(15,'Canberra','au','Oceania','Australia'),
(16,'Vienna','at','Europe','Austria'),
(17,'Baku','az','Asia','Azerbaijan'),
(18,'Nassau','bs','North America','Bahamas'),
(19,'Manama','bh','Asia','Bahrain'),
(20,'Dhaka','bd','Asia','Bangladesh'),
(21,'Bridgetown','bb','North America','Barbados'),
(22,'Minsk','by','Europe','Belarus'),
(23,'Brussels','be','Europe','Belgium'),
(24,'Belmopan','bz','North America','Belize'),
(25,'Porto-Novo','bj','Africa','Benin'),
(26,'Hamilton','bm','North America','Bermuda'),
(27,'Thimphu','bt','Asia','Bhutan'),
(28,'Sucre','bo','South America','Bolivia'),
(29,'Kralendijk','bq','South America','Bonaire, Sint Eustatius and Saba'),
(30,'Sarajevo','ba','Europe','Bosnia and Herzegovina'),
(31,'Gaborone','bw','Africa','Botswana'),
(32,'','bv','','Bouvet Island'),
(33,'Brasília','br','South America','Brazil'),
(34,'Diego Garcia','io','Asia','British Indian Ocean Territory'),
(35,'Bandar Seri Begawan','bn','Asia','Brunei Darussalam'),
(36,'Sofia','bg','Europe','Bulgaria'),
(37,'Ouagadougou','bf','Africa','Burkina Faso'),
(38,'Bujumbura','bi','Africa','Burundi'),
(39,'Praia','cv','Africa','Cabo Verde'),
(40,'Phnom Penh','kh','Asia','Cambodia'),
(41,'Yaoundé','cm','Africa','Cameroon'),
(42,'Ottawa','ca','North America','Canada'),
(43,'','ic','','Canary Islands'),
(44,'','es-ct','','Catalonia'),
(45,'George Town','ky','North America','Cayman Islands'),
(46,'Bangui','cf','Africa','Central African Republic'),
(47,'','cefta','','Central European Free Trade Agreement'),
(48,'','ea','','Ceuta & Melilla'),
(49,'N\'Djamena','td','Africa','Chad'),
(50,'Santiago','cl','South America','Chile'),
(51,'Beijing','cn','Asia','China'),
(52,'Flying Fish Cove','cx','Asia','Christmas Island'),
(53,'','cp','','Clipperton Island'),
(54,'West Island','cc','Asia','Cocos (Keeling) Islands'),
(55,'Bogotá','co','South America','Colombia'),
(56,'Moroni','km','Africa','Comoros'),
(57,'Avarua','ck','Oceania','Cook Islands'),
(58,'San José','cr','North America','Costa Rica'),
(59,'Zagreb','hr','Europe','Croatia'),
(60,'Havana','cu','North America','Cuba'),
(61,'Willemstad','cw','South America','Curaçao'),
(62,'Nicosia','cy','Europe','Cyprus'),
(63,'Prague','cz','Europe','Czech Republic'),
(64,'Yamoussoukro','ci','Africa','Côte d\'Ivoire'),
(65,'Kinshasa','cd','Africa','Democratic Republic of the Congo'),
(66,'Copenhagen','dk','Europe','Denmark'),
(67,'','dg','','Diego Garcia'),
(68,'Djibouti','dj','Africa','Djibouti'),
(69,'Roseau','dm','North America','Dominica'),
(70,'Santo Domingo','do','North America','Dominican Republic'),
(71,'Quito','ec','South America','Ecuador'),
(72,'Cairo','eg','Africa','Egypt'),
(73,'San Salvador','sv','North America','El Salvador'),
(74,'London','gb-eng','Europe','England'),
(75,'Malabo','gq','Africa','Equatorial Guinea'),
(76,'Asmara','er','Africa','Eritrea'),
(77,'Tallinn','ee','Europe','Estonia'),
(78,'Lobamba, Mbabane','sz','Africa','Eswatini'),
(79,'Addis Ababa','et','Africa','Ethiopia'),
(80,'','eu','','Europe'),
(81,'Stanley','fk','South America','Falkland Islands'),
(82,'Tórshavn','fo','Europe','Faroe Islands'),
(83,'Palikir','fm','Oceania','Federated States of Micronesia'),
(84,'Suva','fj','Oceania','Fiji'),
(85,'Helsinki','fi','Europe','Finland'),
(86,'Paris','fr','Europe','France'),
(87,'Cayenne','gf','South America','French Guiana'),
(88,'Papeete','pf','Oceania','French Polynesia'),
(89,'Saint-Pierre, Réunion','tf','Africa','French Southern Territories'),
(90,'Libreville','ga','Africa','Gabon'),
(91,'','es-ga','','Galicia'),
(92,'Banjul','gm','Africa','Gambia'),
(93,'Tbilisi','ge','Asia','Georgia'),
(94,'Berlin','de','Europe','Germany'),
(95,'Accra','gh','Africa','Ghana'),
(96,'Gibraltar','gi','Europe','Gibraltar'),
(97,'Athens','gr','Europe','Greece'),
(98,'Nuuk','gl','North America','Greenland'),
(99,'St. George\'s','gd','North America','Grenada'),
(100,'Basse-Terre','gp','North America','Guadeloupe'),
(101,'Hagåtña','gu','Oceania','Guam'),
(102,'Guatemala City','gt','North America','Guatemala'),
(103,'Saint Peter Port','gg','Europe','Guernsey'),
(104,'Conakry','gn','Africa','Guinea'),
(105,'Bissau','gw','Africa','Guinea-Bissau'),
(106,'Georgetown','gy','South America','Guyana'),
(107,'Port-au-Prince','ht','North America','Haiti'),
(108,'','hm','','Heard Island and McDonald Islands'),
(109,'Vatican City','va','Europe','Holy See'),
(110,'Tegucigalpa','hn','North America','Honduras'),
(111,'Hong Kong','hk','Asia','Hong Kong'),
(112,'Budapest','hu','Europe','Hungary'),
(113,'Reykjavik','is','Europe','Iceland'),
(114,'New Delhi','in','Asia','India'),
(115,'Jakarta','id','Asia','Indonesia'),
(116,'Tehran','ir','Asia','Iran'),
(117,'Baghdad','iq','Asia','Iraq'),
(118,'Dublin','ie','Europe','Ireland'),
(119,'Douglas','im','Europe','Isle of Man'),
(120,'Jerusalem','il','Asia','Israel'),
(121,'Rome','it','Europe','Italy'),
(122,'Kingston','jm','North America','Jamaica'),
(123,'Tokyo','jp','Asia','Japan'),
(124,'Saint Helier','je','Europe','Jersey'),
(125,'Amman','jo','Asia','Jordan'),
(126,'Astana','kz','Asia','Kazakhstan'),
(127,'Nairobi','ke','Africa','Kenya'),
(128,'South Tarawa','ki','Oceania','Kiribati'),
(129,'Pristina','xk','Europe','Kosovo'),
(130,'Kuwait City','kw','Asia','Kuwait'),
(131,'Bishkek','kg','Asia','Kyrgyzstan'),
(132,'Vientiane','la','Asia','Laos'),
(133,'Riga','lv','Europe','Latvia'),
(134,'Beirut','lb','Asia','Lebanon'),
(135,'Maseru','ls','Africa','Lesotho'),
(136,'Monrovia','lr','Africa','Liberia'),
(137,'Tripoli','ly','Africa','Libya'),
(138,'Vaduz','li','Europe','Liechtenstein'),
(139,'Vilnius','lt','Europe','Lithuania'),
(140,'Luxembourg City','lu','Europe','Luxembourg'),
(141,'Macau','mo','Asia','Macau'),
(142,'Antananarivo','mg','Africa','Madagascar'),
(143,'Lilongwe','mw','Africa','Malawi'),
(144,'Kuala Lumpur','my','Asia','Malaysia'),
(145,'Malé','mv','Asia','Maldives'),
(146,'Bamako','ml','Africa','Mali'),
(147,'Valletta','mt','Europe','Malta'),
(148,'Majuro','mh','Oceania','Marshall Islands'),
(149,'Fort-de-France','mq','North America','Martinique'),
(150,'Nouakchott','mr','Africa','Mauritania'),
(151,'Port Louis','mu','Africa','Mauritius'),
(152,'Mamoudzou','yt','Africa','Mayotte'),
(153,'Mexico City','mx','North America','Mexico'),
(154,'Chișinău','md','Europe','Moldova'),
(155,'Monaco','mc','Europe','Monaco'),
(156,'Ulaanbaatar','mn','Asia','Mongolia'),
(157,'Podgorica','me','Europe','Montenegro'),
(158,'Little Bay, Brades, Plymouth','ms','North America','Montserrat'),
(159,'Rabat','ma','Africa','Morocco'),
(160,'Maputo','mz','Africa','Mozambique'),
(161,'Naypyidaw','mm','Asia','Myanmar'),
(162,'Windhoek','na','Africa','Namibia'),
(163,'Yaren District','nr','Oceania','Nauru'),
(164,'Kathmandu','np','Asia','Nepal'),
(165,'Amsterdam','nl','Europe','Netherlands'),
(166,'Nouméa','nc','Oceania','New Caledonia'),
(167,'Wellington','nz','Oceania','New Zealand'),
(168,'Managua','ni','North America','Nicaragua'),
(169,'Niamey','ne','Africa','Niger'),
(170,'Abuja','ng','Africa','Nigeria'),
(171,'Alofi','nu','Oceania','Niue'),
(172,'Kingston','nf','Oceania','Norfolk Island'),
(173,'Pyongyang','kp','Asia','North Korea'),
(174,'Skopje','mk','Europe','North Macedonia'),
(175,'Belfast','gb-nir','Europe','Northern Ireland'),
(176,'Saipan','mp','Oceania','Northern Mariana Islands'),
(177,'Oslo','no','Europe','Norway'),
(178,'Muscat','om','Asia','Oman'),
(179,'Islamabad','pk','Asia','Pakistan'),
(180,'Ngerulmud','pw','Oceania','Palau'),
(181,'Panama City','pa','North America','Panama'),
(182,'Port Moresby','pg','Oceania','Papua New Guinea'),
(183,'Asunción','py','South America','Paraguay'),
(184,'Lima','pe','South America','Peru'),
(185,'Manila','ph','Asia','Philippines'),
(186,'Adamstown','pn','Oceania','Pitcairn'),
(187,'Warsaw','pl','Europe','Poland'),
(188,'Lisbon','pt','Europe','Portugal'),
(189,'San Juan','pr','North America','Puerto Rico'),
(190,'Doha','qa','Asia','Qatar'),
(191,'Brazzaville','cg','Africa','Republic of the Congo'),
(192,'Bucharest','ro','Europe','Romania'),
(193,'Moscow','ru','Europe','Russia'),
(194,'Kigali','rw','Africa','Rwanda'),
(195,'Saint-Denis','re','Africa','Réunion'),
(196,'Gustavia','bl','North America','Saint Barthélemy'),
(197,'Jamestown','sh','Africa','Saint Helena, Ascension and Tristan da Cunha'),
(198,'Basseterre','kn','North America','Saint Kitts and Nevis'),
(199,'Castries','lc','North America','Saint Lucia'),
(200,'Marigot','mf','North America','Saint Martin'),
(201,'Saint-Pierre','pm','North America','Saint Pierre and Miquelon'),
(202,'Kingstown','vc','North America','Saint Vincent and the Grenadines'),
(203,'Apia','ws','Oceania','Samoa'),
(204,'San Marino','sm','Europe','San Marino'),
(205,'São Tomé','st','Africa','Sao Tome and Principe'),
(206,'Riyadh','sa','Asia','Saudi Arabia'),
(207,'Edinburgh','gb-sct','Europe','Scotland'),
(208,'Dakar','sn','Africa','Senegal'),
(209,'Belgrade','rs','Europe','Serbia'),
(210,'Victoria','sc','Africa','Seychelles'),
(211,'Freetown','sl','Africa','Sierra Leone'),
(212,'Singapore','sg','Asia','Singapore'),
(213,'Philipsburg','sx','North America','Sint Maarten'),
(214,'Bratislava','sk','Europe','Slovakia'),
(215,'Ljubljana','si','Europe','Slovenia'),
(216,'Honiara','sb','Oceania','Solomon Islands'),
(217,'Mogadishu','so','Africa','Somalia'),
(218,'Pretoria','za','Africa','South Africa'),
(219,'King Edward Point','gs','Antarctica','South Georgia and the South Sandwich Islands'),
(220,'Seoul','kr','Asia','South Korea'),
(221,'Juba','ss','Africa','South Sudan'),
(222,'Madrid','es','Europe','Spain'),
(223,'Sri Jayawardenepura Kotte, Colombo','lk','Asia','Sri Lanka'),
(224,'Ramallah','ps','Asia','State of Palestine'),
(225,'Khartoum','sd','Africa','Sudan'),
(226,'Paramaribo','sr','South America','Suriname'),
(227,'Longyearbyen','sj','Europe','Svalbard and Jan Mayen'),
(228,'Stockholm','se','Europe','Sweden'),
(229,'Bern','ch','Europe','Switzerland'),
(230,'Damascus','sy','Asia','Syria'),
(231,'Taipei','tw','Asia','Taiwan'),
(232,'Dushanbe','tj','Asia','Tajikistan'),
(233,'Dodoma','tz','Africa','Tanzania'),
(234,'Bangkok','th','Asia','Thailand'),
(235,'Dili','tl','Asia','Timor-Leste'),
(236,'Lomé','tg','Africa','Togo'),
(237,'Nukunonu, Atafu,Tokelau','tk','Oceania','Tokelau'),
(238,'Nukuʻalofa','to','Oceania','Tonga'),
(239,'Port of Spain','tt','South America','Trinidad and Tobago'),
(240,'','ta','','Tristan da Cunha'),
(241,'Tunis','tn','Africa','Tunisia'),
(242,'Ankara','tr','Asia','Turkey'),
(243,'Ashgabat','tm','Asia','Turkmenistan'),
(244,'Cockburn Town','tc','North America','Turks and Caicos Islands'),
(245,'Funafuti','tv','Oceania','Tuvalu'),
(246,'Kampala','ug','Africa','Uganda'),
(247,'Kiev','ua','Europe','Ukraine'),
(248,'Abu Dhabi','ae','Asia','United Arab Emirates'),
(249,'London','gb','Europe','United Kingdom'),
(250,'','un','','United Nations'),
(251,'Washington, D.C.','um','North America','United States Minor Outlying Islands'),
(252,'Washington, D.C.','us','North America','United States of America'),
(253,'','xx','','Unknown'),
(254,'Montevideo','uy','South America','Uruguay'),
(255,'Tashkent','uz','Asia','Uzbekistan'),
(256,'Port Vila','vu','Oceania','Vanuatu'),
(257,'Caracas','ve','South America','Venezuela'),
(258,'Hanoi','vn','Asia','Vietnam'),
(259,'Road Town','vg','North America','Virgin Islands (British)'),
(260,'Charlotte Amalie','vi','North America','Virgin Islands (U.S.)'),
(261,'Cardiff','gb-wls','Europe','Wales'),
(262,'Mata-Utu','wf','Oceania','Wallis and Futuna'),
(263,'Laayoune','eh','Africa','Western Sahara'),
(264,'Sana\'a','ye','Asia','Yemen'),
(265,'Lusaka','zm','Africa','Zambia'),
(266,'Harare','zw','Africa','Zimbabwe');
/*!40000 ALTER TABLE `flags` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `gdpr_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `gdpr_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `enable_gdpr` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer_area` tinyint(1) NOT NULL DEFAULT 0,
  `show_customer_footer` tinyint(1) NOT NULL DEFAULT 0,
  `top_information_block` longtext DEFAULT NULL,
  `enable_export` tinyint(1) NOT NULL DEFAULT 0,
  `data_removal` tinyint(1) NOT NULL DEFAULT 0,
  `lead_removal_public_form` tinyint(1) NOT NULL DEFAULT 0,
  `terms_customer_footer` tinyint(1) NOT NULL DEFAULT 0,
  `terms` longtext DEFAULT NULL,
  `policy` longtext DEFAULT NULL,
  `public_lead_edit` tinyint(1) NOT NULL DEFAULT 0,
  `consent_customer` tinyint(1) NOT NULL DEFAULT 0,
  `consent_leads` tinyint(1) NOT NULL DEFAULT 0,
  `consent_block` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `gdpr_settings` WRITE;
/*!40000 ALTER TABLE `gdpr_settings` DISABLE KEYS */;
INSERT INTO `gdpr_settings` VALUES
(1,0,0,0,NULL,0,0,0,0,NULL,NULL,0,0,0,NULL,'2023-05-30 16:31:54','2023-05-30 16:31:54');
/*!40000 ALTER TABLE `gdpr_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `global_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `global_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `global_app_name` varchar(191) DEFAULT NULL,
  `logo` varchar(191) DEFAULT NULL,
  `light_logo` varchar(191) DEFAULT NULL,
  `login_background` varchar(191) DEFAULT NULL,
  `logo_background_color` varchar(191) DEFAULT NULL,
  `header_color` varchar(191) NOT NULL DEFAULT '#1D82F5',
  `sidebar_logo_style` varchar(191) DEFAULT 'square',
  `locale` varchar(191) NOT NULL DEFAULT 'en',
  `hash` varchar(191) DEFAULT NULL,
  `purchase_code` varchar(100) DEFAULT NULL,
  `supported_until` timestamp NULL DEFAULT NULL,
  `last_license_verified_at` timestamp NULL DEFAULT NULL,
  `google_recaptcha_status` enum('active','deactive') NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v2_status` enum('active','deactive') NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v2_site_key` varchar(191) DEFAULT NULL,
  `google_recaptcha_v2_secret_key` varchar(191) DEFAULT NULL,
  `google_recaptcha_v3_status` enum('active','deactive') NOT NULL DEFAULT 'deactive',
  `google_recaptcha_v3_site_key` varchar(191) DEFAULT NULL,
  `google_recaptcha_v3_secret_key` varchar(191) DEFAULT NULL,
  `app_debug` tinyint(1) NOT NULL DEFAULT 0,
  `currency_converter_key` varchar(191) NOT NULL,
  `currency_key_version` varchar(191) NOT NULL DEFAULT 'free',
  `date_format` varchar(20) NOT NULL DEFAULT 'd-m-Y',
  `time_format` varchar(20) NOT NULL DEFAULT 'h:i a',
  `moment_format` varchar(191) NOT NULL DEFAULT 'DD-MM-YYYY',
  `timezone` varchar(191) NOT NULL DEFAULT 'Asia/Kolkata',
  `rtl` tinyint(1) NOT NULL DEFAULT 0,
  `license_type` varchar(20) DEFAULT NULL,
  `hide_cron_message` tinyint(1) NOT NULL DEFAULT 0,
  `system_update` tinyint(1) NOT NULL DEFAULT 1,
  `show_review_modal` tinyint(1) NOT NULL DEFAULT 1,
  `last_cron_run` timestamp NULL DEFAULT NULL,
  `favicon` varchar(191) DEFAULT NULL,
  `auth_theme` enum('dark','light') NOT NULL DEFAULT 'light',
  `auth_theme_text` enum('dark','light') NOT NULL DEFAULT 'dark',
  `session_driver` enum('file','database') NOT NULL DEFAULT 'file',
  `allowed_file_types` text DEFAULT NULL,
  `allowed_file_size` int(11) NOT NULL DEFAULT 10,
  `datatable_row_limit` int(11) NOT NULL DEFAULT 10,
  `show_update_popup` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `google_map_key` varchar(191) DEFAULT NULL,
  `google_calendar_status` enum('active','inactive') NOT NULL DEFAULT 'inactive',
  `google_client_id` text DEFAULT NULL,
  `google_client_secret` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `global_settings` WRITE;
/*!40000 ALTER TABLE `global_settings` DISABLE KEYS */;
INSERT INTO `global_settings` VALUES
(1,'Gym Lyon Métropole','fb8cef2332eb86b7314cd819c0218887.png','28bbefd7b818f3efac760701dfbd78c2.png',NULL,'#FFFFFF','#1D82F5','square','fr','432712a1cf07882a6b48538b02077f98','9613980b-49c7-4948-803c-43cbf7533eb6','2023-11-27 00:09:17','2025-12-01 01:14:47','deactive','deactive',NULL,NULL,'deactive',NULL,NULL,1,'','free','d-m-Y','H:i','DD-MM-YYYY','Europe/Paris',0,'Regular License',1,1,1,'2025-12-02 11:50:08','05bf54f58175f039fbb7480c28faa3fb.png','light','dark','file','image/*,application/vnd.ms-excel,application/vnd.openxmlformats-officedocument.wordprocessingml.document,application/docx,application/pdf,text/plain,application/msword,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet,application/zip,application/x-zip-compressed,application/x-compressed,multipart/x-zip,.xlsx,video/x-flv,video/mp4,application/x-mpegURL,video/MP2T,video/3gpp,video/quicktime,video/x-msvideo,video/x-ms-wmv,application/sla,.stl',100,10,1,'2023-05-30 16:31:56','2025-12-02 11:50:08',NULL,'active','417214001331-3phf4eled338iqc0nvkpmabf3trkmjc4.apps.googleusercontent.com','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');
/*!40000 ALTER TABLE `global_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `google_calendar_modules`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `google_calendar_modules` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `lead_status` tinyint(1) NOT NULL DEFAULT 0,
  `leave_status` tinyint(1) NOT NULL DEFAULT 0,
  `invoice_status` tinyint(1) NOT NULL DEFAULT 0,
  `contract_status` tinyint(1) NOT NULL DEFAULT 0,
  `task_status` tinyint(1) NOT NULL DEFAULT 0,
  `event_status` tinyint(1) NOT NULL DEFAULT 0,
  `holiday_status` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `google_calendar_modules_company_id_foreign` (`company_id`),
  CONSTRAINT `google_calendar_modules_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `google_calendar_modules` WRITE;
/*!40000 ALTER TABLE `google_calendar_modules` DISABLE KEYS */;
INSERT INTO `google_calendar_modules` VALUES
(1,1,1,1,1,1,1,1,1,'2023-05-30 16:31:56','2023-06-02 10:55:59');
/*!40000 ALTER TABLE `google_calendar_modules` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `holidays`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `holidays` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `date` date NOT NULL,
  `occassion` varchar(100) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `event_id` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `holidays_company_id_foreign` (`company_id`),
  KEY `holidays_date_index` (`date`),
  KEY `holidays_added_by_foreign` (`added_by`),
  KEY `holidays_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `holidays_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `holidays_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `holidays_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `holidays` WRITE;
/*!40000 ALTER TABLE `holidays` DISABLE KEYS */;
INSERT INTO `holidays` VALUES
(1,1,'2023-01-01','Jour de l\'an',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(2,1,'2023-04-10','Lundi de Pâques',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(3,1,'2023-05-01','Fête du Travail',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(4,1,'2023-05-08','Victoire des alliés',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(5,1,'2023-05-18','jeudi de l\'ascension',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(6,1,'2023-05-29','Lundi de pentecôte',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(7,1,'2023-07-14','Fête nationale',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(8,1,'2023-08-15','Assomption',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(9,1,'2023-11-01','La toussaint',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(10,1,'2023-11-11','Armistice',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32'),
(11,1,'2023-12-25','Noel',1,1,NULL,'2023-05-30 18:06:32','2023-05-30 18:06:32');
/*!40000 ALTER TABLE `holidays` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int(10) unsigned NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `filename` varchar(200) DEFAULT NULL,
  `hashname` varchar(200) DEFAULT NULL,
  `size` varchar(200) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_files_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_files_added_by_foreign` (`added_by`),
  KEY `invoice_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `invoice_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_files_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_files` WRITE;
/*!40000 ALTER TABLE `invoice_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_item_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_item_id` int(10) unsigned NOT NULL,
  `filename` varchar(191) NOT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_item_images_invoice_item_id_foreign` (`invoice_item_id`),
  CONSTRAINT `invoice_item_images_invoice_item_id_foreign` FOREIGN KEY (`invoice_item_id`) REFERENCES `invoice_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_item_images` WRITE;
/*!40000 ALTER TABLE `invoice_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` int(10) unsigned NOT NULL,
  `item_name` varchar(191) NOT NULL,
  `item_summary` text DEFAULT NULL,
  `type` enum('item','discount','tax') NOT NULL DEFAULT 'item',
  `quantity` double(16,2) NOT NULL,
  `unit_price` double(16,2) NOT NULL,
  `amount` double(16,2) NOT NULL,
  `taxes` varchar(191) DEFAULT NULL,
  `hsn_sac_code` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_items_invoice_id_foreign` (`invoice_id`),
  KEY `invoice_items_unit_id_foreign` (`unit_id`),
  KEY `invoice_items_product_id_foreign` (`product_id`),
  CONSTRAINT `invoice_items_invoice_id_foreign` FOREIGN KEY (`invoice_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_items` WRITE;
/*!40000 ALTER TABLE `invoice_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `issue_date` date NOT NULL,
  `next_invoice_date` date DEFAULT NULL,
  `due_date` date NOT NULL,
  `sub_total` double NOT NULL DEFAULT 0,
  `total` double NOT NULL DEFAULT 0,
  `discount` double NOT NULL DEFAULT 0,
  `discount_type` enum('percent','fixed') NOT NULL DEFAULT 'percent',
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `file` varchar(191) DEFAULT NULL,
  `file_original_name` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `show_shipping_address` enum('yes','no') NOT NULL DEFAULT 'no',
  `day_of_month` int(11) DEFAULT 1,
  `day_of_week` int(11) DEFAULT 1,
  `payment_method` varchar(191) DEFAULT NULL,
  `rotation` enum('monthly','weekly','bi-weekly','quarterly','half-yearly','annually','daily') NOT NULL,
  `billing_cycle` int(11) DEFAULT NULL,
  `client_can_stop` tinyint(1) NOT NULL DEFAULT 1,
  `unlimited_recurring` tinyint(1) NOT NULL DEFAULT 0,
  `deleted_at` datetime DEFAULT NULL,
  `shipping_address` text DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') NOT NULL DEFAULT 'after_discount',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `immediate_invoice` tinyint(1) NOT NULL DEFAULT 0,
  `bank_account_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_company_id_foreign` (`company_id`),
  KEY `invoice_recurring_currency_id_foreign` (`currency_id`),
  KEY `invoice_recurring_project_id_foreign` (`project_id`),
  KEY `invoice_recurring_client_id_foreign` (`client_id`),
  KEY `invoice_recurring_user_id_foreign` (`user_id`),
  KEY `invoice_recurring_created_by_foreign` (`created_by`),
  KEY `invoice_recurring_added_by_foreign` (`added_by`),
  KEY `invoice_recurring_last_updated_by_foreign` (`last_updated_by`),
  KEY `invoice_recurring_bank_account_id_foreign` (`bank_account_id`),
  CONSTRAINT `invoice_recurring_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring` WRITE;
/*!40000 ALTER TABLE `invoice_recurring` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring_item_images`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring_item_images` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_recurring_item_id` int(10) unsigned NOT NULL,
  `filename` varchar(191) NOT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `external_link` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_item_images_invoice_recurring_item_id_foreign` (`invoice_recurring_item_id`),
  CONSTRAINT `invoice_recurring_item_images_invoice_recurring_item_id_foreign` FOREIGN KEY (`invoice_recurring_item_id`) REFERENCES `invoice_recurring_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring_item_images` WRITE;
/*!40000 ALTER TABLE `invoice_recurring_item_images` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring_item_images` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_recurring_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_recurring_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `invoice_recurring_id` bigint(20) unsigned NOT NULL,
  `item_name` varchar(191) NOT NULL,
  `quantity` double NOT NULL,
  `unit_price` double NOT NULL,
  `amount` double NOT NULL,
  `taxes` text DEFAULT NULL,
  `type` enum('item','discount','tax') NOT NULL DEFAULT 'item',
  `item_summary` text DEFAULT NULL,
  `hsn_sac_code` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `unit_id` bigint(20) unsigned DEFAULT NULL,
  `product_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_recurring_items_invoice_recurring_id_foreign` (`invoice_recurring_id`),
  KEY `invoice_recurring_items_unit_id_foreign` (`unit_id`),
  KEY `invoice_recurring_items_product_id_foreign` (`product_id`),
  CONSTRAINT `invoice_recurring_items_invoice_recurring_id_foreign` FOREIGN KEY (`invoice_recurring_id`) REFERENCES `invoice_recurring` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_items_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoice_recurring_items_unit_id_foreign` FOREIGN KEY (`unit_id`) REFERENCES `unit_types` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_recurring_items` WRITE;
/*!40000 ALTER TABLE `invoice_recurring_items` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoice_recurring_items` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoice_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoice_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `invoice_prefix` varchar(191) NOT NULL,
  `invoice_number_separator` varchar(191) NOT NULL DEFAULT '#',
  `invoice_digit` int(10) unsigned NOT NULL DEFAULT 3,
  `estimate_prefix` varchar(191) NOT NULL DEFAULT 'EST',
  `estimate_number_separator` varchar(191) NOT NULL DEFAULT '#',
  `estimate_digit` int(10) unsigned NOT NULL DEFAULT 3,
  `credit_note_prefix` varchar(191) NOT NULL DEFAULT 'CN',
  `credit_note_number_separator` varchar(191) NOT NULL DEFAULT '#',
  `credit_note_digit` int(10) unsigned NOT NULL DEFAULT 3,
  `contract_prefix` varchar(191) NOT NULL DEFAULT 'CONT',
  `contract_number_separator` varchar(191) NOT NULL DEFAULT '#',
  `contract_digit` int(10) unsigned NOT NULL DEFAULT 3,
  `order_prefix` varchar(191) NOT NULL DEFAULT 'ODR',
  `order_number_separator` varchar(191) NOT NULL DEFAULT '#',
  `order_digit` int(10) unsigned NOT NULL DEFAULT 3,
  `template` varchar(191) NOT NULL,
  `due_after` int(11) NOT NULL,
  `invoice_terms` text NOT NULL,
  `estimate_terms` text DEFAULT NULL,
  `gst_number` varchar(191) DEFAULT NULL,
  `show_gst` enum('yes','no') DEFAULT 'no',
  `logo` varchar(80) DEFAULT NULL,
  `hsn_sac_code_show` tinyint(1) NOT NULL DEFAULT 0,
  `locale` varchar(191) DEFAULT 'en',
  `send_reminder` int(11) NOT NULL DEFAULT 0,
  `reminder` enum('after','every') DEFAULT NULL,
  `send_reminder_after` int(11) NOT NULL DEFAULT 0,
  `tax_calculation_msg` tinyint(1) NOT NULL DEFAULT 0,
  `show_status` tinyint(1) NOT NULL DEFAULT 1,
  `authorised_signatory` tinyint(1) NOT NULL DEFAULT 0,
  `authorised_signatory_signature` varchar(191) DEFAULT NULL,
  `show_project` int(11) NOT NULL DEFAULT 0,
  `show_client_name` enum('yes','no') DEFAULT 'no',
  `show_client_email` enum('yes','no') DEFAULT 'no',
  `show_client_phone` enum('yes','no') DEFAULT 'no',
  `show_client_company_address` enum('yes','no') DEFAULT 'no',
  `show_client_company_name` enum('yes','no') DEFAULT 'no',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `invoice_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `invoice_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoice_settings` WRITE;
/*!40000 ALTER TABLE `invoice_settings` DISABLE KEYS */;
INSERT INTO `invoice_settings` VALUES
(1,1,'INV','#',3,'EST','#',3,'CN','#',3,'CONT','#',3,'ODR','#',3,'invoice-5',15,'Thank you for your business.',NULL,NULL,'no',NULL,0,'en',0,NULL,0,0,1,0,NULL,0,'yes','yes','yes','yes','yes','2023-05-30 16:31:56','2023-05-30 16:31:56');
/*!40000 ALTER TABLE `invoice_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `invoices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(10) unsigned DEFAULT NULL,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `invoice_number` bigint(20) NOT NULL,
  `issue_date` date NOT NULL,
  `due_date` date NOT NULL,
  `sub_total` double(16,2) NOT NULL,
  `discount` double NOT NULL DEFAULT 0,
  `discount_type` enum('percent','fixed') NOT NULL DEFAULT 'percent',
  `total` double(16,2) NOT NULL,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `default_currency_id` int(10) unsigned DEFAULT NULL,
  `exchange_rate` double DEFAULT NULL,
  `status` enum('paid','unpaid','partial','canceled','draft') NOT NULL DEFAULT 'unpaid',
  `recurring` enum('yes','no') NOT NULL DEFAULT 'no',
  `billing_cycle` int(11) DEFAULT NULL,
  `billing_interval` int(11) DEFAULT NULL,
  `billing_frequency` varchar(191) DEFAULT NULL,
  `file` varchar(191) DEFAULT NULL,
  `file_original_name` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `credit_note` tinyint(1) NOT NULL DEFAULT 0,
  `show_shipping_address` enum('yes','no') NOT NULL DEFAULT 'no',
  `estimate_id` int(10) unsigned DEFAULT NULL,
  `send_status` tinyint(1) NOT NULL DEFAULT 1,
  `due_amount` double(8,2) NOT NULL DEFAULT 0.00,
  `parent_id` int(10) unsigned DEFAULT NULL,
  `invoice_recurring_id` bigint(20) unsigned DEFAULT NULL,
  `created_by` int(10) unsigned DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `hash` text DEFAULT NULL,
  `calculate_tax` enum('after_discount','before_discount') NOT NULL DEFAULT 'after_discount',
  `company_address_id` bigint(20) unsigned DEFAULT NULL,
  `event_id` text DEFAULT NULL,
  `custom_invoice_number` varchar(191) DEFAULT NULL,
  `payment_status` enum('1','0') NOT NULL DEFAULT '0',
  `offline_method_id` int(10) unsigned DEFAULT NULL,
  `transaction_id` varchar(191) DEFAULT NULL,
  `gateway` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `bank_account_id` int(10) unsigned DEFAULT NULL,
  `last_viewed` timestamp NULL DEFAULT NULL,
  `ip_address` varchar(191) DEFAULT NULL,
  `quickbooks_invoice_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `invoices_invoice_number_company_id_unique` (`invoice_number`,`company_id`),
  UNIQUE KEY `invoices_transaction_id_unique` (`transaction_id`),
  KEY `invoices_company_id_foreign` (`company_id`),
  KEY `invoices_project_id_foreign` (`project_id`),
  KEY `invoices_client_id_foreign` (`client_id`),
  KEY `invoices_order_id_foreign` (`order_id`),
  KEY `invoices_due_date_index` (`due_date`),
  KEY `invoices_currency_id_foreign` (`currency_id`),
  KEY `invoices_estimate_id_foreign` (`estimate_id`),
  KEY `invoices_parent_id_foreign` (`parent_id`),
  KEY `invoices_invoice_recurring_id_foreign` (`invoice_recurring_id`),
  KEY `invoices_created_by_foreign` (`created_by`),
  KEY `invoices_added_by_foreign` (`added_by`),
  KEY `invoices_last_updated_by_foreign` (`last_updated_by`),
  KEY `invoices_company_address_id_foreign` (`company_address_id`),
  KEY `invoices_bank_account_id_foreign` (`bank_account_id`),
  KEY `invoices_default_currency_id_foreign` (`default_currency_id`),
  KEY `payments_offline_method_id_foreign` (`offline_method_id`),
  CONSTRAINT `invoices_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_bank_account_id_foreign` FOREIGN KEY (`bank_account_id`) REFERENCES `bank_accounts` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_client_id_foreign` FOREIGN KEY (`client_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_company_address_id_foreign` FOREIGN KEY (`company_address_id`) REFERENCES `company_addresses` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_created_by_foreign` FOREIGN KEY (`created_by`) REFERENCES `users` (`id`) ON DELETE NO ACTION ON UPDATE CASCADE,
  CONSTRAINT `invoices_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_default_currency_id_foreign` FOREIGN KEY (`default_currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_estimate_id_foreign` FOREIGN KEY (`estimate_id`) REFERENCES `estimates` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_invoice_recurring_id_foreign` FOREIGN KEY (`invoice_recurring_id`) REFERENCES `invoice_recurring` (`id`) ON DELETE SET NULL,
  CONSTRAINT `invoices_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_offline_method_id_foreign` FOREIGN KEY (`offline_method_id`) REFERENCES `offline_payment_methods` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_order_id_foreign` FOREIGN KEY (`order_id`) REFERENCES `orders` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `invoices_parent_id_foreign` FOREIGN KEY (`parent_id`) REFERENCES `invoices` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `invoices_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `invoices` WRITE;
/*!40000 ALTER TABLE `invoices` DISABLE KEYS */;
/*!40000 ALTER TABLE `invoices` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `issues`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `issues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `description` mediumtext NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `project_id` int(10) unsigned DEFAULT NULL,
  `status` enum('pending','resolved') NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `issues_company_id_foreign` (`company_id`),
  KEY `issues_user_id_foreign` (`user_id`),
  KEY `issues_project_id_foreign` (`project_id`),
  CONSTRAINT `issues_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `issues_project_id_foreign` FOREIGN KEY (`project_id`) REFERENCES `projects` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `issues_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `issues` WRITE;
/*!40000 ALTER TABLE `issues` DISABLE KEYS */;
/*!40000 ALTER TABLE `issues` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `job_batches`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `job_batches` (
  `id` varchar(191) NOT NULL,
  `name` varchar(191) NOT NULL,
  `total_jobs` int(11) NOT NULL,
  `pending_jobs` int(11) NOT NULL,
  `failed_jobs` int(11) NOT NULL,
  `failed_job_ids` text NOT NULL,
  `options` mediumtext DEFAULT NULL,
  `cancelled_at` int(11) DEFAULT NULL,
  `created_at` int(11) NOT NULL,
  `finished_at` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `job_batches` WRITE;
/*!40000 ALTER TABLE `job_batches` DISABLE KEYS */;
/*!40000 ALTER TABLE `job_batches` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) NOT NULL,
  `payload` longtext NOT NULL,
  `attempts` tinyint(3) unsigned NOT NULL,
  `reserved_at` int(10) unsigned DEFAULT NULL,
  `available_at` int(10) unsigned NOT NULL,
  `created_at` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
INSERT INTO `jobs` VALUES
(1,'default','{\"uuid\":\"29a624e2-b846-45a5-bf2e-1cbed40b97de\",\"displayName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"command\":\"O:43:\\\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\\\":10:{s:7:\\\"\\u0000*\\u0000data\\\";a:2:{i:0;s:10:\\\"backup:run\\\";i:1;a:2:{s:9:\\\"--only-db\\\";b:1;s:23:\\\"--disable-notifications\\\";b:1;}}s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}',0,NULL,1685476347,1685476347),
(2,'default','{\"uuid\":\"2629e0fa-75d9-474c-832e-7cb0fc97ed4f\",\"displayName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"job\":\"Illuminate\\\\Queue\\\\CallQueuedHandler@call\",\"maxTries\":null,\"maxExceptions\":null,\"failOnTimeout\":false,\"backoff\":null,\"timeout\":null,\"retryUntil\":null,\"data\":{\"commandName\":\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\",\"command\":\"O:43:\\\"Illuminate\\\\Foundation\\\\Console\\\\QueuedCommand\\\":10:{s:7:\\\"\\u0000*\\u0000data\\\";a:2:{i:0;s:10:\\\"backup:run\\\";i:1;a:2:{s:9:\\\"--only-db\\\";b:1;s:23:\\\"--disable-notifications\\\";b:1;}}s:10:\\\"connection\\\";N;s:5:\\\"queue\\\";N;s:15:\\\"chainConnection\\\";N;s:10:\\\"chainQueue\\\";N;s:19:\\\"chainCatchCallbacks\\\";N;s:5:\\\"delay\\\";N;s:11:\\\"afterCommit\\\";N;s:10:\\\"middleware\\\";a:0:{}s:7:\\\"chained\\\";a:0:{}}\"}}',0,NULL,1685476403,1685476403);
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_base_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_base_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `knowledge_base_id` int(10) unsigned NOT NULL,
  `filename` varchar(200) DEFAULT NULL,
  `hashname` varchar(200) DEFAULT NULL,
  `size` varchar(200) DEFAULT NULL,
  `external_link_name` varchar(191) DEFAULT NULL,
  `external_link` text DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_base_files_company_id_foreign` (`company_id`),
  KEY `knowledge_base_files_knowledge_base_id_foreign` (`knowledge_base_id`),
  KEY `knowledge_base_files_added_by_foreign` (`added_by`),
  KEY `knowledge_base_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `knowledge_base_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_knowledge_base_id_foreign` FOREIGN KEY (`knowledge_base_id`) REFERENCES `knowledge_bases` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_base_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_base_files` WRITE;
/*!40000 ALTER TABLE `knowledge_base_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_base_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_bases`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_bases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `to` varchar(191) NOT NULL DEFAULT 'employee',
  `heading` varchar(191) DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `added_by` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_bases_company_id_foreign` (`company_id`),
  KEY `knowledge_bases_category_id_foreign` (`category_id`),
  CONSTRAINT `knowledge_bases_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `knowledge_categories` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `knowledge_bases_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_bases` WRITE;
/*!40000 ALTER TABLE `knowledge_bases` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_bases` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `knowledge_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `knowledge_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `name` varchar(191) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `knowledge_categories_company_id_foreign` (`company_id`),
  CONSTRAINT `knowledge_categories_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `knowledge_categories` WRITE;
/*!40000 ALTER TABLE `knowledge_categories` DISABLE KEYS */;
/*!40000 ALTER TABLE `knowledge_categories` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `language_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_settings` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `language_code` varchar(191) NOT NULL,
  `language_name` varchar(191) NOT NULL,
  `status` enum('enabled','disabled') NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `flag_code` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `language_settings` WRITE;
/*!40000 ALTER TABLE `language_settings` DISABLE KEYS */;
INSERT INTO `language_settings` VALUES
(1,'en','English','enabled',NULL,NULL,'en'),
(2,'ar','Arabic','disabled',NULL,NULL,'sa'),
(3,'de','German','disabled',NULL,NULL,'de'),
(4,'es','Spanish','disabled',NULL,NULL,'es'),
(5,'et','Estonian','disabled',NULL,NULL,'et'),
(6,'fa','Farsi','disabled',NULL,NULL,'ir'),
(7,'fr','French','enabled',NULL,'2023-06-04 06:26:02','fr'),
(8,'gr','Greek','disabled',NULL,NULL,'gr'),
(9,'it','Italian','disabled',NULL,NULL,'it'),
(10,'nl','Dutch','disabled',NULL,NULL,'nl'),
(11,'pl','Polish','disabled',NULL,NULL,'pl'),
(12,'pt','Portuguese','disabled',NULL,NULL,'pt'),
(13,'pt-br','Portuguese (Brazil)','disabled',NULL,NULL,'br'),
(14,'ro','Romanian','disabled',NULL,NULL,'ro'),
(15,'ru','Russian','disabled',NULL,NULL,'ru'),
(16,'tr','Turkish','disabled',NULL,NULL,'tr'),
(17,'zh-CN','Chinese (S)','disabled',NULL,NULL,'cn'),
(18,'zh-TW','Chinese (T)','disabled',NULL,NULL,'cn');
/*!40000 ALTER TABLE `language_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_agents`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_agents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `status` enum('enabled','disabled') NOT NULL DEFAULT 'enabled',
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_agents_company_id_foreign` (`company_id`),
  KEY `lead_agents_user_id_foreign` (`user_id`),
  KEY `lead_agents_added_by_foreign` (`added_by`),
  KEY `lead_agents_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_agents_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_agents_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_agents` WRITE;
/*!40000 ALTER TABLE `lead_agents` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_agents` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_category` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `category_name` varchar(191) NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_category_company_id_foreign` (`company_id`),
  KEY `lead_category_added_by_foreign` (`added_by`),
  KEY `lead_category_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_category_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_category_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_category_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_category` WRITE;
/*!40000 ALTER TABLE `lead_category` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_category` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_custom_forms`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_custom_forms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `custom_fields_id` int(10) unsigned DEFAULT NULL,
  `field_display_name` varchar(191) NOT NULL,
  `field_name` varchar(191) NOT NULL,
  `field_order` int(11) NOT NULL,
  `status` enum('active','inactive') NOT NULL DEFAULT 'active',
  `required` tinyint(1) NOT NULL DEFAULT 0,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_custom_forms_company_id_foreign` (`company_id`),
  KEY `lead_custom_forms_custom_fields_id_foreign` (`custom_fields_id`),
  KEY `lead_custom_forms_added_by_foreign` (`added_by`),
  KEY `lead_custom_forms_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_custom_forms_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_custom_fields_id_foreign` FOREIGN KEY (`custom_fields_id`) REFERENCES `custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_custom_forms_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_custom_forms` WRITE;
/*!40000 ALTER TABLE `lead_custom_forms` DISABLE KEYS */;
INSERT INTO `lead_custom_forms` VALUES
(1,1,NULL,'Name','name',1,'active',1,NULL,NULL,NULL,NULL),
(2,1,NULL,'Email','email',2,'active',0,NULL,NULL,NULL,NULL),
(3,1,NULL,'Company Name','company_name',3,'active',0,NULL,NULL,NULL,NULL),
(4,1,NULL,'Website','website',4,'active',0,NULL,NULL,NULL,NULL),
(5,1,NULL,'Address','address',5,'active',0,NULL,NULL,NULL,NULL),
(6,1,NULL,'Mobile','mobile',6,'active',0,NULL,NULL,NULL,NULL),
(7,1,NULL,'Message','message',7,'active',0,NULL,NULL,NULL,NULL),
(8,1,NULL,'City','city',1,'active',0,NULL,NULL,NULL,NULL),
(9,1,NULL,'State','state',2,'active',0,NULL,NULL,NULL,NULL),
(10,1,NULL,'Country','country',3,'active',0,NULL,NULL,NULL,NULL),
(11,1,NULL,'Postal Code','postal_code',4,'active',0,NULL,NULL,NULL,NULL),
(12,1,NULL,'Source','source',8,'active',0,NULL,NULL,NULL,NULL),
(13,1,NULL,'Product','product',9,'active',0,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `lead_custom_forms` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `filename` varchar(200) NOT NULL,
  `hashname` varchar(200) NOT NULL,
  `size` varchar(200) NOT NULL,
  `description` text DEFAULT NULL,
  `google_url` varchar(191) DEFAULT NULL,
  `dropbox_link` varchar(191) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_files_lead_id_foreign` (`lead_id`),
  KEY `lead_files_user_id_foreign` (`user_id`),
  KEY `lead_files_added_by_foreign` (`added_by`),
  KEY `lead_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_files_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_files` WRITE;
/*!40000 ALTER TABLE `lead_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_follow_up`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_follow_up` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int(10) unsigned NOT NULL,
  `remark` longtext DEFAULT NULL,
  `next_follow_up_date` datetime DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `event_id` text DEFAULT NULL,
  `send_reminder` enum('yes','no') DEFAULT 'no',
  `remind_time` text DEFAULT NULL,
  `remind_type` enum('minute','hour','day') DEFAULT NULL,
  `status` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_follow_up_lead_id_foreign` (`lead_id`),
  KEY `lead_follow_up_added_by_foreign` (`added_by`),
  KEY `lead_follow_up_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_follow_up_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_follow_up_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_follow_up_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_follow_up` WRITE;
/*!40000 ALTER TABLE `lead_follow_up` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_follow_up` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int(10) unsigned DEFAULT NULL,
  `title` varchar(191) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT 0,
  `member_id` int(10) unsigned DEFAULT NULL,
  `is_lead_show` tinyint(1) NOT NULL DEFAULT 0,
  `ask_password` tinyint(1) NOT NULL DEFAULT 0,
  `details` longtext NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_notes_lead_id_foreign` (`lead_id`),
  KEY `lead_notes_member_id_foreign` (`member_id`),
  KEY `lead_notes_added_by_foreign` (`added_by`),
  KEY `lead_notes_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_notes_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_notes_member_id_foreign` FOREIGN KEY (`member_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_notes` WRITE;
/*!40000 ALTER TABLE `lead_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_products`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_products` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `lead_id` int(10) unsigned NOT NULL,
  `product_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_products_lead_id_foreign` (`lead_id`),
  KEY `lead_products_product_id_foreign` (`product_id`),
  CONSTRAINT `lead_products_lead_id_foreign` FOREIGN KEY (`lead_id`) REFERENCES `leads` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_products_product_id_foreign` FOREIGN KEY (`product_id`) REFERENCES `products` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_products` WRITE;
/*!40000 ALTER TABLE `lead_products` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_products` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_sources`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_sources` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lead_sources_type_company_id_unique` (`type`,`company_id`),
  KEY `lead_sources_company_id_foreign` (`company_id`),
  KEY `lead_sources_added_by_foreign` (`added_by`),
  KEY `lead_sources_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `lead_sources_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `lead_sources_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_sources_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_sources` WRITE;
/*!40000 ALTER TABLE `lead_sources` DISABLE KEYS */;
INSERT INTO `lead_sources` VALUES
(1,1,'email',NULL,NULL,NULL,NULL),
(2,1,'google',NULL,NULL,NULL,NULL),
(3,1,'facebook',NULL,NULL,NULL,NULL),
(4,1,'friend',NULL,NULL,NULL,NULL),
(5,1,'direct visit',NULL,NULL,NULL,NULL),
(6,1,'tv ad',NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `lead_sources` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_status`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_status` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `type` varchar(191) NOT NULL,
  `priority` int(11) NOT NULL,
  `default` tinyint(1) NOT NULL,
  `label_color` varchar(191) NOT NULL DEFAULT '#ff0000',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `lead_status_type_company_id_unique` (`type`,`company_id`),
  KEY `lead_status_company_id_foreign` (`company_id`),
  CONSTRAINT `lead_status_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_status` WRITE;
/*!40000 ALTER TABLE `lead_status` DISABLE KEYS */;
INSERT INTO `lead_status` VALUES
(1,1,'pending',1,1,'#FFE700',NULL,NULL),
(2,1,'in process',2,0,'#009EFF',NULL,NULL),
(3,1,'done',3,0,'#1FAE07',NULL,NULL);
/*!40000 ALTER TABLE `lead_status` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `lead_user_notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `lead_user_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `lead_note_id` int(10) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lead_user_notes_user_id_foreign` (`user_id`),
  KEY `lead_user_notes_lead_note_id_foreign` (`lead_note_id`),
  CONSTRAINT `lead_user_notes_lead_note_id_foreign` FOREIGN KEY (`lead_note_id`) REFERENCES `lead_notes` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `lead_user_notes_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `lead_user_notes` WRITE;
/*!40000 ALTER TABLE `lead_user_notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `lead_user_notes` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `leads` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `client_id` int(11) DEFAULT NULL,
  `source_id` int(11) DEFAULT NULL,
  `status_id` int(11) DEFAULT NULL,
  `column_priority` int(11) NOT NULL,
  `agent_id` bigint(20) unsigned DEFAULT NULL,
  `company_name` varchar(191) DEFAULT NULL,
  `website` varchar(191) DEFAULT NULL,
  `address` text DEFAULT NULL,
  `salutation` enum('mr','mrs','miss','dr','sir','madam') DEFAULT NULL,
  `client_name` varchar(191) NOT NULL,
  `client_email` varchar(191) DEFAULT NULL,
  `mobile` varchar(191) DEFAULT NULL,
  `cell` varchar(191) DEFAULT NULL,
  `office` varchar(191) DEFAULT NULL,
  `city` varchar(191) DEFAULT NULL,
  `state` varchar(191) DEFAULT NULL,
  `country` varchar(191) DEFAULT NULL,
  `postal_code` varchar(191) DEFAULT NULL,
  `note` text DEFAULT NULL,
  `next_follow_up` enum('yes','no') NOT NULL DEFAULT 'yes',
  `value` double DEFAULT 0,
  `currency_id` int(10) unsigned DEFAULT NULL,
  `category_id` int(10) unsigned DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `hash` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leads_company_id_foreign` (`company_id`),
  KEY `leads_agent_id_foreign` (`agent_id`),
  KEY `leads_currency_id_foreign` (`currency_id`),
  KEY `leads_category_id_foreign` (`category_id`),
  KEY `leads_added_by_foreign` (`added_by`),
  KEY `leads_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `leads_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `lead_agents` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_category_id_foreign` FOREIGN KEY (`category_id`) REFERENCES `lead_category` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leads_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_currency_id_foreign` FOREIGN KEY (`currency_id`) REFERENCES `currencies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leads_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leads` WRITE;
/*!40000 ALTER TABLE `leads` DISABLE KEYS */;
/*!40000 ALTER TABLE `leads` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_files` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `leave_id` int(10) unsigned NOT NULL,
  `filename` varchar(191) NOT NULL,
  `hashname` varchar(191) DEFAULT NULL,
  `size` varchar(191) DEFAULT NULL,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_files_company_id_foreign` (`company_id`),
  KEY `leave_files_user_id_foreign` (`user_id`),
  KEY `leave_files_leave_id_foreign` (`leave_id`),
  KEY `leave_files_added_by_foreign` (`added_by`),
  KEY `leave_files_last_updated_by_foreign` (`last_updated_by`),
  CONSTRAINT `leave_files_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leave_files_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leave_files_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leave_files_leave_id_foreign` FOREIGN KEY (`leave_id`) REFERENCES `leaves` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leave_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_files` WRITE;
/*!40000 ALTER TABLE `leave_files` DISABLE KEYS */;
/*!40000 ALTER TABLE `leave_files` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_settings` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `manager_permission` enum('pre-approve','approved','cannot-approve') NOT NULL DEFAULT 'pre-approve',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_settings_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_settings_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_settings` WRITE;
/*!40000 ALTER TABLE `leave_settings` DISABLE KEYS */;
INSERT INTO `leave_settings` VALUES
(1,1,'approved','2023-05-30 16:31:56','2023-06-02 08:00:57');
/*!40000 ALTER TABLE `leave_settings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leave_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `leave_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `type_name` varchar(191) NOT NULL,
  `color` varchar(191) NOT NULL,
  `no_of_leaves` int(11) NOT NULL DEFAULT 5,
  `paid` tinyint(1) NOT NULL DEFAULT 1,
  `monthly_limit` int(11) NOT NULL DEFAULT 0,
  `effective_after` int(11) DEFAULT NULL,
  `effective_type` varchar(191) DEFAULT NULL,
  `unused_leave` varchar(191) DEFAULT NULL,
  `encashed` tinyint(1) NOT NULL,
  `allowed_probation` tinyint(1) NOT NULL,
  `allowed_notice` tinyint(1) NOT NULL,
  `gender` varchar(191) DEFAULT NULL,
  `marital_status` varchar(191) DEFAULT NULL,
  `department` varchar(191) DEFAULT NULL,
  `designation` varchar(191) DEFAULT NULL,
  `role` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leave_types_company_id_foreign` (`company_id`),
  CONSTRAINT `leave_types_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leave_types` WRITE;
/*!40000 ALTER TABLE `leave_types` DISABLE KEYS */;
INSERT INTO `leave_types` VALUES
(4,1,'Congés payés','#16813D',30,1,0,NULL,'days','carry forward',0,0,0,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[\"1\",\"2\",3,4,5]','[\"1\",\"2\",\"3\",4,5,6,7,8,9,10]','[\"1\",\"2\",\"4\"]','2023-06-01 10:52:55','2025-02-24 14:30:26'),
(5,1,'Arrêts maladie','#D51ED5',0,1,0,NULL,'days','lapse',0,0,1,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[\"1\",\"2\",3,4,5]','[\"1\",\"2\",\"3\",4,5,6,7,8,9,10]','[\"1\",\"2\",\"4\"]','2023-06-01 10:54:04','2025-02-24 14:30:26'),
(7,1,'Congé maternité','#0CF5D4',0,1,0,NULL,'days','carry forward',0,1,1,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[\"1\",\"2\",3,4,5]','[\"1\",\"2\",\"3\",4,5,6,7,8,9,10]','[\"1\",\"2\",\"4\"]','2023-06-01 10:55:34','2025-02-24 14:30:26'),
(8,1,'Congé pour enfant malade','#FFDB06',0,1,0,NULL,'day','carry forward',0,1,1,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[\"1\",2,3,4,5]','[\"1\",2,3,4,5,6,7,8,9,10]','[\"1\",\"2\",\"4\"]','2023-06-01 10:55:46','2025-02-24 14:30:26'),
(9,1,'Congé de solidarité familiale','#005CF1',0,1,0,NULL,'day','carry forward',0,1,1,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[\"1\",2,3,4,5]','[\"1\",2,3,4,5,6,7,8,9,10]','[\"1\",\"2\",\"4\"]','2023-06-01 10:56:00','2025-02-24 14:30:26'),
(10,1,'Test','#16813D',0,1,0,NULL,'days','carry forward',0,0,0,'[\"male\",\"female\",\"others\"]','[\"married\",\"unmarried\"]','[\"1\",\"2\",3,4,5]','[\"1\",\"2\",\"3\",4,5,6,7,8,9,10]','[\"1\",\"2\",\"4\"]','2023-06-02 05:15:48','2025-02-24 14:30:26');
/*!40000 ALTER TABLE `leave_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `leaves`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `leaves` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `leave_type_id` int(10) unsigned NOT NULL,
  `unique_id` varchar(191) DEFAULT NULL,
  `duration` varchar(191) NOT NULL,
  `leave_date` date NOT NULL,
  `reason` text NOT NULL,
  `status` enum('approved','pending','rejected') NOT NULL,
  `reject_reason` text DEFAULT NULL,
  `paid` tinyint(1) NOT NULL DEFAULT 0,
  `added_by` int(10) unsigned DEFAULT NULL,
  `last_updated_by` int(10) unsigned DEFAULT NULL,
  `event_id` text DEFAULT NULL,
  `approved_by` int(10) unsigned DEFAULT NULL,
  `approved_at` datetime DEFAULT NULL,
  `half_day_type` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `manager_status_permission` enum('pre-approve','approved') DEFAULT NULL,
  `approve_reason` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `leaves_company_id_foreign` (`company_id`),
  KEY `leaves_user_id_foreign` (`user_id`),
  KEY `leaves_leave_type_id_foreign` (`leave_type_id`),
  KEY `leaves_leave_date_index` (`leave_date`),
  KEY `leaves_added_by_foreign` (`added_by`),
  KEY `leaves_last_updated_by_foreign` (`last_updated_by`),
  KEY `leaves_approved_by_foreign` (`approved_by`),
  CONSTRAINT `leaves_added_by_foreign` FOREIGN KEY (`added_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_approved_by_foreign` FOREIGN KEY (`approved_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leaves_last_updated_by_foreign` FOREIGN KEY (`last_updated_by`) REFERENCES `users` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `leaves_leave_type_id_foreign` FOREIGN KEY (`leave_type_id`) REFERENCES `leave_types` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `leaves_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `leaves` WRITE;
/*!40000 ALTER TABLE `leaves` DISABLE KEYS */;
/*!40000 ALTER TABLE `leaves` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `log_time_for`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `log_time_for` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(10) unsigned DEFAULT NULL,
  `log_time_for` enum('project','task') NOT NULL DEFAULT 'project',
  `auto_timer_stop` enum('yes','no') NOT NULL DEFAULT 'no',
  `approval_required` tinyint(1) NOT NULL,
  `tracker_reminder` tinyint(1) NOT NULL,
  `timelog_report` tinyint(1) NOT NULL,
  `daily_report_roles` varchar(191) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `time` time DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `log_time_for_company_id_foreign` (`company_id`),
  CONSTRAINT `log_time_for_company_id_foreign` FOREIGN KEY (`company_id`) REFERENCES `companies` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `log_time_for` WRITE;
/*!40000 ALTER TABLE `log_time_for` DISABLE KEYS */;
INSERT INTO `log_time_for` VALUES
(1,1,'project','no',0,0,1,'[\"4\"]','2023-05-30 16:31:56','2023-06-01 11:00:37','14:45:00');
/*!40000 ALTER TABLE `log_time_for` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `ltm_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8mb4 */;
CREATE TABLE `ltm_translations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `status` int(11) NOT NULL DEFAULT 0,
  `locale` varchar(191) NOT NULL,
  `group` varchar(191) NOT NULL,
  `key` varchar(191) NOT NULL,
  `value` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=22056 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `ltm_translations` WRITE;
/*!40000 ALTER TABLE `ltm_translations` DISABLE KEYS */;
INSERT INTO `ltm_translations` VALUES
(1,0,'en','app','addUnit','Add New Unit','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(2,0,'en','app','units','Units','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(3,0,'en','app','check','Check','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(4,0,'en','app','true','True','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(5,0,'en','app','false','False','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(6,0,'en','app','title','Title','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(7,0,'en','app','note','Note','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(8,0,'en','app','save','Save','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(9,0,'en','app','update','Update','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(10,0,'en','app','timer','Timer','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(11,0,'en','app','back','Back','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(12,0,'en','app','reset','Reset','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(13,0,'en','app','type','Type','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(14,0,'en','app','lateHalfday','HalfDay , Present( Late )','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(15,0,'en','app','addNew','Add New','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(16,0,'en','app','edit','Edit','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(17,0,'en','app','defaultStatus','Default Status','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(18,0,'en','app','id','Id','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(19,0,'en','app','hierarchy','Hierarchy','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(20,0,'en','app','dragAndDrop','Drag & Drop','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(21,0,'en','app','restructure','restructure','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(22,0,'en','app','name','Name','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(23,0,'en','app','email','Email','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(24,0,'en','app','overwriteAttendance','Attendance Overwrite','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(25,0,'en','app','slack','Slack','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(26,0,'en','app','emptyCart','Empty Cart','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(27,0,'en','app','pushNotification','Push Notification','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(28,0,'en','app','password','Password','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(29,0,'en','app','confirmPassword','Confirm Password','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(30,0,'en','app','phone','Phone','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(31,0,'en','app','mobile','Mobile','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(32,0,'en','app','createdAt','Created','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(33,0,'en','app','addedBy','Added By','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(34,0,'en','app','action','Action','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(35,0,'en','app','search','Search','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(36,0,'en','app','markRead','Mark as Read','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(37,0,'en','app','deadline','Deadline','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(38,0,'en','app','project','Project','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(39,0,'en','app','projectName','Project Name','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(40,0,'en','app','projects','Projects','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(41,0,'en','app','completion','Completion','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(42,0,'en','app','address','Address','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(43,0,'en','app','completed','Completed','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(44,0,'en','app','failed','Failed','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(45,0,'en','app','dueDate','Due Date','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(46,0,'en','app','status','Status','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(47,0,'en','app','selectStatus','Select Status','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(48,0,'en','app','task','Task','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(49,0,'en','app','tasks','Tasks','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(50,0,'en','app','client','Client','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(51,0,'en','app','stop','Stop','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(52,0,'en','app','remove','Remove','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(53,0,'en','app','description','Description','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(54,0,'en','app','incomplete','Incomplete','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(55,0,'en','app','invoice','Invoice','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(56,0,'en','app','date','Date','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(57,0,'en','app','apply','Apply','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(58,0,'en','app','change','Change','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(59,0,'en','app','employeeId','Employee Id','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(60,0,'en','app','logout','Logout','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(61,0,'en','app','active','Active','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(62,0,'en','app','clientName','Client Name','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(63,0,'en','app','lead','Lead','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(64,0,'en','app','paymentOn','Payment On','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(65,0,'en','app','amount','Amount','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(66,0,'en','app','gateway','Gateway','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(67,0,'en','app','transactionId','Transaction Id','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(68,0,'en','app','timeLog','Time Log ','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(69,0,'en','app','time log','Time Log ','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(70,0,'en','app','selectTask','Select Task','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(71,0,'en','app','category','Category','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(72,0,'en','app','panel','Panel','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(73,0,'en','app','credit-note','Credit Note','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(74,0,'en','app','addCreditNote','Add Credit Note','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(75,0,'en','app','mr','Mr','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(76,0,'en','app','mrs','Mrs','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(77,0,'en','app','miss','Miss','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(78,0,'en','app','dr','Dr.','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(79,0,'en','app','sir','Sir','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(80,0,'en','app','madam','Madam','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(81,0,'en','app','invoiceGenerate','Invoice Generated','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(82,0,'en','app','leave','Leave','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(83,0,'en','app','holiday','Holiday ( :name)','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(84,0,'en','app','inProcess','In Process','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(85,0,'en','app','overdue','Overdue','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(86,0,'en','app','clockInAt','Clock In at','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(87,0,'en','app','clockin','Clock In','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(88,0,'en','app','clockout','Clock Out','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(89,0,'en','app','attendanceof','Attendance Sheet of ','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(90,0,'en','app','paypal','Paypal','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(91,0,'en','app','stripe','Stripe','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(92,0,'en','app','razorpay','Razorpay','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(93,0,'en','app','paystack','Paystack','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(94,0,'en','app','mollie','Mollie','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(95,0,'en','app','payfast','Payfast','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(96,0,'en','app','authorize','Authorize.net','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(97,0,'en','app','square','Square','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(98,0,'en','app','flutterwave','Flutterwave','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(99,0,'en','app','offline','Offline','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(100,0,'en','app','lastTweleveMonths','Last 12 Months','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(101,0,'en','app','googleMap','Google Map','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(102,0,'en','app','fullTime','Full Time','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(103,0,'en','app','partTime','Part Time','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(104,0,'en','app','onContract','On Contract','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(105,0,'en','app','internship','Internship','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(106,0,'en','app','trainee','Trainee','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(107,0,'en','app','method','Method','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(108,0,'en','app','passport','Passport','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(109,0,'en','app','visa','Visa','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(110,0,'en','app','nationality','Nationality','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(111,0,'en','app','place','Place','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(112,0,'en','app','months.January','January','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(113,0,'en','app','months.February','February','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(114,0,'en','app','months.March','March','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(115,0,'en','app','months.April','April','2023-05-30 17:19:44','2023-06-04 07:35:58'),
(116,0,'en','app','months.May','May','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(117,0,'en','app','months.June','June','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(118,0,'en','app','months.July','July','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(119,0,'en','app','months.August','August','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(120,0,'en','app','months.September','September','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(121,0,'en','app','months.October','October','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(122,0,'en','app','months.November','November','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(123,0,'en','app','months.December','December','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(124,0,'en','app','menu.units','Units','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(125,0,'en','app','menu.prefixSettings','Prefix Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(126,0,'en','app','menu.parent_id','Parent','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(127,0,'en','app','menu.child_id','Child','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(128,0,'en','app','menu.home','Home','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(129,0,'en','app','menu.myCalendar','My Calendar','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(130,0,'en','app','menu.holiday','Holiday','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(131,0,'en','app','menu.dashboard','Dashboard','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(132,0,'en','app','menu.knowledgebase','Knowledge Base','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(133,0,'en','app','menu.clients','Clients','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(134,0,'en','app','menu.employees','Employees','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(135,0,'en','app','menu.projects','Projects','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(136,0,'en','app','menu.projectCalendar','Project Calendar','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(137,0,'en','app','menu.taskCalendar','Task Calendar','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(138,0,'en','app','menu.calendar','Calendar','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(139,0,'en','app','menu.messages','Messages','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(140,0,'en','app','menu.customFields','Custom Fields','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(141,0,'en','app','menu.Events','Events','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(142,0,'en','app','menu.products','Products','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(143,0,'en','app','menu.orders','Orders','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(144,0,'en','app','menu.profileSettings','Profile Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(145,0,'en','app','menu.twoFactorAuthentication','Two-Factor Authentication','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(146,0,'en','app','menu.attendanceSettings','Attendance Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(147,0,'en','app','menu.currencySettings','Currency Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(148,0,'en','app','menu.emailSettings','Email Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(149,0,'en','app','menu.employeeDocs','Employee Documents','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(150,0,'en','app','menu.clientDocs','Client Documents','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(151,0,'en','app','menu.financeReport','Finance Report','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(152,0,'en','app','menu.incomeVsExpenseReport','Income Vs Expense','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(153,0,'en','app','menu.invoiceSettings','Invoice Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(154,0,'en','app','menu.invoiceTemplate','Invoice Template','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(155,0,'en','app','menu.settings','Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(156,0,'en','app','menu.leadFiles','Lead Files','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(157,0,'en','app','menu.leadSource','Lead Source','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(158,0,'en','app','menu.leadStatus','Lead Status','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(159,0,'en','app','menu.leaveReport','Leave Report','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(160,0,'en','app','menu.leaveSettings','Leaves Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(161,0,'en','app','menu.leaveTypeSettings','Leaves Type Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(162,0,'en','app','menu.leaveGeneralSettings','Leaves General Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(163,0,'en','app','menu.timeLogSettings','Time Log Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(164,0,'en','app','menu.invoices','Invoices','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(165,0,'en','app','menu.issues','Issues','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(166,0,'en','app','menu.timeLogs','Timesheet','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(167,0,'en','app','menu.tasks','Tasks','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(168,0,'en','app','menu.attendance','Attendance','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(169,0,'en','app','menu.estimates','Estimates','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(170,0,'en','app','menu.expenses','Expenses','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(171,0,'en','app','menu.leaves','Leaves','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(172,0,'en','app','menu.leavesQuota','Leaves Quota','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(173,0,'en','app','menu.noticeBoard','Notice Board','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(174,0,'en','app','menu.notes','Notes','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(175,0,'en','app','menu.notices','Notices','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(176,0,'en','app','menu.payments','Payments','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(177,0,'en','app','menu.rolesPermission','Roles & Permissions','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(178,0,'en','app','menu.stickyNotes','Sticky Notes','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(179,0,'en','app','menu.teams','Department','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(180,0,'en','app','menu.tickets','Tickets','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(181,0,'en','app','menu.ticket','Ticket','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(182,0,'en','app','menu.messageSettings','Message Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(183,0,'en','app','menu.reports','Reports','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(184,0,'en','app','menu.taskReport','Task Report','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(185,0,'en','app','menu.timeLogReport','Time Log Report','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(186,0,'en','app','menu.timeSettings','Time Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(187,0,'en','app','menu.accountSettings','Company Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(188,0,'en','app','menu.moduleSettings','Module Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(189,0,'en','app','menu.moduleSettingsInstall','Module Install/Update','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(190,0,'en','app','menu.contacts','Contacts','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(191,0,'en','app','menu.paymentGatewayCredential','Payment Credentials','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(192,0,'en','app','menu.projectTemplateMember','Project Template Member','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(193,0,'en','app','menu.projectTemplate','Project Template','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(194,0,'en','app','menu.contractTemplate','Contract Template','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(195,0,'en','app','menu.projectTemplateTask','Project Template Task','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(196,0,'en','app','menu.pushNotifications','Push Notifications','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(197,0,'en','app','menu.slackSettings','Slack Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(198,0,'en','app','menu.storageSettings','Storage Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(199,0,'en','app','menu.updates','Update App','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(200,0,'en','app','menu.ticketSettings','Ticket Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(201,0,'en','app','menu.themeSettings','Theme Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(202,0,'en','app','menu.ticketAgents','Ticket Agents','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(203,0,'en','app','menu.ticketTypes','Ticket Types','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(204,0,'en','app','menu.groupManage','Ticket Groups','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(205,0,'en','app','menu.group','Group','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(206,0,'en','app','menu.ticketChannel','Ticket Channel','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(207,0,'en','app','menu.replyTemplates','Reply Templates','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(208,0,'en','app','menu.offlinePaymentMethod','Offline Payment Method','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(209,0,'en','app','menu.lead','Leads','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(210,0,'en','app','menu.finance','Finance','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(211,0,'en','app','menu.payroll','Payroll','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(212,0,'en','app','menu.employeeList','Employee List','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(213,0,'en','app','menu.onlinePayment','Online Payment Credential','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(214,0,'en','app','menu.method','Method','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(215,0,'en','app','menu.addProjectTemplate','Add Project Template','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(216,0,'en','app','menu.addContractTemplate','Add Contract Template','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(217,0,'en','app','menu.template','Template','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(218,0,'en','app','menu.notificationSettings','Notification Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(219,0,'en','app','menu.viewArchive','View Archive','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(220,0,'en','app','menu.clientModule','Client Module Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(221,0,'en','app','menu.employeeModule','Employee Module Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(222,0,'en','app','menu.adminModule','Admin Module Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(223,0,'en','app','menu.documents','Documents','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(224,0,'en','app','menu.attendanceReport','Attendance Report','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(225,0,'en','app','menu.projectSettings','Project Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(226,0,'en','app','menu.financeSettings','Finance Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(227,0,'en','app','menu.taxSettings','Tax Settings','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(228,0,'en','app','menu.credit-note','Credit Note','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(229,0,'en','app','menu.designation','Designation','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(230,0,'en','app','menu.help','Help','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(231,0,'en','app','menu.gdpr','GDPR','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(232,0,'en','app','menu.customers','Customers','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(233,0,'en','app','menu.sign','Sign','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(234,0,'en','app','menu.subject','Subject','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(235,0,'en','app','menu.joining','Joining','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(236,0,'en','app','menu.attrition','Attrition','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(237,0,'en','app','menu.contracts','Contracts','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(238,0,'en','app','menu.estimate','Estimate','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(239,0,'en','app','menu.customLink','Custom Link','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(240,0,'en','app','menu.pusher.appId','App Id','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(241,0,'en','app','menu.pusher.appKey','App Key','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(242,0,'en','app','menu.pusher.appSecret','App Secret','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(243,0,'en','app','menu.pusher.appCluster','App Cluster','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(244,0,'en','app','menu.pusher.forceTLS','Force TLS','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(245,0,'en','app','menu.content','Content','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(246,0,'en','app','menu.decline','Decline','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(247,0,'en','app','menu.signed','Signed','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(248,0,'en','app','menu.download','Download','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(249,0,'en','app','menu.applyToInvoice','Pay Invoice using Credit Note','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(250,0,'en','app','menu.credit-notes.invoiceDate','Invoice Date','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(251,0,'en','app','menu.credit-notes.invoiceAmount','Invoice Amount','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(252,0,'en','app','menu.credit-notes.invoiceBalanceDue','Invoice Balance Due','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(253,0,'en','app','menu.credit-notes.amountToCredit','Amount To Credit','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(254,0,'en','app','menu.credit-notes.remainingAmount','Remaining Amount','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(255,0,'en','app','menu.credit-notes.amountCredited','Amount Credited','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(256,0,'en','app','menu.creditedInvoices','Invoices Credited','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(257,0,'en','app','menu.appliedCredits','Applied Credits','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(258,0,'en','app','menu.ticketFiles','Ticket Files','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(259,0,'en','app','menu.file','Files','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(260,0,'en','app','menu.addFile','Add File','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(261,0,'en','app','menu.renew','Renew','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(262,0,'en','app','menu.upload','Upload','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(263,0,'en','app','menu.paymentReminder','Payment Reminder','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(264,0,'en','app','menu.leadAgent','Agent','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(265,0,'en','app','menu.purchaseAllow','Client can purchase','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(266,0,'en','app','menu.allowed','Allowed','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(267,0,'en','app','menu.notAllowed','Not Allowed','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(268,0,'en','app','menu.purchase','Purchase','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(269,0,'en','app','menu.purchaseDate','Purchase Date','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(270,0,'en','app','menu.product','Product','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(271,0,'en','app','menu.mark','Mark','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(272,0,'en','app','menu.exportPdf','Export To PDF','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(273,0,'en','app','menu.version','Version','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(274,0,'en','app','menu.currentVersion','Current Version','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(275,0,'en','app','menu.latestVersion','Latest Version','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(276,0,'en','app','menu.module','Module','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(277,0,'en','app','menu.install','Install','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(278,0,'en','app','menu.verifyEnvato','Verify Purchase Code','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(279,0,'en','app','menu.copy','Copy','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(280,0,'en','app','menu.copyAboveLink','Copy above link','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(281,0,'en','app','menu.used','Used','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(282,0,'en','app','menu.remaining','Remaining','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(283,0,'en','app','menu.adjustment','Adjustment','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(284,0,'en','app','menu.reply','Reply','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(285,0,'en','app','menu.private','Private','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(286,0,'en','app','menu.public','Public','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(287,0,'en','app','menu.today','Today','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(288,0,'en','app','menu.and','and','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(289,0,'en','app','menu.selectTeam','Select Department...','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(290,0,'en','app','menu.previous','Previous','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(291,0,'en','app','menu.next','Next','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(292,0,'en','app','menu.uploadNext','Upload and Move to Next Step','2023-05-30 17:19:45','2023-06-04 07:35:58'),
(293,0,'en','app','menu.projectAdmin','Project Admin','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(294,0,'en','app','menu.shippingAddress','Shipping Address','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(295,0,'en','app','menu.showShippingAddress','Show Shipping Address','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(296,0,'en','app','menu.hideShippingAddress','Hide Shipping Address','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(297,0,'en','app','menu.addShippingAddress','Add Shipping Address','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(298,0,'en','app','menu.new','New','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(299,0,'en','app','menu.share','Share','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(300,0,'en','app','menu.lastLogin','Last login at','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(301,0,'en','app','menu.approve','Approve','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(302,0,'en','app','menu.hrs','hrs','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(303,0,'en','app','menu.mins','mins','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(304,0,'en','app','menu.receipt','Receipt','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(305,0,'en','app','menu.callback','Callback','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(306,0,'en','app','menu.socialAuthSettings.google','Google','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(307,0,'en','app','menu.socialAuthSettings.facebook','Facebook','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(308,0,'en','app','menu.socialAuthSettings.linkedin','Linkedin','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(309,0,'en','app','menu.socialAuthSettings.twitter','Twitter','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(310,0,'en','app','menu.socialAuthSettings.googleClientId','Google App ID','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(311,0,'en','app','menu.socialAuthSettings.facebookClientId','Facebook App ID','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(312,0,'en','app','menu.socialAuthSettings.twitterClientId','Twitter App ID','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(313,0,'en','app','menu.socialAuthSettings.linkedinClientId','Linkedin App ID','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(314,0,'en','app','menu.socialAuthSettings.googleSecret','Google Secret','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(315,0,'en','app','menu.socialAuthSettings.facebookSecret','Facebook Secret','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(316,0,'en','app','menu.socialAuthSettings.twitterSecret','Twitter Secret','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(317,0,'en','app','menu.socialAuthSettings.linkedinSecret','Linkedin Secret','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(318,0,'en','app','menu.saveSend','Save & Send','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(319,0,'en','app','menu.saveDraft','Save as Draft','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(320,0,'en','app','menu.send','Send','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(321,0,'en','app','menu.languageSetting','Language Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(322,0,'en','app','menu.archive','Archive','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(323,0,'en','app','menu.selectCurrency','Select Currency','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(324,0,'en','app','menu.currency','Currency','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(325,0,'en','app','menu.draft','Draft','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(326,0,'en','app','menu.label','Label','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(327,0,'en','app','menu.labelName','Label Name','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(328,0,'en','app','menu.color','Color','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(329,0,'en','app','menu.columnStatus','Status','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(330,0,'en','app','menu.hr','HR','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(331,0,'en','app','menu.work','Work','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(332,0,'en','app','menu.contractType','Contract Type','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(333,0,'en','app','menu.contract','Contract','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(334,0,'en','app','menu.addContract','Add Contract','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(335,0,'en','app','menu.taskFiles','Task Files','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(336,0,'en','app','menu.customModule','Custom Modules','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(337,0,'en','app','menu.pusherSettings','Pusher','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(338,0,'en','app','menu.menuSetting','Menu Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(339,0,'en','app','menu.languageSettings','Language Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(340,0,'en','app','menu.leadSettings','Lead Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(341,0,'en','app','menu.taskSettings','Task Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(342,0,'en','app','menu.general','General','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(343,0,'en','app','menu.rightToDataPortability','Right to data portability','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(344,0,'en','app','menu.rightToErasure','Right to Erasure','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(345,0,'en','app','menu.rightToBeInformed','Right to be informed','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(346,0,'en','app','menu.rightOfRectification','Right of Access/Rectification','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(347,0,'en','app','menu.consent','Consent','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(348,0,'en','app','menu.proposal','Proposal','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(349,0,'en','app','menu.socialLogin','Social Login Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(350,0,'en','app','menu.leads','Leads','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(351,0,'en','app','menu.agentDashboard','Agent Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(352,0,'en','app','menu.taskLabel','Task Labels','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(353,0,'en','app','menu.projectDashboard','Project Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(354,0,'en','app','menu.clientDashboard','Client Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(355,0,'en','app','menu.hrDashboard','HR Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(356,0,'en','app','menu.ticketDashboard','Ticket Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(357,0,'en','app','menu.financeDashboard','Finance Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(358,0,'en','app','menu.expensesRecurring','Recurring Expenses','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(359,0,'en','app','menu.itemName','item Name','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(360,0,'en','app','menu.appSettings','App Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(361,0,'en','app','menu.securitySettings','Security Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(362,0,'en','app','menu.projectRating','Project Rating','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(363,0,'en','app','menu.gdprSettings','GDPR Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(364,0,'en','app','menu.removalRequest','Removal Request (Customer)','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(365,0,'en','app','menu.removalRequestLead','Removal Request (Lead)','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(366,0,'en','app','menu.businessAddresses','Business Address','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(367,0,'en','app','menu.googleCalendarSetting','Google Calendar Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(368,0,'en','app','menu.databaseBackupSetting','Database Backup Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(369,0,'en','app','menu.emailSync','Email Sync','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(370,0,'en','app','menu.employeeShifts','Employee Shifts','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(371,0,'en','app','menu.shiftRoster','Shift Roster','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(372,0,'en','app','menu.department','Department','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(373,0,'en','app','menu.expenseReport','Expense Report','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(374,0,'en','app','menu.advanced','Advanced','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(375,0,'en','app','menu.miroboard','Miroboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(376,0,'en','app','menu.bankaccount','Bank Account','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(377,0,'en','app','menu.award','Award','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(378,0,'en','app','menu.appreciation','Appreciation','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(379,0,'en','app','menu.consentSettings','Consent Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(380,0,'en','app','menu.consentLists','Consent Lists','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(381,0,'en','app','menu.leadReport','Lead Report','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(382,0,'en','app','menu.quickBookSettings','Quickbooks Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(383,0,'en','app','menu.customLinkSetting','Custom Link Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(384,0,'en','app','menu.salesReport','Sales Report','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(385,0,'en','app','menu.addProducts','Add Products','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(386,0,'en','app','menu.addHoliday','Add Holiday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(387,0,'en','app','menu.addShiftRoster','Add Shift Roster','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(388,0,'en','app','menu.addConsent','Add Consent','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(389,0,'en','app','menu.addReply','Add Reply','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(390,0,'en','app','menu.addDesignation','Add Designation','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(391,0,'en','app','menu.addTemplate','Add Template','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(392,0,'en','app','menu.privateDashboard','Private Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(393,0,'en','app','menu.advanceDashboard','Advanced Dashboard','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(394,0,'en','app','menu.contractSettings','Contract Settings','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(395,0,'en','app','menu.editDepartment','Edit Department','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(396,0,'en','app','menu.editdesignation','Edit Designation','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(397,0,'en','app','menu.editConsent','Edit Consent','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(398,0,'en','app','menu.editHoliday','Edit Holiday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(399,0,'en','app','menu.editLeaves','Edit Leaves','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(400,0,'en','app','menu.editProducts','Edit Products','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(401,0,'en','app','menu.editEvents','Edit Events','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(402,0,'en','app','menu.addBankAccount','Add Bank Account','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(403,0,'en','app','menu.selectProduct','Select Product','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(404,0,'en','app','menu.selectProductCategory','Select Product Category','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(405,0,'en','app','menu.listView','List View','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(406,0,'en','app','parentId','Parent','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(407,0,'en','app','childId','Child','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(408,0,'en','app','language','Language','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(409,0,'en','app','delete','Delete','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(410,0,'en','app','pending','Pending','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(411,0,'en','app','on-hold','On Hold','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(412,0,'en','app','processing','Processing','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(413,0,'en','app','refund','Refund','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(414,0,'en','app','refunded','Refunded','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(415,0,'en','app','deactive','Inactive','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(416,0,'en','app','inactive','Inactive','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(417,0,'en','app','admin','Admin','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(418,0,'en','app','employee','Employee','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(419,0,'en','app','complete','Complete','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(420,0,'en','app','approved','Approved','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(421,0,'en','app','reject','Reject','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(422,0,'en','app','preApprove','Pre-Approve','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(423,0,'en','app','progress','Progress','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(424,0,'en','app','required','is required','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(425,0,'en','app','reason','Reason','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(426,0,'en','app','yes','Yes','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(427,0,'en','app','no','No','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(428,0,'en','app','all','All','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(429,0,'en','app','exportExcel','Export','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(430,0,'en','app','importExcel','Import','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(431,0,'en','app','columnName','Column Name','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(432,0,'en','app','datatable','//cdn.datatables.net/plug-ins/1.10.15/i18n/English.json','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(433,0,'en','app','startDate','Start Date','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(434,0,'en','app','endDate','End Date','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(435,0,'en','app','cancel','Cancel','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(436,0,'en','app','updateContactDetails','Update Contact Details','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(437,0,'en','app','skills','Skills','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(438,0,'en','app','add','Add','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(439,0,'en','app','year','Year','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(440,0,'en','app','gstIn','GST IN','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(441,0,'en','app','close','Close','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(442,0,'en','app','remark','Remark','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(443,0,'en','app','next_follow_up','Allow Follow Up','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(444,0,'en','app','select','Select','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(445,0,'en','app','accept','Accept','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(446,0,'en','app','optional','Optional','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(447,0,'en','app','sampleFile','Sample File','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(448,0,'en','app','inclusiveAllTaxes','inclusive of all taxes','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(449,0,'en','app','team','Department','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(450,0,'en','app','list','List','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(451,0,'en','app','duration','Duration','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(452,0,'en','app','days','Day(s)','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(453,0,'en','app','month','Month','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(454,0,'en','app','upcoming','Upcoming','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(455,0,'en','app','disableCache','Disable Cache','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(456,0,'en','app','refreshCache','Refresh Cache','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(457,0,'en','app','submit','Submit','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(458,0,'en','app','manage','Manage','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(459,0,'en','app','open','Open','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(460,0,'en','app','resolved','Resolved','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(461,0,'en','app','rememberMe','Stay logged in','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(462,0,'en','app','forgotPassword','Forgot your password?','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(463,0,'en','app','forbiddenError','Forbidden Error','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(464,0,'en','app','to','To','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(465,0,'en','app','watchTutorial','Watch Tutorial','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(466,0,'en','app','view','View','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(467,0,'en','app','welcome','Welcome','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(468,0,'en','app','role','User Role','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(469,0,'en','app','projectAdminPanel','Project Admin Panel','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(470,0,'en','app','loginAsProjectAdmin','Login As Project Admin','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(471,0,'en','app','price','Price','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(472,0,'en','app','last','Last','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(473,0,'en','app','income','Income','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(474,0,'en','app','expense','Expense','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(475,0,'en','app','total','Total','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(476,0,'en','app','day','Day(s)','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(477,0,'en','app','week','Week(s)','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(478,0,'en','app','filterBy','Filter by','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(479,0,'en','app','others','Others','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(480,0,'en','app','value','Value','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(481,0,'en','app','monday','Monday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(482,0,'en','app','tuesday','Tuesday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(483,0,'en','app','wednesday','Wednesday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(484,0,'en','app','thursday','Thursday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(485,0,'en','app','friday','Friday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(486,0,'en','app','saturday','Saturday','2023-05-30 17:19:46','2023-06-04 07:35:58'),
(487,0,'en','app','sunday','Sunday','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(488,0,'en','app','newNotifications','New notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(489,0,'en','app','from','From','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(490,0,'en','app','low','Low','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(491,0,'en','app','Manage role','Manage role','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(492,0,'en','app','Search:','Search:','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(493,0,'en','app','rejected','Rejected','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(494,0,'en','app','selectFile','Select File','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(495,0,'en','app','login','Log In','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(496,0,'en','app','noPermission','You do not have permission to access this.','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(497,0,'en','app','recoverPassword','Recover Password','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(498,0,'en','app','resetPassword','Reset Password','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(499,0,'en','app','sendPasswordLink','Send Reset Link','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(500,0,'en','app','enterEmailInstruction','Enter your Email and instructions will be sent to you!','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(501,0,'en','app','medium','Medium','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(502,0,'en','app','high','High','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(503,0,'en','app','urgent','Urgent','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(504,0,'en','app','male','Male','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(505,0,'en','app','female','Female','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(506,0,'en','app','source','Source','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(507,0,'en','app','where','where','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(508,0,'en','app','followUp','Follow Up','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(509,0,'en','app','createdOn','Created','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(510,0,'en','app','updatedOn','Updated on','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(511,0,'en','app','notice','Notice','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(512,0,'en','app','minutes','Minutes','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(513,0,'en','app','onLeave','On Leave','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(514,0,'en','app','present','Present','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(515,0,'en','app','presentlate','Present(Late)','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(516,0,'en','app','enable','Enable','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(517,0,'en','app','disable','Disable','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(518,0,'en','app','absent','Absent','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(519,0,'en','app','paid','Paid','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(520,0,'en','app','unpaid','Unpaid','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(521,0,'en','app','partial','Partial','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(522,0,'en','app','earnings','Earnings','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(523,0,'en','app','latitude','Latitude','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(524,0,'en','app','longitude','Longitude','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(525,0,'en','app','generateKey','Generate Key','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(526,0,'en','app','gstNumber','GST/VAT Number','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(527,0,'en','app','showGst','Show Tax number on invoice','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(528,0,'en','app','showTaxCalculationMessage','Show tax calculation message','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(529,0,'en','app','showProjectOnInvoice','Show Project on invoice','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(530,0,'en','app','create','Create','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(531,0,'en','app','leaveStatus','Leave Status','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(532,0,'en','app','leaveType','Leave Type','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(533,0,'en','app','leaveDate','Leave Date','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(534,0,'en','app','thumbnail','Thumbnail','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(535,0,'en','app','enableCache','Enable Cache','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(536,0,'en','app','copied','Copied','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(537,0,'en','app','webhook','Webhook URL','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(538,0,'en','app','url','URL','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(539,0,'en','app','hour','Hour(s)','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(540,0,'en','app','minute','Minute(s)','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(541,0,'en','app','venue','Venue','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(542,0,'en','app','time','Time','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(543,0,'en','app','summary','Summary','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(544,0,'en','app','estimate','Estimate','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(545,0,'en','app','zero','Zero','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(546,0,'en','app','designation','Designation','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(547,0,'en','app','company_name','Company Name','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(548,0,'en','app','thanks','Thanks','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(549,0,'en','app','invoiceNumber','Invoice Number','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(550,0,'en','app','orderNumber','Order Number','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(551,0,'en','app','disabled','Disabled','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(552,0,'en','app','enabled','Enabled','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(553,0,'en','app','language_code','Language Code','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(554,0,'en','app','code','Code','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(555,0,'en','app','viewInvoice','View Related Invoice','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(556,0,'en','app','inProgress','In Progress','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(557,0,'en','app','onHold','On Hold','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(558,0,'en','app','notStarted','Not Started','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(559,0,'en','app','canceled','Canceled','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(560,0,'en','app','finished','Finished','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(561,0,'en','app','customers','Customers','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(562,0,'en','app','sign','Sign','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(563,0,'en','app','subject','Subject','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(564,0,'en','app','joining','Joining','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(565,0,'en','app','attrition','Attrition','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(566,0,'en','app','contracts','Contracts','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(567,0,'en','app','bankaccount','Bank Account','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(568,0,'en','app','Changestatus','Lead Status','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(569,0,'en','app','pusher.appId','App Id','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(570,0,'en','app','pusher.appKey','App Key','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(571,0,'en','app','pusher.appSecret','App Secret','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(572,0,'en','app','pusher.appCluster','App Cluster','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(573,0,'en','app','pusher.forceTLS','Force TLS','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(574,0,'en','app','content','Content','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(575,0,'en','app','decline','Decline','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(576,0,'en','app','signed','Signed','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(577,0,'en','app','download','Download','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(578,0,'en','app','applyToInvoice','Pay Invoice using Credit Note','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(579,0,'en','app','credit-notes.invoiceDate','Invoice Date','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(580,0,'en','app','credit-notes.invoiceAmount','Invoice Amount','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(581,0,'en','app','credit-notes.invoiceBalanceDue','Invoice Balance Due','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(582,0,'en','app','credit-notes.amountToCredit','Amount To Credit','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(583,0,'en','app','credit-notes.remainingAmount','Remaining Amount','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(584,0,'en','app','credit-notes.amountCredited','Amount Credited','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(585,0,'en','app','onesignal.actionMessage','We\'d like to show you notifications for the latest news and updates.','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(586,0,'en','app','onesignal.acceptButtonText','ALLOW','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(587,0,'en','app','onesignal.cancelButtonText','NO THANKS','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(588,0,'en','app','onesignal.tip.state.unsubscribed','Subscribe to notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(589,0,'en','app','onesignal.tip.state.subscribed','You\'re subscribed to notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(590,0,'en','app','onesignal.tip.state.blocked','You\'ve blocked notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(591,0,'en','app','onesignal.message.prenotify','Click to subscribe to notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(592,0,'en','app','onesignal.message.action.subscribed','Thanks for subscribing!','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(593,0,'en','app','onesignal.message.action.resubscribed','You\'re subscribed to notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(594,0,'en','app','onesignal.message.action.unsubscribed','You won\'t receive notifications again','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(595,0,'en','app','onesignal.dialog.main.title','Manage Site Notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(596,0,'en','app','onesignal.dialog.main.button.subscribe','SUBSCRIBE','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(597,0,'en','app','onesignal.dialog.main.button.unsubscribe','UNSUBSCRIBE','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(598,0,'en','app','onesignal.dialog.blocked.title','Unblock Notifications','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(599,0,'en','app','onesignal.dialog.blocked.message','Follow these instructions to allow notifications:','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(600,0,'en','app','creditedInvoices','Invoices Credited','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(601,0,'en','app','appliedCredits','Applied Credits','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(602,0,'en','app','ticketFiles','Ticket Files','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(603,0,'en','app','file','Files','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(604,0,'en','app','renew','Renew','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(605,0,'en','app','upload','Upload','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(606,0,'en','app','paymentReminder','Payment Reminder','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(607,0,'en','app','leadAgent','Agent','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(608,0,'en','app','purchaseAllow','Client can purchase','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(609,0,'en','app','allowed','Allowed','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(610,0,'en','app','notAllowed','Not Allowed','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(611,0,'en','app','purchase','Purchase','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(612,0,'en','app','purchaseDate','Purchase Date','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(613,0,'en','app','product','Product','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(614,0,'en','app','mark','Mark','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(615,0,'en','app','exportPdf','Export To PDF','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(616,0,'en','app','version','Version','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(617,0,'en','app','currentVersion','Current Version','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(618,0,'en','app','latestVersion','Latest Version','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(619,0,'en','app','module','Module','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(620,0,'en','app','install','Install','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(621,0,'en','app','verifyEnvato','Verify Purchase Code','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(622,0,'en','app','copy','Copy','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(623,0,'en','app','copyAboveLink','Copy above link','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(624,0,'en','app','used','Used','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(625,0,'en','app','remaining','Remaining','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(626,0,'en','app','adjustment','Adjustment','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(627,0,'en','app','reply','Reply','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(628,0,'en','app','private','Private','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(629,0,'en','app','public','Public','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(630,0,'en','app','today','Today','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(631,0,'en','app','and','and','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(632,0,'en','app','selectTeam','Select Department...','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(633,0,'en','app','previous','Previous','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(634,0,'en','app','next','Next','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(635,0,'en','app','uploadNext','Upload and Move to Next Step','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(636,0,'en','app','collapseSidebar','Collapse Sidebar','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(637,0,'en','app','collapse','Collapse','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(638,0,'en','app','projectAdmin','Project Admin','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(639,0,'en','app','shippingAddress','Shipping Address','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(640,0,'en','app','showShippingAddress','Show Shipping Address','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(641,0,'en','app','hideShippingAddress','Hide Shipping Address','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(642,0,'en','app','addShippingAddress','Add Shipping Address','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(643,0,'en','app','new','New','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(644,0,'en','app','customerResponded','Customer responded','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(645,0,'en','app','newResponse','New response','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(646,0,'en','app','share','Share','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(647,0,'en','app','expand','Expand','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(648,0,'en','app','lastLogin','Last login at','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(649,0,'en','app','approve','Approve','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(650,0,'en','app','hrs','hrs','2023-05-30 17:19:47','2023-06-04 07:35:58'),
(651,0,'en','app','mins','mins','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(652,0,'en','app','receipt','Receipt','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(653,0,'en','app','callback','Callback','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(654,0,'en','app','socialAuthSettings.google','Google','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(655,0,'en','app','socialAuthSettings.facebook','Facebook','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(656,0,'en','app','socialAuthSettings.linkedin','Linkedin','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(657,0,'en','app','socialAuthSettings.twitter','Twitter','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(658,0,'en','app','socialAuthSettings.googleClientId','Google App ID','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(659,0,'en','app','socialAuthSettings.facebookClientId','Facebook App ID','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(660,0,'en','app','socialAuthSettings.twitterClientId','Twitter App ID','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(661,0,'en','app','socialAuthSettings.linkedinClientId','Linkedin App ID','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(662,0,'en','app','socialAuthSettings.googleSecret','Google Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(663,0,'en','app','socialAuthSettings.facebookSecret','Facebook Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(664,0,'en','app','socialAuthSettings.twitterSecret','Twitter Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(665,0,'en','app','socialAuthSettings.linkedinSecret','Linkedin Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(666,0,'en','app','saveSend','Save & Send','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(667,0,'en','app','saveMark','Save & Mark as Send','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(668,0,'en','app','markSent','Mark as Sent','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(669,0,'en','app','saveDraft','Save as Draft','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(670,0,'en','app','send','Send','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(671,0,'en','app','languageSetting','Language Settings','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(672,0,'en','app','archive','Archive','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(673,0,'en','app','selectCurrency','Select Currency','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(674,0,'en','app','currency','Currency','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(675,0,'en','app','draft','Draft','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(676,0,'en','app','label','Label','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(677,0,'en','app','labelName','Label Name','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(678,0,'en','app','color','Color','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(679,0,'en','app','columnStatus','Status','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(680,0,'en','app','clientDashboard','Client Dashboard','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(681,0,'en','app','financeDashboard','Finance Dashboard','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(682,0,'en','app','signature','Signature','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(683,0,'en','app','hrDashboard','HR Dashboard','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(684,0,'en','app','completions','Completions','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(685,0,'en','app','projectDashboard','Project Dashboard','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(686,0,'en','app','ticketDashboard','Ticket Dashboard','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(687,0,'en','app','milestone','Milestone','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(688,0,'en','app','goToCart','Go to cart','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(689,0,'en','app','toAllEmployee','Assign To All Employees','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(690,0,'en','app','projectMember','Project Member','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(691,0,'en','app','notes','Notes','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(692,0,'en','app','daily','Daily','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(693,0,'en','app','weekly','Weekly','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(694,0,'en','app','bi-weekly','Bi-Weekly','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(695,0,'en','app','bi-week','Bi-Week','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(696,0,'en','app','monthly','Monthly','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(697,0,'en','app','halfday','HalfDay','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(698,0,'en','app','empdate','Employee / Date','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(699,0,'en','app','quarterly','Quarterly','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(700,0,'en','app','quarter','Quarter','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(701,0,'en','app','half-yearly','Half-Yearly','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(702,0,'en','app','half-year','Half-Year','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(703,0,'en','app','annually','Annually','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(704,0,'en','app','member','Member','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(705,0,'en','app','bill','Bill','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(706,0,'en','app','billableTask','Billable Task','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(707,0,'en','app','priceDetail','Price Detail','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(708,0,'en','app','recurringDetail','Recurring Detail','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(709,0,'en','app','infinite','Infinite','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(710,0,'en','app','completedExpense','Completed Expense','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(711,0,'en','app','pendingExpense','Pending Expense','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(712,0,'en','app','totalAmount','Total Amount','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(713,0,'en','app','recurring','Recurring','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(714,0,'en','app','info','Info','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(715,0,'en','app','duplicate','Duplicate','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(716,0,'en','app','pin','Pin','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(717,0,'en','app','removePinned','Remove Pin','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(718,0,'en','app','unpin','Unpin','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(719,0,'en','app','pinnedItem','Pinned Project','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(720,0,'en','app','pinnedTask','Pinned Task','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(721,0,'en','app','sorry','Sorry','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(722,0,'en','app','about','About','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(723,0,'en','app','todaysAttendance','Today`s Attendance','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(724,0,'en','app','pinned','Pinned','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(725,0,'en','app','invoiceRecurring','Recurring Invoice','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(726,0,'en','app','pendingInvoice','Pending  Invoice','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(727,0,'en','app','completedInvoice','Completed Invoice','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(728,0,'en','app','recurringInvoices','Recurring Invoices','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(729,0,'en','app','client_name','Client Name','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(730,0,'en','app','selectFollowUpDateRange','Select Follow-up Date Range','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(731,0,'en','app','contractFiles','Contract Files','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(732,0,'en','app','preview','Preview','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(733,0,'en','app','fields','Field','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(734,0,'en','app','closed','Closed','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(735,0,'en','app','cancelEstimate','Cancel Estimate','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(736,0,'en','app','enterYear','4-digit year','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(737,0,'en','app','clearFilters','Clear','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(738,0,'en','app','startTyping','Start typing to search','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(739,0,'en','app','selectAction','No Action','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(740,0,'en','app','country','Country','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(741,0,'en','app','dragDrop','Choose a file','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(742,0,'en','app','dragDropReplace','Drop a file or click to replace','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(743,0,'en','app','largeFile','Sorry, the file is too large','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(744,0,'en','app','filters','Filters','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(745,0,'en','app','moreFilters','Filters','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(746,0,'en','app','planned','Planned','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(747,0,'en','app','actual','Actual','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(748,0,'en','app','overrun','Overrun','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(749,0,'en','app','threshold','Threshold','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(750,0,'en','app','default','Default','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(751,0,'en','app','readBy','Read By','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(752,0,'en','app','unReadBy','Waiting for Read','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(753,0,'en','app','viewPassword','Show/Hide Value','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(754,0,'en','app','contact','Contact','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(755,0,'en','app','addContact','Add Contact','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(756,0,'en','app','other','Other','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(757,0,'en','app','rating','Rating','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(758,0,'en','app','comment','Comment','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(759,0,'en','app','cardDetails','Card Details','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(760,0,'en','app','proposal','Proposal','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(761,0,'en','app','hsnSacCode','HSN/SAC Code','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(762,0,'en','app','hsnSacCodeShow','Hsn/Sac Code Show','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(763,0,'en','app','added','Added','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(764,0,'en','app','owned','Owned','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(765,0,'en','app','both','Added & Owned','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(766,0,'en','app','none','None','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(767,0,'en','app','more','More','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(768,0,'en','app','inviteMember','Invite member to ','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(769,0,'en','app','darkTheme','Dark Mode','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(770,0,'en','app','addToCart','Add to Cart','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(771,0,'en','app','cart','Cart','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(772,0,'en','app','order','Order','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(773,0,'en','app','signUp','Sign up','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(774,0,'en','app','by','By','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(775,0,'en','app','after','After','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(776,0,'en','app','showAll','Show All','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(777,0,'en','app','rtlTheme','Enable RTL Theme (Right to Left)','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(778,0,'en','app','invite','Invite','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(779,0,'en','app','last30Days','Last 30 Days','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(780,0,'en','app','thisMonth','This Month','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(781,0,'en','app','lastMonth','Last Month','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(782,0,'en','app','last90Days','Last 90 Days','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(783,0,'en','app','last6Months','Last 6 Months','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(784,0,'en','app','last1Year','Last 1 Year','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(785,0,'en','app','customRange','Custom Range','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(786,0,'en','app','link','Link','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(787,0,'en','app','settings','Settings','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(788,0,'en','app','lists','Lists','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(789,0,'en','app','hsnSac','Hsn/Sac','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(790,0,'en','app','sendReminderBefore','Send Reminder Before','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(791,0,'en','app','sendReminderAfter','Send Reminder After','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(792,0,'en','app','sendReminderEvery','Send Reminder Every','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(793,0,'en','app','before','Before','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(794,0,'en','app','unarchive','Restore','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(795,0,'en','app','accountSetup','Account Setup','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(796,0,'en','app','saveLogin','Save and Login','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(797,0,'en','app','sandbox','Sandbox','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(798,0,'en','app','live','Live','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(799,0,'en','app','production','Production','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(800,0,'en','app','test','Test','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(801,0,'en','app','moveFilesToCloud','Move Files from Local to Cloud Storage','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(802,0,'en','app','selectEnvironment','Select Environment','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(803,0,'en','app','sandboxPaypalClientId','Sandbox Paypal Client Id','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(804,0,'en','app','sandboxPaypalSecret','Sandbox Paypal Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(805,0,'en','app','livePaypalClientId','Live Paypal Client Id','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(806,0,'en','app','livePaypalSecret','Live Paypal Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(807,0,'en','app','webhookUrlCopied','Webhook URL Copied','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(808,0,'en','app','razorpayKey','Razorpay Key','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(809,0,'en','app','razorpaySecret','Razorpay Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(810,0,'en','app','stripePublishableKey','Stripe Publishable Key','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(811,0,'en','app','stripeSecret','Stripe Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(812,0,'en','app','stripeWebhookSecret','Stripe Webhook Signing Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(813,0,'en','app','storageSetting.selectStorage','Select Storage','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(814,0,'en','app','storageSetting.local','Local (Default)','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(815,0,'en','app','storageSetting.aws','AWS S3 Storage (Amazon Web Services S3)','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(816,0,'en','app','storageSetting.awsKey','AWS Key','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(817,0,'en','app','storageSetting.awsSecret','AWS Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(818,0,'en','app','storageSetting.awsRegion','AWS Region','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(819,0,'en','app','storageSetting.awsBucket','AWS Bucket','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(820,0,'en','app','storageSetting.digitalocean','DigitalOcean Spaces (S3-Compatible Cloud Object Storage)','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(821,0,'en','app','storageSetting.digitaloceanKey','Digitalocean Spaces Key','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(822,0,'en','app','storageSetting.digitaloceanSecret','Digitalocean Spaces Secret','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(823,0,'en','app','storageSetting.digitaloceanRegion','Digitalocean Spaces Region','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(824,0,'en','app','storageSetting.digitaloceanBucket','Digitalocean Spaces Bucket','2023-05-30 17:19:48','2023-06-04 07:35:58'),
(825,0,'en','app','storageSetting.testDigitalocean','Test Digitalocean Spaces Upload','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(826,0,'en','app','storageSetting.wasabiKey','Wasabi Key','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(827,0,'en','app','storageSetting.wasabiSecret','Wasabi Secret','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(828,0,'en','app','storageSetting.wasabiRegion','Wasabi Region','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(829,0,'en','app','storageSetting.wasabiBucket','Wasabi Bucket','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(830,0,'en','app','storageSetting.testWasabi','Test Wasabi Upload','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(831,0,'en','app','storageSetting.viewFile','View File','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(832,0,'en','app','storageSetting.downloadFile','Download File','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(833,0,'en','app','storageSetting.uploadFile','Upload file to test if its getting uploaded to bucket','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(834,0,'en','app','storageSetting.testAWSSetting','Test AWS Settings','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(835,0,'en','app','storageSetting.testDigitaloceanSetting','Test Digitalocean Spaces Settings','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(836,0,'en','app','storageSetting.testwasabiSetting','Test Wasabi Storage Settings','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(837,0,'en','app','storageSetting.testAws','Test AWS S3 Upload','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(838,0,'en','app','storageSetting.storageSuggestion','<b>Suggestion:</b> Consider using AWS S3, DigitalOcean Spaces, or Wasabi Storage for an additional layer of security','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(839,0,'en','app','storageSetting.localStorageNote','means that the files you upload will be stored on your own server within the <b>public/user-uploads</b> directory.','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(840,0,'en','app','message','Message','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(841,0,'en','app','verify','Verify','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(842,0,'en','app','itemSelected','items selected','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(843,0,'en','app','clientNote','Client Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(844,0,'en','app','membersSelected','members selected','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(845,0,'en','app','clientsSelected','clients selected','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(846,0,'en','app','viewPublicPage','View Public Page','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(847,0,'en','app','creditnoteNumber','Credit Note Number','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(848,0,'en','app','enable2FA','Enable 2FA','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(849,0,'en','app','disable2FA','Disable 2FA','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(850,0,'en','app','recoveryCode','Recovery Code','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(851,0,'en','app','twoFactorVerification','Two Factor Verification','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(852,0,'en','app','twoFactorCode','Two-factor authentication code','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(853,0,'en','app','twoFactorCodeEmail','Two-factor email authentication code','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(854,0,'en','app','twoFactorRecoveryCode','Two-factor authentication recovery code','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(855,0,'en','app','clickHere','click here','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(856,0,'en','app','itsYou','It\'s you','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(857,0,'en','app','withoutDueDate','Without Due Date','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(858,0,'en','app','regenerate','Regenerate','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(859,0,'en','app','authenticationRequired','Authentication Required','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(860,0,'en','app','verifyUsingRecoveryCodes','Verify using Recovery Codes','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(861,0,'en','app','verifyUsingGoogleAuthenticatorCodes','Verify using Google Authenticator Codes','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(862,0,'en','app','verifyUsingEmail','Verify using Email','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(863,0,'en','app','statistics','Statistics','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(864,0,'en','app','signUpAsClient','Sign Up as Customer','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(865,0,'en','app','dateFilterOn','Date Filter On','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(866,0,'en','app','skipAll','Skip All','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(867,0,'en','app','showSkippedColumns','Show Skipped Columns','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(868,0,'en','app','btnBack','Back','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(869,0,'en','app','btnSave','Save','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(870,0,'en','app','skip','Skip','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(871,0,'en','app','willNotBeImported','will not be Imported','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(872,0,'en','app','selectAColumn','Select a column','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(873,0,'en','app','doNotCloseOrRefreshPage','Do not close or refresh this page until the import is complete','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(874,0,'en','app','importFailedJobs',':failedJobs entries failed of :totalJobs entries in the import.','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(875,0,'en','app','importInProgress','Import in progress...','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(876,0,'en','app','pleaseWait','Please wait...','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(877,0,'en','app','importProcessedJobs',':processedJobs entries processed of :totalJobs entries in the import.','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(878,0,'en','app','importCompleted','Import completed','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(879,0,'en','app','exceptions','Exceptions while importing','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(880,0,'en','app','importExcelInfo','Date format should be in Y-m-d (e.g. 2022-04-21) format. Make sure the date format is correct in the excel file.','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(881,0,'en','app','importAttendanceExcelInfo','Datetime format should be in Y-m-d H:i:s (e.g. 2022-04-21 12:00:00) format. Make sure the date format is correct in the excel file.','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(882,0,'en','app','importProjectExcelInfo','Date format should be in Y-m-d (e.g. 2022-04-21) format. Make sure the date format is correct in the excel file.','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(883,0,'en','app','backToEmployees','Back to Employees','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(884,0,'en','app','backToClient','Back to Clients','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(885,0,'en','app','backToAttendance','Back to Attendance','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(886,0,'en','app','backToLead','Back to Leads','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(887,0,'en','app','backToProject','Back to Projects','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(888,0,'en','app','unsyncedUsers','Unsynced Users','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(889,0,'en','app','location','Location','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(890,0,'en','app','crop','Crop','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(891,0,'en','app','cropImage','Crop Image','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(892,0,'en','app','dragImage','Drag Image','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(893,0,'en','app','rotateLeftImage','Rotate Left Image','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(894,0,'en','app','rotateRightImage','Rotate Right Image','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(895,0,'en','app','downloadable','Downloadable','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(896,0,'en','app','downloadableFile','Downloadable File','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(897,0,'en','app','unmatchedColumn','Unmatched Column','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(898,0,'en','app','tax','Tax','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(899,0,'en','app','rejectReason','Reject reason','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(900,0,'en','app','payment','Payment','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(901,0,'en','app','only','only','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(902,0,'en','app','relationship','Relationship','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(903,0,'en','app','details','Details','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(904,0,'en','app','profile','Profile','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(905,0,'en','app','orderMarkAsComplete','Mark as complete','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(906,0,'en','app','flowId','Flow Id','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(907,0,'en','app','smsTemplateCopied','SMS Template Copied','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(908,0,'en','app','accepted','Accepted','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(909,0,'en','app','waiting','Waiting','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(910,0,'en','app','googleCalender','Enable Google Calender','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(911,0,'en','app','saveAddMore','Save & Add More','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(912,0,'en','app','department','Department','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(913,0,'en','app','awardDate','Award Date','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(914,0,'en','app','loading','Loading...','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(915,0,'en','app','createNew','Create new','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(916,0,'en','app','googleMapSettings','Google Map Settings','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(917,0,'en','app','clientSignUpSettings','Client Sign up Settings','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(918,0,'en','app','viewedOn','Viewed on','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(919,0,'en','app','at','at','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(920,0,'en','app','using','Using','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(921,0,'en','app','viewPdf','View PDF','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(922,0,'en','app','showAuthorisedSignatory','Show Authorised Signatory','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(923,0,'en','app','showStatus','Show Status','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(924,0,'en','app','every','Every','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(925,0,'en','app','client_email','Client Email','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(926,0,'en','app','single','Full Day','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(927,0,'en','app','general','General','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(928,0,'en','app','ticket','Ticket','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(929,0,'en','app','contract','Contract','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(930,0,'en','app','text','Text','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(931,0,'en','app','number','Number','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(932,0,'en','app','textarea','Text Area','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(933,0,'en','app','radio','Radio','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(934,0,'en','app','checkbox','Check Box','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(935,0,'en','app','converted','Converted','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(936,0,'en','app','google','Google','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(937,0,'en','app','facebook','Facebook','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(938,0,'en','app','friend','Friend','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(939,0,'en','app','direct','Direct','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(940,0,'en','app','tv','Tv','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(941,0,'en','app','howItWorks','How It Works','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(942,0,'en','app','signInToDifferentDomain','Sign in to Different Domain','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(943,0,'en','app','addProject','Add Project','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(944,0,'en','app','addTask','Add Task','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(945,0,'en','app','addClient','Add Client','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(946,0,'en','app','addLead','Add Lead','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(947,0,'en','app','addPassport','Add Passport','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(948,0,'en','app','addVisa','Add Visa','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(949,0,'en','app','addInvoiceRecurring','Add Recurring Invoice','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(950,0,'en','app','addLanguage','Add Language','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(951,0,'en','app','addEmployee','Add Employee','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(952,0,'en','app','addClientNote','Add Client Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(953,0,'en','app','addLeadNote','Add Lead Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(954,0,'en','app','addProjectNote','Add Project Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(955,0,'en','app','editAddress','Edit Address','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(956,0,'en','app','editCurrency','Edit Currency','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(957,0,'en','app','editPassport','Edit Passport','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(958,0,'en','app','editVisa','Edit Visa','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(959,0,'en','app','editFile','Edit File','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(960,0,'en','app','editLanguage','Edit Language','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(961,0,'en','app','editContact','Edit Contact','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(962,0,'en','app','editClientNote','Edit Client Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(963,0,'en','app','editLeadNote','Edit Lead Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(964,0,'en','app','editProjectNote','Edit Project Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(965,0,'en','app','editNote','Edit Note','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(966,0,'en','app','downloadFile','Download File','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(967,0,'en','app','completedOn','Completed On','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(968,0,'en','app','alternateShift','There is no alternate shift for this date','2023-05-30 17:19:49','2023-06-04 07:35:58'),
(969,0,'en','auth','failed','These credentials do not match our records.','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(970,0,'en','auth','password','The provided password is incorrect.','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(971,0,'en','auth','throttle','Too many login attempts. Please try again in :seconds seconds.','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(972,0,'en','auth','failedLoginDisabled','Login has been disabled by your administrator','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(973,0,'en','auth','failedBlocked','Your account is disabled!. Please contact your administrator to enable it.','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(974,0,'en','auth','recaptchaFailed','Recaptcha not validated.','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(975,0,'en','auth','sociaLoginFail','Your account does not exists. Please sign up','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(976,0,'en','auth','signInGoogle','Sign in with Google','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(977,0,'en','auth','signInFacebook','Sign in with Facebook','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(978,0,'en','auth','signInLinkedin','Sign in with LinkedIn','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(979,0,'en','auth','signInTwitter','Sign in with Twitter','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(980,0,'en','auth','useEmail','or, use email address','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(981,0,'en','auth','email','Email Address','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(982,0,'en','auth','next','Next','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(983,0,'en','email','newEvent.subject','New Event Created','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(984,0,'en','email','newEvent.text','We are excited to announce a new event that has been created and we would like to invite you to join us. To make it easier for you to save the date, we have attached an ICS file to this email that you can download and add to your calendar.','2023-05-30 17:19:49','2023-06-04 06:42:01'),
(985,0,'en','email','newEvent.action','View Event','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(986,0,'en','email','loginDashboard','Go To Dashboard','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(987,0,'en','email','viewInvoice','View Invoice','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(988,0,'en','email','thankyouNote','Thank you for using our application!','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(989,0,'en','email','notificationAction','Notification Action','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(990,0,'en','email','notificationIntro','The introduction to the notification.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(991,0,'en','email','hello','Hello','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(992,0,'en','email','whoops','Whoops','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(993,0,'en','email','regards','Regards','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(994,0,'en','email','newExpense.subject','New Expense Submitted for Approval','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(995,0,'en','email','newExpense.action','View Expense','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(996,0,'en','email','newExpenseRecurring.subject','New Recurring Expense Submitted for Approval','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(997,0,'en','email','newExpenseRecurring.action','View Recurring Expense','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(998,0,'en','email','expenseStatus.subject','Expense status updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(999,0,'en','email','expenseStatus.text','Your expense status updated to','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1000,0,'en','email','expenseStatus.action','View Expense','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1001,0,'en','email','expenseRecurringStatus.subject','Recurring Expense status updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1002,0,'en','email','expenseRecurringStatus.text','Your Recurring expense status updated to','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1003,0,'en','email','expenseRecurringStatus.action','View Recurring Expense','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1004,0,'en','email','newNotice.subject','Important Notice: New Update Published','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1005,0,'en','email','newNotice.text','New notice has been published. Login to view the notice.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1006,0,'en','email','newNotice.action','View Notice','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1007,0,'en','email','newProjectMember.subject','Project Update: You Have Been Assigned a New Project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1008,0,'en','email','newProjectMember.text','You have been added as a member to the project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1009,0,'en','email','newProjectMember.action','View Project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1010,0,'en','email','newProjectMember.mentionProject','You Have Been Mention On New Project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1011,0,'en','email','newProjectMember.mentionText','You have been mentioned on project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1012,0,'en','email','newProjectMember.mentionProjectNote','Project Update: You Have Been Mention On New Project Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1013,0,'en','email','newProjectMember.mentionNoteText','You have been mentioned on project Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1014,0,'en','email','projectNote.mentionSubject','You have Been Mention On New Project Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1015,0,'en','email','projectNote.mentionText','You have been mentioned on New Project Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1016,0,'en','email','projectNote.text','New note added for','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1017,0,'en','email','projectNote.action','View Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1018,0,'en','email','projectNote.subject','New note added for Project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1019,0,'en','email','newProject.subject','New Project Added','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1020,0,'en','email','newProject.text','A new project added with name','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1021,0,'en','email','newProject.withName','with name.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1022,0,'en','email','newProject.loginNow',' Login now to view the project.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1023,0,'en','email','newProjectStatus.subject','Project Status Updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1024,0,'en','email','newProjectStatus.text','Project Status has been changed','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1025,0,'en','email','newProjectStatus.withName','with name.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1026,0,'en','email','newProjectStatus.loginNow',' Login now to view the project.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1027,0,'en','email','newTask.subject','Task Assignment: A New Task has been Assigned to You','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1028,0,'en','email','newTask.mentionSubject','Mention On New Task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1029,0,'en','email','newTask.mentionTask','You have been mentioned in a task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1030,0,'en','email','dueOn','Due On','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1031,0,'en','email','newTicket.subject','New Support Ticket Requested','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1032,0,'en','email','newTicket.text','New Support Ticket is requested. Login to view the ticket.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1033,0,'en','email','newTicket.action','View Ticket','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1034,0,'en','email','newUser.subject','Welcome to','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1035,0,'en','email','newUser.text','Congratulations! Your account has been created successfully. You can now login and start using our service.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1036,0,'en','email','newUser.action','Login to Dashboard','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1037,0,'en','email','newUserViaLink.subject','New Team Member: Welcome to the Team!','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1038,0,'en','email','newUserViaLink.text','New account has been created successfully via invitation link. Following are the details-','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1039,0,'en','email','newUserViaLink.action','View User Details','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1040,0,'en','email','leaves.subject','New leave request received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1041,0,'en','email','leaves.statusSubject','Leave application status updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1042,0,'en','email','leaves.multipleSubject','New multiple leave request received by :user','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1043,0,'en','email','leaves.action','View Leave','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1044,0,'en','email','taskComplete.subject','Task marked as complete','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1045,0,'en','email','taskComplete.action','View Task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1046,0,'en','email','taskComplete.completedBy','Task completed by','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1047,0,'en','email','taskUpdate.subject','Task updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1048,0,'en','email','taskUpdate.action','View Task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1049,0,'en','email','leave.approve','Leave application approved.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1050,0,'en','email','leave.reject','Leave application rejected.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1051,0,'en','email','leave.applied','Leave application applied.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1052,0,'en','email','leave.action','View Leave Application','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1053,0,'en','email','newClientTask.subject','New Task Generated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1054,0,'en','email','newClientTask.content','A New Task has been Created in Project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1055,0,'en','email','reminder.subject','Reminder for assigned task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1056,0,'en','email','invoices.paymentReceived','Payment Received: Confirmation','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1057,0,'en','email','invoices.paymentReceivedForInvoice','Payment received for invoice ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1058,0,'en','email','invoices.paymentReceivedForOrder','Payment received for order ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1059,0,'en','email','invoices.action','View Invoice','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1060,0,'en','email','invoices.newPaymentReceived','New Payment Received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1061,0,'en','email','invoices.paymentReminder','Payment Reminder Received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1062,0,'en','email','orders.action','View Order','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1063,0,'en','email','orders.subject','New Order Recieved','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1064,0,'en','email','eventReminder.subject','Reminder: Upcoming Event - Save the Date!','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1065,0,'en','email','eventReminder.text','This is to remind you about the following event. Log in for more details about the event.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1066,0,'en','email','eventReminder.action','View Event','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1067,0,'en','email','taskReminder.subject','Urgent Task Reminder: Deadline Approaching','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1068,0,'en','email','estimate.subject','New Estimate Created','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1069,0,'en','email','estimate.text','A new estimate has been Created. Please click on the link below to view estimate.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1070,0,'en','email','estimate.loginDashboard','Approve / Reject','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1071,0,'en','email','invoice.subject','New Invoice Received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1072,0,'en','email','invoice.text','A new invoice has been received. Please click on the link below to view invoice.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1073,0,'en','email','invoice.action','View Invoice','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1074,0,'en','email','invoice.updateSubject','Invoice Updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1075,0,'en','email','invoice.updateText','Invoice has been updated. Please click on the link below to view invoice.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1076,0,'en','email','invoice.updateTextSms','Invoice has been updated. Please check the invoice :invoice_number.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1077,0,'en','email','order.subject','New Order Placed','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1078,0,'en','email','order.text','A new order has been placed. Please click on the link below to view order.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1079,0,'en','email','order.action','View Order','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1080,0,'en','email','order.updateSubject','Order Updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1081,0,'en','email','order.updateText','Order has been updated. Please click on the link below to view order.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1082,0,'en','email','projectReminder.text','This is to remind you about the due date of the following projects which is','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1083,0,'en','email','projectReminder.subject','Project Reminder','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1084,0,'en','email','projectReminder.action','View Projects','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1085,0,'en','email','messages.loginForMoreDetails','Log in for more details.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1086,0,'en','email','messages.referenceMessage','I have attached a copy of the invoice for your reference.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1087,0,'en','email','messages.confirmMessage','I would be really grateful if you could confirm that everything is on track for payment.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1088,0,'en','email','taskComment.subject','New comment on task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1089,0,'en','email','taskComment.action','View Task Comment','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1090,0,'en','email','taskComment.mentionTask','You have been mentioned in a task comment','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1091,0,'en','email','taskComment.mentionSubject','Mentioned On Comment','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1092,0,'en','email','taskNote.subject','New note added for task','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1093,0,'en','email','taskNote.action','View Task Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1094,0,'en','email','taskNote.mentionNote','You have been mention in task note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1095,0,'en','email','taskNote.mentionSubject','Mentioned On Note','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1096,0,'en','email','removalRequestAdmin.subject','New Removal Request','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1097,0,'en','email','removalRequestAdmin.text','New removal request has been received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1098,0,'en','email','removalRequestApprovedUser.subject','Removal Request Approval','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1099,0,'en','email','removalRequestApprovedUser.text','Your removal request has been approved','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1100,0,'en','email','removalRequestRejectedUser.subject','Removal Request Rejected','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1101,0,'en','email','removalRequestRejectedUser.text','Your removal request has been rejected','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1102,0,'en','email','removalRequestApprovedLead.subject','Removal Request Approval','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1103,0,'en','email','removalRequestApprovedLead.text','Your removal request for lead has been approved','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1104,0,'en','email','removalRequestRejectedLead.subject','Removal Request Rejected','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1105,0,'en','email','removalRequestRejectedLead.text','Your removal request for lead has been rejected','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1106,0,'en','email','paymentReminder.subject','Payment Reminder','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1107,0,'en','email','paymentReminder.content','This is to remind you about the due date of the following project invoice payment which is','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1108,0,'en','email','paymentReminder.smsText','This is to remind you about the due date of the following project invoice payment :invoice_number which is :due_date.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1109,0,'en','email','fileUpload.subject','New file uploaded to project : ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1110,0,'en','email','fileUpload.action','View Project Files','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1111,0,'en','email','payment.subject','Payment Received!','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1112,0,'en','email','payment.text','A new Payment has been done. Login now to view the Payment.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1113,0,'en','email','payment.action','View Payment','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1114,0,'en','email','payment.amount','Paid Amount','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1115,0,'en','email','payment.method','Payment mode','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1116,0,'en','email','payment.invoiceNumber','Invoice Number','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1117,0,'en','email','payment.clientsubject','Payment Success','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1118,0,'en','email','payment.clientName','Client Name','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1119,0,'en','email','payment.clientEmail','Client Email','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1120,0,'en','email','payment.Project','Project','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1121,0,'en','email','ticketAgent.subject','You have been assigned a ticket','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1122,0,'en','email','ticketAgent.text','You have been assigned a new ticket.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1123,0,'en','email','ticketAgent.action','View Ticket','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1124,0,'en','email','subTaskComplete.subject','Sub Task marked as complete','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1125,0,'en','email','subTaskComplete.action','View Sub Tasks','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1126,0,'en','email','subTaskAssigneeAdded.subject','Sub Task assigned to you.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1127,0,'en','email','subTaskAssigneeAdded.text','You have been added as assignee on Task ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1128,0,'en','email','subTaskAssigneeAdded.action','View Sub Tasks','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1129,0,'en','email','leadAgent.subject','New lead received.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1130,0,'en','email','leadAgent.action','View Lead','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1131,0,'en','email','subTaskCreated','Sub task created.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1132,0,'en','email','discussionReply.subject',' replied to ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1133,0,'en','email','discussionReply.text','You have received a reply on ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1134,0,'en','email','discussionReply.action','View Discussion','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1135,0,'en','email','discussion.subject','New discussion started ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1136,0,'en','email','discussion.action','View Discussion','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1137,0,'en','email','discussion.mentionSubject','Mentioned On Discussion','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1138,0,'en','email','discussion.mentionContent','You have been mentioned on new Project Discussion','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1139,0,'en','email','ticketReply.subject','New ticket reply received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1140,0,'en','email','ticketReply.receivedText','You have received a reply on ticket ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1141,0,'en','email','ticketReply.repliedText','You have replied on ticket ','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1142,0,'en','email','ticketReply.action','View Ticket','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1143,0,'en','email','contractSign.subject','Contract Signed','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1144,0,'en','email','contractSign.text',':contract (contract) is signed by :client.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1145,0,'en','email','newContract.subject','New Contract Created!','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1146,0,'en','email','newContract.text','A new contract has been created.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1147,0,'en','email','newChat.subject','New message received','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1148,0,'en','email','newChat.action','View Message','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1149,0,'en','email','noticeUpdate.subject','A notice has been updated','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1150,0,'en','email','noticeUpdate.text','Notice has been updated. Login to view the notice.','2023-05-30 17:19:50','2023-06-04 06:42:01'),
(1151,0,'en','email','noticeUpdate.action','View Notice','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1152,0,'en','email','payments.paymentReceived','Payment Received','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1153,0,'en','email','estimateDeclined.subject','Estimate Declined','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1154,0,'en','email','estimateDeclined.text','A estimate has been Declined. Please click on the link below to check the estimate.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1155,0,'en','email','estimateDeclined.smsText','A estimate has been Declined. Kindly check the estimate #:estimate_number','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1156,0,'en','email','estimateDeclined.action','View Estimate','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1157,0,'en','email','estimateAccepted.subject','Estimate Accepted','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1158,0,'en','email','newMeeting.subject','New Meeting Created','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1159,0,'en','email','newMeeting.text','New meeting has been created. Download the attachment to add meeting to your calendar.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1160,0,'en','email','removalRequestApproved.subject','Removal Request Approval','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1161,0,'en','email','removalRequestApproved.text','Your removal request for lead has been Approved','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1162,0,'en','email','removalRequestReject.subject','Removal Request Reject','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1163,0,'en','email','removalRequestReject.text','Your removal request for lead has been rejected','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1164,0,'en','email','newTicketRequester.subject','New Ticket Has Been Generated For You.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1165,0,'en','email','newTicketRequester.text','New support ticket is has been generated for you. Login to view the ticket.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1166,0,'en','email','newTicketRequester.action','View Ticket','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1167,0,'en','email','newInvoiceRecurring.subject','New Recurring Invoice submitted','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1168,0,'en','email','newInvoiceRecurring.text','A new recurring invoice has been submitted. Please click on the link below to view the invoice.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1169,0,'en','email','newInvoiceRecurring.smsText','A new recurring invoice has been submitted.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1170,0,'en','email','newInvoiceRecurring.action','View Recurring Invoice','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1171,0,'en','email','invoiceRecurringStatus.subject','Recurring Invoice status updated','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1172,0,'en','email','invoiceRecurringStatus.text','Your recurring invoice status updated to','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1173,0,'en','email','invoiceRecurringStatus.action','View Recurring Invoice','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1174,0,'en','email','creditNote.subject','New Credit Note received','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1175,0,'en','email','creditNote.text','A new credit note has been received. Login now to view the credit note.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1176,0,'en','email','creditNote.action','View Credit Note','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1177,0,'en','email','proposal.subject','New Proposal Received','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1178,0,'en','email','proposal.text','A new proposal has been received. Login now to view the proposal.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1179,0,'en','email','proposalSigned.subject','Proposal has been accepted!','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1180,0,'en','email','proposalSigned.text','A new Proposal has been accepted and signed.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1181,0,'en','email','proposalSigned.approve','Approved By','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1182,0,'en','email','proposalRejected.subject','Proposal has been declined by lead!','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1183,0,'en','email','proposalRejected.text','A new Proposal has been declined.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1184,0,'en','email','proposalRejected.rejected','Rejected','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1185,0,'en','email','testMail.testMail','Test Mail','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1186,0,'en','email','testMail.mailAddress','Enter email address where test mail needs to be sent','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1187,0,'en','email','invitation.subject',' has invited you to join ','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1188,0,'en','email','invitation.action','Accept Invitation','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1189,0,'en','email','invoiceReminder.subject','Invoice Reminder','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1190,0,'en','email','invoiceReminder.text','This is to remind you about the due date of the following invoice which was','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1191,0,'en','email','invoiceReminder.action','View Invoice','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1192,0,'en','email','invoiceReminderAfter.subject','Invoice Reminder','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1193,0,'en','email','invoiceReminderAfter.text','I just wanted to drop you a quick note to remind you that the due for payment on','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1194,0,'en','email','invoiceReminderAfter.action','View Invoice','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1195,0,'en','email','test.subject','Confirm Receipt: Test Email','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1196,0,'en','email','test.text','This is a test email to verify that the SMTP settings are configured correctly and the email system is functioning properly. If you receive this message, it means that the SMTP configuration is working fine.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1197,0,'en','email','test.thankyouNote','Thank you for using our application!','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1198,0,'en','email','AttendanceReminder.subject','Action Required: Mark Today\'s Attendance','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1199,0,'en','email','AttendanceReminder.text','This email is a friendly reminder to mark your attendance for today. We noticed that you have not yet clocked in and we wanted to remind you to do so as soon as possible to avoid being marked as absent.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1200,0,'en','email','AttendanceReminder.action','Mark Attendance','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1201,0,'en','email','BirthdayReminder.subject','members have birthday today','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1202,0,'en','email','BirthdayReminder.text','The following team members are celebrating their birthdays today','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1203,0,'en','email','BirthdayReminder.action','Go to dashboard','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1204,0,'en','email','BirthdayReminder.birthdayNotification','have birthday','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1205,0,'en','email','BirthdayReminder.birthdayNotificationText',' others have birthday on ','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1206,0,'en','email','twoFactor.line1','Your two-factor authentication code is ','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1207,0,'en','email','twoFactor.line2','The code will expire in 10 minutes','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1208,0,'en','email','twoFactor.line3','If you have not tried to login, ignore this message.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1209,0,'en','email','newCustomer.subject','New Customer Registration','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1210,0,'en','email','newCustomer.text','New customer has been registered.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1211,0,'en','email','footer','If you\'re experiencing difficulties with clicking the \":actionText\" button, kindly copy and paste the URL below into your web browser:','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1212,0,'en','email','productPurchase.subject','New Product Purchase','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1213,0,'en','email','productPurchase.text','A new product purchase has been made. Login now to view the purchase.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1214,0,'en','email','productPurchase.action','View Invoice','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1215,0,'en','email','followUpReminder.subject','Urgent: Follow-up Reminder','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1216,0,'en','email','followUpReminder.nextFollowUpDate','Next follow up date','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1217,0,'en','email','followUpReminder.action','View Follow Up Details','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1218,0,'en','email','followUpReminder.nextFollowUpTime','Next follow up time','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1219,0,'en','email','followUpReminder.followUpLead','Followup Lead Name','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1220,0,'en','email','followUpReminder.followUpLeadText','You have new follow up','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1221,0,'en','email','shiftScheduled.subject','Schedule Update: Your Shifts have been Assigned','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1222,0,'en','email','shiftChange.subject','New Shift Change Request Received','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1223,0,'en','email','shiftChange.action','Go to Shift Roster','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1224,0,'en','email','shiftChange.text','Request to change Shift is received.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1225,0,'en','email','shiftChangeStatus.subject','Shift change request response','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1226,0,'en','email','shiftChangeStatus.text','Your request for shift change is ','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1227,0,'en','email','newAppreciation.subject','Congratulations: You Have Been Awarded','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1228,0,'en','email','newAppreciation.text','You have been awarded :award on :award_at','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1229,0,'en','email','newAppreciation.action','View Award Details','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1230,0,'en','email','attendanceReport.subject','Attendance Report for the month of ','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1231,0,'en','email','attendanceReport.text','Please find the attendance report in attachment.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1232,0,'en','email','trackerReminder.subject','Time Tracker Reminder','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1233,0,'en','email','trackerReminder.text','You forgot to start the time tracker.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1234,0,'en','email','trackerReminder.action','View Tasks','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1235,0,'en','email','holidays.subject','New Holiday Created','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1236,0,'en','email','dailyTimelogReport.subject','Timelog Report for the date','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1237,0,'en','email','dailyTimelogReport.text','Please find the timelog report in attachment.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1238,0,'en','installer_messages','title','Laravel Installer','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1239,0,'en','installer_messages','next','Next Step','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1240,0,'en','installer_messages','finish','Install','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1241,0,'en','installer_messages','welcome.title','Welcome To The Installer','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1242,0,'en','installer_messages','welcome.message','Welcome to the setup wizard.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1243,0,'en','installer_messages','requirements.title','Server Requirements','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1244,0,'en','installer_messages','permissions.title','Permissions','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1245,0,'en','installer_messages','environment.title','Database Configuration','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1246,0,'en','installer_messages','environment.save','Save .env','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1247,0,'en','installer_messages','environment.success','Your .env file settings have been saved.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1248,0,'en','installer_messages','environment.errors','Unable to save the .env file, Please create it manually.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1249,0,'en','installer_messages','install','Install','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1250,0,'en','installer_messages','final.title','Finished','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1251,0,'en','installer_messages','final.finished','Application has been successfully installed.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1252,0,'en','installer_messages','final.exit','Click here to exit','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1253,0,'en','installer_messages','checkPermissionAgain',' Check Permission Again','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1254,0,'en','messages','fetchChat','Fetching chat detail.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1255,0,'en','messages','confirm','Confirm','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1256,0,'en','messages','projectCodeRequired','Project short code field is required.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1257,0,'en','messages','changeLeaveStatusConfirmation','Do you really want to change leave status.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1258,0,'en','messages','updateSuccess','Updated successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1259,0,'en','messages','recordSaved','Record saved successfully','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1260,0,'en','messages','deleteSuccess','Deleted Successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1261,0,'en','messages','checkDayHoliday','Choose at-least 1.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1262,0,'en','messages','selectOfflineMethod','Offline method is required if you select offline.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1263,0,'en','messages','invoicePaymentError','Please enter amount.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1264,0,'en','messages','selectGateway','Payment method required.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1265,0,'en','messages','invoiceDateError','Please enter date.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1266,0,'en','messages','addItem','Add at-least 1 item.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1267,0,'en','messages','cartEmpty','Your cart is emplty successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1268,0,'en','messages','quantityNumber','Quantity should be a number','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1269,0,'en','messages','unitPriceNumber','Unit price should be a number','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1270,0,'en','messages','amountNumber','Amount should be a number.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1271,0,'en','messages','itemBlank','Item name cannot be blank.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1272,0,'en','messages','invalidRequest','Invalid Request','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1273,0,'en','messages','fileUploadedSuccessfully','File uploaded successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1274,0,'en','messages','fileUploadIssue','File not uploaded. Please contact to administrator','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1275,0,'en','messages','issueStatusChanged','Issue status changed successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1276,0,'en','messages','newTaskAddedToTheProject','New task added to the project.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1277,0,'en','messages','timerStoppedSuccessfully','Timer stopped successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1278,0,'en','messages','attendanceSaveSuccess','Attendance Saved Successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1279,0,'en','messages','leadClientChangeSuccess','Lead changed in client successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1280,0,'en','messages','adminCannotDelete','Admin user cannot be deleted.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1281,0,'en','messages','roleCannotChange','To change the role of this user, You need to assign the same role to some other user and then login as that user to change it','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1282,0,'en','messages','roleAssigned','Roles assigned successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1283,0,'en','messages','emptyCartMessage','Your cart is empty successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1284,0,'en','messages','overwriteAttendanceTooltip','This will delete the existing attendance and will create new attendance record for the selected duration','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1285,0,'en','messages','leaveAssignSuccess','Leave assigned successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1286,0,'en','messages','leaveTypeAdded','Leave type saved.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1287,0,'en','messages','reasonForLeaveRejection','Reason for leave rejection','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1288,0,'en','messages','reasonForLeaveApproval','Reason for leave approval','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1289,0,'en','messages','importSuccess','File imported successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1290,0,'en','messages','newFileUploadedToTheProject','New file uploaded to the project.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1291,0,'en','messages','isAddedAsProjectMember','is added as project member.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1292,0,'en','messages','memberRemovedFromProject','Member removed from project successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1293,0,'en','messages','milestoneSuccess','Milestone saved successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1294,0,'en','messages','addedAsNewProject','added as new project.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1295,0,'en','messages','projectArchiveSuccessfully','Project archived successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1296,0,'en','messages','projectRevertSuccessfully','Project reverted successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1297,0,'en','messages','noMemberAddedToProject','No member added to this project.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1298,0,'en','messages','ticketReplySuccess','Reply sent successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1299,0,'en','messages','timeLogAdded','Time logged successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1300,0,'en','messages','timelogAlreadyExist','Time-log already exist for this user.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1301,0,'en','messages','noConversation','No conversation found.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1302,0,'en','messages','noUser','No user found.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1303,0,'en','messages','norecordSaved','No Offline payment Methods Added.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1304,0,'en','messages','agentRemoveSuccess','Agent removed successfully.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1305,0,'en','messages','templateUpdateSuccess','Template update success.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1306,0,'en','messages','notAnAuthorisedDevice','This is not an authorised device for clock-in or clock-out','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1307,0,'en','messages','notAnValidLocation','Your current location is not with in the clock-in range','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1308,0,'en','messages','unAuthorisedUser','You are not a authorised user.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1309,0,'en','messages','updatedProfile','Updated profile.','2023-05-30 17:19:51','2023-06-04 06:42:01'),
(1310,0,'en','messages','taskUpdated','Marked the task as ','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1311,0,'en','messages','timerStartedTask','Started the timer for task ','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1312,0,'en','messages','timerStartedSuccessfully','Timer started successfully.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1313,0,'en','messages','timerAlreadyRunning','Timer is already running for a task.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1314,0,'en','messages','notificationRead','Notification marked as read.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1315,0,'en','messages','atleastOneValidation','Select at least 1 member','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1316,0,'en','messages','chooseProject','Choose a project.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1317,0,'en','messages','noRecordFound','No record found.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1318,0,'en','messages','currencyConvertApiKeyUrl','Get API key by this url','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1319,0,'en','messages','exchangeRateNote','Exchange rate is calculated from your default currency. Change default currency in App Settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1320,0,'en','messages','earningChartNote','The earnings are mentioned in your base currency.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1321,0,'en','messages','noPendingLeadFollowUps','No pending follow-up.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1322,0,'en','messages','employeeDocsAllowedFormat','Allowed file formats: jpg, png, gif, doc, docx, xls, xlsx, pdf, txt.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1323,0,'en','messages','noFileUploaded','No file uploaded.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1324,0,'en','messages','noLeadSourceAdded','No lead source added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1325,0,'en','messages','noLeadStatusAdded','No lead status added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1326,0,'en','messages','selectMultipleDates','You can select multiple dates.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1327,0,'en','messages','sweetAlertTitle','Are you sure?','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1328,0,'en','messages','unArchiveMessage','Do you want to restore this project.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1329,0,'en','messages','confirmRevert','Yes, Restore it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1330,0,'en','messages','confirmNoArchive','No, cancel please!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1331,0,'en','messages','confirmNo','No, please!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1332,0,'en','messages','archiveMessage','Do you want to archive this project.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1333,0,'en','messages','confirmArchive','Yes, archive it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1334,0,'en','messages','noInvoice','No invoice created.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1335,0,'en','messages','noClientAddedToProject','No client assigned to the project.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1336,0,'en','messages','noAgentAdded','No agent added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1337,0,'en','messages','noTemplateFound','No template found.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1338,0,'en','messages','noTicketTypeAdded','No ticket type added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1339,0,'en','messages','pleaseEnterSomeData','Please enter some data to save bulk payments.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1340,0,'en','messages','paymentTypeNotFound','Payment Type Not Found','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1341,0,'en','messages','noSubTaskFound','Seems like no sub task exists in the database. Please create the sub task first','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1342,0,'en','messages','noActivityByThisUser','No activity by the user.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1343,0,'en','messages','noClientAdded','No client added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1344,0,'en','messages','confirmDelete','Yes, delete it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1345,0,'en','messages','confirmRemove','Yes, remove it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1346,0,'en','messages','confirmSend','Yes, send it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1347,0,'en','messages','creditText','When creating credit note from non paid invoice, full invoice amount will be credited. Are you sure that you want to create the credit note?','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1348,0,'en','messages','confirmCreate','Yes, create it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1349,0,'en','messages','invoiceText','Do you want to cancel the invoice?','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1350,0,'en','messages','recoverRecord','You will not be able to recover the deleted record!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1351,0,'en','messages','confirmPin','Yes, pin it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1352,0,'en','messages','confirmUnpin','Yes, unpin it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1353,0,'en','messages','projectPin','You want to pin this project!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1354,0,'en','messages','removeAgentText','This will remove the agent from the list.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1355,0,'en','messages','removeChannelText','This will remove the channel type from the list.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1356,0,'en','messages','removeGroupText','This will delete the group from the list.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1357,0,'en','messages','removeTemplateText','This will remove the template from the list.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1358,0,'en','messages','removeTicketText','This will remove the ticket type from the list.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1359,0,'en','messages','ticketText','You will not be able to recover the deleted ticket!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1360,0,'en','messages','removeFileText','You will not be able to recover the deleted file!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1361,0,'en','messages','markHolidayTitle','Are you sure you want to mark selected days as holiday ?','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1362,0,'en','messages','noteHolidayText','Note: This will mark all the selected days throughout the year as holiday. You will have to manually delete them once added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1363,0,'en','messages','confirmSave','Yes, save it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1364,0,'en','messages','deleteInvoice','You will not be able to recover the deleted recurring invoice!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1365,0,'en','messages','removeLead','This will remove the lead status from the list.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1366,0,'en','messages','deleteLeave','You will not be able to recover the deleted leave!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1367,0,'en','messages','deleteLeaveType','You will not be able to recover the deleted leave type!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1368,0,'en','messages','removeMethodText','This will remove the payment method from the list','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1369,0,'en','messages','deleteProduct','You will not be able to recover the deleted product!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1370,0,'en','messages','deleteTask','You will not be able to recover the deleted task!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1371,0,'en','messages','markCompleteTask','There is a incomplete sub-task in this task do you want to mark complete!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1372,0,'en','messages','sendReminder','Do you want to send reminder to assigned employee?','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1373,0,'en','messages','completeIt','Yes, complete it!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1374,0,'en','messages','noCategoryAdded','No category added','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1375,0,'en','messages','incorrectPassword','Incorrect Password','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1376,0,'en','messages','passwordMatched','Password Matched','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1377,0,'en','messages','departmentName','Department name is required','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1378,0,'en','messages','departmentUniq','The department name has already been taken.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1379,0,'en','messages','unitTypeAdded','Unit Type Added Successfully','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1380,0,'en','messages','estimateTemplateDeleted','Estimate Template Deleted','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1381,0,'en','messages','estimateTemplateCreated','Estimate Template Created','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1382,0,'en','messages','estimateTemplateUpdated','Estimate Template Updated','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1383,0,'en','messages','clientFinanceCount','This client have :projectCount :project, :invoiceCount :invoice, :estimateCount :estimate, :paymentCount :payment . ','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1384,0,'en','messages','signatureAdded','Signature Added Successfully','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1385,0,'en','messages','endTimeAfterOrEqual','The end time must be a time after or equal to start time.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1386,0,'en','messages','atleastOneRole','Select at least 1 role.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1387,0,'en','messages','selectOccassion','If occassion not select then checked day name will be Occassion name','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1388,0,'en','messages','clientFilterVerification','Client filter according verification','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1389,0,'en','messages','welcome.message','Welcome to the setup wizard','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1390,0,'en','messages','welcome.title','Welcome to the installer','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1391,0,'en','messages','title','Laravel installer','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1392,0,'en','messages','next','Following','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1393,0,'en','messages','finish','Install','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1394,0,'en','messages','final.title','Finalized.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1395,0,'en','messages','final.finished','The application has been installed successfully!','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1396,0,'en','messages','final.exit','Click here to exit.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1397,0,'en','messages','currency.currencyPosition','This controls the position of the currency symbol. like $1 or 1$ or $ 1 or 1 $','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1398,0,'en','messages','currency.thousandSeparator','This sets the thousand separotor of displayed prices. like $10,000 or $1000,0000','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1399,0,'en','messages','currency.decimalSeparator','This sets the decimal seprator of displayed prices. like $10.00 or $10,00','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1400,0,'en','messages','currency.numberOfdecimals','This sets the number of decimal points shown in displayed prices. like $10.00 or $10.000','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1401,0,'en','messages','noGroupAdded','No group added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1402,0,'en','messages','noRoleFound','No role found.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1403,0,'en','messages','noLeaveTypeAdded','No leave type added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1404,0,'en','messages','updateAlert','Do not click update now button if the application is customised. Your changes will be lost.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1405,0,'en','messages','updateBackupNotice','Take backup of files and database before updating.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1406,0,'en','messages','fieldBlank','Field cannot be blank.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1407,0,'en','messages','defaultRoleCantDelete','Default role can not be deleted.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1408,0,'en','messages','reminderMailSuccess','Reminder Mail sent successfully.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1409,0,'en','messages','smtpError','Your SMTP details are not correct. Please update to correct one','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1410,0,'en','messages','smtpSuccess','Your SMTP details are correct','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1411,0,'en','messages','smtpSecureEnabled','For Gmail SMTP configuration, please follow the follow link ','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1412,0,'en','messages','smtpNotSet','You have not configured SMTP settings. You might get an error when adding info ','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1413,0,'en','messages','addStripeWebhookUrlHelpVisit1','Visit <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">Generate</a> Add end point as above url and enter the webhook key generated','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1414,0,'en','messages','addStripeWebhookUrlHelpVisit2','Select event <b>invoice.payment_failed, invoice.payment_succeeded , payment_intent.succeeded</b> and <b>payment_intent.payment_failed</b> while creating webhook.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1415,0,'en','messages','addPaypalWebhookUrl','Add this webhook url on your paypal app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1416,0,'en','messages','addFlutterwaveWebhookUrl','Add this webhook url on your flutterwave app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1417,0,'en','messages','addSquareWebhookUrl','Add this webhook url on your square app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1418,0,'en','messages','addRazorpayWebhookUrl','Add this webhook url on your razorpay app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1419,0,'en','messages','addPaystackWebhookUrl','Add this webhook url on your paystack app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1420,0,'en','messages','addPaystackCallbackUrl','Add this callback url on your paystack app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1421,0,'en','messages','gdprUpdated','GDPR setting successfully updated','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1422,0,'en','messages','invoiceCanNotDeleted','Invalid Request You can not delete this invoice','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1423,0,'en','messages','addDiscussion','Message sent successfully.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1424,0,'en','messages','creditNoteAppliedSuccessfully','Credit note applied successfully.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1425,0,'en','messages','pleaseEnterCreditAmount','Enter atleast one credit amount.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1426,0,'en','messages','creditNoteCanNotDeleted','Credit Note cannot be deleted.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1427,0,'en','messages','noLeadAgentAdded','No lead agent added.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1428,0,'en','messages','selectProduct','Please select at-least one product.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1429,0,'en','messages','noLeadAgent','No Lead Agent Found','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1430,0,'en','messages','noCommentFound','No comment found.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1431,0,'en','messages','noNoteFound','No note found.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1432,0,'en','messages','leaveApplySuccess','Leave applied successfully.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1433,0,'en','messages','leaveApplyError','Leave already applied for the selected date.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1434,0,'en','messages','holidayLeaveApplyError','You can not apply leave on holiday.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1435,0,'en','messages','errorOccured','Some error occurred.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1436,0,'en','messages','noNotification','No new notifications','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1437,0,'en','messages','addGoogleCallback','Add this callback url on your google app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1438,0,'en','messages','addFacebookCallback','Add this callback url on your facebook app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1439,0,'en','messages','addLinkedinCallback','Add this callback url on your linkedin app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1440,0,'en','messages','addTwitterCallback','Add this callback url on your twitter app settings.','2023-05-30 17:19:52','2023-06-04 06:42:01'),
(1441,0,'en','messages','clockOutTimeError','Clock-out time cannot be less than clock in time','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1442,0,'en','messages','leaveTypeValueError','No. of leaves should be grater than or equal to Zero','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1443,0,'en','messages','maxClockin','Maximum check-ins reached.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1444,0,'en','messages','attendanceMarked','Attendance has been already marked.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1445,0,'en','messages','amountIsZero','Amount should be more than ZERO for the payment','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1446,0,'en','messages','taskAfterDateValidation','Task end date should not be less than the task start date','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1447,0,'en','messages','taskBeforeDateValidation','Task end date should not be greater than the milestones end date','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1448,0,'en','messages','noProductSubCategoryAdded','No product sub category added.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1449,0,'en','messages','pinnedSuccess','Pinned successfully','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1450,0,'en','messages','noInvoiceFound','Seems like no invoice has been generated.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1451,0,'en','messages','noClientFound','Seems like no client exists. Please create the client first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1452,0,'en','messages','noTaskFound','Seems like no task exists. Please create the task first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1453,0,'en','messages','noTaskFilesFound','Seems like no task files uploaded.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1454,0,'en','messages','noEmployeesFound','Seems like no employees exists. Please create the employee first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1455,0,'en','messages','noEstimatesFound','Seems like no estimates exists. Please create the estimate first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1456,0,'en','messages','noInvoicesFound','Seems like no invoices exists. Please create the invoice first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1457,0,'en','messages','noExpensesFound','Seems like no expenses exists. Please create the expense first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1458,0,'en','messages','noTicketsFound','Seems like no tickets exists.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1459,0,'en','messages','noLeadFound','Seems like no leads exists. Please create the leads first','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1460,0,'en','messages','noNoticeFound','Seems like no notice exists.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1461,0,'en','messages','noLeavesFound','Seems like no leaves exists.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1462,0,'en','messages','noProjectAssigned','No project assigned to you.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1463,0,'en','messages','noAttendanceDetailTOday','No attendance detail for today.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1464,0,'en','messages','noSpacePlease','No space please!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1465,0,'en','messages','confirmation.createCreditNotes','Are you sure that you want to create the credit note?','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1466,0,'en','messages','confirmation.orderStatusChange','Are you sure you want to change the order status?','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1467,0,'en','messages','confirmation.rejectConfirm','Yes, reject','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1468,0,'en','messages','invoiceSentSuccessfully','Invoice sent Successfully','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1469,0,'en','messages','invoiceMarkAsSent','Invoice Mark as Sent Successfully','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1470,0,'en','messages','deleteField','You will not be able to recover the deleted field!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1471,0,'en','messages','confirmCancel','Confirm Cancel!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1472,0,'en','messages','estimateCancelText','Do you want to cancel this estimate!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1473,0,'en','messages','selectAction','Select Action','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1474,0,'en','messages','notEnoughData','Not enough data','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1475,0,'en','messages','newMilestoneCreated','New milestone created','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1476,0,'en','messages','milestoneUpdated','Milestone Updated','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1477,0,'en','messages','milestoneDeleted','Milestone Deleted','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1478,0,'en','messages','selectConversation','Select a conversation to send a message','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1479,0,'en','messages','discountExceed','Discount cannot be more than total amount.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1480,0,'en','messages','proposalSendSuccess','Proposal sent Successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1481,0,'en','messages','proposalMarkAsSent','Proposal Mark as Sent Successfully','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1482,0,'en','messages','totalTimeZero','End time should be greater than start time.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1483,0,'en','messages','contractRenewSuccess','Contract renewed successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1484,0,'en','messages','signatureRequired','Signature is required.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1485,0,'en','messages','estimateSigned','Estimate accepted successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1486,0,'en','messages','adminPermissionError','Admin permissions cannot be changed.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1487,0,'en','messages','newEmployeeInfo','According to date of joining.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1488,0,'en','messages','leaveInfo','According to date of leave.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1489,0,'en','messages','employeeExitInfo','According to date of exit.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1490,0,'en','messages','unresolveTicketInfo','Tickets with status Pending or Open.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1491,0,'en','messages','unassignTicketInfo','Tickets which are not assigned to agent.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1492,0,'en','messages','themeChangesReset','All custom theme changes will reset.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1493,0,'en','messages','permissionDenied','Permission Denied.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1494,0,'en','messages','accessDenied','Access Denied.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1495,0,'en','messages','forbidden','Forbidden','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1496,0,'en','messages','pageNotFound','Page not found.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1497,0,'en','messages','404Title','Error 404 (Not Found)','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1498,0,'en','messages','inviteEmailSuccess','Invitation sent successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1499,0,'en','messages','acceptInviteError','Invalid invitation. You are not authorised to sign up.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1500,0,'en','messages','signupSuccess','Sign up successfully. You will be redirected to your dashboard in while','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1501,0,'en','messages','inviteLinkSuccess','Invitation link created successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1502,0,'en','messages','installingUpdateMessage','Installing...Please wait (This may take few minutes.)','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1503,0,'en','messages','installedUpdateMessage','Installed successfully. Reload page to see the changes.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1504,0,'en','messages','consentOptIn','Consent Opt In Successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1505,0,'en','messages','consentOptOut','Consent Opt Out Successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1506,0,'en','messages','inviteInfo','Employees will receive an email to login and update their profile through the self-service portal.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1507,0,'en','messages','taskDependentDate','Dependent task due date cannot be in future.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1508,0,'en','messages','assignClientFirst','You need to assign a client to the project.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1509,0,'en','messages','invalidOrInactiveAccount','Email not found or account is inactive. Please check your email.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1510,0,'en','messages','viewKey','Click Here to View Key','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1511,0,'en','messages','testMailSentSuccessfully','Test mail sent successfully','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1512,0,'en','messages','fileUploaded','File uploaded successfully. Click view file to view the uploaded file','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1513,0,'en','messages','filesMoveToAwsSuccessfully','Files successfully moved to AWS S3','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1514,0,'en','messages','allFilesMovedtoAws','All Files are already moved to AWS S3','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1515,0,'en','messages','primaryColorRequired','Primary color is required.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1516,0,'en','messages','settingModuleCannotBeDisabled','Setting  module cannot be disabled.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1517,0,'en','messages','paymentSuccessful','Payment Successful.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1518,0,'en','messages','darkThemeRestrictionInfo','Theme color settings will not work when Dark Mode is active.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1519,0,'en','messages','cronIsNotRunning','It appears that your cron job has not run in the last 48 hours. Please check to ensure that it is properly configured. This message will automatically disappear once the cron job is functioning correctly again.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1520,0,'en','messages','resolveTicketInfo','Tickets with status Closed or Resolved.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1521,0,'en','messages','invoicePaymentExceedError','Payment amount cannot be more than invoice due amount.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1522,0,'en','messages','paymentFailed','Payment Failed.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1523,0,'en','messages','invalidPayload','Invalid Payload.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1524,0,'en','messages','invalidSignature','Invalid Signature.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1525,0,'en','messages','webhookHandled','Webhook Handled.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1526,0,'en','messages','projectDetailsNotAdded','Project details not added.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1527,0,'en','messages','inviteLinkCopied','Invite Link Copied.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1528,0,'en','messages','unsentInvoiceInfo','The Invoice cannot be paid until the invoice is sent to the customer.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1529,0,'en','messages','selectCustomerForBillingAddress','Select client to show billing address.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1530,0,'en','messages','invoicesWidgetMessage','Invoices are shown on the basis of date of creation of invoices.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1531,0,'en','messages','estimatesWidgetMessage','Estimates are shown on the basis of due date of estimates.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1532,0,'en','messages','proposalsWidgetMessage','Proposals are shown on the basis of date of creation.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1533,0,'en','messages','holidayDataNotFound','Data not found for mark holiday.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1534,0,'en','messages','codeSent','Two factor verification code sent to email.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1535,0,'en','messages','codeNotMatch','The two factor code you have entered does not match.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1536,0,'en','messages','resendCode','You have received an email which contains two factor login code. If you have not received it, ','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1537,0,'en','messages','noConsentFound','No Consent found.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1538,0,'en','messages','proposalInfo','Proposals are for Leads. If you want to create for existing clients, then create Estimate.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1539,0,'en','messages','twoFaAppInfo','Enter the code from the two-factor app on your mobile device. If you\'ve lost your device, you may enter one of your recovery codes.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1540,0,'en','messages','sessionDeleteConfirmation','All the logged in users will be logged out.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1541,0,'en','messages','requiredForLogin','This field is required for user login.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1542,0,'en','messages','showHidePurchaseCode','Show or hide purchase code','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1543,0,'en','messages','changePurchaseCode','Change purchase code','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1544,0,'en','messages','enable2FAUsingEmail','Enabling this feature will send code on your email account <b>:email</b> for log in.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1545,0,'en','messages','enable2FAUsingAuthenticator','Use the Authenticator app to get free verification codes, even when your phone is offline. Available for Android and iPhone.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1546,0,'en','messages','approvalWarning','User will be able to access the account.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1547,0,'en','messages','invalid2FaCode','Invalid 2FA Code.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1548,0,'en','messages','downloadFilefromCodecanyon','Download the zip file from codecanyon and upload it here. Only .zip file type is allowed for uploading.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1549,0,'en','messages','phpUpdateRequired','PHP version update is required','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1550,0,'en','messages','invalidEmailFormat','Invalid email format.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1551,0,'en','messages','calculateTaxBeforeDiscount','Note : Tax is calculating before discount.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1552,0,'en','messages','calculateTaxAfterDiscount','Note : Tax is calculating after discount.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1553,0,'en','messages','fileFormat.ImageFile','only .jpg, .jpeg, .png, .svg formats are allowed.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1554,0,'en','messages','fileFormat.multipleImageFile','only .txt, .pdf, .doc, .xls, .xlsx, .docx, .rtf, .png, .jpg, .jpeg formats are allowed.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1555,0,'en','messages','leaveFileMessage','You can attach the receipt of prescription, doctor visit or travel document etc','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1556,0,'en','messages','matchColumnMessage','Please sort the data you have uploaded by matching the columns in the CSV to the fields in the associated fields.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1557,0,'en','messages','columnMatchSuccess','<strong>Well done!</strong> You have successfully matched all the columns. Please click on submit to save.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1558,0,'en','messages','requiredColumnsUnmatched','Following fields are required and must be matched: <strong>:columns</strong>','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1559,0,'en','messages','unmatchedColumns','<span id=\"unmatchedCount\">:unmatchCount</span> unmatched columns.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1560,0,'en','messages','pleaseSelectAColumn','Please select a column or click on skip','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1561,0,'en','messages','pleaseSelectCategory','Please select a Category','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1562,0,'en','messages','importUploadSuccess','Data uploaded successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1563,0,'en','messages','importProcessStart','Import process started. Please wait.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1564,0,'en','messages','confirmResetPermission','This will reset permissions for all users with this role. Do you want to reset?','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1565,0,'en','messages','invoiceDueOn','Invoice Due On','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1566,0,'en','messages','googleCalendar.confirmRemove','Are you really want to disable Google Calendar ?','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1567,0,'en','messages','googleCalendar.yesRemove','Yes, Remove it!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1568,0,'en','messages','googleCalendar.removedSuccess','Google Calendar removed successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1569,0,'en','messages','googleCalendar.AuthorizedRedirectURI','Authorized redirect URIs','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1570,0,'en','messages','googleCalendar.AuthorizedRedirectURIInfoMessage','Users will be redirected to this path after they have authenticated with Google. The path will be appended with the authorization code for access, and must have a protocol. It can’t contain URL fragments, relative paths, or wildcards, and can’t be a public IP address.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1571,0,'en','messages','googleCalendar.addGoogleCalendarUrl','Add this redirect URI to your Google Console','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1572,0,'en','messages','googleCalendar.notificationTitle','Notification Settings','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1573,0,'en','messages','googleCalendar.verifiedSuccess','Google calendar settings verified successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1574,0,'en','messages','googleCalendar.updatedSuccess','Google calendar settings updated successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1575,0,'en','messages','databasebackup.note','Note: Due to the limited execution time and memory available to PHP, backing up very large databases may not be possible. If your database is very large you might need to backup directly from your SQL server via the command line, or have your server admin do it for you if you do not have root privileges.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1576,0,'en','messages','databasebackup.backupNotExist','Backup file doesn\'t exist.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1577,0,'en','messages','databasebackup.backupDeleted','Successfully deleted backup!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1578,0,'en','messages','databasebackup.backedupSuccessful','The database backup has been added to the queue. It will start to appear here once the next cron job runs successfully.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1579,0,'en','messages','databasebackup.databaseError','Database error','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1580,0,'en','messages','databasebackup.createDatabaseBackupAlert','Do you really want to create Database Backup!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1581,0,'en','messages','databasebackup.confirmCreateDatabaseBackup','Yes, Create It!','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1582,0,'en','messages','databasebackup.info','Note: Create backup every :everyDayCount days at :time, auto delete backups older than :olderDayCount days (set -1 to disable) ','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1583,0,'en','messages','notAllowedToAssignAdminPermission','You\'re not allowed to assign admin role.','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1584,0,'en','messages','downloadable','Downloadable product gives access to a file upon purchase','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1585,0,'en','messages','invalidData','Invalid Data : ','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1586,0,'en','messages','invalidDate','Invalid Date Format : ','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1587,0,'en','messages','duplicateEntryForEmail','Duplicate Entry for Email : ','2023-05-30 17:19:53','2023-06-04 06:42:01'),
(1588,0,'en','messages','duplicateEntryForEmployeeId','Duplicate Entry for Employee ID : ','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1589,0,'en','messages','employeeNotFound','Employee not found','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1590,0,'en','messages','dragDropScreenInfo','Drag and drop will work on desktop devices only.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1591,0,'en','messages','timerPausedSuccessfully','Timer paused successfully.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1592,0,'en','messages','orderStatusChanged','Order status changed successfully.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1593,0,'en','messages','orderStatus.pending','Pending order is ready to collect payment.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1594,0,'en','messages','orderStatus.onHold','On hold order is waiting for payment or payment is pending.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1595,0,'en','messages','orderStatus.failed','Failed order is failed to collect payment.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1596,0,'en','messages','orderStatus.processing','Processing order is in process.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1597,0,'en','messages','orderStatus.completed','Completed order will create invoice and payment of order.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1598,0,'en','messages','orderStatus.canceled','Canceled order is canceled and can\'t be processed.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1599,0,'en','messages','orderStatus.refunded','Refunded order will create credit note of order.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1600,0,'en','messages','employeeEmergencyContact','Emergency contact saved successfully.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1601,0,'en','messages','sameCurrencyInvoiceNote','Only same currency Invoices will show here.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1602,0,'en','messages','alreadySigned','Already signed','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1603,0,'en','messages','invoiceAlreadyPaid','Invoice already paid','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1604,0,'en','messages','currencyExchangeKeyNotFound','Currency Converter Key Not Found','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1605,0,'en','messages','noUnpaidInvoiceFound','No unpaid invoice found.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1606,0,'en','messages','leaveLimitError','Leave limit exceeded for the selected leave type.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1607,0,'en','messages','remainingLeaveError','Only :leave leave remaining for the selected leave type.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1608,0,'en','messages','multipleRemainingLeaveError','Only :leaves leaves remaining for the selected leave type.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1609,0,'en','messages','monthlyLeaveLimitError','Monthly Leave limit exceeded for the selected leave type.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1610,0,'en','messages','employeeShiftAdded','Employee Shift Saved.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1611,0,'en','messages','removeShiftText','All the employees related to this shift will be moved to the default shift.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1612,0,'en','messages','defaultLanguageCantChange','To modify the default language, please navigate to the :appsettings. The current language is set as the default.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1613,0,'en','messages','defaultEnLanguageCantChange','Modifying English language not permitted, but can be enabled/disabled.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1614,0,'en','messages','requestSubmitSuccess','Request submitted successfully.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1615,0,'en','messages','existingShiftOverride','The existing shift will be overridden.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1616,0,'en','messages','leadFollowUpRestricted','Follow-up is disabled for this user.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1617,0,'en','messages','clockInNotAllowed','Clock In Not Allowed.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1618,0,'en','messages','roleNotAssigned','Role is not assigned.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1619,0,'en','messages','archivedTaskNotWork','You will not be able to perform action on archived project tasks.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1620,0,'en','messages','totalEmployeeInfo','Total employees in the company. Date filter not applied.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1621,0,'en','messages','dateFilterNotApplied','Date filter not applied.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1622,0,'en','messages','youAreOnLeave','You are on leave today.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1623,0,'en','messages','holidayToday','Today is a Holiday.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1624,0,'en','messages','languageEnabledAlertMessage','Simply enabling a language setting will not automatically change the language. To effectively change the language, you must also have translations available in that specific language.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1625,0,'en','messages','mailSettingSelectMessage','We recommend using <b>SMTP</b>. Mail settings might not work on every server which also results in emails landing to SPAM. Please also check test email if your mail server is working or not','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1626,0,'en','messages','customPermissionError','Permissions have been customised for this user.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1627,0,'en','messages','congratulationNewAward','Congratulation for :award award','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1628,0,'en','messages','appreciationPhoto','Photo taken while presenting the award','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1629,0,'en','messages','disableIt','Inactive It','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1630,0,'en','messages','recoverAwardRecord','You have :employeeCount employees awarded by this award. You will not be able to recover the deleted employees awarded record!','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1631,0,'en','messages','loginDetailsEmailed','Login details will be emailed to this email','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1632,0,'en','messages','notAllowedToDeleteCurrency','You are not allowed to delete this currency as its been used in other places.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1633,0,'en','messages','appNameToolTip','This will be visible to left sidebar top and on login page','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1634,0,'en','messages','brandingStyleToolTip','Below branding style will work for left sidebar top and on login page.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1635,0,'en','messages','darkThemeLogoTooltip','This logo will be shown when you change the theme to dark mode','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1636,0,'en','messages','lightThemeLogoTooltip','This logo will be shown when you change the theme to light mode','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1637,0,'en','messages','configureCurrencyConverterKey','You need to configure Currency converter key first to fetch Latest exchange rate. :link to add key','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1638,0,'en','messages','noticePeriodMessage','Notice Period Ends On','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1639,0,'en','messages','probationMessage','Probation Ends On','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1640,0,'en','messages','internshipMessage','Internship Ends On','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1641,0,'en','messages','contractMessage','Contract Ends On','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1642,0,'en','messages','probationEndDate','Enter the end date when the employee\'s probation is going to end and he/she is going to be the part of company permanently','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1643,0,'en','messages','noticePeriodStartDate','Enter the start date when an employee is going to be in the notice period before leaving the company','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1644,0,'en','messages','noticePeriodEndDate','Enter the end date when an employee is going to be in the notice period before leaving the company','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1645,0,'en','messages','googleMapMessage','You need to add google map Key to see the Maps here and locate your location directly to map. Visit','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1646,0,'en','messages','googleMapRemove','Leave blank to remove Google map key','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1647,0,'en','messages','googleMapTooltip','You can add the location on map in <b>:route</b> once google map setting is configured','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1648,0,'en','messages','googleMapLocationAddedTooltip','Latitude and longitude added for this address','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1649,0,'en','messages','invoiceLogoTooltip','This logo will appear on the invoices (only .jpg, .jpeg, .png formats are allowed)','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1650,0,'en','messages','companyNameTooltip','Add full name of your company. Company name visible to the left sidebar will be changed from theme setting','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1651,0,'en','messages','defaultAddressInfo','The attendance and other modules utilize the default business address, but when creating records, you have the option to select a different address as default address','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1652,0,'en','messages','bankTransactionSuccess','Bank Transaction Success','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1653,0,'en','messages','selectDate','Select Date','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1654,0,'en','messages','pusherError','Your Pusher details are not correct. Please update to correct one','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1655,0,'en','messages','pusherSuccess','Your Pusher details are correct','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1656,0,'en','messages','authorisedSignatorySignatureTooltip','This signature will appear on the paid invoices (only .jpg, .jpeg, .png formats are allowed). Check Show Authorised Signatory from bottom of the invoice setting page','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1657,0,'en','messages','invoiceStatusShowTooltip','This will show the invoice status (paid/unpaid/partial paid) on the invoice pdf','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1658,0,'en','messages','invoiceAuthorisedSignatoryShowTooltip','This will show the authorised signatory on the invoice pdf if Signature is uploaded and invoice status is paid.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1659,0,'en','messages','projectCopiedSuccessfully','Project Copied Successfully','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1660,0,'en','messages','quickBooksCredentialsIncorrect','QuickBooks credentials are incorrect.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1661,0,'en','messages','quickBooksConnectSuccess','QuickBooks account is connected.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1662,0,'en','messages','cacheClear','Successfully cleared cache.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1663,0,'en','messages','leadStatusChangeSuccess','Lead Status Change Successfully','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1664,0,'en','messages','calculateTaskProgress','We calculate progress on task completion','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1665,0,'en','messages','emailCannotChange','Email cannot be changed as it is registered with other companies also.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1666,0,'en','messages','accessDeniedMessage','We\'re sorry, but it appears that the link you were trying to access has expired. This could be due to a variety of reasons, such as the content being removed or updated, the link being deactivated, or the link having a limited timeframe for access','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1667,0,'en','messages','markSentInfo','Client will not receive any email.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1668,0,'en','messages','enableClientModule','Enable Client Module to access this section.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1669,0,'en','messages','leave.allowedNotice','Check this if you want to allow employees in the <b>Notice Period</b> to apply for leaves of this type.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1670,0,'en','messages','leave.allowedProbation','Check this if you want to allow employees in the <b>Probation</b> to apply for leaves of this type.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1671,0,'en','messages','leave.unusedLeave','Determines how the unused leaves are treated at the end of the year.<br><br><b>Carry Forward</b>: Unused leaves will be added to next year leaves.<br><br><b>Lapse</b>: Unused leaves will simply lapse and no action will be taken.<br><br><b>Paid</b>: Employee will be paid salary of the number of days equivalent of unused leaves.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1672,0,'en','messages','leave.effectiveAfter','This leave type will be effective after the number of days or the number of month of employee\'s joining. <br><br>Leave blank to allow from date of joining.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1673,0,'en','messages','leave.gender','Leave Type can only be used by selected <b>Gender</b> employees and other employees will not be able to apply for leaves with this leave type','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1674,0,'en','messages','leave.maritalStatus','Leave Type can only be used by selected <b>Marital Status</b> employees and other employees will not be able to apply for leaves with this leave type','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1675,0,'en','messages','leave.department','Leave Type can only be used by selected <b>Department</b> employees and other employees will not be able to apply for leaves with this leave type','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1676,0,'en','messages','leave.designation','Leave Type can only be used by selected <b>Designation</b> employees and other employees will not be able to apply for leaves with this leave type','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1677,0,'en','messages','leave.role','Leave Type can only be used by selected <b>Role</b> and other role will not be able to apply for leaves with this leave type','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1678,0,'en','messages','leave.noOfLeaves','Number of leaves of this type given to each employee per year. For example, your company may give 10 sick leaves per year','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1679,0,'en','messages','leave.monthlyLimit','The maximum number of leaves of this type an employee can take per month.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1680,0,'en','messages','leave.paidStatus','This leave type will be paid or unpaid for all the employees','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1681,0,'en','messages','unitDeleteError','You cannot delete this unit as it is associated with finance and product items. Dissociate the unit from all items and try again.','2023-05-30 17:19:54','2023-06-04 06:42:01'),
(1682,0,'en','modules','dashboard.totalClients','Total Clients','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1683,0,'en','modules','dashboard.newClients','New Clients','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1684,0,'en','modules','dashboard.totalEmployees','Total Employees','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1685,0,'en','modules','dashboard.totalProjects','Total Projects','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1686,0,'en','modules','dashboard.newProjects','New Projects','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1687,0,'en','modules','dashboard.totalPaidInvoices','Paid Invoices','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1688,0,'en','modules','dashboard.totalTickets','Tickets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1689,0,'en','modules','dashboard.totalOpenTickets','Open Tickets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1690,0,'en','modules','dashboard.openTickets','Open Tickets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1691,0,'en','modules','dashboard.totalHoursLogged','Hours Logged','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1692,0,'en','modules','dashboard.totalPendingTasks','Pending Tasks','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1693,0,'en','modules','dashboard.totalCompletedTasks','Completed Tasks','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1694,0,'en','modules','dashboard.totalPendingIssues','Total Pending Issues','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1695,0,'en','modules','dashboard.totalPaidAmount','Paid Amount','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1696,0,'en','modules','dashboard.totalOutstandingAmount','Outstanding Amount','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1697,0,'en','modules','dashboard.recentEarnings','Recent Earnings','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1698,0,'en','modules','dashboard.overdueTasks','Overdue Tasks','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1699,0,'en','modules','dashboard.pendingClientIssues','Pending Issues','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1700,0,'en','modules','dashboard.projectActivityTimeline','Project Activity Timeline','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1701,0,'en','modules','dashboard.userActivityTimeline','User Activity Timeline','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1702,0,'en','modules','dashboard.dueDate','Due Date','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1703,0,'en','modules','dashboard.weatherSetLocation','Set current location to see weather','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1704,0,'en','modules','dashboard.totalTodayAttendance','Today Attendance','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1705,0,'en','modules','dashboard.newTickets','Open Tickets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1706,0,'en','modules','dashboard.totalUnpaidInvoices','Due Invoices','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1707,0,'en','modules','dashboard.followUpDate','Follow Up Date','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1708,0,'en','modules','dashboard.pendingFollowUp','Pending FollowUp','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1709,0,'en','modules','dashboard.totalLeads','Total Leads','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1710,0,'en','modules','dashboard.newLead','New Lead','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1711,0,'en','modules','dashboard.newproduct','New Product','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1712,0,'en','modules','dashboard.addNewproduct','Add New Product','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1713,0,'en','modules','dashboard.totalConvertedClient','Total Client Convert','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1714,0,'en','modules','dashboard.totalPendingFollowUps','Pending Follow Up','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1715,0,'en','modules','dashboard.nextFollowUp','Next Follow Up','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1716,0,'en','modules','dashboard.holidayCheck','Today is Holiday for','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1717,0,'en','modules','dashboard.totalArchiveProjects','Archived Projects','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1718,0,'en','modules','dashboard.freeEmployees','Not working on project','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1719,0,'en','modules','dashboard.dashboardWidgets','Dashboard Widgets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1720,0,'en','modules','dashboard.totalResolvedTickets','Resolved Tickets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1721,0,'en','modules','dashboard.totalUnresolvedTickets','Unresolved Tickets','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1722,0,'en','modules','dashboard.clientFeedback','Client Feedback','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1723,0,'en','modules','dashboard.settingsLeaves','Leaves Calendar','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1724,0,'en','modules','dashboard.totalActiveClients','Active Clients','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1725,0,'en','modules','dashboard.totalContractsSigned','Contracts Signed','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1726,0,'en','modules','dashboard.totalContractsGenerated','Contracts Generated','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1727,0,'en','modules','dashboard.totalLeadConversions','Lead Conversions','2023-05-30 17:19:54','2023-06-05 07:31:08'),
(1728,0,'en','modules','dashboard.latestClient','Latest Clients','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1729,0,'en','modules','dashboard.recentLoginActivities','Recent Login Activities','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1730,0,'en','modules','dashboard.clientWiseEarnings','Client Wise Earnings','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1731,0,'en','modules','dashboard.clientWiseTimelogs','Client Wise Timelogs','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1732,0,'en','modules','dashboard.leadVsStatus','Leads Count by Status','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1733,0,'en','modules','dashboard.leadVsSource','Leads Count by Source','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1734,0,'en','modules','dashboard.totalExpenses','Total Expenses','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1735,0,'en','modules','dashboard.totalEarnings','Total Earnings','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1736,0,'en','modules','dashboard.totalProfit','Total Profit','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1737,0,'en','modules','dashboard.totalPendingAmount','Total Pending Amount','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1738,0,'en','modules','dashboard.earningsByClient','Earnings By Client','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1739,0,'en','modules','dashboard.earningsByProjects','Earnings By Projects','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1740,0,'en','modules','dashboard.lastReceivedPayments','Last Received Payments','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1741,0,'en','modules','dashboard.invoiceTab','Invoices','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1742,0,'en','modules','dashboard.estimateTab','Estimates','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1743,0,'en','modules','dashboard.expenseTab','Expenses','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1744,0,'en','modules','dashboard.paymentTab','Payments','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1745,0,'en','modules','dashboard.duePaymentsTab','Due Payments','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1746,0,'en','modules','dashboard.proposalTab','Proposals','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1747,0,'en','modules','dashboard.invoiceOverview','Invoice Overview','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1748,0,'en','modules','dashboard.invoiceDraft','Draft','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1749,0,'en','modules','dashboard.invoiceNotSent','Not Sent','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1750,0,'en','modules','dashboard.invoiceUnpaid','Unpaid','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1751,0,'en','modules','dashboard.invoicePartiallyPaid','Partially Paid','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1752,0,'en','modules','dashboard.invoiceOverdue','Overdue','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1753,0,'en','modules','dashboard.invoicePaid','Paid','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1754,0,'en','modules','dashboard.estimateOverview','Estimate Overview','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1755,0,'en','modules','dashboard.estimateDraft','Draft','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1756,0,'en','modules','dashboard.estimateNotSent','Not Sent','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1757,0,'en','modules','dashboard.estimateSent','Sent','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1758,0,'en','modules','dashboard.estimateExpired','Expired','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1759,0,'en','modules','dashboard.estimateDeclined','Declined','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1760,0,'en','modules','dashboard.estimateAccepted','Accepted','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1761,0,'en','modules','dashboard.proposalOverview','Proposal Overview','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1762,0,'en','modules','dashboard.proposalWaiting','Waiting','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1763,0,'en','modules','dashboard.proposalConverted','Converted','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1764,0,'en','modules','dashboard.proposalDeclined','Declined','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1765,0,'en','modules','dashboard.proposalAccepted','Accepted','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1766,0,'en','modules','dashboard.proposalExpired','Expired','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1767,0,'en','modules','dashboard.totalLeavesApproved','Leaves Approved','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1768,0,'en','modules','dashboard.totalNewEmployee','New Employees','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1769,0,'en','modules','dashboard.totalEmployeeExits','Employee Exits','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1770,0,'en','modules','dashboard.departmentWiseEmployee','Department Wise Employee','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1771,0,'en','modules','dashboard.designationWiseEmployee','Designation Wise Employee','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1772,0,'en','modules','dashboard.genderWiseEmployee','Gender Wise Employee','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1773,0,'en','modules','dashboard.roleWiseEmployee','Role Wise Employee','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1774,0,'en','modules','dashboard.averageAttendance','Average Attendance','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1775,0,'en','modules','dashboard.leavesTaken','Leaves Taken','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1776,0,'en','modules','dashboard.lateAttendanceMark','Late Attendance','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1777,0,'en','modules','dashboard.lateMark','Late Mark','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1778,0,'en','modules','dashboard.totalProject','Total Projects','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1779,0,'en','modules','dashboard.totalOverdueProject','Total Overdue Project','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1780,0,'en','modules','dashboard.statusWiseProject','Status Wise Projects','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1781,0,'en','modules','dashboard.pendingMilestone','Pending Milestone','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1782,0,'en','modules','dashboard.totalUnassignedTicket','Total Unassigned Ticket','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1783,0,'en','modules','dashboard.typeWiseTicket','Type Wise Ticket','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1784,0,'en','modules','dashboard.statusWiseTicket','Status Wise Ticket','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1785,0,'en','modules','dashboard.channelWiseTicket','Channel Wise Ticket','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1786,0,'en','modules','dashboard.thisMonth','This Month','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1787,0,'en','modules','dashboard.timelogs','Timelogs','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1788,0,'en','modules','dashboard.privateTaskInfo','Private tasks not included','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1789,0,'en','modules','dashboard.verificationPending','Account verification pending','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1790,0,'en','modules','dashboard.verificationPendingInfo','Your account verification is pending by the owner.','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1791,0,'en','modules','dashboard.birthday','Birthdays','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1792,0,'en','modules','dashboard.inDays','in :days days','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1793,0,'en','modules','dashboard.inDay','in :days day','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1794,0,'en','modules','dashboard.profile','Profile','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1795,0,'en','modules','dashboard.shiftSchedule','Shift Schedule','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1796,0,'en','modules','dashboard.notices','Notices','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1797,0,'en','modules','dashboard.tasks','Tasks','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1798,0,'en','modules','dashboard.projects','Projects','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1799,0,'en','modules','dashboard.myTask','My Task','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1800,0,'en','modules','dashboard.myCalender','My Calender','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1801,0,'en','modules','dashboard.weekTimelog','Week Timelogs','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1802,0,'en','modules','dashboard.lead','Leads','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1803,0,'en','modules','dashboard.leave','On Leave Today','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1804,0,'en','modules','dashboard.workFromHome','On Work From Home Today','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1805,0,'en','modules','dashboard.fullDay','Full Day','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1806,0,'en','modules','dashboard.headcount','Headcount','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1807,0,'en','modules','dashboard.appreciation','Appreciations','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1808,0,'en','modules','dashboard.joiningVsAttrition','Joining Vs Attrition','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1809,0,'en','modules','dashboard.workAnniversary','Work Anniversary','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1810,0,'en','modules','dashboard.joinedToday','Joined Today','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1811,0,'en','modules','dashboard.ticket','Tickets','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1812,0,'en','modules','dashboard.noticePeriodDuration','Notice Period Duration','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1813,0,'en','modules','dashboard.probationDate','Probation Date','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1814,0,'en','modules','dashboard.internshipDate','Internship Date','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1815,0,'en','modules','dashboard.contractDate','Contract Date','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1816,0,'en','modules','dashboard.dashboardWidgetsSettings','Dashboard Widgets Settings','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1817,0,'en','modules','client.createNote','Add Note','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1818,0,'en','modules','client.noteTitle','Note Title','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1819,0,'en','modules','client.noteType','Note Type','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1820,0,'en','modules','client.noteDetail','Note Detail','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1821,0,'en','modules','client.visibleToClient','Visible To Client','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1822,0,'en','modules','client.askToReenterPassword','Ask to re-enter password','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1823,0,'en','modules','client.createTitle','Add Client Info','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1824,0,'en','modules','client.companyDetails','Company Details','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1825,0,'en','modules','client.companyName','Company Name','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1826,0,'en','modules','client.website','Official Website','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1827,0,'en','modules','client.address','Address','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1828,0,'en','modules','client.clientDetails','Client Details','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1829,0,'en','modules','client.clientBasicDetails','Client Basic Details','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1830,0,'en','modules','client.clientOtherDetails','Other Details','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1831,0,'en','modules','client.clientName','Client Name','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1832,0,'en','modules','client.clientEmail','Client Email','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1833,0,'en','modules','client.clientPhone','Client Phone','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1834,0,'en','modules','client.emailNote','Client will login using this email and email notifications will be sent to this email.','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1835,0,'en','modules','client.password','Password','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1836,0,'en','modules','client.passwordNote','Client will login using this password.','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1837,0,'en','modules','client.passwordUpdateNote','Leave blank to keep current password.','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1838,0,'en','modules','client.mobile','Mobile','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1839,0,'en','modules','client.updateTitle','Update Client Info','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1840,0,'en','modules','client.addNewClient','Add New Client','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1841,0,'en','modules','client.viewDetails','View Details','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1842,0,'en','modules','client.projectName','Project Name','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1843,0,'en','modules','client.startedOn','Started On','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1844,0,'en','modules','client.deadline','Deadline','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1845,0,'en','modules','client.generateRandomPassword','Generate Random Password','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1846,0,'en','modules','client.offline','Offline','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1847,0,'en','modules','client.online','Online','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1848,0,'en','modules','client.all','All','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1849,0,'en','modules','client.sendCredentials','Send Credentials','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1850,0,'en','modules','client.sendCredentialsMessage','Do you want to send credentials via E-mail to client ?','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1851,0,'en','modules','client.assignProject','Assign Project','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1852,0,'en','modules','client.cell','Cell','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1853,0,'en','modules','client.officePhoneNumber','Office Phone Number','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1854,0,'en','modules','client.addedOn','Added On','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1855,0,'en','modules','client.clientCategory','Client Category','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1856,0,'en','modules','client.clientSubCategory','Client Sub Category','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1857,0,'en','modules','client.profileInfo','Profile Info','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1858,0,'en','modules','client.clientCanLogin','Login Allowed?','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1859,0,'en','modules','client.salutation','Salutation','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1860,0,'en','modules','credit-notes.currency','Currency','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1861,0,'en','modules','credit-notes.creditNoteDate','Credit Note Date','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1862,0,'en','modules','credit-notes.isRecurringPayment','Is it a recurring payments?','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1863,0,'en','modules','credit-notes.item','Item','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1864,0,'en','modules','credit-notes.qty','Quantity','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1865,0,'en','modules','credit-notes.unitPrice','Unit Price','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1866,0,'en','modules','credit-notes.tax','Tax','2023-05-30 17:19:55','2023-06-05 07:31:08'),
(1867,0,'en','modules','credit-notes.amount','Amount','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1868,0,'en','modules','credit-notes.addItem','Add Item','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1869,0,'en','modules','credit-notes.subTotal','Sub Total','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1870,0,'en','modules','credit-notes.discount','Discount','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1871,0,'en','modules','credit-notes.total','Total','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1872,0,'en','modules','credit-notes.addCreditNote','Add Credit Note','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1873,0,'en','modules','credit-notes.billingFrequency','Billing Frequency','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1874,0,'en','modules','credit-notes.billingInterval','Billing Interval','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1875,0,'en','modules','credit-notes.billingCycle','Billing Cycle','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1876,0,'en','modules','credit-notes.billedTo','Billed To','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1877,0,'en','modules','credit-notes.generatedBy','Generated By','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1878,0,'en','modules','credit-notes.price','Price','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1879,0,'en','modules','credit-notes.downloadPdf','Download Pdf','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1880,0,'en','modules','credit-notes.creditAmountTotal','Credit Amount Total','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1881,0,'en','modules','credit-notes.creditAmountRemaining','Credits Remaining','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1882,0,'en','modules','credit-notes.creditAmountUsed','Credit Amount Used','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1883,0,'en','modules','credit-notes.applyToInvoice','Apply Credits To Invoice','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1884,0,'en','modules','credit-notes.closed','Closed','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1885,0,'en','modules','credit-notes.open','Open','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1886,0,'en','modules','credit-notes.paid','Paid','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1887,0,'en','modules','credit-notes.unpaid','Unpaid','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1888,0,'en','modules','credit-notes.partial','Partial','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1889,0,'en','modules','credit-notes.uploadInvoice','Upload Invoice','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1890,0,'en','modules','credit-notes.addTtax','Add Tax','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1891,0,'en','modules','contacts.addContact','Add Contact','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1892,0,'en','modules','contacts.contactName','Contact Name','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1893,0,'en','modules','employees.addNewEmployee','Add New Employee','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1894,0,'en','modules','employees.createTitle','Add Employee Info','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1895,0,'en','modules','employees.employeeName','Employee Name','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1896,0,'en','modules','employees.employeeEmail','Employee Email','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1897,0,'en','modules','employees.emailNote','Employee will login using this email.','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1898,0,'en','modules','employees.employeePassword','Password','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1899,0,'en','modules','employees.passwordNote','Employee will login using this password.','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1900,0,'en','modules','employees.jobTitle','Job Title','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1901,0,'en','modules','employees.hourlyRate','Hourly Rate','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1902,0,'en','modules','employees.updateTitle','update Employee Info','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1903,0,'en','modules','employees.updatePasswordNote','Employee will login using this password. (Leave blank to keep current password)','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1904,0,'en','modules','employees.tasksDone','Tasks Done','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1905,0,'en','modules','employees.hoursLogged','Hours Logged','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1906,0,'en','modules','employees.activity','Activity','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1907,0,'en','modules','employees.profile','Profile','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1908,0,'en','modules','employees.fullName','Full Name','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1909,0,'en','modules','employees.startTime','Start Time','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1910,0,'en','modules','employees.endTime','End Time','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1911,0,'en','modules','employees.totalHours','Total Hours','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1912,0,'en','modules','employees.totalMinutes','Total Minutes','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1913,0,'en','modules','employees.memo','Memo','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1914,0,'en','modules','employees.slackUsername','Slack Member ID','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1915,0,'en','modules','employees.joiningDate','Joining Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1916,0,'en','modules','employees.workAnniversary','Work Anniversary','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1917,0,'en','modules','employees.joineeAndWorkAnniversary','Today\'s Joinings & Work Anniversary','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1918,0,'en','modules','employees.gender','Gender','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1919,0,'en','modules','employees.title','Select Employee','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1920,0,'en','modules','employees.role','Role','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1921,0,'en','modules','employees.lastDate','Exit Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1922,0,'en','modules','employees.employeeId','Employee ID','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1923,0,'en','modules','employees.chooseDepartment','Choose Department','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1924,0,'en','modules','employees.chooseDesignation','Choose Designation','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1925,0,'en','modules','employees.chooseStatus','Choose Status','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1926,0,'en','modules','employees.pendingTasks','Pending Tasks','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1927,0,'en','modules','employees.leavesTaken','Leaves Taken','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1928,0,'en','modules','employees.department','Department','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1929,0,'en','modules','employees.designation','Designation','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1930,0,'en','modules','employees.status','Status','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1931,0,'en','modules','employees.employeeIdInfo','Employee ID is the unique ID distributed to employees','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1932,0,'en','modules','employees.employeeIdHelp','<p>Unique ID you use to identify employees in your organization.</p><p>For employees created through <b>Invite</b>, an employee id is automatically generated, which you can change later.</p>','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1933,0,'en','modules','employees.accountDetails','Account Details','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1934,0,'en','modules','employees.inviteLink','Invite by link','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1935,0,'en','modules','employees.inviteEmail','Invite by email','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1936,0,'en','modules','employees.sendInvite','Send Invite','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1937,0,'en','modules','employees.createLink','Create Link','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1938,0,'en','modules','employees.createLinkLabel','Create an invite link for members to join.','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1939,0,'en','modules','employees.allowAnyEmail','Allow any email address','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1940,0,'en','modules','employees.onlyAllow','Only allow email addresses with domain ','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1941,0,'en','modules','employees.message','Add a message (optional)','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1942,0,'en','modules','employees.exEmployee','Ex employee','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1943,0,'en','modules','employees.dateOfBirth','Date of Birth','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1944,0,'en','modules','employees.reportingTo','Reporting To','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1945,0,'en','modules','employees.reportingTeam','Reporting Team','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1946,0,'en','modules','employees.probationEndDate','Probation End Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1947,0,'en','modules','employees.noticePeriodStartDate','Notice Period Start Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1948,0,'en','modules','employees.noticePeriodEndDate','Notice Period End Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1949,0,'en','modules','employees.internshipEndDate','Internship End Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1950,0,'en','modules','employees.contractEndDate','Contract End Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1951,0,'en','modules','employees.maritalStatus','Marital Status','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1952,0,'en','modules','employees.marriageAnniversaryDate','Marriage Anniversary Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1953,0,'en','modules','employees.employmentType','Employment Type','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1954,0,'en','modules','employees.immigration','Immigration','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1955,0,'en','modules','employees.passportDetails','Passport Details','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1956,0,'en','modules','employees.passportNumber','Passport Number','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1957,0,'en','modules','employees.visaNumber','Visa Number','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1958,0,'en','modules','employees.issueDate','Issue Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1959,0,'en','modules','employees.expiryDate','Expiry Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1960,0,'en','modules','employees.scanCopy','Scan Copy','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1961,0,'en','modules','employees.visaDetails','Visa Details','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1962,0,'en','modules','projects.addNewProject','Add New Project','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1963,0,'en','modules','projects.projectName','Project Name','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1964,0,'en','modules','projects.projectMembers','Project Members','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1965,0,'en','modules','projects.createTitle','Add Project','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1966,0,'en','modules','projects.selectClient','Select Client','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1967,0,'en','modules','projects.startDate','Start Date','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1968,0,'en','modules','projects.deadline','Deadline','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1969,0,'en','modules','projects.projectSummary','Project Summary','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1970,0,'en','modules','projects.projectDetails','Project Details','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1971,0,'en','modules','projects.updateTitle','Update Project Details','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1972,0,'en','modules','projects.projectCategory','Project Category','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1973,0,'en','modules','projects.manageProjectCategory','Manage Category','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1974,0,'en','modules','projects.clientFeedback','Client Feedback','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1975,0,'en','modules','projects.projectCompletionStatus','Project Completion Status','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1976,0,'en','modules','projects.overview','Overview','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1977,0,'en','modules','projects.members','Members','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1978,0,'en','modules','projects.files','Files','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1979,0,'en','modules','projects.activeTimers','Active Timers','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1980,0,'en','modules','projects.whoWorking','Who\'s Working','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1981,0,'en','modules','projects.activeSince','Active Since','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1982,0,'en','modules','projects.openTasks','Open Tasks','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1983,0,'en','modules','projects.daysLeft','Days Left','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1984,0,'en','modules','projects.hoursLogged','Hours Logged','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1985,0,'en','modules','projects.issuesPending','Issues Pending','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1986,0,'en','modules','projects.activityTimeline','Activity Timeline','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1987,0,'en','modules','projects.addMemberTitle','Add Project Members','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1988,0,'en','modules','projects.uploadFile','Upload File','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1989,0,'en','modules','projects.dropFile','Drop files here OR click to upload','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1990,0,'en','modules','projects.updateSuccess',' project details updated.','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1991,0,'en','modules','projects.calculateTasksProgress','Calculate progress through tasks','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1992,0,'en','modules','projects.viewGanttChart','Gantt Chart','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1993,0,'en','modules','projects.clientViewTask','Client can manage tasks of this project','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1994,0,'en','modules','projects.manualTimelog','Allow manual time logs','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1995,0,'en','modules','projects.clientTaskNotification','Send task notification to client','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1996,0,'en','modules','projects.selectPayment','The payment gateway is required when payment status is Enable','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1997,0,'en','modules','projects.allProject','All Projects','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1998,0,'en','modules','projects.withoutDeadline','There is no project deadline','2023-05-30 17:19:56','2023-06-05 07:31:08'),
(1999,0,'en','modules','projects.pause','Pause','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2000,0,'en','modules','projects.resume','Resume','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2001,0,'en','modules','projects.cancel','Cancel','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2002,0,'en','modules','projects.activate','Activate','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2003,0,'en','modules','projects.projectInfo','Project Info','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2004,0,'en','modules','projects.clientInfo','Client Info','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2005,0,'en','modules','projects.budgetInfo','Budget Info','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2006,0,'en','modules','projects.projectBudget','Project Budget','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2007,0,'en','modules','projects.hours_allocated','Hours Estimate (In Hours)','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2008,0,'en','modules','projects.milestones','Milestones','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2009,0,'en','modules','projects.createMilestone','Create Milestone','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2010,0,'en','modules','projects.editMilestone','Edit Milestone','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2011,0,'en','modules','projects.milestoneCost','Milestone Cost','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2012,0,'en','modules','projects.milestoneTitle','Milestone Title','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2013,0,'en','modules','projects.milestoneSummary','Milestone Summary','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2014,0,'en','modules','projects.milestoneStartDate','Milestone Start Date','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2015,0,'en','modules','projects.milestoneEndDate','Milestone End Date','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2016,0,'en','modules','projects.projectEarningInfo','Calculated from payments module','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2017,0,'en','modules','projects.otherInfo','Other Info','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2018,0,'en','modules','projects.expenses_total','Expenses','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2019,0,'en','modules','projects.projectExpenseInfo','Calculated from expenses module','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2020,0,'en','modules','projects.addFileLink','Add file link','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2021,0,'en','modules','projects.selfAssignAsProjectMember','Add me as a project member','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2022,0,'en','modules','projects.viewPublicGanttChart','Public Gantt Chart','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2023,0,'en','modules','projects.burndownChart','Burndown Chart','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2024,0,'en','modules','projects.fileName','File name','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2025,0,'en','modules','projects.discussion','Discussion','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2026,0,'en','modules','projects.rating','Rating','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2027,0,'en','modules','projects.addCostProjectBudget','Add Cost To Project Budget','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2028,0,'en','modules','projects.chooseMembers','Choose Members','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2029,0,'en','modules','projects.chooseDepartment','Choose Department','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2030,0,'en','modules','projects.hideFinishedProjects','Hide Finished Projects','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2031,0,'en','modules','projects.projectProgress','Project Progress','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2032,0,'en','modules','projects.note','Notes','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2033,0,'en','modules','projects.visibleRatingToMembers','Visible Rating to Members','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2034,0,'en','modules','projects.noRatingAvailable','No Rating Available','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2035,0,'en','modules','projects.createPublicProject','Create Public Project','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2036,0,'en','modules','projects.createPrivateProject','Change To Private Project','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2037,0,'en','modules','projects.changeToPublicProject','Change To Public Project','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2038,0,'en','modules','projects.projectAdminInfo','Project Admin can add project member, tasks, discussions, notes, files, milestones','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2039,0,'en','modules','projects.enableMiroboard','Enable Miroboard','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2040,0,'en','modules','projects.miroBoardId','Miro Board ID','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2041,0,'en','modules','projects.clientMiroAccess','Client Can Access Miro ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2042,0,'en','modules','projects.projectClient','Project Client Details ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2043,0,'en','modules','projects.projectDoNotHaveClient','This project do not contain any client','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2044,0,'en','modules','projects.projectStatusSettings','Project Status Settings','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2045,0,'en','modules','projects.sameAssignee','Copy the same assignees','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2046,0,'en','modules','tasks.noSubTaskFound','No Sub Task Found','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2047,0,'en','modules','tasks.selectProject','Select Project','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2048,0,'en','modules','tasks.hideCompletedTask','Hide completed task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2049,0,'en','modules','tasks.newTask','New Task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2050,0,'en','modules','tasks.myTask','My Task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2051,0,'en','modules','tasks.changeStatus','Change Status','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2052,0,'en','modules','tasks.lastCreated','Last Created','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2053,0,'en','modules','tasks.dueSoon','Due Soon','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2054,0,'en','modules','tasks.dueDate','Due Date','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2055,0,'en','modules','tasks.assignTo','Assigned To','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2056,0,'en','modules','tasks.high','High','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2057,0,'en','modules','tasks.medium','Medium','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2058,0,'en','modules','tasks.low','Low','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2059,0,'en','modules','tasks.priority','Priority','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2060,0,'en','modules','tasks.selectPriority','Select Priority','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2061,0,'en','modules','tasks.updateTask','Update Task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2062,0,'en','modules','tasks.chooseAssignee','Choose Assignee','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2063,0,'en','modules','tasks.taskDetail','Task Detail','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2064,0,'en','modules','tasks.taskBoard','Task Board','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2065,0,'en','modules','tasks.addBoardColumn','Add Status Column','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2066,0,'en','modules','tasks.boardColumn','Board Column','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2067,0,'en','modules','tasks.columnName','Column Name','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2068,0,'en','modules','tasks.labelColor','Label Color','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2069,0,'en','modules','tasks.tasksTable','Tasks Table','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2070,0,'en','modules','tasks.position','Board Column Position','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2071,0,'en','modules','tasks.subTask','Sub Task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2072,0,'en','modules','tasks.comment','Comment','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2073,0,'en','modules','tasks.taskCategory','Task category','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2074,0,'en','modules','tasks.selectTaskCategory','Select Task category','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2075,0,'en','modules','tasks.noTaskCategory','No Task category available','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2076,0,'en','modules','tasks.category','Category','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2077,0,'en','modules','tasks.assignBy','Assigned By','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2078,0,'en','modules','tasks.markComplete','Mark as complete','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2079,0,'en','modules','tasks.markIncomplete','Mark as incomplete','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2080,0,'en','modules','tasks.reminder','Send Reminder','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2081,0,'en','modules','tasks.sectionVisibleClient','Section Visible To Client','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2082,0,'en','modules','tasks.moveToBoard','Move to Board','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2083,0,'en','modules','tasks.deleteRecurringTasks','Delete With Recurring Tasks','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2084,0,'en','modules','tasks.dependent','Task is dependent on another task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2085,0,'en','modules','tasks.dependentTask','Dependent Task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2086,0,'en','modules','tasks.chooseTask','Choose Task','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2087,0,'en','modules','tasks.uplodedFiles','Uploaded Files','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2088,0,'en','modules','tasks.cyclesToolTip','Number of times to repeat','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2089,0,'en','modules','tasks.preDeadlineReminder','Send task reminder <strong>before</strong> X days of due date','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2090,0,'en','modules','tasks.onDeadlineReminder','Send task reminder on the day of due date','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2091,0,'en','modules','tasks.postDeadlineReminder','Send task reminder <strong>after</strong> X days of due date','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2092,0,'en','modules','tasks.makePrivate','Make Private','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2093,0,'en','modules','tasks.privateInfo','Private tasks are only visible to admin, assignor and assignee.','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2094,0,'en','modules','tasks.createActivity','Task is created by','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2095,0,'en','modules','tasks.updateActivity','Task details are updated by ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2096,0,'en','modules','tasks.statusActivity','Task status changed by ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2097,0,'en','modules','tasks.commentActivity','Comment added by ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2098,0,'en','modules','tasks.fileActivity','File is uploaded by ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2099,0,'en','modules','tasks.subTaskCreateActivity','Sub task is created by ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2100,0,'en','modules','tasks.subTaskUpdateActivity','Sub task is updated by ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2101,0,'en','modules','tasks.history','History','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2102,0,'en','modules','tasks.defaultTaskStatus','Default Task Status','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2103,0,'en','modules','tasks.billable','Billable','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2104,0,'en','modules','tasks.billableInfo','Invoice can be generated for this task\'s time log.','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2105,0,'en','modules','tasks.assigned','Assigned','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2106,0,'en','modules','tasks.taskLabel','Task Label','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2107,0,'en','modules','tasks.assignMe','Assign to me','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2108,0,'en','modules','tasks.setTimeEstimate','Time estimate','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2109,0,'en','modules','tasks.users','Users','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2110,0,'en','modules','tasks.taskInfo','Task Info','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2111,0,'en','modules','tasks.loadMore','Load More','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2112,0,'en','modules','tasks.taskboardDefaultLength','Taskboard Default Length','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2113,0,'en','modules','tasks.timerStartedTask','Started the timer for task ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2114,0,'en','modules','tasks.timerStartedBy','Timer started','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2115,0,'en','modules','tasks.timerStartedProject','Started the timer for project ','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2116,0,'en','modules','tasks.timerStoppedBy','Timer stopped','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2117,0,'en','modules','tasks.copyTaskLink','Copy Task Link','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2118,0,'en','modules','tasks.timerPausedBy','Timer paused','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2119,0,'en','modules','tasks.unassigned','Unassigned','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2120,0,'en','modules','tasks.like','Like','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2121,0,'en','modules','tasks.dislike','Dislike','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2122,0,'en','modules','tasks.you','You','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2123,0,'en','modules','tasks.likeUser',':user reacted with thumbs up','2023-05-30 17:19:57','2023-06-05 07:31:08'),
(2124,0,'en','modules','tasks.dislikeUser',':user reacted with thumbs down','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2125,0,'en','modules','tasks.repeatInfo','Task will auto-create after every X days.','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2126,0,'en','modules','tasks.leaveMessage','One or more assignees are on leave on selected dates.','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2127,0,'en','modules','tasks.leaveOn','is on leave','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2128,0,'en','modules','tasks.editSubTask','Edit Sub Task','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2129,0,'en','modules','invoices.addInvoice','Create Invoice','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2130,0,'en','modules','invoices.receivedPayment','I have received the payment','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2131,0,'en','modules','invoices.paid','Paid','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2132,0,'en','modules','invoices.unpaid','Unpaid','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2133,0,'en','modules','invoices.pending','Pending','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2134,0,'en','modules','invoices.dueDate','Due Date','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2135,0,'en','modules','invoices.on-hold','On Hold','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2136,0,'en','modules','invoices.failed','Failed','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2137,0,'en','modules','invoices.processing','Processing','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2138,0,'en','modules','invoices.completed','Completed','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2139,0,'en','modules','invoices.refunded','Refunded','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2140,0,'en','modules','invoices.currency','Currency','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2141,0,'en','modules','invoices.invoiceDate','Invoice Date','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2142,0,'en','modules','invoices.projectName','Project Name','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2143,0,'en','modules','invoices.item','Item','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2144,0,'en','modules','invoices.qty','Quantity','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2145,0,'en','modules','invoices.unitPrice','Unit Price','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2146,0,'en','modules','invoices.amount','Amount','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2147,0,'en','modules','invoices.addItem','Add Item','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2148,0,'en','modules','invoices.subTotal','Sub Total','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2149,0,'en','modules','invoices.discount','Discount','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2150,0,'en','modules','invoices.tax','Tax','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2151,0,'en','modules','invoices.total','Total','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2152,0,'en','modules','invoices.billedTo','Billed To','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2153,0,'en','modules','invoices.billedFrom','Billed From','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2154,0,'en','modules','invoices.generatedBy','Generated By','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2155,0,'en','modules','invoices.price','Price','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2156,0,'en','modules','invoices.type','Type','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2157,0,'en','modules','invoices.payPaypal','Pay via Paypal','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2158,0,'en','modules','invoices.payPaystack','Pay via Paystack','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2159,0,'en','modules','invoices.payFlutterwave','Pay via Flutterwave','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2160,0,'en','modules','invoices.payMollie','Pay via Mollie','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2161,0,'en','modules','invoices.payPayfast','Pay via Payfast','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2162,0,'en','modules','invoices.payAuthorize','Pay via Authorize','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2163,0,'en','modules','invoices.paySquare','Pay via Square','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2164,0,'en','modules','invoices.downloadPdf','Download Pdf','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2165,0,'en','modules','invoices.isRecurringPayment','Is it a recurring payments?','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2166,0,'en','modules','invoices.billingCycle','Billing Cycle','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2167,0,'en','modules','invoices.billingFrequency','Billing Frequency','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2168,0,'en','modules','invoices.billingInterval','Billing Interval','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2169,0,'en','modules','invoices.recurringPayments','Recurring Payment','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2170,0,'en','modules','invoices.recurringInvoiceInfo','Recurring Invoice Info','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2171,0,'en','modules','invoices.payNow','Pay Now','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2172,0,'en','modules','invoices.payStripe','Pay via Stripe','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2173,0,'en','modules','invoices.taxName','Tax Name','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2174,0,'en','modules','invoices.rate','Rate','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2175,0,'en','modules','invoices.payOffline','Pay Offline','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2176,0,'en','modules','invoices.partial','Partially Paid','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2177,0,'en','modules','invoices.due','Due','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2178,0,'en','modules','invoices.uploadInvoice','Upload Invoice','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2179,0,'en','modules','invoices.project','Project','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2180,0,'en','modules','invoices.payRazorpay','Pay via Razorpay','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2181,0,'en','modules','invoices.copyPaymentLink','Copy Payment Link','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2182,0,'en','modules','invoices.appliedCredits','Applied Credits','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2183,0,'en','modules','invoices.amountDue','Amount Due','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2184,0,'en','modules','invoices.amountPaid','Amount Paid','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2185,0,'en','modules','invoices.markCancel','Mark as Canceled','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2186,0,'en','modules','invoices.showShippingAddress','Show Shipping Address','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2187,0,'en','modules','invoices.showShippingAddressInfo','Show Shipping Address in invoices','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2188,0,'en','modules','invoices.notSent','Not Sent','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2189,0,'en','modules','invoices.draft','Draft','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2190,0,'en','modules','invoices.buy','Buy','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2191,0,'en','modules','invoices.infinite','For Infinite Expenses','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2192,0,'en','modules','invoices.assignMe','Assign to me','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2193,0,'en','modules','invoices.totalUnpaidInvoice','Total Unpaid Invoices','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2194,0,'en','modules','invoices.to','To','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2195,0,'en','modules','invoices.paymentMethod','Payment Method','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2196,0,'en','modules','invoices.paidOn','Paid on','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2197,0,'en','modules','invoices.invoiceNumber','Invoice Number','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2198,0,'en','modules','invoices.billingAddress','Billing Address','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2199,0,'en','modules','invoices.shippingAddress','Shipping Address','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2200,0,'en','modules','invoices.note','note for recipient','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2201,0,'en','modules','invoices.placeOrder','Place Order','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2202,0,'en','modules','invoices.cardInfo','Card Info','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2203,0,'en','modules','invoices.canceled','Canceled','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2204,0,'en','modules','invoices.calculateTax','Calculate Tax','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2205,0,'en','modules','invoices.afterDiscount','After Discount','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2206,0,'en','modules','invoices.beforeDiscount','Before Discount','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2207,0,'en','modules','invoices.unitType','Unit Type','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2208,0,'en','modules','invoices.noOfBillingCycle','No. of billing cycles to be charged (set -1 for infinite cycles)','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2209,0,'en','modules','invoices.totalCount','Total Count','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2210,0,'en','modules','invoices.customerCharged','Customer will be charged','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2211,0,'en','modules','invoices.description','Description','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2212,0,'en','modules','invoices.invoiceBalanceDue','Invoice Balance Due','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2213,0,'en','modules','invoices.invoiceValue','Invoice Value','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2214,0,'en','modules','invoices.taxableValue','Taxable Value','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2215,0,'en','modules','invoices.editTax','Edit Tax','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2216,0,'en','modules','invoices.paymentDescription','Payment Description','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2217,0,'en','modules','invoices.sameIp','It\'s the same IP which you have.','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2218,0,'en','modules','issues.pending','Pending','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2219,0,'en','modules','issues.addIssue','Add Issue','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2220,0,'en','modules','issues.updateIssue','Update Issue','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2221,0,'en','modules','issues.resolved','Resolved','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2222,0,'en','modules','issues.markPending','Mark Pending','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2223,0,'en','modules','issues.markResolved','Mark Resolved','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2224,0,'en','modules','issues.reportedOn','Reported On','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2225,0,'en','modules','timeLogs.whoLogged','Who Logged','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2226,0,'en','modules','timeLogs.startTime','Start Time','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2227,0,'en','modules','timeLogs.endTime','End Time','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2228,0,'en','modules','timeLogs.totalHours','Total Hours','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2229,0,'en','modules','timeLogs.totalMinutes','Total Minutes','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2230,0,'en','modules','timeLogs.memo','Memo','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2231,0,'en','modules','timeLogs.lastUpdatedBy','Last updated by','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2232,0,'en','modules','timeLogs.employeeName','Employee Name','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2233,0,'en','modules','timeLogs.startDate','Start Date','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2234,0,'en','modules','timeLogs.endDate','End Date','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2235,0,'en','modules','timeLogs.logTime','Log Time','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2236,0,'en','modules','timeLogs.startTimer','Start Timer','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2237,0,'en','modules','timeLogs.stopTimer','Stop Timer','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2238,0,'en','modules','timeLogs.selectProject','Select Project','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2239,0,'en','modules','timeLogs.selectTask','Select Task','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2240,0,'en','modules','timeLogs.task','Task','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2241,0,'en','modules','timeLogs.whenLogged','when Logged','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2242,0,'en','modules','timeLogs.timeLogFrom','Time Log From','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2243,0,'en','modules','timeLogs.timeLogTo','Time Log To','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2244,0,'en','modules','timeLogs.myActiveTimer','My Active Timer','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2245,0,'en','modules','timeLogs.pauseTimer','Pause Timer','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2246,0,'en','modules','timeLogs.resumeTimer','Resume Timer','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2247,0,'en','modules','timeLogs.paused','Paused','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2248,0,'en','modules','timeLogs.break','Break','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2249,0,'en','modules','timeLogs.thisWeek','This Week','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2250,0,'en','modules','timeLogs.editBreak','Edit Break','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2251,0,'en','modules','taskCalendar.note','Calendar shows the due tasks on their due dates.','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2252,0,'en','modules','taskCalendar.taskDetail','Task Detail','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2253,0,'en','modules','notices.addNotice','Add New Notice','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2254,0,'en','modules','notices.notice','Notice','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2255,0,'en','modules','notices.noticeHeading','Notice Heading','2023-05-30 17:19:58','2023-06-05 07:31:08'),
(2256,0,'en','modules','notices.noticeDetails','Notice Details','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2257,0,'en','modules','notices.updateNotice','Update Notice','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2258,0,'en','modules','notices.toEmployee','To Employees','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2259,0,'en','modules','notices.toClients','To Clients','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2260,0,'en','modules','knowledgeBase.addknowledgebase','Add New Article','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2261,0,'en','modules','knowledgeBase.knowledgeDetails','Article Details','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2262,0,'en','modules','knowledgeBase.knowledgeDesc','Description','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2263,0,'en','modules','knowledgeBase.knowledgeHeading','Article Heading','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2264,0,'en','modules','knowledgeBase.knowledgeCategory','Article Category','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2265,0,'en','modules','knowledgeBase.knowledge','Knowledge','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2266,0,'en','modules','knowledgeBase.knowledgebase','Knowledge Base','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2267,0,'en','modules','knowledgeBase.updateknowledge','Update Article','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2268,0,'en','modules','knowledgeBase.toEmployee','For Employees','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2269,0,'en','modules','knowledgeBase.toClients','For Clients','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2270,0,'en','modules','knowledgeBase.uploadFile','Upload File','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2271,0,'en','modules','sticky.addNote','Add Note','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2272,0,'en','modules','sticky.lastUpdated','Updated','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2273,0,'en','modules','sticky.colors','Color Code','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2274,0,'en','modules','taskReport.taskToComplete','Total Tasks','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2275,0,'en','modules','taskReport.completedTasks','Completed Tasks','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2276,0,'en','modules','taskReport.pendingTasks','Pending Tasks','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2277,0,'en','modules','taskReport.chartTitle','Pie Chart','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2278,0,'en','modules','leaveReport.leaveReport','Leave Report','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2279,0,'en','modules','timeLogReport.chartTitle','Time Log Bar Chart','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2280,0,'en','modules','financeReport.showAmountIn','Show amount in ','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2281,0,'en','modules','financeReport.selectCurrency','Select Currency','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2282,0,'en','modules','financeReport.chartTitle','Earnings Bar Chart','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2283,0,'en','modules','financeReport.financeReport','Earnings Bar Chart','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2284,0,'en','modules','financeReport.noteText','The earnings are calculated with latest exchange rate for different currencies.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2285,0,'en','modules','accountSettings.updateTitle','Update Settings','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2286,0,'en','modules','accountSettings.appName','App Name','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2287,0,'en','modules','accountSettings.companyName','Company Name','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2288,0,'en','modules','accountSettings.companyEmail','Company Email','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2289,0,'en','modules','accountSettings.companyPhone','Company Phone','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2290,0,'en','modules','accountSettings.companyWebsite','Company Website','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2291,0,'en','modules','accountSettings.companyLogo','Company Logo','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2292,0,'en','modules','accountSettings.darkCompanyLogo','Dark Mode Logo','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2293,0,'en','modules','accountSettings.lightCompanyLogo','Light Mode Logo','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2294,0,'en','modules','accountSettings.companyAddress','Company Address','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2295,0,'en','modules','accountSettings.defaultTimezone','Default Timezone','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2296,0,'en','modules','accountSettings.defaultCurrency','Default Currency','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2297,0,'en','modules','accountSettings.changeLanguage','Change Language','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2298,0,'en','modules','accountSettings.language','Language','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2299,0,'en','modules','accountSettings.uploadLogo','Upload your logo','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2300,0,'en','modules','accountSettings.getLocation','Set current location','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2301,0,'en','modules','accountSettings.dateFormat','Date Format','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2302,0,'en','modules','accountSettings.timeFormat','Time Format','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2303,0,'en','modules','accountSettings.currencyConverterKey','Currency converter key','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2304,0,'en','modules','accountSettings.google_map_key','Google map key','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2305,0,'en','modules','accountSettings.weatherKey','Weather Key','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2306,0,'en','modules','accountSettings.appDebugInfo','This determines how much information about an error is actually displayed to the user.  ','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2307,0,'en','modules','accountSettings.appDebug','App Debug','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2308,0,'en','modules','accountSettings.googleRecaptcha','Google Recaptcha','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2309,0,'en','modules','accountSettings.googleRecaptchaInfo','Show google recaptcha on login page.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2310,0,'en','modules','accountSettings.googleRecaptchaKey','Google Recaptcha Key','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2311,0,'en','modules','accountSettings.googleRecaptchaSecret','Google Recaptcha Secret','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2312,0,'en','modules','accountSettings.sendReminder','Send Reminder','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2313,0,'en','modules','accountSettings.sendReminderInfo','Remind project members about due date of projects.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2314,0,'en','modules','accountSettings.updateEnableDisable','App Update','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2315,0,'en','modules','accountSettings.updateEnableDisableTest','This will hide or show the new update message on dashboard and hide/show the <b>Update Log</b> menu from settings','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2316,0,'en','modules','accountSettings.latitude','Latitude','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2317,0,'en','modules','accountSettings.longitude','Longitude','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2318,0,'en','modules','accountSettings.dashboardClock','Dashboard Clock','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2319,0,'en','modules','accountSettings.showDashboardClock','Show clock on dashboard page.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2320,0,'en','modules','accountSettings.clearCache','Clear Cache','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2321,0,'en','modules','accountSettings.currencyFormat','Currency Format','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2322,0,'en','modules','accountSettings.currencyFormatSetting','Currency Format Settings','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2323,0,'en','modules','accountSettings.currencyFormatSettingTooltip','We have taken 1000 as an example to show currency format','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2324,0,'en','modules','accountSettings.currencySetting','Currency Settings','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2325,0,'en','modules','accountSettings.numberOfdecimals','Number of Decimals','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2326,0,'en','modules','accountSettings.accountSetupInfo','Setup your admin account. This can be changed later.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2327,0,'en','modules','accountSettings.faviconImage','Favicon Image','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2328,0,'en','modules','accountSettings.setupProgress','Setup Progress','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2329,0,'en','modules','accountSettings.sessionDriver','Session Driver','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2330,0,'en','modules','accountSettings.sessionFile','File','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2331,0,'en','modules','accountSettings.sessionDatabase','Database','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2332,0,'en','modules','accountSettings.sessionInfo','This option controls the session \"driver\" that will be used on requests. Database driver gives you more control. <br><em>* Changing the driver will make you logout.</em>','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2333,0,'en','modules','accountSettings.deleteSessions','Delete Sessions','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2334,0,'en','modules','accountSettings.allowClientSignup','Allow Client Signup','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2335,0,'en','modules','accountSettings.allowClientSignupPopUp','Allowing it will show the sign up button on login page for the clients to get themselves register','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2336,0,'en','modules','accountSettings.needClientSignupApprovalPopUp','If you want newly registered client should be logged in to system only after it gets approved by the admin then enable this. Disabling it means the client can logging without approval','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2337,0,'en','modules','accountSettings.needClientSignupApproval','Need admin approval after client signup','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2338,0,'en','modules','accountSettings.fileUploadSetting','File Upload Settings','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2339,0,'en','modules','accountSettings.allowedFileType','Allowed file types for upload','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2340,0,'en','modules','accountSettings.allowedFileSize','Max File size for upload','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2341,0,'en','modules','accountSettings.commaSeparatedValues','Add comma (,) separated values.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2342,0,'en','modules','accountSettings.generateCredentials','Generate Credentials.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2343,0,'en','modules','accountSettings.autocompleteSearch','Autocomplete Search','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2344,0,'en','modules','accountSettings.businessMapLocation','Business Location on Map','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2345,0,'en','modules','accountSettings.yearStartsFrom','Year Starts from','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2346,0,'en','modules','accountSettings.appLanguageInfo','This will be the default language of the application for every user. This can be changed by user in profile settings.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2347,0,'en','modules','accountSettings.datatableRowLimit','Datatable Row Limit','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2348,0,'en','modules','accountSettings.datatableRowLimitPopover','Set the default row limit for all tables','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2349,0,'en','modules','accountSettings.appCurrencyInfo','When you change the currency you may have to update the exchange rates for the other currencies in currency settings and previous payments will calculate as per old currency exchange rates in finance report.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2350,0,'en','modules','profile.updateTitle','Update Profile Info','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2351,0,'en','modules','profile.yourName','Your Name','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2352,0,'en','modules','profile.yourEmail','Your Email','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2353,0,'en','modules','profile.yourPassword','Your Password','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2354,0,'en','modules','profile.passwordNote','Leave blank to keep your current password.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2355,0,'en','modules','profile.yourMobileNumber','Your Mobile Number','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2356,0,'en','modules','profile.yourAddress','Your Address','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2357,0,'en','modules','profile.profilePicture','Profile Picture','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2358,0,'en','modules','profile.uploadPicture','Upload your picture','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2359,0,'en','modules','profile.companyLogo','Company Logo','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2360,0,'en','modules','profile.productimage','Product Image','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2361,0,'en','modules','emailSettings.notificationTitle','Email Notification Settings','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2362,0,'en','modules','emailSettings.notificationSubtitle','Select the events for which an email should be sent to user.','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2363,0,'en','modules','emailSettings.configTitle','Mail Configuration','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2364,0,'en','modules','emailSettings.mailDriver','Mail Driver','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2365,0,'en','modules','emailSettings.mailHost','Mail Host','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2366,0,'en','modules','emailSettings.mailPort','Mail Port','2023-05-30 17:19:59','2023-06-05 07:31:08'),
(2367,0,'en','modules','emailSettings.mailUsername','Mail Username','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2368,0,'en','modules','emailSettings.mailPassword','Mail Password','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2369,0,'en','modules','emailSettings.mailFrom','Mail From Name','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2370,0,'en','modules','emailSettings.mailEncryption','Mail Encryption','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2371,0,'en','modules','emailSettings.userRegistration','User Registration/Added by Admin','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2372,0,'en','modules','emailSettings.employeeAssign','Employee Assign to Project','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2373,0,'en','modules','emailSettings.newNotice','New Notice Published','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2374,0,'en','modules','emailSettings.taskAssign','User Assign to Task','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2375,0,'en','modules','emailSettings.expenseAdded','New Expense (Added by Admin)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2376,0,'en','modules','emailSettings.expenseMember','New Expense (Added by Member)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2377,0,'en','modules','emailSettings.expenseStatus','Expense Status Changed','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2378,0,'en','modules','emailSettings.ticketRequest','New Support Ticket Request','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2379,0,'en','modules','emailSettings.mailFromEmail','Mail From Email','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2380,0,'en','modules','emailSettings.leaveRequest','Leave Request Received','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2381,0,'en','modules','emailSettings.taskComplete','Task completed','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2382,0,'en','modules','emailSettings.sendTestEmail','Send Test Email','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2383,0,'en','modules','emailSettings.removeImage','Remove Image','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2384,0,'en','modules','emailSettings.invoiceNotification','Invoice Notifications','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2385,0,'en','modules','emailSettings.emailNotifications','Receive email notifications?','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2386,0,'en','modules','emailSettings.user-registrationadded-by-admin','User Registration/Added by Admin','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2387,0,'en','modules','emailSettings.employee-assign-to-project','Employee Assign to Project','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2388,0,'en','modules','emailSettings.new-notice-published','New Notice Published','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2389,0,'en','modules','emailSettings.user-assign-to-task','User Assign to Task','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2390,0,'en','modules','emailSettings.new-expenseadded-by-admin','New Expense (Added by Admin)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2391,0,'en','modules','emailSettings.new-expenseadded-by-member','New Expense (Added by Member)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2392,0,'en','modules','emailSettings.expense-status-changed','Expense Status Changed','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2393,0,'en','modules','emailSettings.new-support-ticket-request','New Support Ticket Request','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2394,0,'en','modules','emailSettings.new-leave-application','Leave Request Received','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2395,0,'en','modules','emailSettings.task-completed','Task completed','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2396,0,'en','modules','emailSettings.invoice-createupdate-notification','Invoice Notifications','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2397,0,'en','modules','emailSettings.discussion-reply','Discussion Replies','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2398,0,'en','modules','emailSettings.mailConnection','Enable Email Queue','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2399,0,'en','modules','emailSettings.mailConnectionInfo','<p>To speed up the emailing process, the system will add the emails in queue and will send them via cron job.</p>  <p> Choose <u>No</u> to send email immediately <strong>(Slower)</strong>.</p><p>Choose <u>Yes</u> to send emails in background <strong>(Faster)</strong>.</p><p><em>*Make sure cron job is configured properly to use email queueing.</em></p>','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2400,0,'en','modules','moduleSettings.employeeModuleTitle','Modules','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2401,0,'en','modules','moduleSettings.clientModuleTitle','Client Module Title','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2402,0,'en','modules','moduleSettings.employeeSubTitle','Select the modules which you want to enable.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2403,0,'en','modules','moduleSettings.clientSubTitle','Select the modules which client can access.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2404,0,'en','modules','moduleSettings.moduleSetting','Module Settings','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2405,0,'en','modules','moduleSettings.section','section.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2406,0,'en','modules','moduleSettings.verifyPurchase','Verify Your Purchase','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2407,0,'en','modules','moduleSettings.contactAdmin','Contact your admin if you are not the admin to verify the purchase.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2408,0,'en','modules','moduleSettings.findPurchaseCode','Click this link to find your purchase code.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2409,0,'en','modules','moduleSettings.step1','Step 1','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2410,0,'en','modules','moduleSettings.step2','Step 2','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2411,0,'en','modules','currencySettings.addNewCurrency','Add New Currency','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2412,0,'en','modules','currencySettings.currencyName','Currency Name','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2413,0,'en','modules','currencySettings.currencySymbol','Currency Symbol','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2414,0,'en','modules','currencySettings.currencyCode','Currency Code','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2415,0,'en','modules','currencySettings.currencies','Currencies','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2416,0,'en','modules','currencySettings.updateTitle','Update Currency','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2417,0,'en','modules','currencySettings.exchangeRate','Exchange Rate','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2418,0,'en','modules','currencySettings.cantDeleteDefault','Cannot delete default currency.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2419,0,'en','modules','currencySettings.isCryptoCurrency','Is Cryptocurrency','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2420,0,'en','modules','currencySettings.usdPrice','USD Price','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2421,0,'en','modules','currencySettings.usdPriceInfo','Required to calculate earnings.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2422,0,'en','modules','currencySettings.fetchLatestExchangeRate','Fetch latest exchange rate.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2423,0,'en','modules','currencySettings.currencyPosition','Currency Position','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2424,0,'en','modules','currencySettings.thousandSeparator','Thousand Separator','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2425,0,'en','modules','currencySettings.decimalSeparator','Decimal Separator','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2426,0,'en','modules','currencySettings.noOfDecimals','Number Of Decimals','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2427,0,'en','modules','currencySettings.sample','Example','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2428,0,'en','modules','currencySettings.left','Left','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2429,0,'en','modules','currencySettings.right','Right','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2430,0,'en','modules','currencySettings.leftWithSpace','Left With Space','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2431,0,'en','modules','currencySettings.rightWithSpace','Right With Space','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2432,0,'en','modules','customLinkSettings.linkTitle','Link Title','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2433,0,'en','modules','customLinkSettings.url','URL','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2434,0,'en','modules','customLinkSettings.status','Status','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2435,0,'en','modules','customLinkSettings.addNewCustomLink','Add New Custom Link','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2436,0,'en','modules','customLinkSettings.canBeViewedBy','Can Be Viewed By','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2437,0,'en','modules','customLinkSettings.editCustomLink','Edit Custom Link','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2438,0,'en','modules','messages.startConversation','New Conversation','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2439,0,'en','modules','messages.chooseMember','Choose Member','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2440,0,'en','modules','messages.message','Message','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2441,0,'en','modules','messages.send','Send','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2442,0,'en','modules','messages.sendTo','Send To','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2443,0,'en','modules','messages.searchContact','Type to search contact','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2444,0,'en','modules','messages.typeMessage','Type your message here...','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2445,0,'en','modules','messages.chooseAdmin','Choose Admin','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2446,0,'en','modules','messages.allowClientEmployeeChat','Allow chat between client and employees?','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2447,0,'en','modules','messages.allowClientAdminChat','Allow chat between client and admin?','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2448,0,'en','modules','messages.admins','Administrators','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2449,0,'en','modules','messages.members','Project Members','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2450,0,'en','modules','messages.typing','typing','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2451,0,'en','modules','messages.allowClientProjectEmployeeChat','Only project members can chat with client','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2452,0,'en','modules','messages.sendSoundNotification','Send Sound Notification Alert','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2453,0,'en','modules','messages.soundNotificationInfo','Every 10 seconds application will check for new messgaes.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2454,0,'en','modules','taskDetail','Task Detail','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2455,0,'en','modules','themeSettings.adminPanelTheme','Admin Panel Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2456,0,'en','modules','themeSettings.projectAdminPanelTheme','Project Admin Panel Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2457,0,'en','modules','themeSettings.employeePanelTheme','Employee Panel Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2458,0,'en','modules','themeSettings.clientPanelTheme','Client Panel Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2459,0,'en','modules','themeSettings.headerColor','Primary Color','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2460,0,'en','modules','themeSettings.sidebarColor','Sidebar Background','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2461,0,'en','modules','themeSettings.sidebarTextColor','Sidebar Text Color','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2462,0,'en','modules','themeSettings.linkColor','Sidebar Active Color','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2463,0,'en','modules','themeSettings.loginScreenBackground','Login Screen Background Image','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2464,0,'en','modules','themeSettings.uploadImage','Upload Image','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2465,0,'en','modules','themeSettings.customCss','Custom CSS','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2466,0,'en','modules','themeSettings.useDefaultTheme','Use Default Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2467,0,'en','modules','themeSettings.useCustomTheme','Use Custom Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2468,0,'en','modules','themeSettings.enableRoundTheme','Enable rounded theme?','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2469,0,'en','modules','themeSettings.loginLogoBackgroundColor','Login Screen Logo\'s background Color','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2470,0,'en','modules','themeSettings.sidebarTheme','Sidebar Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2471,0,'en','modules','themeSettings.dark','Dark','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2472,0,'en','modules','themeSettings.light','Light','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2473,0,'en','modules','themeSettings.authTheme','Public Pages Theme','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2474,0,'en','modules','themeSettings.authThemeInfo','Theme for Login, Register and other public pages.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2475,0,'en','modules','themeSettings.logoSize','Recommended size 250 X 250 (Pixels)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2476,0,'en','modules','themeSettings.loginBackgroundSize','Recommended size: 1500 X 1056 (Pixels)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2477,0,'en','modules','themeSettings.faviconSize','Recommended size: 16 X 16 (Pixels)','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2478,0,'en','modules','themeSettings.sidebarBrandingStyle','Sidebar Branding Style','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2479,0,'en','modules','themeSettings.selectBrandingStyle','Select Branding Style','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2480,0,'en','modules','themeSettings.loginLogoTextColor','Login Screen Logo\'s text Color.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2481,0,'en','modules','themeSettings.loginLogoTextColorInfo','<strong>Dark:</strong> will show logo text in black.<br><br><strong>Light:</strong> will show logo text in White.','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2482,0,'en','modules','estimates.createEstimate','Create Estimate','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2483,0,'en','modules','estimates.validTill','Valid Till','2023-05-30 17:20:00','2023-06-05 07:31:08'),
(2484,0,'en','modules','estimates.waiting','Waiting','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2485,0,'en','modules','estimates.accepted','Accepted','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2486,0,'en','modules','estimates.declined','Declined','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2487,0,'en','modules','estimates.updateEstimate','Update Estimate','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2488,0,'en','modules','estimates.convertEstimateTitle','Convert Estimate To Invoice','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2489,0,'en','modules','estimates.convertInvoiceTitle','CONVERT INVOICE TO CREDIT NOTE','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2490,0,'en','modules','estimates.estimatesNumber','Estimate Number','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2491,0,'en','modules','estimates.signatureAndConfirmation','Signature & Confirmation Of Identity','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2492,0,'en','modules','estimates.cpatureAndConfirmation','Signature & Confirmation Of Identity','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2493,0,'en','modules','estimates.firstName','First Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2494,0,'en','modules','estimates.lastName','Last Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2495,0,'en','modules','estimates.signature','Signature','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2496,0,'en','modules','estimates.signedBy','Signed By','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2497,0,'en','modules','estimates.undo','Undo','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2498,0,'en','modules','estimates.clear','Clear','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2499,0,'en','modules','estimates.duplicateEstimate','Duplicate Estimate','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2500,0,'en','modules','estimates.estimateTo','Estimate To:','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2501,0,'en','modules','estimates.createDate','Create Date:','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2502,0,'en','modules','estimates.item','Item','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2503,0,'en','modules','estimates.price','Price','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2504,0,'en','modules','estimates.qty','Qty','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2505,0,'en','modules','estimates.total','Total','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2506,0,'en','modules','estimates.address','Address:','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2507,0,'en','modules','estimates.subtotal','Subtotal','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2508,0,'en','modules','estimates.discount','Discount','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2509,0,'en','modules','estimates.notes','Notes','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2510,0,'en','modules','estimates.sendEstimate','Send Estimate','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2511,0,'en','modules','estimates.draft','Draft','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2512,0,'en','modules','estimates.canceled','Canceled','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2513,0,'en','modules','estimates.copyLink','Copy Public Link','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2514,0,'en','modules','estimates.uploadSignature','Upload Signature','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2515,0,'en','modules','estimates.viewLink','View Public Link','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2516,0,'en','modules','estimates.estimateTemplate','Estimate Template','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2517,0,'en','modules','estimates.addEstimateTemplate','Add Estimate Template','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2518,0,'en','modules','estimates.createestimateTemplate','Create Estimate Template','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2519,0,'en','modules','estimates.updateEstimateTemplate','Update EstimateTemplate','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2520,0,'en','modules','estimates.estimateTemplates','ESTIMATE TEMPLATE','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2521,0,'en','modules','estimates.companysignature','Company Signature','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2522,0,'en','modules','estimates.clientsignature','Client Signature','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2523,0,'en','modules','payments.addPayment','Add Payment','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2524,0,'en','modules','payments.selectPaymentMethod','Select Payment Method','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2525,0,'en','modules','payments.selectOfflineMethod','Select Offline Method','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2526,0,'en','modules','payments.filterByCustomer','Filter invoices by client','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2527,0,'en','modules','payments.paymentDateMessage','Payment date required.','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2528,0,'en','modules','payments.transactionIdMsg','Transaction id required.','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2529,0,'en','modules','payments.offlineMethodMsg','Select offline method','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2530,0,'en','modules','payments.amountReceived','Amount Received','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2531,0,'en','modules','payments.paidOn','Paid On','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2532,0,'en','modules','payments.selectInvoice','Select Invoice','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2533,0,'en','modules','payments.paymentGateway','Payment Gateway','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2534,0,'en','modules','payments.transactionId','Transaction Id','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2535,0,'en','modules','payments.updatePayment','Update Payment','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2536,0,'en','modules','payments.paypalStatus','Paypal Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2537,0,'en','modules','payments.markInvoicePaid','Mark Invoice Paid?','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2538,0,'en','modules','payments.stripeStatus','Stripe Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2539,0,'en','modules','payments.import','Import CSV','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2540,0,'en','modules','payments.firstCharacter','First Character is Currency?','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2541,0,'en','modules','payments.remark','Remark','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2542,0,'en','modules','payments.amount','Amount','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2543,0,'en','modules','payments.totalAmount','Total Amount','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2544,0,'en','modules','payments.totalPaid','Total Paid','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2545,0,'en','modules','payments.totalDue','Total Due','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2546,0,'en','modules','payments.paymentDetailNotFound','Payment details not found.','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2547,0,'en','modules','payments.paymentDetails','Payment details','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2548,0,'en','modules','payments.paymentLink','View Payment Page','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2549,0,'en','modules','payments.razorpayStatus','Razorpay Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2550,0,'en','modules','payments.razorpayWebhookSecret','Razorpay Webhook Secret','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2551,0,'en','modules','payments.payStack','Paystack','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2552,0,'en','modules','payments.paystackKey','Paystack Public Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2553,0,'en','modules','payments.paystackStatus','Paystack Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2554,0,'en','modules','payments.PaystackSecretKey','Paystack Secret Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2555,0,'en','modules','payments.paystackMerchantEmail','Paystack Merchant Email','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2556,0,'en','modules','payments.flutterwave','Flutterwave','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2557,0,'en','modules','payments.flutterwaveKey','Flutterwave Public Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2558,0,'en','modules','payments.flutterwaveStatus','Flutterwave Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2559,0,'en','modules','payments.flutterwaveSecretKey','Flutterwave Secret Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2560,0,'en','modules','payments.flutterwaveSecretHash','Flutterwave Secret Hash','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2561,0,'en','modules','payments.flutterwaveWebhookSecretHash','Flutterwave Webhook Secret Hash','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2562,0,'en','modules','payments.mollieKey','Mollie Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2563,0,'en','modules','payments.mollieStatus','Mollie Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2564,0,'en','modules','payments.merchantId','Payfast Merchant ID','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2565,0,'en','modules','payments.merchantKey','Payfast Merchant Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2566,0,'en','modules','payments.merchantPassphrase','Payfast Passphrase','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2567,0,'en','modules','payments.testMerchantId','Test Payfast Merchant ID','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2568,0,'en','modules','payments.testMerchantKey','Test Payfast Merchant Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2569,0,'en','modules','payments.testMerchantPassphrase','Test Payfast Passphrase','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2570,0,'en','modules','payments.payfastStatus','Payfast Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2571,0,'en','modules','payments.authorizeStatus','Authorize Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2572,0,'en','modules','payments.authorizeApiLoginId','Authorize Api Login Id','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2573,0,'en','modules','payments.authorizeTransactionKey','Authorize Transaction Key','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2574,0,'en','modules','payments.squareStatus','Square Status','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2575,0,'en','modules','payments.squareApplicationId','Square Application Id','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2576,0,'en','modules','payments.squareLocationId','Square Location Id','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2577,0,'en','modules','payments.squareAccessToken','Square Access Token','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2578,0,'en','modules','payments.amountInWords','Amount received in words','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2579,0,'en','modules','payments.offlinePaymentMethod','Offline Payment Methods','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2580,0,'en','modules','payments.paymentDate','Payment Date','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2581,0,'en','modules','payments.addBulkPayment','Add Bulk Payment','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2582,0,'en','modules','projectCategory.addProjectCategory','Add Project Category','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2583,0,'en','modules','projectCategory.categoryName','Category Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2584,0,'en','modules','paystack.client_name','Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2585,0,'en','modules','paystack.client_email','Email','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2586,0,'en','modules','paystack.details','Paystack Details','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2587,0,'en','modules','flutterwave.client_name','Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2588,0,'en','modules','flutterwave.client_email','Email','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2589,0,'en','modules','flutterwave.client_phone','Phone','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2590,0,'en','modules','flutterwave.details','Flutterwave Details','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2591,0,'en','modules','flutterwave.somethingWentWrong','Something went wrong please try again later.','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2592,0,'en','modules','mollie.client_name','Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2593,0,'en','modules','mollie.client_email','Email','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2594,0,'en','modules','mollie.details','Mollie Details','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2595,0,'en','modules','payfast.client_name','Name','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2596,0,'en','modules','payfast.client_email','Email','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2597,0,'en','modules','payfast.details','Payfast Details','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2598,0,'en','modules','payfast.redirectMessage','You will redirect to Payfast payment page.','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2599,0,'en','modules','authorize.details','Authorize Payment','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2600,0,'en','modules','authorize.nameOnCard','Name on Card','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2601,0,'en','modules','authorize.cardNumber','Card Number','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2602,0,'en','modules','authorize.cvv','CVV','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2603,0,'en','modules','authorize.expMonth','Expiry Month','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2604,0,'en','modules','authorize.expYear','Expiry Year','2023-05-30 17:20:01','2023-06-05 07:31:08'),
(2605,0,'en','modules','authorize.errorMessage','There were some issue with the payment. Please try again later.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2606,0,'en','modules','authorize.errorNoResponse','No response returned','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2607,0,'en','modules','square.details','Square Payment','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2608,0,'en','modules','square.redirectMessage','You will redirect to Square payment page.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2609,0,'en','modules','expenses.addExpense','Add Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2610,0,'en','modules','expenses.editExpense','Edit Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2611,0,'en','modules','expenses.itemName','Item Name','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2612,0,'en','modules','expenses.purchaseDate','Purchase Date','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2613,0,'en','modules','expenses.purchaseFrom','Purchased From','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2614,0,'en','modules','expenses.updateExpense','Update Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2615,0,'en','modules','expenses.infinite','For Infinite Expenses','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2616,0,'en','modules','expenses.expenseCategory','Expense Category','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2617,0,'en','modules','expenses.attachBill','Attach Bill','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2618,0,'en','modules','expenses.removeBill','Remove Bill','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2619,0,'en','modules','expenses.approvedBy','Approved By','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2620,0,'en','modules','expenses.payrollExpenseReport','Payroll Expense Report','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2621,0,'en','modules','expenses.expenseBill','Expense Bill','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2622,0,'en','modules','expensesRecurring.addExpense','Add Recurring Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2623,0,'en','modules','expensesRecurring.itemName','Item Name','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2624,0,'en','modules','expensesRecurring.purchaseDate','Purchase Date','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2625,0,'en','modules','expensesRecurring.purchaseFrom','Purchased From','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2626,0,'en','modules','expensesRecurring.updateExpense','Update Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2627,0,'en','modules','expensesRecurring.infinite','For Infinite Expenses','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2628,0,'en','modules','expensesRecurring.created_at','Created On','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2629,0,'en','modules','expensesRecurring.dayOfWeek','Day Of Week','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2630,0,'en','modules','expensesRecurring.dayOfMonth','Day Of Month','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2631,0,'en','modules','expensesRecurring.lastPaymentDate','Last Payment Date','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2632,0,'en','modules','expensesRecurring.immediateExpense','Immediate start ( Expense will generate from now )','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2633,0,'en','modules','expensesRecurring.nextExpense','Next Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2634,0,'en','modules','expensesRecurring.nextExpenseDate','Next Expense Date will be','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2635,0,'en','modules','expensesRecurring.currentExpenseDate','First Expense will be generated on','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2636,0,'en','modules','expensesRecurring.expenseGenerated','The expense will be generate','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2637,0,'en','modules','expensesRecurring.completedTotalExpense','Completed/Total Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2638,0,'en','modules','expensesRecurring.firstExpenseDate','First Expense Date','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2639,0,'en','modules','invoiceSettings.invoicePrefix','Invoice Prefix','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2640,0,'en','modules','invoiceSettings.template','Template','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2641,0,'en','modules','invoiceSettings.dueAfter','Due after','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2642,0,'en','modules','invoiceSettings.invoiceTerms','Terms and Conditions','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2643,0,'en','modules','invoiceSettings.updateTitle','Update Finance Settings','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2644,0,'en','modules','invoiceSettings.invoiceDigit','Invoice Number Digits','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2645,0,'en','modules','invoiceSettings.invoiceLookLike','Invoice Number Example','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2646,0,'en','modules','invoiceSettings.estimatePrefix','Estimate Prefix','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2647,0,'en','modules','invoiceSettings.estimateDigit','Estimate Number Digits','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2648,0,'en','modules','invoiceSettings.estimateLookLike','Estimate Number Example','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2649,0,'en','modules','invoiceSettings.credit_notePrefix','Credit Note Prefix','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2650,0,'en','modules','invoiceSettings.credit_noteDigit','Credit Note Digits','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2651,0,'en','modules','invoiceSettings.credit_noteLookLike','Credit Note Number Example','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2652,0,'en','modules','invoiceSettings.contractPrefix','Contract Prefix','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2653,0,'en','modules','invoiceSettings.orderPrefix','Order Prefix','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2654,0,'en','modules','invoiceSettings.contractDigit','Contract Number Digits','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2655,0,'en','modules','invoiceSettings.orderDigit','Order Number Digits','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2656,0,'en','modules','invoiceSettings.contractLookLike','Contract Number Example','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2657,0,'en','modules','invoiceSettings.orderLookLike','Order Number Example','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2658,0,'en','modules','invoiceSettings.logo','Invoice Logo','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2659,0,'en','modules','invoiceSettings.showFieldsInInvoice','Client info to show on invoice','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2660,0,'en','modules','invoiceSettings.invoiceNumberSeparator','Invoice Number Separator','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2661,0,'en','modules','invoiceSettings.estimateNumberSeparator','Estimate Number Separator','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2662,0,'en','modules','invoiceSettings.credit_noteNumberSeparator','Credit Note Number Separator','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2663,0,'en','modules','invoiceSettings.contractNumberSeparator','Contract Number Separator','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2664,0,'en','modules','invoiceSettings.orderNumberSeparator','Order Number Separator','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2665,0,'en','modules','invoiceSettings.authorisedSignatory','Authorised Signatory','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2666,0,'en','modules','invoiceSettings.authorisedSignatorySignature','Authorised Signatory Signature','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2667,0,'en','modules','invoiceSettings.syncType','Sync Type','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2668,0,'en','modules','invoiceSettings.syncTypeInfo','<strong>One Way Sync:</strong> If you create invoice in this app then an invoice will be created on Quickbooks also.<br><br><strong>Two Way Sync:</strong> If you create invoice in this app then an invoice will be created on Quickbooks. And when invoice is created on Quickbooks then an invoice will be created in this app.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2669,0,'en','modules','invoiceSettings.oneWaySync','One Way Sync','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2670,0,'en','modules','invoiceSettings.twoWaySync','Two Way Sync','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2671,0,'en','modules','invoiceSettings.connectQuickBooks','Connect Quickbooks Account. Without connecting quickbooks account Sync will not work.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2672,0,'en','modules','invoiceSettings.reauthorizeQuickBooks','Reauthorize Quickbooks Account','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2673,0,'en','modules','invoiceSettings.syncInfo','It is only One-Way Sync. If you create invoice or payment here then an invoice or payment will be created on Quickbooks too.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2674,0,'en','modules','invoiceSettings.quickbooksRedirectUrl','Quickbooks Redirect URL','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2675,0,'en','modules','invoiceSettings.addQuickbooksRedirectUrl','Add this callback url in your quickbooks app settings.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2676,0,'en','modules','mobile.camera','Camera','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2677,0,'en','modules','mobile.gallery','Gallery','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2678,0,'en','modules','mobile.maximumFileSize','Maximum File Size','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2679,0,'en','modules','slackSettings.updateTitle','Update Slack Settings','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2680,0,'en','modules','slackSettings.uploadSlackLogo','Upload Notification Logo','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2681,0,'en','modules','slackSettings.notificationSubtitle','Select the events for which an notification should be sent to user.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2682,0,'en','modules','slackSettings.sendTestNotification','Send Test Notification','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2683,0,'en','modules','slackSettings.slackWebhook','Slack Webhook','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2684,0,'en','modules','slackSettings.slackNotificationLogo','Notification Logo','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2685,0,'en','modules','slackSettings.notificationTitle','Slack Notification Settings','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2686,0,'en','modules','update.systemDetails','System Details','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2687,0,'en','modules','update.updateTitle','Update To New Version','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2688,0,'en','modules','update.updateDatabase','Update Database','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2689,0,'en','modules','update.fileReplaceAlert','To update the worksuite to new version check documentation for the instructions.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2690,0,'en','modules','update.updateDatabaseButton','Click to update database','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2691,0,'en','modules','update.newUpdate','New update available','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2692,0,'en','modules','update.updateNow','Update Now','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2693,0,'en','modules','update.updateAlternate','If the <b>Update Now</b> button does not work then follow the <b> manual update</b> instructions as mentioned in the documentation.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2694,0,'en','modules','update.updateManual','Update Alternate Method','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2695,0,'en','modules','update.updateFiles','Update Files','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2696,0,'en','modules','update.install','Install','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2697,0,'en','modules','update.downloadUpdateFile','Download Update File','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2698,0,'en','modules','update.moduleFile','Once the zip file is uploaded, you will see a list of modules available for installation or update. To proceed with the installation or update, simply click on the \"install\" button for the respective module. Please note that after clicking the \"install\" button, you will be logged out. Once the installation is complete, you will be able to see the module on the module list. You can activate or deactivate the module from the list at any time.','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2699,0,'en','modules','incomeVsExpenseReport.totalIncome','Total Income','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2700,0,'en','modules','incomeVsExpenseReport.totalExpense','Total Expense','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2701,0,'en','modules','incomeVsExpenseReport.chartTitle','Bar Chart','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2702,0,'en','modules','tickets.ticketDetail','Ticket Details','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2703,0,'en','modules','tickets.agents','Agents','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2704,0,'en','modules','tickets.notAssigned','Not assigned','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2705,0,'en','modules','tickets.priority','Priority','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2706,0,'en','modules','tickets.selectPriority','Select Priority','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2707,0,'en','modules','tickets.newTicket','New Ticket','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2708,0,'en','modules','tickets.chooseAgents','Choose Agents','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2709,0,'en','modules','tickets.assignGroup','Assign Group','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2710,0,'en','modules','tickets.addGroup','Add group','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2711,0,'en','modules','tickets.group','Group','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2712,0,'en','modules','tickets.manageGroups','Manage Groups','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2713,0,'en','modules','tickets.groupName','Group Name','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2714,0,'en','modules','tickets.ticketType','Ticket Type','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2715,0,'en','modules','tickets.addType','Add Type','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2716,0,'en','modules','tickets.channelName','Channel Name','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2717,0,'en','modules','tickets.ticketChannel','Ticket Channel','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2718,0,'en','modules','tickets.template','Template','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2719,0,'en','modules','tickets.templateHeading','Template Heading','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2720,0,'en','modules','tickets.templateText','Template Text','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2721,0,'en','modules','tickets.addTicket','Create Ticket','2023-05-30 17:20:02','2023-06-05 07:31:08'),
(2722,0,'en','modules','tickets.ticket','Ticket','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2723,0,'en','modules','tickets.ticketSubject','Ticket Subject','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2724,0,'en','modules','tickets.ticketDescription','Ticket Description','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2725,0,'en','modules','tickets.applyTemplate','Apply Template','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2726,0,'en','modules','tickets.agent','Agent','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2727,0,'en','modules','tickets.tags','Tags','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2728,0,'en','modules','tickets.addChannel','Add Channel','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2729,0,'en','modules','tickets.requesterName','Requester Name','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2730,0,'en','modules','tickets.requester','Requester','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2731,0,'en','modules','tickets.reply','Reply','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2732,0,'en','modules','tickets.replies','Replies','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2733,0,'en','modules','tickets.totalTickets','Total Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2734,0,'en','modules','tickets.totalClosedTickets','Closed Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2735,0,'en','modules','tickets.totalOpenTickets','Open Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2736,0,'en','modules','tickets.totalPendingTickets','Pending Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2737,0,'en','modules','tickets.totalResolvedTickets','Resolved Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2738,0,'en','modules','tickets.requestedOn','Requested On','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2739,0,'en','modules','tickets.requestTicket','Request Support Ticket','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2740,0,'en','modules','tickets.closeTicket','Close Ticket','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2741,0,'en','modules','tickets.goToAgentDashboard','Go To Agent Dashboard','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2742,0,'en','modules','tickets.reopenTicket','Reopen Ticket','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2743,0,'en','modules','tickets.totalTicketInfo','No. of new tickets which were created for the selected date range.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2744,0,'en','modules','tickets.closedTicketInfo','No. of tickets which were closed in the selected date range.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2745,0,'en','modules','tickets.openTicketInfo','No. of tickets which are not yet assigned to any agent and updated in the selected date range.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2746,0,'en','modules','tickets.pendingTicketInfo','No. of tickets which were updated in the selected date range and are assigned to an agent.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2747,0,'en','modules','tickets.resolvedTicketInfo','No. of tickets which were resolved in the selected date range but waiting for requester confirmation.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2748,0,'en','modules','tickets.completedProjects','Completed Projects','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2749,0,'en','modules','tickets.inProcessProjects','In Process Projects','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2750,0,'en','modules','tickets.overDueProjects','Overdue Projects','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2751,0,'en','modules','tickets.totalUnresolvedTickets','Unresolved Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2752,0,'en','modules','tickets.ticketTrendGraph','Ticket trend graph','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2753,0,'en','modules','tickets.urgent','Urgent','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2754,0,'en','modules','tickets.nofilter','No filter','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2755,0,'en','modules','tickets.submitOpen','Submit as Open','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2756,0,'en','modules','tickets.submitPending','Submit as Pending','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2757,0,'en','modules','tickets.submitResolved','Submit as Resolved','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2758,0,'en','modules','tickets.submitClosed','Submit as Closed','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2759,0,'en','modules','tickets.recentTickets','Recent Tickets','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2760,0,'en','modules','tickets.name','Name','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2761,0,'en','modules','tickets.email','Email','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2762,0,'en','modules','tickets.ticket_subject','Ticket Subject','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2763,0,'en','modules','tickets.ticket_description','Ticket Description','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2764,0,'en','modules','tickets.assign_group','Assign Group','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2765,0,'en','modules','tickets.type','Type','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2766,0,'en','modules','tickets.googleCaptcha','Google Captcha','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2767,0,'en','modules','tickets.message','Message','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2768,0,'en','modules','tickets.imapSettings','IMAP Settings','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2769,0,'en','modules','tickets.imapHost','IMAP Host','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2770,0,'en','modules','tickets.imapPort','IMAP Port','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2771,0,'en','modules','tickets.imapEncryption','IMAP Encryption','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2772,0,'en','modules','tickets.smtpSettings','SMTP Settings','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2773,0,'en','modules','tickets.syncIntervals','Sync Interval','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2774,0,'en','modules','tickets.addTicketChannel','Add Ticket Channel','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2775,0,'en','modules','attendance.autoClockIn','Auto clock-in employee by first sign in','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2776,0,'en','modules','attendance.officeStartTime','Shift Start Time','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2777,0,'en','modules','attendance.officeEndTime','Shift End Time','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2778,0,'en','modules','attendance.halfDayMarkTime','Half-day Mark Time','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2779,0,'en','modules','attendance.lateMark','Late mark after (minutes)','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2780,0,'en','modules','attendance.allowSelfClock','Allowed Employee self Clock-In/Clock-Out','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2781,0,'en','modules','attendance.markAttendance','Mark Attendance','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2782,0,'en','modules','attendance.everyonePresent','Everyone`s present today','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2783,0,'en','modules','attendance.clock_in','Clock In','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2784,0,'en','modules','attendance.clockedIn','Clocked In','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2785,0,'en','modules','attendance.extraDays','Extra Working Days','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2786,0,'en','modules','attendance.late','Late','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2787,0,'en','modules','attendance.clock_out','Clock Out','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2788,0,'en','modules','attendance.clockedOut','Clocked Out','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2789,0,'en','modules','attendance.halfDay','Half Day','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2790,0,'en','modules','attendance.working_from','Working From','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2791,0,'en','modules','attendance.office','Office','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2792,0,'en','modules','attendance.home','Home','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2793,0,'en','modules','attendance.other','Other','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2794,0,'en','modules','attendance.otherPlace','Other Locations','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2795,0,'en','modules','attendance.workFrom','Office, Home, etc.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2796,0,'en','modules','attendance.officeOpenDays','Office opens on','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2797,0,'en','modules','attendance.totalWorkingDays','Working Days','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2798,0,'en','modules','attendance.daysPresent','Days Present','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2799,0,'en','modules','attendance.absent','Absent','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2800,0,'en','modules','attendance.viewFullAttendance','View Full Attendance','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2801,0,'en','modules','attendance.present','Present','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2802,0,'en','modules','attendance.currentTime','Current Time','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2803,0,'en','modules','attendance.attendanceByDate','Attendance By Date','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2804,0,'en','modules','attendance.attendanceByMember','Attendance by Member','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2805,0,'en','modules','attendance.attendanceByHour','Attendance by Hour','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2806,0,'en','modules','attendance.attendanceByLocation','Attendance by Location','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2807,0,'en','modules','attendance.holiday','Holiday','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2808,0,'en','modules','attendance.holidays','Holidays','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2809,0,'en','modules','attendance.holidayfor','Holiday for','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2810,0,'en','modules','attendance.checkininday','Maximum check-in allowed in a day','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2811,0,'en','modules','attendance.maxClockin','Maximum check-ins reached.','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2812,0,'en','modules','attendance.attendanceDetail','Attendance Detail','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2813,0,'en','modules','attendance.yes','Yes','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2814,0,'en','modules','attendance.no','No','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2815,0,'en','modules','attendance.leave','On Leave','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2816,0,'en','modules','attendance.leaveFor','Leave for','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2817,0,'en','modules','attendance.checkForIp','Clock-in check with added IP address','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2818,0,'en','modules','attendance.checkForRadius','Clock-in check with added location Radius','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2819,0,'en','modules','attendance.radius','Radius (in meter)','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2820,0,'en','modules','attendance.ipAddress','IP Address','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2821,0,'en','modules','attendance.hoursClocked','Hours Clocked','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2822,0,'en','modules','attendance.notClockOut','Did not clock out','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2823,0,'en','modules','attendance.attendanceReminderStatus','Attendance Reminder Status','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2824,0,'en','modules','attendance.ReminderAfterMinutes','Reminder After Minutes','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2825,0,'en','modules','attendance.autoClockInDefualtLocation','Defualt Location','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2826,0,'en','modules','attendance.saveCurrentLocation','Save Clock-In Location','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2827,0,'en','modules','attendance.showOnMap','Show on Map','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2828,0,'en','modules','attendance.showClockIn','Allow clock-in outside shift hours','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2829,0,'en','modules','attendance.clock_in_ip','Clock In IP','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2830,0,'en','modules','attendance.clock_out_ip','Clock Out IP','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2831,0,'en','modules','attendance.shift','Employee Shift','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2832,0,'en','modules','attendance.shiftName','Shift Name','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2833,0,'en','modules','attendance.scheduleShifts','Schedule Shifts','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2834,0,'en','modules','attendance.weekStartFrom','Week Starts From','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2835,0,'en','modules','attendance.shiftShortCode','Shift Short Code','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2836,0,'en','modules','attendance.shiftSchedule','Shift Schedule','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2837,0,'en','modules','attendance.notScheduled','Not Scheduled','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2838,0,'en','modules','attendance.requestChange','Request Change','2023-05-30 17:20:03','2023-06-05 07:31:08'),
(2839,0,'en','modules','attendance.requestFor','Request For','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2840,0,'en','modules','attendance.allowShiftChange','Allow employee to request shift change','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2841,0,'en','modules','attendance.shiftChangeRequests','Shift Change Requests','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2842,0,'en','modules','attendance.bulkShiftAssign','Assign Bulk Shifts','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2843,0,'en','modules','attendance.assignShift','Assign Shift','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2844,0,'en','modules','attendance.sendEmail','Send Email','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2845,0,'en','modules','attendance.requestPending','Request Pending','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2846,0,'en','modules','attendance.sendMonthlyReport','Send monthly attendance report email','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2847,0,'en','modules','attendance.chooseRoleReport','Choose roles for email report','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2848,0,'en','modules','attendance.dayOff','Day Off','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2849,0,'en','modules','attendance.earlyClockIn','Early Clock In (minutes)','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2850,0,'en','modules','attendance.deleteRequestChange','Delete Request Change','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2851,0,'en','modules','customFields.label','Field Label','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2852,0,'en','modules','customFields.addField','Add Field','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2853,0,'en','modules','customFields.editField','Edit Field','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2854,0,'en','modules','customFields.export','Allow export in table view','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2855,0,'en','modules','customFields.fieldType','Field Type','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2856,0,'en','modules','customFields.showInTable','Show in table view','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2857,0,'en','modules','statusFields.defaultStatus','Default Status','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2858,0,'en','modules','statusFields.addstatus','Add Status','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2859,0,'en','modules','statusFields.createStatus','Create Project Status','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2860,0,'en','modules','statusFields.editStatus','Edit Project Status','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2861,0,'en','modules','statusFields.change','You can not change inactive status to Default status','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2862,0,'en','modules','statusFields.addCategory','Add Category','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2863,0,'en','modules','events.addEvent','Add Event','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2864,0,'en','modules','events.eventName','Event Name','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2865,0,'en','modules','events.startOnDate','Starts On Date','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2866,0,'en','modules','events.startOnTime','Starts On Time','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2867,0,'en','modules','events.endOnDate','Ends On Date','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2868,0,'en','modules','events.endOnTime','Ends On Time','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2869,0,'en','modules','events.startOn','Start On','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2870,0,'en','modules','events.endOn','End On','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2871,0,'en','modules','events.addAttendees','Add Attendees','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2872,0,'en','modules','events.allEmployees','All Employees','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2873,0,'en','modules','events.where','Where','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2874,0,'en','modules','events.repeat','Repeat','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2875,0,'en','modules','events.repeatEvery','Repeat every','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2876,0,'en','modules','events.cycles','Cycles','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2877,0,'en','modules','events.cyclesToolTip','Recurring will be stopped after the number of cycles. Keep it blank for infinity.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2878,0,'en','modules','events.viewAttendees','View Attendees','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2879,0,'en','modules','events.attendees','Attendees','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2880,0,'en','modules','events.remindBefore','Remind before','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2881,0,'en','modules','events.eventLink','Event Link','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2882,0,'en','modules','events.uploadFile','Upload File','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2883,0,'en','modules','payroll.addPayroll','Add Payroll','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2884,0,'en','modules','payroll.amountPaid','Amount Paid','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2885,0,'en','modules','payroll.updatePayroll','Update Payroll','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2886,0,'en','modules','payroll.projectPayrollReport','Project Payroll Report','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2887,0,'en','modules','payroll.totalEarning','Total Earning','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2888,0,'en','modules','roles.addRole','Manage Role','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2889,0,'en','modules','permission.projectNote','User can view the basic details of projects assigned to him even without any permission.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2890,0,'en','modules','permission.attendanceNote','User can view his own attendance even without any permission.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2891,0,'en','modules','permission.taskNote','User can view the tasks assigned to him even without any permission.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2892,0,'en','modules','permission.ticketNote','User can view the tickets generated by him as default even without any permission.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2893,0,'en','modules','permission.eventNote','User can view the events to be attended by him as default even without any permission.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2894,0,'en','modules','permission.holidayNote','User can view the holidays as default even without any permission.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2895,0,'en','modules','permission.selectAll','Select All','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2896,0,'en','modules','permission.addRoleMember','Manage Role Members','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2897,0,'en','modules','permission.addMembers','Add Members','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2898,0,'en','modules','permission.roleName','Role Name','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2899,0,'en','modules','permission.deselectAll','Deselect All','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2900,0,'en','modules','permission.permissions','Permissions','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2901,0,'en','modules','permission.importFromRole','Import from Role','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2902,0,'en','modules','leaves.assignLeave','Assign Leave','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2903,0,'en','modules','leaves.addLeaveType','Add Leave Type','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2904,0,'en','modules','leaves.addLeave','New Leave','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2905,0,'en','modules','leaves.editLeave','Edit Leave','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2906,0,'en','modules','leaves.leaveType','Leave Type','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2907,0,'en','modules','leaves.selectDuration','Select Duration','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2908,0,'en','modules','leaves.leaveDate','Leave Date','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2909,0,'en','modules','leaves.single','Full Day','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2910,0,'en','modules','leaves.multiple','Multiple','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2911,0,'en','modules','leaves.halfDay','Half Day','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2912,0,'en','modules','leaves.hours','Hours','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2913,0,'en','modules','leaves.selectDates','Select Dates','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2914,0,'en','modules','leaves.reason','Reason for absence','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2915,0,'en','modules','leaves.statusReport','Approval by reporting manager','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2916,0,'en','modules','leaves.rejectReason','Reason for leave rejection','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2917,0,'en','modules','leaves.applicantName','Applicant Name','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2918,0,'en','modules','leaves.updateLeave','Update Leave','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2919,0,'en','modules','leaves.pendingLeaves','Pending Leaves','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2920,0,'en','modules','leaves.applyLeave','Apply Leave','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2921,0,'en','modules','leaves.noOfLeaves','No. of Leaves','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2922,0,'en','modules','leaves.countLeavesFromDateOfJoining','Count leaves from the date of joining','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2923,0,'en','modules','leaves.countLeavesFromStartOfYear','Count leaves from the start of the year','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2924,0,'en','modules','leaves.leaveSettingNote','Note: Approve means direct approval, Pre-Approval means another approval by admin/hr is required.','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2925,0,'en','modules','leaves.preApprove','Pre-Approve','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2926,0,'en','modules','leaves.approve','Approve','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2927,0,'en','modules','leaves.canNotApprove','Not Approve','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2928,0,'en','modules','leaves.reportingManager','Reporting Manager can','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2929,0,'en','modules','leaves.theLeave','the Leave','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2930,0,'en','modules','leaves.leavesTaken','Leaves Taken','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2931,0,'en','modules','leaves.remainingLeaves','Remaining Leaves','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2932,0,'en','modules','leaves.myLeaves','My Leaves','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2933,0,'en','modules','leaves.tableView','Table View','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2934,0,'en','modules','leaves.calendarView','Calendar View','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2935,0,'en','modules','leaves.leaveRequest','Leave Request','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2936,0,'en','modules','leaves.upcomingLeaves','Upcoming Leaves','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2937,0,'en','modules','leaves.leavePaidStatus','Leave Paid Status','2023-05-30 17:20:04','2023-06-05 07:31:08'),
(2938,0,'en','modules','leaves.employeeOnLeave','Employee is on leave','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2939,0,'en','modules','leaves.employeesOnLeave','Employees are on leave','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2940,0,'en','modules','leaves.approvedAt','Actioned At','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2941,0,'en','modules','leaves.approvedBy','Actioned By','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2942,0,'en','modules','leaves.firstHalf','First Half','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2943,0,'en','modules','leaves.secondHalf','Second Half','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2944,0,'en','modules','leaves.monthLimitInfo','Set 0 for no monthly limit','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2945,0,'en','modules','leaves.monthLimit','Monthly Limit','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2946,0,'en','modules','leaves.relatedLeave','Related Leaves','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2947,0,'en','modules','leaves.entitlement','Entitlement','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2948,0,'en','modules','leaves.effectiveAfter','Effective After','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2949,0,'en','modules','leaves.ofJoining','of Joining','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2950,0,'en','modules','leaves.unusedLeaves','Unused Leaves','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2951,0,'en','modules','leaves.canBeEncashed','Can Be Encashed','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2952,0,'en','modules','leaves.allowedProbation','Allowed in probation','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2953,0,'en','modules','leaves.allowedNotice','Allowed in notice period','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2954,0,'en','modules','leaves.applicability','Applicability','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2955,0,'en','modules','leaves.maritalStatus','Marital Status','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2956,0,'en','modules','leaves.married','Married','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2957,0,'en','modules','leaves.unmarried','Unmarried','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2958,0,'en','modules','leaves.carryForward','Carry Forward','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2959,0,'en','modules','leaves.lapse','Lapse','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2960,0,'en','modules','leaves.editLeaveType','Edit Leave Type','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2961,0,'en','modules','leaves.approveAll','Approve All','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2962,0,'en','modules','leaves.rejectAll','Reject All','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2963,0,'en','modules','leaves.approveRemaining','Approve Remaining','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2964,0,'en','modules','leaves.rejectRemaining','Reject Remaining','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2965,0,'en','modules','lead.createTitle','Add Lead Info','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2966,0,'en','modules','lead.companyDetails','Company Details','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2967,0,'en','modules','lead.companyName','Company Name','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2968,0,'en','modules','lead.website','Website','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2969,0,'en','modules','lead.address','Address','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2970,0,'en','modules','lead.leadDetails','Lead Details','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2971,0,'en','modules','lead.clientName','Lead Name','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2972,0,'en','modules','lead.clientEmail','Lead Email','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2973,0,'en','modules','lead.emailNote','Lead will login using this email.','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2974,0,'en','modules','lead.password','Password','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2975,0,'en','modules','lead.passwordNote','Client will login using this password.','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2976,0,'en','modules','lead.passwordUpdateNote','Client will login using this password. (Leave blank to keep current password)','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2977,0,'en','modules','lead.mobile','Mobile','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2978,0,'en','modules','lead.updateTitle','Update Lead Info','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2979,0,'en','modules','lead.addNewLead','Add New Lead','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2980,0,'en','modules','lead.viewDetails','View Details','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2981,0,'en','modules','lead.leadSource','Lead Source','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2982,0,'en','modules','lead.leadStatus','Lead Status','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2983,0,'en','modules','lead.leadFollowUp','Follow Up Next','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2984,0,'en','modules','lead.remark','Remark','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2985,0,'en','modules','lead.proposal','Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2986,0,'en','modules','lead.proposalTemplate','Proposal Template','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2987,0,'en','modules','lead.profile','Profile','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2988,0,'en','modules','lead.followUp','Follow Up','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2989,0,'en','modules','lead.note','Note','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2990,0,'en','modules','lead.email','Email','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2991,0,'en','modules','lead.source','Source','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2992,0,'en','modules','lead.status','Status','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2993,0,'en','modules','lead.leadDetail','Lead Detail','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2994,0,'en','modules','lead.nextFollowUp','Next Follow Up','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2995,0,'en','modules','lead.all','All','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2996,0,'en','modules','lead.lead','Lead','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2997,0,'en','modules','lead.client','Client','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2998,0,'en','modules','lead.pending','Pending','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(2999,0,'en','modules','lead.changeToClient','Change To Client','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3000,0,'en','modules','lead.addFollowUp','Add Follow Up','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3001,0,'en','modules','lead.edit','Edit','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3002,0,'en','modules','lead.action','Action','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3003,0,'en','modules','lead.view','View','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3004,0,'en','modules','lead.file','Files','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3005,0,'en','modules','lead.leadAgent','Lead Agent','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3006,0,'en','modules','lead.kanbanboard','Kanban Board','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3007,0,'en','modules','lead.defaultLeadStatus','Default Lead Status','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3008,0,'en','modules','lead.leadForm','Lead Form','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3009,0,'en','modules','lead.iframeSnippet','Copy & Paste the code anywhere in your site to show the form, additionally you can adjust the width and height px to fit for your website.','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3010,0,'en','modules','lead.leadCategory','Lead Category','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3011,0,'en','modules','lead.visibleToLead','Visible To Lead','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3012,0,'en','modules','lead.leadEmailInfo','Email will be used to send proposals.','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3013,0,'en','modules','lead.convertedLead','Converted Leads','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3014,0,'en','modules','lead.convertedClient','Converted into Client','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3015,0,'en','modules','lead.changeAgent','Change Agent','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3016,0,'en','modules','lead.estimateTemplate','Estimate Template','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3017,0,'en','modules','lead.products','Products','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3018,0,'en','modules','lead.convertedAmount','Converted Amount','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3019,0,'en','modules','lead.addLeadCategory','Add Lead Category','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3020,0,'en','modules','lead.addFile','Add Files','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3021,0,'en','modules','lead.addLeadSource','Add Lead Source','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3022,0,'en','modules','lead.editLeadCategory','Edit Lead Category','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3023,0,'en','modules','lead.editLeadSource','Edit Lead Source','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3024,0,'en','modules','lead.editLeadStatus','Edit Lead Status','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3025,0,'en','modules','lead.editFollowUp','Edit FollowUp','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3026,0,'en','modules','proposal.createTitle','Add Proposal Info','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3027,0,'en','modules','proposal.updateTitle','Update Proposal Info','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3028,0,'en','modules','proposal.addNewLead','Add New Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3029,0,'en','modules','proposal.viewDetails','View Details','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3030,0,'en','modules','proposal.title',' Lead Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3031,0,'en','modules','proposal.proposal',' Lead Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3032,0,'en','modules','proposal.createProposal','Create Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3033,0,'en','modules','proposal.validTill','Valid Till','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3034,0,'en','modules','proposal.waiting','Waiting','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3035,0,'en','modules','proposal.accepted','Accepted','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3036,0,'en','modules','proposal.declined','Declined','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3037,0,'en','modules','proposal.updateProposal','Update Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3038,0,'en','modules','proposal.convertProposalTitle','Convert Proposal To Invoice','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3039,0,'en','modules','proposal.edit','Edit','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3040,0,'en','modules','proposal.action','Action','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3041,0,'en','modules','proposal.view','View','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3042,0,'en','modules','proposal.delete','Delete','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3043,0,'en','modules','proposal.download','Download','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3044,0,'en','modules','proposal.publicLink','Public Link','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3045,0,'en','modules','proposal.rejectConfirm','Reject Confirm','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3046,0,'en','modules','proposal.requireSignature','Require customer signature for approval','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3047,0,'en','modules','proposal.sendProposal','Send Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3048,0,'en','modules','proposal.addProposalTemplate','Add Proposal Template','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3049,0,'en','modules','proposal.proposalTemplate','Proposal Template','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3050,0,'en','modules','proposal.createProposalTemplate','Create Proposal Template','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3051,0,'en','modules','proposal.updateProposalTemplate','Update Proposal Template','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3052,0,'en','modules','proposal.name','Name','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3053,0,'en','modules','followup.newFollowUp','New Follow Up','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3054,0,'en','modules','followup.updateFollow','Update Follow Up','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3055,0,'en','modules','followup.addNewLead','Add New Proposal','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3056,0,'en','modules','followup.viewDetails','View Details','2023-05-30 17:20:05','2023-06-05 07:31:08'),
(3057,0,'en','modules','followup.title',' Lead Proposal','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3058,0,'en','modules','followup.proposal',' Lead Proposal','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3059,0,'en','modules','followup.createProposal','Create Proposal','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3060,0,'en','modules','followup.validTill','Valid Till','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3061,0,'en','modules','followup.waiting','Waiting','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3062,0,'en','modules','followup.accepted','Accepted','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3063,0,'en','modules','followup.declined','Declined','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3064,0,'en','modules','followup.updateProposal','Update Proposal','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3065,0,'en','modules','followup.convertProposalTitle','Convert Proposal To Invoice','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3066,0,'en','modules','followup.followUpNotFound','No follow up found','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3067,0,'en','modules','followup.followUpNote','Follow up add and edit functionality will work when lead <b>next follow up</b> is set to <b>YES</b>.','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3068,0,'en','modules','holiday.title','Holiday','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3069,0,'en','modules','holiday.addNewHoliday','Add Holiday','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3070,0,'en','modules','holiday.viewDetails','View Details','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3071,0,'en','modules','holiday.createHoliday','Create Holiday','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3072,0,'en','modules','holiday.followUpNotFound','No Holiday found','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3073,0,'en','modules','holiday.markSunday',' Mark Default Holidays','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3074,0,'en','modules','holiday.date','Date','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3075,0,'en','modules','holiday.occasion','Occasion','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3076,0,'en','modules','holiday.day','Day','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3077,0,'en','modules','holiday.action','Action','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3078,0,'en','modules','holiday.listOf','List Of','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3079,0,'en','modules','holiday.viewOnCalendar','View on Calendar','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3080,0,'en','modules','holiday.markHoliday','Mark Holiday','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3081,0,'en','modules','holiday.officeHolidayMarkDays','Mark days for default Holidays for the current year','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3082,0,'en','modules','department.title','Department','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3083,0,'en','modules','department.addDepartment','Add Department','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3084,0,'en','modules','department.parentDepartment','Parent Department','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3085,0,'en','modules','department.dragAndDrop','Drag & drop to restructure','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3086,0,'en','modules','department.treeView','Hierarchy View','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3087,0,'en','modules','department.hierarchy','Hierarchy','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3088,0,'en','modules','department.searchValidation','Type atleast 3 characters','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3089,0,'en','modules','department.addTitle','Add Department','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3090,0,'en','modules','offlinePayment.title','Offline Payment Method','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3091,0,'en','modules','offlinePayment.method','Method','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3092,0,'en','modules','offlinePayment.description','Description','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3093,0,'en','modules','offlinePayment.addMethod','Add Offline Payment Method','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3094,0,'en','modules','offlinePayment.active','Active','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3095,0,'en','modules','offlinePayment.inActive','Inactive','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3096,0,'en','modules','offlinePayment.offlinePayment','Offline Payment','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3097,0,'en','modules','projectTemplate.addNewTemplate','Add New Template','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3098,0,'en','modules','projectTemplate.projectName','Template Name','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3099,0,'en','modules','projectTemplate.projectMembers','Template Members','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3100,0,'en','modules','projectTemplate.createTitle','Add Template Template','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3101,0,'en','modules','projectTemplate.selectClient','Select Client','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3102,0,'en','modules','projectTemplate.startDate','Start Date','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3103,0,'en','modules','projectTemplate.deadline','Deadline','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3104,0,'en','modules','projectTemplate.projectSummary','Template Summary','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3105,0,'en','modules','projectTemplate.note','Note','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3106,0,'en','modules','projectTemplate.updateTitle','Update Template Details','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3107,0,'en','modules','projectTemplate.projectCategory','Template Category','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3108,0,'en','modules','projectTemplate.clientFeedback','Client Feedback','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3109,0,'en','modules','projectTemplate.projectCompletionStatus','Template Completion Status','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3110,0,'en','modules','projectTemplate.overview','Overview','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3111,0,'en','modules','projectTemplate.members','Members','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3112,0,'en','modules','projectTemplate.files','Files','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3113,0,'en','modules','projectTemplate.activeTimers','Active Timers','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3114,0,'en','modules','projectTemplate.whoWorking','Who\'s Working','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3115,0,'en','modules','projectTemplate.activeSince','Active Since','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3116,0,'en','modules','projectTemplate.openTasks','Open Tasks','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3117,0,'en','modules','projectTemplate.daysLeft','Days Left','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3118,0,'en','modules','projectTemplate.hoursLogged','Hours Logged','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3119,0,'en','modules','projectTemplate.issuesPending','Issues Pending','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3120,0,'en','modules','projectTemplate.activityTimeline','Activity Timeline','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3121,0,'en','modules','projectTemplate.addMemberTitle','Add Template Members','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3122,0,'en','modules','projectTemplate.uploadFile','Upload File','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3123,0,'en','modules','projectTemplate.dropFile','Drop files here OR click to upload','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3124,0,'en','modules','projectTemplate.updateSuccess',' project details updated.','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3125,0,'en','modules','projectTemplate.calculateTasksProgress','Calculate progress through tasks','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3126,0,'en','modules','projectTemplate.viewGanttChart','Gantt Chart','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3127,0,'en','modules','projectTemplate.clientViewTask','Client can manage tasks of this project','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3128,0,'en','modules','projectTemplate.clientTaskNotification','Send task notification to client?','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3129,0,'en','modules','projectTemplate.manualTimelog','Allow manual time logs','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3130,0,'en','modules','templateTasks.newTask','New Template Task','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3131,0,'en','modules','templateTasks.lastCreated','Last Created','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3132,0,'en','modules','templateTasks.dueSoon','Due Soon','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3133,0,'en','modules','templateTasks.assignTo','Assigned To','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3134,0,'en','modules','templateTasks.high','High','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3135,0,'en','modules','templateTasks.medium','Medium','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3136,0,'en','modules','templateTasks.low','Low','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3137,0,'en','modules','templateTasks.priority','Priority','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3138,0,'en','modules','templateTasks.updateTask','Update Template Task','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3139,0,'en','modules','templateTasks.chooseAssignee','Choose Assignee','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3140,0,'en','modules','templateTasks.taskDetail','Template Task Detail','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3141,0,'en','modules','templateTasks.taskBoard','Template Task Board','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3142,0,'en','modules','templateTasks.addBoardColumn','Add Status Column','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3143,0,'en','modules','templateTasks.columnName','Column Name','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3144,0,'en','modules','templateTasks.labelColor','Label Color','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3145,0,'en','modules','templateTasks.tasksTable','Tasks Table','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3146,0,'en','modules','templateTasks.position','Position','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3147,0,'en','modules','templateTasks.subTask','Sub Template Task','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3148,0,'en','modules','templateTasks.comment','Comment','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3149,0,'en','modules','templateTasks.editBoardColumn','Edit Status Column','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3150,0,'en','modules','logTimeSetting.title','Log Time Settings','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3151,0,'en','modules','logTimeSetting.project','Project','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3152,0,'en','modules','logTimeSetting.task','Task','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3153,0,'en','modules','logTimeSetting.autoStopTimerAfterOfficeTime','Stop timer automatically after office time.','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3154,0,'en','modules','logTimeSetting.approvalRequired','Timelog will require approval','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3155,0,'en','modules','logTimeSetting.trackerReminder','Send time tracker reminders','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3156,0,'en','modules','logTimeSetting.dailyTimelogReport','Send Daily Timelog Report','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3157,0,'en','modules','taskCategory.addTaskCategory','Add Task Category','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3158,0,'en','modules','taskCategory.categoryName','Category Name','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3159,0,'en','modules','taskCategory.manageTaskCategory','Manage Task Category','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3160,0,'en','modules','taskCategory.taskCategory','Task Category','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3161,0,'en','modules','pushSettings.updateTitle','Update Push Notification Settings','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3162,0,'en','modules','pushSettings.oneSignalAppId','One Signal App ID','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3163,0,'en','modules','pushSettings.oneSignalRestApiKey','One Signal Rest API Key','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3164,0,'en','modules','pushSettings.notificationTitle','Push Notification Settings','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3165,0,'en','modules','timelogAlreadyExist','Time-log already exist for this user.','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3166,0,'en','modules','module.clients','Clients','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3167,0,'en','modules','module.employees','Employees','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3168,0,'en','modules','module.projects','Projects','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3169,0,'en','modules','module.proposals','Proposals','2023-05-30 17:20:06','2023-06-05 07:31:08'),
(3170,0,'en','modules','module.attendance','Attendance','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3171,0,'en','modules','module.tasks','Tasks','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3172,0,'en','modules','module.estimates','Estimates','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3173,0,'en','modules','module.invoices','Invoices','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3174,0,'en','modules','module.payments','Payments','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3175,0,'en','modules','module.tickets','Tickets','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3176,0,'en','modules','module.events','Events','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3177,0,'en','modules','module.noticeBoard','Notice Board','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3178,0,'en','modules','module.leaves','Leaves','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3179,0,'en','modules','module.leads','Leads','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3180,0,'en','modules','module.holidays','Holidays','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3181,0,'en','modules','module.products','Products','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3182,0,'en','modules','module.expenses','Expenses','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3183,0,'en','modules','module.timelogs','Time Logs','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3184,0,'en','modules','module.notice board','Notice Board','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3185,0,'en','modules','module.notices','Notices','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3186,0,'en','modules','module.messages','Messages','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3187,0,'en','modules','module.contracts','Contracts','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3188,0,'en','modules','module.product','Product','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3189,0,'en','modules','module.asset','Assets','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3190,0,'en','modules','module.payroll','Payroll','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3191,0,'en','modules','module.restapi','RestAPI','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3192,0,'en','modules','module.gitlab','GITLAB','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3193,0,'en','modules','module.zoom','Zoom','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3194,0,'en','modules','module.notes','Notes','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3195,0,'en','modules','module.reports','Reports','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3196,0,'en','modules','module.settings','Settings','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3197,0,'en','modules','module.dashboards','Dashboards','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3198,0,'en','modules','module.orders','Orders','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3199,0,'en','modules','module.sms','SMS','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3200,0,'en','modules','module.knowledgebase','Knowledge Base','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3201,0,'en','modules','module.addknowledgebaseCategory','Manage Article Category','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3202,0,'en','modules','module.emergency_contact','Emergency Contact','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3203,0,'en','modules','module.recruit','Recruit','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3204,0,'en','modules','module.bankaccount','Bank Account','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3205,0,'en','modules','projectSettings.sendNotificationsTo','Send Reminder To','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3206,0,'en','modules','loginAgain','You will have to login again to see the changes.','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3207,0,'en','modules','gdpr.gdpr','GDPR','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3208,0,'en','modules','gdpr.customers','Customers','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3209,0,'en','modules','gdpr.purpose','Purpose','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3210,0,'en','modules','gdpr.ipAddress','IP Address','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3211,0,'en','modules','gdpr.staffMember','Staff Member','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3212,0,'en','modules','gdpr.additionalDescription','Additional Description','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3213,0,'en','modules','gdpr.purposeDescription','Purpose Description','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3214,0,'en','modules','gdpr.optIn','OPT IN','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3215,0,'en','modules','gdpr.optOut','OPT OUT','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3216,0,'en','modules','gdpr.consent','Consent','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3217,0,'en','modules','gdpr.requestDataRemoval','Request Data Removal','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3218,0,'en','modules','gdpr.dataRemovalDescription','Briefly describe the purpose of removal of data','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3219,0,'en','modules','gdpr.removalRequestSuccess','Removal request has been sent to the admin. You will informed once it is approved','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3220,0,'en','modules','gdpr.enableGdpr','Enable GDPR','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3221,0,'en','modules','gdpr.showGdprLinkInNavigation','Show GDPR link in customers area navigation','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3222,0,'en','modules','gdpr.showGdprLinkInFooter','Show GDPR link in customers area footer','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3223,0,'en','modules','gdpr.gdprTopInformationBlock','GDPR page top information block','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3224,0,'en','modules','gdpr.enableCustomerToExportData','Enable customers to export their data','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3225,0,'en','modules','gdpr.enableCustomerToRequestForDataRemove','Enable customers to request for data remove','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3226,0,'en','modules','gdpr.enableLeadTorequestForDataRemove','Enable leads to request for data removal (via public form)','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3227,0,'en','modules','gdpr.enableTNCToCustomersFooter','Enable Terms & Conditions to customers footer','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3228,0,'en','modules','gdpr.termsAndCondition','Terms and Conditions','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3229,0,'en','modules','gdpr.privacyAndPolicy','Privacy and Policy','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3230,0,'en','modules','gdpr.allowLeadToUpdateDataFromPublicForm','Allow leads to update their data from public form','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3231,0,'en','modules','gdpr.enableConsentForCustomers','Enable consent for customers','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3232,0,'en','modules','gdpr.enableConsentForLeads','Enable consent for Leads','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3233,0,'en','modules','gdpr.publicPageConsentInformationBlock','Public page consent information block','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3234,0,'en','modules','gdpr.viewConsent','View Consent','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3235,0,'en','modules','gdpr.agree','I Agree','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3236,0,'en','modules','gdpr.disagree','I Disagree','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3237,0,'en','modules','reports.totalExpense','Total Expense','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3238,0,'en','modules','reports.totalCategories','Total Categories','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3239,0,'en','modules','contracts.createContract','Create Contract','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3240,0,'en','modules','contracts.createContractType','Create Contract Type','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3241,0,'en','modules','contracts.contractType','Contract Type','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3242,0,'en','modules','contracts.summery','Summary','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3243,0,'en','modules','contracts.discussion','Discussion','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3244,0,'en','modules','contracts.addComment','Add Comment','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3245,0,'en','modules','contracts.contractValue','Contract Value','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3246,0,'en','modules','contracts.contractNumber','Contract Number','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3247,0,'en','modules','contracts.endDate','End Date','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3248,0,'en','modules','contracts.totalContracts','Total Contracts','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3249,0,'en','modules','contracts.subject','Subject','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3250,0,'en','modules','contracts.description','Description','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3251,0,'en','modules','contracts.expired','Expired','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3252,0,'en','modules','contracts.active','Active','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3253,0,'en','modules','contracts.aboutToExpire','About To Expire','2023-05-30 17:20:07','2023-06-05 07:31:08'),
(3254,0,'en','modules','contracts.manageContractType','Manage Contract Type','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3255,0,'en','modules','contracts.addContractType','Add Contract Type','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3256,0,'en','modules','contracts.notes','Notes','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3257,0,'en','modules','contracts.editDiscussion','Edit Discussion','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3258,0,'en','modules','contracts.discussionUpdated','Discussion successfully updated.','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3259,0,'en','modules','contracts.discussionDeleted','Discussion successfully deleted.','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3260,0,'en','modules','contracts.discussionAdded','Discussion successfully added.','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3261,0,'en','modules','contracts.renewContract','Renew Contract','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3262,0,'en','modules','contracts.renewedThisContract','renewed this contract','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3263,0,'en','modules','contracts.newStartDate','New start date','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3264,0,'en','modules','contracts.newEndDate','New end date','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3265,0,'en','modules','contracts.newAmount','New Contract Value','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3266,0,'en','modules','contracts.contractRenewalHistory','Contract Renewal History','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3267,0,'en','modules','contracts.keepSignature','Keep Customer Signature','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3268,0,'en','modules','contracts.contractName','Contract Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3269,0,'en','modules','contracts.alternateAddress','Alternate Address','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3270,0,'en','modules','contracts.companyLogo','Company Logo','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3271,0,'en','modules','contracts.noValue','No Value','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3272,0,'en','modules','contracts.noEndDate','No End Date','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3273,0,'en','modules','contracts.streetAddress1','Street Address 1','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3274,0,'en','modules','contracts.streetAddress2','Street Address 2','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3275,0,'en','modules','contracts.setZero','Set value to 0 if contract does not have cost.','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3276,0,'en','modules','burndown.actual','Actual','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3277,0,'en','modules','burndown.ideal','Ideal','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3278,0,'en','modules','clients.addShippingAddress','Add Shipping Address','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3279,0,'en','modules','clients.shippingAddress','Shipping Address','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3280,0,'en','modules','discussions.lastCreated','Last Created','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3281,0,'en','modules','discussions.lastModified','Last Modified','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3282,0,'en','modules','discussions.discussionCategory','Discussion Category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3283,0,'en','modules','discussions.replied','replied at','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3284,0,'en','modules','discussions.posted','posted on','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3285,0,'en','modules','discussions.bestReply','Best Reply','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3286,0,'en','modules','discussions.removeBestReply','Remove as Best Reply','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3287,0,'en','modules','discussions.goBestReply','Go To Best Reply','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3288,0,'en','modules','stripeCustomerAddress.details','Address Details','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3289,0,'en','modules','stripeCustomerAddress.name','Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3290,0,'en','modules','stripeCustomerAddress.line1','Address Line','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3291,0,'en','modules','stripeCustomerAddress.postalCode','Postal code','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3292,0,'en','modules','stripeCustomerAddress.city','City','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3293,0,'en','modules','stripeCustomerAddress.state','State','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3294,0,'en','modules','stripeCustomerAddress.country','Country','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3295,0,'en','modules','taskLabel.createLabel','Create Label','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3296,0,'en','modules','taskLabel.addLabel','Add Label','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3297,0,'en','modules','recurringInvoice.allowToClient','Client can stop recurring.','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3298,0,'en','modules','recurringInvoice.invoiceDate','Date from which invoice will be created','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3299,0,'en','modules','recurringInvoice.immediateInvoice','Immediate start ( Invoice will generate from now )','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3300,0,'en','modules','recurringInvoice.billingCycle','No. of billing cycle is','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3301,0,'en','modules','recurringInvoice.nextInvoiceDate','Next Invoice Date will be','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3302,0,'en','modules','recurringInvoice.currentInvoiceDate','First Invoice will be generated on','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3303,0,'en','modules','recurringInvoice.nextInvoice','Next invoice','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3304,0,'en','modules','recurringInvoice.firstInvoiceDate','First Invoice Date','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3305,0,'en','modules','recurringInvoice.lastInvoiceDate','Last Invoice Date','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3306,0,'en','modules','recurringInvoice.completedTotalInvoice','Completed/Total Invoice','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3307,0,'en','modules','recurringInvoice.week','Week','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3308,0,'en','modules','recurringInvoice.soOn','And so on....','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3309,0,'en','modules','expenseCategory.expenseCategoryReport','Expense Category Report','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3310,0,'en','modules','expenseCategory.addExpenseCategory','Add Expense Category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3311,0,'en','modules','expenseCategory.categoryName','Category Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3312,0,'en','modules','expenseCategory.allowRoles','Allow Roles','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3313,0,'en','modules','expenseCategory.assignToRole','Assign To Roles','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3314,0,'en','modules','productCategory.subCategory','Sub Category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3315,0,'en','modules','productCategory.subCategoryName','Sub Category Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3316,0,'en','modules','productCategory.category','Category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3317,0,'en','modules','productCategory.productCategory','Product Category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3318,0,'en','modules','productCategory.productSubCategory','Product Sub Category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3319,0,'en','modules','productCategory.filterByCategory','Filter by category','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3320,0,'en','modules','leads.name','Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3321,0,'en','modules','leads.client_email','Email','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3322,0,'en','modules','leads.client_name','Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3323,0,'en','modules','leads.email','Email','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3324,0,'en','modules','leads.company_name','Company Name','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3325,0,'en','modules','leads.website','Website','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3326,0,'en','modules','leads.address','Address','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3327,0,'en','modules','leads.mobile','Mobile','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3328,0,'en','modules','leads.message','Message','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3329,0,'en','modules','leads.city','City','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3330,0,'en','modules','leads.state','State','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3331,0,'en','modules','leads.country','Country','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3332,0,'en','modules','leads.postal_code','Postal Code','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3333,0,'en','modules','emailNotification.new-expenseadded-by-admin','New Expense/Added by Admin','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3334,0,'en','modules','emailNotification.new-expenseadded-by-member','New Expense/Added by Member','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3335,0,'en','modules','emailNotification.expense-status-changed','Expense Status Changed','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3336,0,'en','modules','emailNotification.user-registrationadded-by-admin',' User Registration/Added by Admin','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3337,0,'en','modules','emailNotification.employee-assign-to-project','Employee Assign to Project','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3338,0,'en','modules','emailNotification.new-notice-published','New Notice Published','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3339,0,'en','modules','emailNotification.user-assign-to-task','User Assign to Task','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3340,0,'en','modules','emailNotification.new-leave-application','New Leave Application','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3341,0,'en','modules','emailNotification.task-completed','Task Completed','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3342,0,'en','modules','emailNotification.invoice-createupdate-notification','Invoice Create/Update Notification','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3343,0,'en','modules','emailNotification.payment-createupdate-notification','Payment Create/Update Notification','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3344,0,'en','modules','emailNotification.discussion-reply','Discussion Reply','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3345,0,'en','modules','emailNotification.new-proposal','New Proposal','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3346,0,'en','modules','emailNotification.lead-notification','Lead notification','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3347,0,'en','modules','emailNotification.birthday-notification','Birthday Notification','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3348,0,'en','modules','emailNotification.new-support-ticket-request','New Support Ticket Request','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3349,0,'en','modules','emailNotification.new-product-purchase-request','New Product Purchase Request','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3350,0,'en','modules','emailNotification.order-createupdate-notification','Order Create/Update Notification','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3351,0,'en','modules','emailNotification.user-join-via-invitation','User Join Via Invitation','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3352,0,'en','modules','emailNotification.follow-up-reminder','Follow Up Reminder','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3353,0,'en','modules','emailNotification.leave-approved','Leave Approved','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3354,0,'en','modules','emailNotification.leave-rejected','Leave Rejected','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3355,0,'en','modules','emailNotification.task-updated','Task Updated','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3356,0,'en','modules','emailNotification.new-task','New Task','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3357,0,'en','modules','emailNotification.new-client-task','New Client Task','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3358,0,'en','modules','emailNotification.task-update-client','Task Update Client','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3359,0,'en','modules','emailNotification.new-expense-added-by-admin','New Expense/Added by Admin','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3360,0,'en','modules','emailNotification.new-expense-added-by-member','New Expense/Added by Member','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3361,0,'en','modules','emailNotification.agent-ticket','Agent Ticket','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3362,0,'en','modules','emailNotification.new-ticket','New Ticket','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3363,0,'en','modules','emailNotification.invoice-created','Invoice Created','2023-05-30 17:20:08','2023-06-05 07:31:08'),
(3364,0,'en','modules','emailNotification.new-leave-request','New Leave Request','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3365,0,'en','modules','emailNotification.test-sms-notification','Test Sms Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3366,0,'en','modules','emailNotification.attendance-reminder','Attendance Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3367,0,'en','modules','emailNotification.auto-task-reminder','Auto Task Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3368,0,'en','modules','emailNotification.contract-signed','Contract Signed','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3369,0,'en','modules','emailNotification.estimate-declined','Estimate Declined','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3370,0,'en','modules','emailNotification.event-invite','Event Invite','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3371,0,'en','modules','emailNotification.event-reminder','Event Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3372,0,'en','modules','emailNotification.recurring-expense-status-updated','Recurring Expense Status Updated','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3373,0,'en','modules','emailNotification.new-file-uploaded-to-project','New File Uploaded to Project','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3374,0,'en','modules','emailNotification.payment-received','Payment Received','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3375,0,'en','modules','emailNotification.recurring-invoice-status-updated','Recurring Invoice Status Updated','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3376,0,'en','modules','emailNotification.invoice-reminder','Invoice Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3377,0,'en','modules','emailNotification.invoice-updated','Invoice Updated','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3378,0,'en','modules','emailNotification.leave-updated','Leave Updated','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3379,0,'en','modules','emailNotification.multiple-leave-application','Multiple Leave Application','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3380,0,'en','modules','emailNotification.new-multiple-leave-application','New Multiple Leave Application','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3381,0,'en','modules','emailNotification.new-order','New Order','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3382,0,'en','modules','emailNotification.new-payment','New Payment','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3383,0,'en','modules','emailNotification.new-product-purchase','New Product Purchase','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3384,0,'en','modules','emailNotification.new-project','New Project','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3385,0,'en','modules','emailNotification.new-recurring-invoice','New Recurring Invoice','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3386,0,'en','modules','emailNotification.payment-reminder','Payment Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3387,0,'en','modules','emailNotification.project-reminder','Project Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3388,0,'en','modules','emailNotification.proposal-approved','Proposal Approved','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3389,0,'en','modules','emailNotification.proposal-rejected','Proposal Rejected','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3390,0,'en','modules','emailNotification.order-updated','Order Updated','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3391,0,'en','modules','emailNotification.new-ticket-reply','New Ticket Reply','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3392,0,'en','modules','emailNotification.new-ticket-request','New Ticket Request','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3393,0,'en','modules','emailNotification.task-completed-client','Task Completed Client','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3394,0,'en','modules','emailNotification.notice-updated','Notice Updated','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3395,0,'en','modules','emailNotification.removal-request-admin-notification','Removal Request Admin Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3396,0,'en','modules','emailNotification.removal-request-approved','Removal Request Approved','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3397,0,'en','modules','emailNotification.removal-request-rejected','Removal Request Rejected','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3398,0,'en','modules','emailNotification.removal-request-approved-lead','Removal Request Approved Lead','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3399,0,'en','modules','emailNotification.removal-request-reject-lead','Removal Request Reject Lead','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3400,0,'en','modules','emailNotification.sub-task-assignee-added','Sub Task Assignee Added','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3401,0,'en','modules','emailNotification.sub-task-completed','Sub Task Completed','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3402,0,'en','modules','emailNotification.task-comment','Task Comment','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3403,0,'en','modules','emailNotification.task-note','Task Note','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3404,0,'en','modules','emailNotification.task-reminder','Task Reminder','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3405,0,'en','modules','emailNotification.removal-request-reject','Removal Request Reject','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3406,0,'en','modules','emailNotification.payment-notification','Payment Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3407,0,'en','modules','emailNotification.employee-appreciation','Employee Appreciation','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3408,0,'en','modules','emailNotification.clock-in-notification','Clock In Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3409,0,'en','modules','emailNotification.holiday-notification','Holiday Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3410,0,'en','modules','emailNotification.estimate-notification','Estimate Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3411,0,'en','modules','emailNotification.event-notification','Event Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3412,0,'en','modules','emailNotification.message-notification','Message Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3413,0,'en','modules','emailNotification.task-mention','Task Mention Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3414,0,'en','modules','emailNotification.project-mention-notification','Project Mention Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3415,0,'en','modules','emailNotification.task-mention-notification','Task Mention Notification','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3416,0,'en','modules','languageSettings.translate','Translate','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3417,0,'en','modules','languageSettings.autoTranslate','Auto Translate Settings','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3418,0,'en','modules','languageSettings.googleTranslationAPI','Google Translation API key','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3419,0,'en','modules','languageSettings.googleTranslationAPIMessage','Enable Cloud Translation API from Google Cloud Console and create API key.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3420,0,'en','modules','checklist.checklistInfo','We have prepared a list of things that will help you get there quickly.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3421,0,'en','modules','checklist.installation','Installation','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3422,0,'en','modules','checklist.installationInfo','Upload files on server and configure the database.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3423,0,'en','modules','checklist.accountSetup','Account Setup','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3424,0,'en','modules','checklist.accountSetupInfo','Setup admin account details.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3425,0,'en','modules','checklist.companyLogo','Add Company Logo','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3426,0,'en','modules','checklist.companyLogoInfo','This logo will show on Login, Register and Sidebar menu.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3427,0,'en','modules','checklist.favicon','Add Favicon','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3428,0,'en','modules','checklist.faviconInfo','This icon shows near the page title on the browser.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3429,0,'en','modules','checklist.profileImage','Add Profile Picture','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3430,0,'en','modules','checklist.profileImageInfo','Add your profile picture.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3431,0,'en','modules','checklist.emailSetup','Configure Email Settings','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3432,0,'en','modules','checklist.configureEmailSetting','Email setup is required to send emails to users for project, tasks, etc.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3433,0,'en','modules','checklist.crontSetup','Setup Cron Job','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3434,0,'en','modules','checklist.cronSetupInfo','Cron job setup is required to send reminder notifications and background tasks.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3435,0,'en','modules','ticketForm','Ticket Form','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3436,0,'en','modules','orders.createOrder','Create Order','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3437,0,'en','modules','orders.orderDate','Order Date','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3438,0,'en','modules','orders.orderNumber','Order Number','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3439,0,'en','modules','pusher.notificationTitle','Enable Pusher For','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3440,0,'en','modules','pusher.userNotifications','User Notifications','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3441,0,'en','modules','twofactor.authenticateVia','Authenticate Via','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3442,0,'en','modules','twofactor.userNotifications','User Notifications','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3443,0,'en','modules','twofactor.twoFaInfo','Increase your account\'s security by enabling Two-Factor Authentication (2FA)','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3444,0,'en','modules','twofactor.2faBarcode','Set up your 2FA by scanning the barcode below.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3445,0,'en','modules','twofactor.2faAppWarning','You must set up your <a href=\"https://play.google.com/store/apps/details?id=com.google.android.apps.authenticator2\" target=\"_blank\">Google Authenticator app for android <i class=\"fa fa-external-link-alt\"></i></a> or <a href=\"https://apps.apple.com/us/app/google-authenticator/id388497605\" target=\"_blank\">Google Authenticator app for IOS <i class=\"fa fa-external-link-alt\"></i></a> before\n    continuing. You will be unable to login otherwise.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3446,0,'en','modules','twofactor.setupGoogleAuthenticator','Setup Using Google Authenticator','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3447,0,'en','modules','twofactor.setupEmail','Setup Using Email','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3448,0,'en','modules','twofactor.verifySmtp','Email SMTP settings not configured.','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3449,0,'en','modules','twofactor.both','Both','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3450,0,'en','modules','twofactor.validate2FA','Validate 2FA','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3451,0,'en','modules','import.file','Upload File (file must be a file of type: xls, xlsx, csv)','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3452,0,'en','modules','import.containsHeadings','File Contains Headings Row','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3453,0,'en','modules','productImage','Product Image','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3454,0,'en','modules','invoiceFiles','Invoice Files','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3455,0,'en','modules','googleCalendar.clientId','Client ID','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3456,0,'en','modules','googleCalendar.clientSecret','Client Secret','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3457,0,'en','modules','databaseBackup.autobackup','Auto Backup Settings','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3458,0,'en','modules','databaseBackup.createDatabaseBackup','Create Database Backup','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3459,0,'en','modules','databaseBackup.backup','Backup','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3460,0,'en','modules','databaseBackup.backupSize','Backup Size','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3461,0,'en','modules','databaseBackup.hourOfDayForbackup','Hour of day to perform backup','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3462,0,'en','modules','databaseBackup.createBackupAfterDay','Create backup every X days','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3463,0,'en','modules','databaseBackup.deleteBackupAfter','Auto delete backups older then X days (set -1 to disable)','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3464,0,'en','modules','databaseBackup.enableCron','Enable (Requires Cron)','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3465,0,'en','modules','makeDefaultImage','Set default','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3466,0,'en','modules','emergencyContact.emergencyContact','Emergency Contacts','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3467,0,'en','modules','emergencyContact.viewEmergencyContact','View Emergency Contact','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3468,0,'en','modules','emergencyContact.editEmergencyContact','Edit Emergency Contact','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3469,0,'en','modules','emergencyContact.addNewEmergencyContact','Add New Emergency Contact','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3470,0,'en','modules','invoiceExport','Invoice','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3471,0,'en','modules','taskShortCode','Short Code','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3472,0,'en','modules','taskCode','Code','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3473,0,'en','modules','ticketStatus',' Ticket Status','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3474,0,'en','modules','flag','Flag','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3475,0,'en','modules','appreciations.icon','Icon','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3476,0,'en','modules','appreciations.addAppreciation','Add Appreciation','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3477,0,'en','modules','appreciations.editAppreciation','Edit Appreciation','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3478,0,'en','modules','appreciations.appreciation','Appreciation','2023-05-30 17:20:09','2023-06-05 07:31:08'),
(3479,0,'en','modules','appreciations.appreciationType','Award','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3480,0,'en','modules','appreciations.appreciationTypeName','Award Name','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3481,0,'en','modules','appreciations.addAppreciationType','Add Award','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3482,0,'en','modules','appreciations.editAppreciationType','Edit Award','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3483,0,'en','modules','appreciations.awardTo','Given To','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3484,0,'en','modules','appreciations.awardToEmployee','Given To ','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3485,0,'en','modules','appreciations.awardDate','Given On','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3486,0,'en','modules','appreciations.photo','Photo','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3487,0,'en','modules','appreciations.chooseIcon','Choose Icon','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3488,0,'en','modules','appreciations.appreciationStatus','Appreciation Status','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3489,0,'en','modules','awards.appreciationType','Award','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3490,0,'en','modules','awards.backgroundColor','Icon Background Color','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3491,0,'en','modules','bankaccount.bankName','Bank Name','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3492,0,'en','modules','bankaccount.addBankAccount','Add Bank Account','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3493,0,'en','modules','bankaccount.type','Account Type','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3494,0,'en','modules','bankaccount.accountName','Account Holder Name','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3495,0,'en','modules','bankaccount.accountType','Account Type','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3496,0,'en','modules','bankaccount.accountNumber','Account Number','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3497,0,'en','modules','bankaccount.contactNumber','Contact Number','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3498,0,'en','modules','bankaccount.openingBalance','Opening Balance','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3499,0,'en','modules','bankaccount.bankLogo','Bank Logo','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3500,0,'en','modules','bankaccount.cash','Cash','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3501,0,'en','modules','bankaccount.bank','Bank','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3502,0,'en','modules','bankaccount.updateBankAccount','Update Bank Account','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3503,0,'en','modules','bankaccount.relation','Relation','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3504,0,'en','modules','bankaccount.bankTransaction','Bank Transaction','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3505,0,'en','modules','bankaccount.bankTransfer','Bank Transfer','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3506,0,'en','modules','bankaccount.bankAccountTransfer','Bank Account Transfer','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3507,0,'en','modules','bankaccount.fromBankAccount','From Bank Account','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3508,0,'en','modules','bankaccount.toBankAccount','To Bank Account','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3509,0,'en','modules','bankaccount.memo','Memo','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3510,0,'en','modules','bankaccount.createTransaction','Create Transaction','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3511,0,'en','modules','bankaccount.deposit','Deposit','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3512,0,'en','modules','bankaccount.withdraw','Withdraw','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3513,0,'en','modules','bankaccount.transactionDate','Transaction Date','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3514,0,'en','modules','bankaccount.related','Related','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3515,0,'en','modules','bankaccount.bankBalance','Bank Balance','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3516,0,'en','modules','bankaccount.generateStatement','Generate Statement','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3517,0,'en','modules','bankaccount.bankStatement','Bank Statement','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3518,0,'en','modules','bankaccount.particulars','Particulars','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3519,0,'en','modules','bankaccount.saving','Saving','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3520,0,'en','modules','bankaccount.current','Current','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3521,0,'en','modules','bankaccount.statementDetail','Statement of transactions in :accountType account number: :accountNumber in :currency For the period :startDate To :endDate','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3522,0,'en','modules','bankaccount.bank-account-created','Opening Balance','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3523,0,'en','modules','bankaccount.bank-account-updated','Bank Account Updated','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3524,0,'en','modules','bankaccount.bank-account-transfer','Bank Account Transfer','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3525,0,'en','modules','bankaccount.bank-account-deposit','Amount Deposit','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3526,0,'en','modules','bankaccount.bank-account-withdraw','Amount Withdraw','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3527,0,'en','modules','bankaccount.payment-credited','Payment Credited','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3528,0,'en','modules','bankaccount.payment-updated','Payment Updated','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3529,0,'en','modules','bankaccount.payment-deleted','Payment Deleted','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3530,0,'en','modules','bankaccount.expense-added','Expense Added','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3531,0,'en','modules','bankaccount.expense-modified','Expense Modified','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3532,0,'en','modules','bankaccount.expense-deleted','Expense Deleted','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3533,0,'en','modules','bankaccount.accountStatus','Account Status','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3534,0,'en','modules','bankaccount.credit','Credit','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3535,0,'en','modules','bankaccount.debit','Debit','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3536,0,'en','modules','bankaccount.creditCard','Credit Card','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3537,0,'en','modules','bankaccount.loan','Loans','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3538,0,'en','modules','bankaccount.overdraft','Overdraft','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3539,0,'en','modules','bankaccount.insight','Insight','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3540,0,'en','modules','bankaccount.creditVsDebit','Credit vs Debit','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3541,0,'en','modules','bankaccount.recentTransactions','Recent Transactions','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3542,0,'en','modules','bankaccount.currencyHelp','Enter the amount in ','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3543,0,'en','modules','bankaccount.payment-debited','Payment Debited','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3544,0,'en','modules','unitType.UnitTypeName','Unit Types','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3545,0,'en','modules','unitType.unitType','Unit Type','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3546,0,'en','modules','addIpAddress','Add IP Address','2023-05-30 17:20:10','2023-06-05 07:31:08'),
(3547,0,'en','pagination','previous','&laquo; Previous','2023-05-30 17:20:10','2023-06-04 06:42:01'),
(3548,0,'en','pagination','next','Next &raquo;','2023-05-30 17:20:10','2023-06-04 06:42:01'),
(3549,0,'en','passwords','reset','Your password has been reset!. Please wait, you will be redirected back to login page in a while','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3550,0,'en','passwords','sent','Please check your email account. We have e-mailed your password reset link!','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3551,0,'en','passwords','throttled','Please wait before retrying.','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3552,0,'en','passwords','token','This password reset token is invalid.','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3553,0,'en','passwords','user','We can\'t find a user with that e-mail address.','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3554,0,'en','passwords','password','Passwords must be at least six characters and match the confirmation.','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3555,0,'en','permissions','manage_skill','Manage Skills','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3556,0,'en','permissions','add_job','Add Job','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3557,0,'en','permissions','view_job','View Job','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3558,0,'en','permissions','edit_job','Edit Job','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3559,0,'en','permissions','delete_job','Delete Job','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3560,0,'en','permissions','add_job_application','Add Job Application','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3561,0,'en','permissions','view_job_application','View Job Application','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3562,0,'en','permissions','edit_job_application','Edit Job Application','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3563,0,'en','permissions','delete_job_application','Delete Job Application','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3564,0,'en','permissions','add_notes','Add Notes','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3565,0,'en','permissions','edit_notes','Edit Notes','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3566,0,'en','permissions','delete_notes','Delete Notes','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3567,0,'en','permissions','add_application_status','Add Application Status','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3568,0,'en','permissions','edit_application_status','Edit Application Status','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3569,0,'en','permissions','delete_application_status','Delete Application Status','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3570,0,'en','permissions','change_application_status','Change Application Status','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3571,0,'en','permissions','add_interview_schedule','Add Interview Schedule','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3572,0,'en','permissions','view_interview_schedule','View Interview Schedule','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3573,0,'en','permissions','edit_interview_schedule','Edit Interview Schedule','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3574,0,'en','permissions','delete_interview_schedule','Delete Interview Schedule','2023-05-30 17:20:10','2023-06-04 06:42:02'),
(3575,0,'en','permissions','reschedule_interview','Reschedule Interview','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3576,0,'en','permissions','add_recommendation_status','Add Recommendation Status','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3577,0,'en','permissions','edit_recommendation_status','Edit Recommendation Status','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3578,0,'en','permissions','delete_recommendation_status','Delete Recommendation Status','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3579,0,'en','permissions','add_recruiter','Add Recruiter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3580,0,'en','permissions','edit_recruiter','Edit Recruiter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3581,0,'en','permissions','delete_recruiter','Delete Recruiter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3582,0,'en','permissions','add_offer_letter','Add Offer Letter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3583,0,'en','permissions','view_offer_letter','View Offer Letter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3584,0,'en','permissions','edit_offer_letter','Edit Offer Letter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3585,0,'en','permissions','delete_offer_letter','Delete Offer Letter','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3586,0,'en','permissions','add_footer_link','Add Footer Link','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3587,0,'en','permissions','edit_footer_link','Edit Footer Link','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3588,0,'en','permissions','delete_footer_link','Delete Footer Link','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3589,0,'en','permissions','view_report','View Report','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3590,0,'en','permissions','recruit_settings','Recruit Settings','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3591,0,'en','permissions','manage_salary_payment_method','Manage Salary Payment Method','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3592,0,'en','permissions','manage_salary_component','Manage Salary Component','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3593,0,'en','permissions','manage_salary_group','Manage Salary Group','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3594,0,'en','permissions','manage_salary_tds','Manage Salary Tds','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3595,0,'en','permissions','manage_employee_salary','Manage Employee Salary','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3596,0,'en','permissions','add_payroll','Add Payroll','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3597,0,'en','permissions','view_payroll','View Payroll','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3598,0,'en','permissions','edit_payroll','Edit Payroll','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3599,0,'en','permissions','delete_payroll','Delete Payroll','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3600,0,'en','permissions','manage_job_category','Manage Job Category','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3601,0,'en','permissions','manage_job_sub_category','Manage Job Sub Category','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3602,0,'en','permissions','add_clients','Add Clients','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3603,0,'en','permissions','view_clients','View Clients','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3604,0,'en','permissions','edit_clients','Edit Clients','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3605,0,'en','permissions','delete_clients','Delete Clients','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3606,0,'en','permissions','manage_client_category','Manage Client Category','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3607,0,'en','permissions','manage_client_subcategory','Manage Client Subcategory','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3608,0,'en','permissions','add_client_contacts','Add Client Contacts','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3609,0,'en','permissions','view_client_contacts','View Client Contacts','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3610,0,'en','permissions','edit_client_contacts','Edit Client Contacts','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3611,0,'en','permissions','delete_client_contacts','Delete Client Contacts','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3612,0,'en','permissions','add_client_note','Add Client Note','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3613,0,'en','permissions','view_client_note','View Client Note','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3614,0,'en','permissions','edit_client_note','Edit Client Note','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3615,0,'en','permissions','delete_client_note','Delete Client Note','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3616,0,'en','permissions','add_client_document','Add Client Document','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3617,0,'en','permissions','view_client_document','View Client Document','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3618,0,'en','permissions','edit_client_document','Edit Client Document','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3619,0,'en','permissions','delete_client_document','Delete Client Document','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3620,0,'en','permissions','add_employees','Add Employees','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3621,0,'en','permissions','view_employees','View Employees','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3622,0,'en','permissions','edit_employees','Edit Employees','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3623,0,'en','permissions','delete_employees','Delete Employees','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3624,0,'en','permissions','add_designation','Add Designation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3625,0,'en','permissions','view_designation','View Designation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3626,0,'en','permissions','edit_designation','Edit Designation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3627,0,'en','permissions','delete_designation','Delete Designation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3628,0,'en','permissions','add_department','Add Department','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3629,0,'en','permissions','view_department','View Department','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3630,0,'en','permissions','edit_department','Edit Department','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3631,0,'en','permissions','delete_department','Delete Department','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3632,0,'en','permissions','add_documents','Add Documents','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3633,0,'en','permissions','view_documents','View Documents','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3634,0,'en','permissions','edit_documents','Edit Documents','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3635,0,'en','permissions','delete_documents','Delete Documents','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3636,0,'en','permissions','view_leaves_taken','View Leaves Taken','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3637,0,'en','permissions','update_leaves_quota','Update Leaves Quota','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3638,0,'en','permissions','view_employee_tasks','View Employee Tasks','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3639,0,'en','permissions','view_employee_projects','View Employee Projects','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3640,0,'en','permissions','view_employee_timelogs','View Employee Timelogs','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3641,0,'en','permissions','change_employee_role','Change Employee Role','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3642,0,'en','permissions','manage_emergency_contact','Manage Emergency Contact','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3643,0,'en','permissions','manage_award','Manage Award','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3644,0,'en','permissions','add_appreciation','Add Appreciation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3645,0,'en','permissions','view_appreciation','View Appreciation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3646,0,'en','permissions','edit_appreciation','Edit Appreciation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3647,0,'en','permissions','delete_appreciation','Delete Appreciation','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3648,0,'en','permissions','add_immigration','Add Immigration','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3649,0,'en','permissions','view_immigration','View Immigration','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3650,0,'en','permissions','edit_immigration','Edit Immigration','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3651,0,'en','permissions','delete_immigration','Delete Immigration','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3652,0,'en','permissions','add_projects','Add Projects','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3653,0,'en','permissions','view_projects','View Projects','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3654,0,'en','permissions','edit_projects','Edit Projects','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3655,0,'en','permissions','delete_projects','Delete Projects','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3656,0,'en','permissions','manage_project_category','Manage Project Category','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3657,0,'en','permissions','view_project_files','View Project Files','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3658,0,'en','permissions','add_project_files','Add Project Files','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3659,0,'en','permissions','delete_project_files','Delete Project Files','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3660,0,'en','permissions','view_project_discussions','View Project Discussions','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3661,0,'en','permissions','add_project_discussions','Add Project Discussions','2023-05-30 17:20:11','2023-06-04 06:42:02'),
(3662,0,'en','permissions','edit_project_discussions','Edit Project Discussions','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3663,0,'en','permissions','delete_project_discussions','Delete Project Discussions','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3664,0,'en','permissions','manage_discussion_category','Manage Discussion Category','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3665,0,'en','permissions','view_project_milestones','View Project Milestones','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3666,0,'en','permissions','add_project_milestones','Add Project Milestones','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3667,0,'en','permissions','edit_project_milestones','Edit Project Milestones','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3668,0,'en','permissions','delete_project_milestones','Delete Project Milestones','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3669,0,'en','permissions','view_project_members','View Project Members','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3670,0,'en','permissions','add_project_members','Add Project Members','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3671,0,'en','permissions','edit_project_members','Edit Project Members','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3672,0,'en','permissions','delete_project_members','Delete Project Members','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3673,0,'en','permissions','view_project_rating','View Project Rating','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3674,0,'en','permissions','add_project_rating','Add Project Rating','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3675,0,'en','permissions','edit_project_rating','Edit Project Rating','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3676,0,'en','permissions','delete_project_rating','Delete Project Rating','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3677,0,'en','permissions','view_project_budget','View Project Budget','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3678,0,'en','permissions','view_project_timelogs','View Project Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3679,0,'en','permissions','view_project_expenses','View Project Expenses','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3680,0,'en','permissions','view_project_tasks','View Project Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3681,0,'en','permissions','view_project_invoices','View Project Invoices','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3682,0,'en','permissions','view_project_burndown_chart','View Project Burndown Chart','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3683,0,'en','permissions','view_project_payments','View Project Payments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3684,0,'en','permissions','view_project_gantt_chart','View Project Gantt Chart','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3685,0,'en','permissions','add_project_note','Add Project Note','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3686,0,'en','permissions','view_project_note','View Project Note','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3687,0,'en','permissions','edit_project_note','Edit Project Note','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3688,0,'en','permissions','delete_project_note','Delete Project Note','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3689,0,'en','permissions','manage_project_template','Manage Project Template','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3690,0,'en','permissions','view_project_template','View Project Template','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3691,0,'en','permissions','view_project_hourly_rates','View Project Hourly Rates','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3692,0,'en','permissions','create_public_project','Create Public Project','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3693,0,'en','permissions','view_miroboard','View Miroboard','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3694,0,'en','permissions','manage_employee_shifts','Manage Employee Shifts','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3695,0,'en','permissions','view_shift_roster','View Shift Roster','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3696,0,'en','permissions','add_attendance','Add Attendance','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3697,0,'en','permissions','view_attendance','View Attendance','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3698,0,'en','permissions','edit_attendance','Edit Attendance','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3699,0,'en','permissions','delete_attendance','Delete Attendance','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3700,0,'en','permissions','add_tasks','Add Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3701,0,'en','permissions','view_tasks','View Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3702,0,'en','permissions','edit_tasks','Edit Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3703,0,'en','permissions','delete_tasks','Delete Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3704,0,'en','permissions','view_task_category','View Task Category','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3705,0,'en','permissions','add_task_category','Add Task Category','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3706,0,'en','permissions','edit_task_category','Edit Task Category','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3707,0,'en','permissions','delete_task_category','Delete Task Category','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3708,0,'en','permissions','view_task_files','View Task Files','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3709,0,'en','permissions','add_task_files','Add Task Files','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3710,0,'en','permissions','delete_task_files','Delete Task Files','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3711,0,'en','permissions','view_sub_tasks','View Sub Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3712,0,'en','permissions','add_sub_tasks','Add Sub Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3713,0,'en','permissions','edit_sub_tasks','Edit Sub Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3714,0,'en','permissions','delete_sub_tasks','Delete Sub Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3715,0,'en','permissions','view_task_comments','View Task Comments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3716,0,'en','permissions','add_task_comments','Add Task Comments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3717,0,'en','permissions','edit_task_comments','Edit Task Comments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3718,0,'en','permissions','delete_task_comments','Delete Task Comments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3719,0,'en','permissions','view_task_notes','View Task Notes','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3720,0,'en','permissions','add_task_notes','Add Task Notes','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3721,0,'en','permissions','edit_task_notes','Edit Task Notes','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3722,0,'en','permissions','delete_task_notes','Delete Task Notes','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3723,0,'en','permissions','task_labels','Task Labels','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3724,0,'en','permissions','change_status','Change Status','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3725,0,'en','permissions','send_reminder','Send Reminder','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3726,0,'en','permissions','add_status','Add Status','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3727,0,'en','permissions','view_unassigned_tasks','View Unassigned Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3728,0,'en','permissions','create_unassigned_tasks','Create Unassigned Tasks','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3729,0,'en','permissions','add_estimates','Add Estimates','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3730,0,'en','permissions','view_estimates','View Estimates','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3731,0,'en','permissions','edit_estimates','Edit Estimates','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3732,0,'en','permissions','delete_estimates','Delete Estimates','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3733,0,'en','permissions','add_invoices','Add Invoices','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3734,0,'en','permissions','view_invoices','View Invoices','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3735,0,'en','permissions','edit_invoices','Edit Invoices','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3736,0,'en','permissions','delete_invoices','Delete Invoices','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3737,0,'en','permissions','manage_tax','Manage Tax','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3738,0,'en','permissions','link_invoice_bank_account','Link Invoice Bank Account','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3739,0,'en','permissions','manage_recurring_invoice','Manage Recurring Invoice','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3740,0,'en','permissions','add_payments','Add Payments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3741,0,'en','permissions','view_payments','View Payments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3742,0,'en','permissions','edit_payments','Edit Payments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3743,0,'en','permissions','delete_payments','Delete Payments','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3744,0,'en','permissions','link_payment_bank_account','Link Payment Bank Account','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3745,0,'en','permissions','add_timelogs','Add Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3746,0,'en','permissions','view_timelogs','View Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3747,0,'en','permissions','edit_timelogs','Edit Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3748,0,'en','permissions','delete_timelogs','Delete Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3749,0,'en','permissions','approve_timelogs','Approve Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3750,0,'en','permissions','manage_active_timelogs','Manage Active Timelogs','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3751,0,'en','permissions','view_timelog_earnings','View Timelog Earnings','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3752,0,'en','permissions','add_tickets','Add Tickets','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3753,0,'en','permissions','view_tickets','View Tickets','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3754,0,'en','permissions','edit_tickets','Edit Tickets','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3755,0,'en','permissions','delete_tickets','Delete Tickets','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3756,0,'en','permissions','manage_ticket_type','Manage Ticket Type','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3757,0,'en','permissions','manage_ticket_agent','Manage Ticket Agent','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3758,0,'en','permissions','manage_ticket_channel','Manage Ticket Channel','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3759,0,'en','permissions','manage_ticket_tags','Manage Ticket Tags','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3760,0,'en','permissions','add_events','Add Events','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3761,0,'en','permissions','view_events','View Events','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3762,0,'en','permissions','edit_events','Edit Events','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3763,0,'en','permissions','delete_events','Delete Events','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3764,0,'en','permissions','add_notice','Add Notice','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3765,0,'en','permissions','view_notice','View Notice','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3766,0,'en','permissions','edit_notice','Edit Notice','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3767,0,'en','permissions','delete_notice','Delete Notice','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3768,0,'en','permissions','add_leave','Add Leave','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3769,0,'en','permissions','view_leave','View Leave','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3770,0,'en','permissions','edit_leave','Edit Leave','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3771,0,'en','permissions','delete_leave','Delete Leave','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3772,0,'en','permissions','approve_or_reject_leaves','Approve Or Reject Leaves','2023-05-30 17:20:12','2023-06-04 06:42:02'),
(3773,0,'en','permissions','delete_approve_leaves','Delete Approve Leaves','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3774,0,'en','permissions','add_lead','Add Lead','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3775,0,'en','permissions','view_lead','View Lead','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3776,0,'en','permissions','edit_lead','Edit Lead','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3777,0,'en','permissions','delete_lead','Delete Lead','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3778,0,'en','permissions','view_lead_agents','View Lead Agents','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3779,0,'en','permissions','add_lead_agent','Add Lead Agent','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3780,0,'en','permissions','edit_lead_agent','Edit Lead Agent','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3781,0,'en','permissions','delete_lead_agent','Delete Lead Agent','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3782,0,'en','permissions','view_lead_category','View Lead Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3783,0,'en','permissions','add_lead_category','Add Lead Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3784,0,'en','permissions','edit_lead_category','Edit Lead Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3785,0,'en','permissions','delete_lead_category','Delete Lead Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3786,0,'en','permissions','manage_lead_custom_forms','Manage Lead Custom Forms','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3787,0,'en','permissions','view_lead_files','View Lead Files','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3788,0,'en','permissions','add_lead_files','Add Lead Files','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3789,0,'en','permissions','delete_lead_files','Delete Lead Files','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3790,0,'en','permissions','view_lead_follow_up','View Lead Follow Up','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3791,0,'en','permissions','add_lead_follow_up','Add Lead Follow Up','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3792,0,'en','permissions','edit_lead_follow_up','Edit Lead Follow Up','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3793,0,'en','permissions','delete_lead_follow_up','Delete Lead Follow Up','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3794,0,'en','permissions','view_lead_sources','View Lead Sources','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3795,0,'en','permissions','add_lead_sources','Add Lead Sources','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3796,0,'en','permissions','edit_lead_sources','Edit Lead Sources','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3797,0,'en','permissions','delete_lead_sources','Delete Lead Sources','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3798,0,'en','permissions','view_lead_proposals','View Lead Proposals','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3799,0,'en','permissions','add_lead_proposals','Add Lead Proposals','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3800,0,'en','permissions','edit_lead_proposals','Edit Lead Proposals','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3801,0,'en','permissions','delete_lead_proposals','Delete Lead Proposals','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3802,0,'en','permissions','manage_proposal_template','Manage Proposal Template','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3803,0,'en','permissions','change_lead_status','Change Lead Status','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3804,0,'en','permissions','add_lead_note','Add Lead Note','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3805,0,'en','permissions','view_lead_note','View Lead Note','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3806,0,'en','permissions','edit_lead_note','Edit Lead Note','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3807,0,'en','permissions','delete_lead_note','Delete Lead Note','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3808,0,'en','permissions','manage_lead_status','Manage Lead Status','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3809,0,'en','permissions','add_holiday','Add Holiday','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3810,0,'en','permissions','view_holiday','View Holiday','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3811,0,'en','permissions','edit_holiday','Edit Holiday','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3812,0,'en','permissions','delete_holiday','Delete Holiday','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3813,0,'en','permissions','add_product','Add Product','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3814,0,'en','permissions','view_product','View Product','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3815,0,'en','permissions','edit_product','Edit Product','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3816,0,'en','permissions','delete_product','Delete Product','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3817,0,'en','permissions','manage_product_category','Manage Product Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3818,0,'en','permissions','manage_product_sub_category','Manage Product Sub Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3819,0,'en','permissions','add_expenses','Add Expenses','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3820,0,'en','permissions','view_expenses','View Expenses','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3821,0,'en','permissions','edit_expenses','Edit Expenses','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3822,0,'en','permissions','delete_expenses','Delete Expenses','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3823,0,'en','permissions','manage_expense_category','Manage Expense Category','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3824,0,'en','permissions','manage_recurring_expense','Manage Recurring Expense','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3825,0,'en','permissions','approve_expenses','Approve Expenses','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3826,0,'en','permissions','link_expense_bank_account','Link Expense Bank Account','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3827,0,'en','permissions','add_contract','Add Contract','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3828,0,'en','permissions','view_contract','View Contract','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3829,0,'en','permissions','edit_contract','Edit Contract','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3830,0,'en','permissions','delete_contract','Delete Contract','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3831,0,'en','permissions','manage_contract_type','Manage Contract Type','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3832,0,'en','permissions','renew_contract','Renew Contract','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3833,0,'en','permissions','add_contract_discussion','Add Contract Discussion','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3834,0,'en','permissions','edit_contract_discussion','Edit Contract Discussion','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3835,0,'en','permissions','view_contract_discussion','View Contract Discussion','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3836,0,'en','permissions','delete_contract_discussion','Delete Contract Discussion','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3837,0,'en','permissions','add_contract_files','Add Contract Files','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3838,0,'en','permissions','view_contract_files','View Contract Files','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3839,0,'en','permissions','delete_contract_files','Delete Contract Files','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3840,0,'en','permissions','manage_contract_template','Manage Contract Template','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3841,0,'en','permissions','view_task_report','View Task Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3842,0,'en','permissions','view_time_log_report','View Time Log Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3843,0,'en','permissions','view_finance_report','View Finance Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3844,0,'en','permissions','view_income_expense_report','View Income Vs Expense Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3845,0,'en','permissions','view_leave_report','View Leave Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3846,0,'en','permissions','view_attendance_report','View Attendance Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3847,0,'en','permissions','view_expense_report','View Expense Report','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3848,0,'en','permissions','manage_company_setting','Manage Company Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3849,0,'en','permissions','manage_app_setting','Manage App Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3850,0,'en','permissions','manage_notification_setting','Manage Notification Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3851,0,'en','permissions','manage_currency_setting','Manage Currency Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3852,0,'en','permissions','manage_payment_setting','Manage Payment Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3853,0,'en','permissions','manage_finance_setting','Manage Finance Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3854,0,'en','permissions','manage_ticket_setting','Manage Ticket Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3855,0,'en','permissions','manage_project_setting','Manage Project Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3856,0,'en','permissions','manage_attendance_setting','Manage Attendance Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3857,0,'en','permissions','manage_leave_setting','Manage Leave Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3858,0,'en','permissions','manage_custom_field_setting','Manage Custom Field Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3859,0,'en','permissions','manage_message_setting','Manage Message Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3860,0,'en','permissions','manage_storage_setting','Manage Storage Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3861,0,'en','permissions','manage_language_setting','Manage Language Setting','2023-05-30 17:20:13','2023-06-04 06:42:02'),
(3862,0,'en','permissions','manage_lead_setting','Manage Lead Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3863,0,'en','permissions','manage_time_log_setting','Manage Time Log Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3864,0,'en','permissions','manage_task_setting','Manage Task Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3865,0,'en','permissions','manage_social_login_setting','Manage Social Login Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3866,0,'en','permissions','manage_security_setting','Manage Security Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3867,0,'en','permissions','manage_gdpr_setting','Manage Gdpr Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3868,0,'en','permissions','manage_theme_setting','Manage Theme Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3869,0,'en','permissions','manage_role_permission_setting','Manage Role Permission Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3870,0,'en','permissions','manage_module_setting','Manage Module Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3871,0,'en','permissions','manage_google_calendar_setting','Manage Google Calendar Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3872,0,'en','permissions','view_overview_dashboard','View Overview Dashboard','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3873,0,'en','permissions','view_project_dashboard','View Project Dashboard','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3874,0,'en','permissions','view_client_dashboard','View Client Dashboard','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3875,0,'en','permissions','view_hr_dashboard','View Hr Dashboard','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3876,0,'en','permissions','view_ticket_dashboard','View Ticket Dashboard','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3877,0,'en','permissions','view_finance_dashboard','View Finance Dashboard','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3878,0,'en','permissions','add_order','Add Order','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3879,0,'en','permissions','view_order','View Order','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3880,0,'en','permissions','edit_order','Edit Order','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3881,0,'en','permissions','delete_order','Delete Order','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3882,0,'en','permissions','add_knowledgebase','Add Knowledgebase','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3883,0,'en','permissions','view_knowledgebase','View Knowledgebase','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3884,0,'en','permissions','edit_knowledgebase','Edit Knowledgebase','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3885,0,'en','permissions','delete_knowledgebase','Delete Knowledgebase','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3886,0,'en','permissions','add_bankaccount','Add Bankaccount','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3887,0,'en','permissions','view_bankaccount','View Bankaccount','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3888,0,'en','permissions','edit_bankaccount','Edit Bankaccount','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3889,0,'en','permissions','delete_bankaccount','Delete Bankaccount','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3890,0,'en','permissions','add_bank_transfer','Add Bank Transfer','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3891,0,'en','permissions','add_bank_deposit','Add Bank Deposit','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3892,0,'en','permissions','add_bank_withdraw','Add Bank Withdraw','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3893,0,'en','permissions','view_lead_report','View Lead Report','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3894,0,'en','permissions','manage_ticket_groups','Manage Ticket Groups','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3895,0,'en','permissions','add_asset','Add Asset','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3896,0,'en','permissions','view_asset','View Asset','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3897,0,'en','permissions','edit_asset','Edit Asset','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3898,0,'en','permissions','delete_asset','Delete Asset','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3899,0,'en','permissions','add_zoom_meetings','Add Meetings','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3900,0,'en','permissions','view_zoom_meetings','View Meetings','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3901,0,'en','permissions','edit_zoom_meetings','Edit Meetings','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3902,0,'en','permissions','delete_zoom_meetings','Delete Meetings','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3903,0,'en','permissions','add_assets_type','Add Assets Type','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3904,0,'en','permissions','edit_assets_type','Edit Assets Type','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3905,0,'en','permissions','view_assets_type','View Assets Type','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3906,0,'en','permissions','delete_assets_type','Delete Assets Type','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3907,0,'en','permissions','edit_assets_history','Edit Assets History','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3908,0,'en','permissions','delete_assets_history','Delete Assets History','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3909,0,'en','permissions','view_assets_history','View Assets History','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3910,0,'en','permissions','manage_zoom_category','Manage Zoom category','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3911,0,'en','permissions','manage_test_push_notification','Manage Test Push Notification','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3912,0,'en','permissions','manage_rest_api_settings','Manage Rest Api Settings','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3913,0,'en','permissions','manage_sms_settings','Manage Sms Settings','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3914,0,'en','permissions','manage_contract_setting','Manage Contract Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3915,0,'en','permissions','manage_custom_link_setting','Manage Custom Link Setting','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3916,0,'en','placeholders','knowledgeBase','Update your profile picture','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3917,0,'en','placeholders','writeshortcode','Project unique short code','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3918,0,'en','placeholders','taskshortcode','Task unique short code','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3919,0,'en','placeholders','name','e.g. John Doe','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3920,0,'en','placeholders','email','e.g. johndoe@example.com','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3921,0,'en','placeholders','mobile','e.g. 1234567890','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3922,0,'en','placeholders','password','Must have at least 8 characters','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3923,0,'en','placeholders','designation','e.g. Team Lead','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3924,0,'en','placeholders','department','e.g. Human Resource','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3925,0,'en','placeholders','date','Select Date','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3926,0,'en','placeholders','address','e.g. 132, My Street, Kingston, New York 12401','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3927,0,'en','placeholders','skills','e.g. communication, ReactJS','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3928,0,'en','placeholders','project','Write a project name','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3929,0,'en','placeholders','price','e.g. 10000','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3930,0,'en','placeholders','hours','e.g. 10:00 AM','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3931,0,'en','placeholders','category','Enter a category name','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3932,0,'en','placeholders','task','Enter a task title','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3933,0,'en','placeholders','label','Enter a label title','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3934,0,'en','placeholders','leaveType','E.g. Sick, Casual','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3935,0,'en','placeholders','colorPicker','Select a color','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3936,0,'en','placeholders','ticketType','e.g. Support','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3937,0,'en','placeholders','milestone','Enter milestone title','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3938,0,'en','placeholders','milestoneSummary','Enter milestone summary','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3939,0,'en','placeholders','sampleText','e.g. This is sample text','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3940,0,'en','placeholders','webhook','e.g. samplewebhook123','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3941,0,'en','placeholders','key','e.g. 0f99088a2f31e70daxxxx','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3942,0,'en','placeholders','secret','e.g. cbabcd0948aed7dd9xxxx','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3943,0,'en','placeholders','id','e.g. 1275901','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3944,0,'en','placeholders','cluster','e.g. ap2','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3945,0,'en','placeholders','note','Enter note title','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3946,0,'en','placeholders','consent','Enter consent name','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3947,0,'en','placeholders','consentDescription','Briefly describe the purpose on consent','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3948,0,'en','placeholders','title','e.g. Manager','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3949,0,'en','placeholders','linkTitle','Link Title','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3950,0,'en','placeholders','url','URL','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3951,0,'en','placeholders','categoryName','e.g. Finance','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3952,0,'en','placeholders','invoices.invoicePrefix','Enter invoice prefix','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3953,0,'en','placeholders','invoices.estimatePrefix','Enter estimate prefix','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3954,0,'en','placeholders','invoices.creditNotePrefix','Enter credit note prefix','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3955,0,'en','placeholders','invoices.contractNumber','Enter contract number','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3956,0,'en','placeholders','invoices.gstNumber','Enter Tax Number','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3957,0,'en','placeholders','invoices.invoiceTerms','Enter invoice terms','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3958,0,'en','placeholders','invoices.description','Enter Description (optional)','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3959,0,'en','placeholders','invoices.note','e.g. Thank you for your business','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3960,0,'en','placeholders','invoices.terms','Include your return and cancellation policy','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3961,0,'en','placeholders','invoices.invoiceNumberSeparator','Invoice Number Separator','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3962,0,'en','placeholders','invoices.estimateNumberSeparator','Estimate Number Separator','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3963,0,'en','placeholders','invoices.credit_noteNumberSeparator','Credit Note Number Separator','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3964,0,'en','placeholders','invoices.contractNumberSeparator','Contract Number Separator','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3965,0,'en','placeholders','invoices.contractPrefix','Contract Prefix','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3966,0,'en','placeholders','currency.currencyName','e.g. Dollar','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3967,0,'en','placeholders','currency.currencySymbol','e.g. $','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3968,0,'en','placeholders','currency.currencyCode','e.g. USD','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3969,0,'en','placeholders','currency.thousandSeparator','e.g. ,','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3970,0,'en','placeholders','currency.decimalSeparator','e.g. .','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3971,0,'en','placeholders','ticket.replyTicket','Enter template heading','2023-05-30 17:20:14','2023-06-04 06:42:02'),
(3972,0,'en','placeholders','ticket.templateText','Enter template text here','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3973,0,'en','placeholders','columnName','e.g. Pending','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3974,0,'en','placeholders','message','Write your message here','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3975,0,'en','placeholders','payments.remark','Enter summary of the payment.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3976,0,'en','placeholders','payments.transactionId','Enter transaction ID of the payment','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3977,0,'en','placeholders','payments.paymentGateway','e.g. PayPal, Stripe, Bank Transfer, Cash etc.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3978,0,'en','placeholders','expense.item','e.g. Wireless Keyboard','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3979,0,'en','placeholders','expense.vendor','e.g. Acme Corporation','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3980,0,'en','placeholders','status','e.g. In Progress','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3981,0,'en','placeholders','timelog.memo','e.g. Working on new logo','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3982,0,'en','placeholders','noticeTitle','e.g. New year celebrations at office.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3983,0,'en','placeholders','search','Enter keyword to search','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3984,0,'en','placeholders','attendance.workFrom','e.g. Office, Home, etc.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3985,0,'en','placeholders','dateRange','Start Date To End Date','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3986,0,'en','placeholders','emailDomain','e.g. gmail.com','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3987,0,'en','placeholders','slackWebhook','e.g. https://hooks.slack.com/services/XXXXXXXXXXXXXXXXXXXX','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3988,0,'en','placeholders','gdpr.additionDescription','Enter Additional Description','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3989,0,'en','placeholders','productName','e.g. Web Hosting, Laptop, Notebook, Mobile App etc.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3990,0,'en','placeholders','leave.reason','e.g. Feeling not well','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3991,0,'en','placeholders','company','e.g. Acme Corporation','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3992,0,'en','placeholders','storageSetting.awsKey','e.g. AKIAXXXXX67FNYNM2P','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3993,0,'en','placeholders','storageSetting.awsBucket','e.g. test-bucket','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3994,0,'en','placeholders','hsnSac','e.g. 995431','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3995,0,'en','placeholders','hourEstimate','e.g. 500','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3996,0,'en','placeholders','paymentGateway.sandboxPaypalClientId','e.g. AW-Ydt5KHz2FwhAikHsObpRrpB55qE8MyvUkHbQsFb_6_2Unv3WNBSmBxEqA8N74JzOaFTPBUI-MG4sB','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3997,0,'en','placeholders','paymentGateway.livePaypalClientId','e.g. AW-Ydt5KHz2FwhAikHsObpRrpB55qE8MyvUkHbQsFb_6_2Unv3WNBSmBxEqA8N74JzOaFTPBUI-MG4sB','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3998,0,'en','placeholders','paymentGateway.testStripePublishableKey','e.g. sk_test_XXXXXXXXXXxBXnjBe1d6G5reXbGAc8a1qumQN0doumYbhb2tChV6qTCuFfvQyxEDInYho7jhQoR4MqNBWcafRYPCb00r2jkEBKe','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(3999,0,'en','placeholders','paymentGateway.liveStripePublishableKey','e.g. sk_live_51GbndSLM4xBXnjBe1d6G5reXbGAc8a1qumQN0doumYbhb2tChV6qTCuFfvQyxEDInYho7jhQoR4MqNBWcafRYPCbXXXXXXXXX','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4000,0,'en','placeholders','paymentGateway.testRazorpayKey','e.g. rzp_test_znKZOLXXT3XXEX','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4001,0,'en','placeholders','paymentGateway.liveRazorpayKey','e.g. rzp_live_znKZOLn4TXXXXX','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4002,0,'en','placeholders','paymentGateway.paystackKey','e.g. pk_live_XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4003,0,'en','placeholders','paymentGateway.flutterwaveKey','e.g. FLWPUBK-xxxxxxxxxxxxxxxxxxxxx-X','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4004,0,'en','placeholders','bankaccount.accountName','e.g. John Doe','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4005,0,'en','placeholders','bankaccount.bankName','e.g. Federal Bank','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4006,0,'en','placeholders','bankaccount.accountNumber','e.g. 123456789','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4007,0,'en','placeholders','renterPassword','Please enter your password','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4008,0,'en','placeholders','city','e.g. New York, Jaipur, Dubai','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4009,0,'en','placeholders','location','Enter a location','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4010,0,'en','placeholders','website','e.g. https://www.example.com','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4011,0,'en','placeholders','relationship','e.g. father','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4012,0,'en','placeholders','shiftName','e.g. Night Shift','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4013,0,'en','placeholders','shiftShortCode','e.g. NS','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4014,0,'en','placeholders','appreciation.title','e.g. Employee of the month','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4015,0,'en','placeholders','select2Min','Please enter 2 or more characters','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4016,0,'en','placeholders','searchForProjects','Search for projects','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4017,0,'en','placeholders','min','Min','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4018,0,'en','placeholders','max','Max','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4019,0,'en','validation','accepted','The :attribute must be accepted.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4020,0,'en','validation','accepted_if','The :attribute field must be accepted when :other is :value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4021,0,'en','validation','active_url','The :attribute is not a valid URL.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4022,0,'en','validation','after','The :attribute must be a date after :date.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4023,0,'en','validation','after_or_equal','The :attribute must be a date after or equal to :date.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4024,0,'en','validation','alpha','The :attribute may only contain letters.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4025,0,'en','validation','alpha_dash','The :attribute may only contain letters, numbers, and dashes.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4026,0,'en','validation','alpha_num','The :attribute may only contain letters and numbers.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4027,0,'en','validation','array','The :attribute must be an array.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4028,0,'en','validation','ascii','The :attribute field must only contain single-byte alphanumeric characters and symbols.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4029,0,'en','validation','before','The :attribute must be a date before :date.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4030,0,'en','validation','before_or_equal','The :attribute must be a date before or equal to :date.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4031,0,'en','validation','between.array','The :attribute must have between :min and :max items.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4032,0,'en','validation','between.file','The :attribute must be between :min and :max kilobytes.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4033,0,'en','validation','between.numeric','The :attribute must be between :min and :max.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4034,0,'en','validation','between.string','The :attribute must be between :min and :max characters.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4035,0,'en','validation','boolean','The :attribute field must be true or false.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4036,0,'en','validation','confirmed','The :attribute confirmation does not match.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4037,0,'en','validation','current_password','The password is incorrect.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4038,0,'en','validation','date','The :attribute is not a valid date.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4039,0,'en','validation','date_equals','The :attribute field must be a date equal to :date.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4040,0,'en','validation','date_format','The :attribute does not match the format :format.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4041,0,'en','validation','decimal','The :attribute field must have :decimal decimal places.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4042,0,'en','validation','declined','The :attribute field must be declined.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4043,0,'en','validation','declined_if','The :attribute field must be declined when :other is :value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4044,0,'en','validation','different','The :attribute and :other must be different.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4045,0,'en','validation','digits','The :attribute must be :digits digits.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4046,0,'en','validation','digits_between','The :attribute must be between :min and :max digits.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4047,0,'en','validation','dimensions','The :attribute has invalid image dimensions.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4048,0,'en','validation','distinct','The :attribute field has a duplicate value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4049,0,'en','validation','doesnt_end_with','The :attribute field must not end with one of the following: :values.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4050,0,'en','validation','doesnt_start_with','The :attribute field must not start with one of the following: :values.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4051,0,'en','validation','email','The :attribute must be a valid email address.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4052,0,'en','validation','ends_with','The :attribute field must end with one of the following: :values.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4053,0,'en','validation','enum','The selected :attribute is invalid.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4054,0,'en','validation','exists','The selected :attribute is invalid.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4055,0,'en','validation','file','The :attribute must be a file.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4056,0,'en','validation','filled','The :attribute field must have a value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4057,0,'en','validation','gt.array','The :attribute field must have more than :value items.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4058,0,'en','validation','gt.file','The :attribute field must be greater than :value kilobytes.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4059,0,'en','validation','gt.numeric','The :attribute field must be greater than :value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4060,0,'en','validation','gt.string','The :attribute field must be greater than :value characters.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4061,0,'en','validation','gte.array','The :attribute field must have :value items or more.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4062,0,'en','validation','gte.file','The :attribute field must be greater than or equal to :value kilobytes.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4063,0,'en','validation','gte.numeric','The :attribute field must be greater than or equal to :value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4064,0,'en','validation','gte.string','The :attribute field must be greater than or equal to :value characters.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4065,0,'en','validation','image','The :attribute must be an image.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4066,0,'en','validation','in','The selected :attribute is invalid.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4067,0,'en','validation','in_array','The :attribute field does not exist in :other.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4068,0,'en','validation','integer','The :attribute must be an integer.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4069,0,'en','validation','ip','The :attribute must be a valid IP address.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4070,0,'en','validation','ipv4','The :attribute field must be a valid IPv4 address.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4071,0,'en','validation','ipv6','The :attribute field must be a valid IPv6 address.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4072,0,'en','validation','json','The :attribute must be a valid JSON string.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4073,0,'en','validation','lowercase','The :attribute field must be lowercase.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4074,0,'en','validation','lt.array','The :attribute field must have less than :value items.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4075,0,'en','validation','lt.file','The :attribute field must be less than :value kilobytes.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4076,0,'en','validation','lt.numeric','The :attribute field must be less than :value.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4077,0,'en','validation','lt.string','The :attribute field must be less than :value characters.','2023-05-30 17:20:15','2023-06-04 06:42:02'),
(4078,0,'en','validation','lte.array','The :attribute field must not have more than :value items.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4079,0,'en','validation','lte.file','The :attribute field must be less than or equal to :value kilobytes.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4080,0,'en','validation','lte.numeric','The :attribute field must be less than or equal to :value.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4081,0,'en','validation','lte.string','The :attribute field must be less than or equal to :value characters.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4082,0,'en','validation','mac_address','The :attribute field must be a valid MAC address.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4083,0,'en','validation','max.array','The :attribute may not have more than :max items.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4084,0,'en','validation','max.file','The :attribute may not be greater than :max kilobytes.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4085,0,'en','validation','max.numeric','The :attribute may not be greater than :max.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4086,0,'en','validation','max.string','The :attribute may not be greater than :max characters.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4087,0,'en','validation','max_digits','The :attribute field must not have more than :max digits.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4088,0,'en','validation','mimes','The :attribute must be a file of type: :values.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4089,0,'en','validation','mimetypes','The :attribute must be a file of type: :values.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4090,0,'en','validation','min.array','The :attribute must have at least :min items.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4091,0,'en','validation','min.file','The :attribute must be at least :min kilobytes.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4092,0,'en','validation','min.numeric','The :attribute must be at least :min.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4093,0,'en','validation','min.string','The :attribute must be at least :min characters.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4094,0,'en','validation','min_digits','The :attribute field must have at least :min digits.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4095,0,'en','validation','missing','The :attribute field must be missing.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4096,0,'en','validation','missing_if','The :attribute field must be missing when :other is :value.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4097,0,'en','validation','missing_unless','The :attribute field must be missing unless :other is :value.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4098,0,'en','validation','missing_with','The :attribute field must be missing when :values is present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4099,0,'en','validation','missing_with_all','The :attribute field must be missing when :values are present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4100,0,'en','validation','multiple_of','The :attribute field must be a multiple of :value.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4101,0,'en','validation','not_in','The selected :attribute is invalid.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4102,0,'en','validation','not_regex','The :attribute field format is invalid.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4103,0,'en','validation','numeric','The :attribute must be a number.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4104,0,'en','validation','password.letters','The :attribute field must contain at least one letter.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4105,0,'en','validation','password.mixed','The :attribute field must contain at least one uppercase and one lowercase letter.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4106,0,'en','validation','password.numbers','The :attribute field must contain at least one number.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4107,0,'en','validation','password.symbols','The :attribute field must contain at least one symbol.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4108,0,'en','validation','password.uncompromised','The given :attribute has appeared in a data leak. Please choose a different :attribute.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4109,0,'en','validation','present','The :attribute field must be present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4110,0,'en','validation','prohibited','The :attribute field is prohibited.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4111,0,'en','validation','prohibited_if','The :attribute field is prohibited when :other is :value.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4112,0,'en','validation','prohibited_unless','The :attribute field is prohibited unless :other is in :values.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4113,0,'en','validation','prohibits','The :attribute field prohibits :other from being present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4114,0,'en','validation','regex','The :attribute format is invalid.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4115,0,'en','validation','required','The :attribute field is required.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4116,0,'en','validation','required_array_keys','The :attribute field must contain entries for: :values.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4117,0,'en','validation','required_if','The :attribute field is required when :other is :value.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4118,0,'en','validation','required_if_accepted','The :attribute field is required when :other is accepted.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4119,0,'en','validation','required_unless','The :attribute field is required unless :other is in :values.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4120,0,'en','validation','required_with','The :attribute field is required when :values is present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4121,0,'en','validation','required_with_all','The :attribute field is required when :values is present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4122,0,'en','validation','required_without','The :attribute field is required when :values is not present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4123,0,'en','validation','required_without_all','The :attribute field is required when none of :values are present.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4124,0,'en','validation','same','The :attribute and :other must match.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4125,0,'en','validation','size.array','The :attribute must contain :size items.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4126,0,'en','validation','size.file','The :attribute must be :size kilobytes.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4127,0,'en','validation','size.numeric','The :attribute must be :size.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4128,0,'en','validation','size.string','The :attribute must be :size characters.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4129,0,'en','validation','starts_with','The :attribute field must start with one of the following: :values.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4130,0,'en','validation','string','The :attribute must be a string.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4131,0,'en','validation','timezone','The :attribute must be a valid zone.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4132,0,'en','validation','unique','The :attribute has already been taken.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4133,0,'en','validation','uploaded','The :attribute failed to upload.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4134,0,'en','validation','uppercase','The :attribute field must be uppercase.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4135,0,'en','validation','url','The :attribute format is invalid.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4136,0,'en','validation','ulid','The :attribute field must be a valid ULID.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4137,0,'en','validation','uuid','The :attribute field must be a valid UUID.','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4138,0,'en','validation','custom.attribute-name.rule-name','custom-message','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4139,0,'en','validation','attributes.client_name','client name','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4140,0,'en','validation','attributes.client_email','client email','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4141,0,'en','validation','attributes.website','website','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4142,0,'en','validation','attributes.name','name','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4143,0,'en','validation','attributes.email','email','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4144,0,'en','validation','attributes.password','password','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4145,0,'en','validation','attributes.country','country','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4146,0,'en','validation','attributes.mobile','mobile','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4147,0,'en','validation','attributes.category_name','category name','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4148,0,'en','validation','attributes.title','title','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4149,0,'en','validation','attributes.details','details','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4150,0,'en','validation','attributes.user_id','employee','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4151,0,'en','validation','attributes.category_id','category id','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4152,0,'en','validation','attributes.file','file','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4153,0,'en','validation','attributes.contact_name','contact name','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4154,0,'en','validation','attributes.import_file','import file','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4155,0,'en','validation','attributes.remind_time','remind time','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4156,0,'en','validation','attributes.next_follow_up_date','next follow up date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4157,0,'en','validation','attributes.employee_id','employee id','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4158,0,'en','validation','attributes.department','department','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4159,0,'en','validation','attributes.designation','designation','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4160,0,'en','validation','attributes.hourly_rate','hourly rate','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4161,0,'en','validation','attributes.joining_date','joining date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4162,0,'en','validation','attributes.last_date','last date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4163,0,'en','validation','attributes.date_of_birth','date of birth','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4164,0,'en','validation','attributes.probation_end_date','probation end date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4165,0,'en','validation','attributes.notice_period_start_date','notice period start date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4166,0,'en','validation','attributes.notice_period_end_date','notice period end date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4167,0,'en','validation','attributes.internship_end_date','internship end date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4168,0,'en','validation','attributes.contract_end_date','contract end date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4169,0,'en','validation','attributes.relationship','relationship','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4170,0,'en','validation','attributes.award','award','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4171,0,'en','validation','attributes.given_to','given to','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4172,0,'en','validation','attributes.award_date','award date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4173,0,'en','validation','attributes.multi_date','multi date','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4174,0,'en','validation','attributes.year','year','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4175,0,'en','validation','attributes.month','month','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4176,0,'en','validation','attributes.office_start_time','office start time','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4177,0,'en','validation','attributes.office_end_time','office end time','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4178,0,'en','validation','attributes.shift_short_code','shift short code','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4179,0,'en','validation','attributes.color','color','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4180,0,'en','validation','attributes.late_mark_duration','late mark duration','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4181,0,'en','validation','attributes.clockin_in_day','clock in day','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4182,0,'en','validation','attributes.office_open_days','office open days','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4183,0,'en','validation','attributes.clock_in_time','clock in time','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4184,0,'en','validation','attributes.clock_out_time','clock out time','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4185,0,'en','validation','attributes.working_from','working from','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4186,0,'en','validation','attributes.clock_in_ip','clock in ip','2023-05-30 17:20:16','2023-06-04 06:42:02'),
(4187,0,'en','validation','attributes.clock_out_ip','clock out ip','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4188,0,'en','validation','attributes.designation_name','designation name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4189,0,'en','validation','attributes.team_name','team name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4190,0,'en','validation','attributes.client_id','client id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4191,0,'en','validation','attributes.subject','subject','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4192,0,'en','validation','attributes.amount','amount','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4193,0,'en','validation','attributes.contract_type','contract type','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4194,0,'en','validation','attributes.start_date','start date','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4195,0,'en','validation','attributes.first_name','first name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4196,0,'en','validation','attributes.last_name','last name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4197,0,'en','validation','attributes.signature','signature','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4198,0,'en','validation','attributes.image','image','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4199,0,'en','validation','attributes.comment','comment','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4200,0,'en','validation','attributes.project_name','project name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4201,0,'en','validation','attributes.hours_allocated','hours allocated','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4202,0,'en','validation','attributes.deadline','deadline','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4203,0,'en','validation','attributes.project_budget','project budget','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4204,0,'en','validation','attributes.currency_id','currency id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4205,0,'en','validation','attributes.project_id','project id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4206,0,'en','validation','attributes.milestone_title','milestone title','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4207,0,'en','validation','attributes.summary','summary','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4208,0,'en','validation','attributes.discussion_category','discussion category','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4209,0,'en','validation','attributes.description','description','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4210,0,'en','validation','attributes.priority','priority','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4211,0,'en','validation','attributes.due_date','due date','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4212,0,'en','validation','attributes.repeat_cycles','repeat cycles','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4213,0,'en','validation','attributes.dependent_task_id','dependent task id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4214,0,'en','validation','attributes.estimate_hours','estimate hours','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4215,0,'en','validation','attributes.estimate_minutes','estimate minutes','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4216,0,'en','validation','attributes.note','note','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4217,0,'en','validation','attributes.memo','memo','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4218,0,'en','validation','attributes.start_time','start time','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4219,0,'en','validation','attributes.end_time','end time','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4220,0,'en','validation','attributes.valid_till','valid till','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4221,0,'en','validation','attributes.sub_total','sub total','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4222,0,'en','validation','attributes.total','total','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4223,0,'en','validation','attributes.lead_id','lead id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4224,0,'en','validation','attributes.estimate_number','estimate number','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4225,0,'en','validation','attributes.invoice_number','invoice number','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4226,0,'en','validation','attributes.issue_date','issue date','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4227,0,'en','validation','attributes.shipping_address','shipping address','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4228,0,'en','validation','attributes.day_of_week','day of week','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4229,0,'en','validation','attributes.day_of_month','day of month','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4230,0,'en','validation','attributes.cn_number','cn number','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4231,0,'en','validation','attributes.invoice_id','invoice id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4232,0,'en','validation','attributes.item_name','item name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4233,0,'en','validation','attributes.purchase_date','purchase date','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4234,0,'en','validation','attributes.price','price','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4235,0,'en','validation','attributes.billing_cycle','billing cycle','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4236,0,'en','validation','attributes.paid_on','paid on','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4237,0,'en','validation','attributes.transaction_id','transaction id','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4238,0,'en','validation','attributes.downloadable_file','downloadable file','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4239,0,'en','validation','attributes.tax_name','tax name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4240,0,'en','validation','attributes.rate_percent','rate percent','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4241,0,'en','validation','attributes.status','status','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4242,0,'en','validation','attributes.order_date','order date','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4243,0,'en','validation','attributes.ticket_subject','ticket subject','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4244,0,'en','validation','attributes.ticket_description','ticket description','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4245,0,'en','validation','attributes.message','message','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4246,0,'en','validation','attributes.type','type','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4247,0,'en','validation','attributes.channel_name','channel name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4248,0,'en','validation','attributes.event_name','event name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4249,0,'en','validation','attributes.all_employees','all employees','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4250,0,'en','validation','attributes.where','where','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4251,0,'en','validation','attributes.event_link','event link','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4252,0,'en','validation','attributes.heading','heading','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4253,0,'en','validation','attributes.category','category','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4254,0,'en','validation','attributes.company_name','company name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4255,0,'en','validation','attributes.company_email','company email','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4256,0,'en','validation','attributes.company_phone','company phone','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4257,0,'en','validation','attributes.location','location','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4258,0,'en','validation','attributes.address','address','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4259,0,'en','validation','attributes.allowed_file_types','allowed file types','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4260,0,'en','validation','attributes.allowed_file_size','allowed file size','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4261,0,'en','validation','attributes.currency_name','currency name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4262,0,'en','validation','attributes.currency_symbol','currency symbol','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4263,0,'en','validation','attributes.usd_price','usd_price','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4264,0,'en','validation','attributes.exchange_rate','exchange rate','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4265,0,'en','validation','attributes.currency_code','currency code','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4266,0,'en','validation','attributes.invoice_prefix','invoice prefix','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4267,0,'en','validation','attributes.estimate_prefix','estimate prefix','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4268,0,'en','validation','attributes.credit_note_prefix','credit note prefix','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4269,0,'en','validation','attributes.template','template','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4270,0,'en','validation','attributes.due_after','date after','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4271,0,'en','validation','attributes.invoice_terms','invoice terms','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4272,0,'en','validation','attributes.app_name','app name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4273,0,'en','validation','attributes.code','code','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4274,0,'en','validation','attributes.search_keyword','search keyword','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4275,0,'en','validation','attributes.reply_heading','reply heading','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4276,0,'en','validation','attributes.reply_text','reply text','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4277,0,'en','validation','attributes.send_reminder','send reminder','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4278,0,'en','validation','attributes.remind_to','send reminder','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4279,0,'en','validation','attributes.remind_type','remind type','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4280,0,'en','validation','attributes.radius','radius','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4281,0,'en','validation','attributes.alert_after','alert after','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4282,0,'en','validation','attributes.monthly_report_roles','monthly report roles','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4283,0,'en','validation','attributes.type_name','type name','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4284,0,'en','validation','attributes.leave_number','leave number','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4285,0,'en','validation','attributes.monthly_limit','monthly limit','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4286,0,'en','validation','attributes.label','label','2023-05-30 17:20:17','2023-06-04 06:42:02'),
(4287,0,'en','validation','attributes.required','required','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4288,0,'en','validation','attributes.agent_name','agent name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4289,0,'en','validation','attributes.primary_color','primary color','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4290,0,'en','validation','attributes.language_name','language name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4291,0,'en','validation','attributes.language_code','language code','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4292,0,'en','validation','attributes.flag','flag','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4293,0,'en','validation','attributes.additional_description','additional description','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4294,0,'en','validation','attributes.consent_description','consent description','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4295,0,'en','validation','attributes.full_name','full name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4296,0,'en','validation','attributes.allow_email','allow email','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4297,0,'en','validation','attributes.email_domain','email domain','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4298,0,'en','validation','attributes.external_link','external link','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4299,0,'en','validation','attributes.filename','filename','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4300,0,'en','validation','attributes.task_id','task id','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4301,0,'en','validation','attributes.group_name','group name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4302,0,'en','validation','attributes.column_name','column name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4303,0,'en','validation','attributes.label_color','label color','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4304,0,'en','validation','attributes.clientName','client name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4305,0,'en','validation','attributes.city','city','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4306,0,'en','validation','attributes.state','state','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4307,0,'en','validation','attributes.line1','line1','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4308,0,'en','validation','attributes.notetext','note text','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4309,0,'en','validation','attributes.value','value','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4310,0,'en','validation','attributes.admin_id','admin id','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4311,0,'en','validation','attributes.reason','reason','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4312,0,'en','validation','attributes.leave_date','leave date','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4313,0,'en','validation','attributes.duration','duration','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4314,0,'en','validation','attributes.leave_type_id','leave type id','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4315,0,'en','validation','attributes.occassion','occasion','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4316,0,'en','validation','attributes.date','date','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4317,0,'en','validation','attributes.employee_shift_id','employee shift id','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4318,0,'en','validation','attributes.hour_of_day','hour of day','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4319,0,'en','validation','attributes.backup_after_days','backup after days','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4320,0,'en','validation','attributes.delete_backup_after_days','delete backup after days','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4321,0,'en','validation','attributes.credit_note_id','credit note id','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4322,0,'en','validation','attributes.billing_frequency','billing frequency','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4323,0,'en','validation','attributes.billing_interval','billing interval','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4324,0,'en','validation','attributes.work_from_type','work from type','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4325,0,'en','validation','attributes.label_name','label name','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4326,0,'en','validation','attributes.has_heading','has heading','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4327,0,'en','validation','attributes.effective_after','Effective After','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4328,0,'en','validation','invalidEmail','Please enter a valid email address.','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4329,0,'en','validation','invalidEmailPassword','Email and password combination is not correct.','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4330,0,'en','validation','email_domain','The :attribute must be a valid domain e.g. gmail.com','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4331,0,'en','validation','slack_webhook','The webhook format is invalid. For more information please visit this','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4332,0,'en','validation','not_custom_fields','You cannnot add the custom field with this label','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4333,0,'en','validation','givenDataInvalid','The given data was invalid.','2023-05-30 17:20:18','2023-06-04 06:42:02'),
(4334,0,'en','vendor/backup','exception_message','Exception message: :message','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4335,0,'en','vendor/backup','exception_trace','Exception trace: :trace','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4336,0,'en','vendor/backup','exception_message_title','Exception message','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4337,0,'en','vendor/backup','exception_trace_title','Exception trace','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4338,0,'en','vendor/backup','backup_failed_subject','Failed backup of :application_name','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4339,0,'en','vendor/backup','backup_failed_body','Important: An error occurred while backing up :application_name','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4340,0,'en','vendor/backup','backup_successful_subject','Successful new backup of :application_name','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4341,0,'en','vendor/backup','backup_successful_subject_title','Successful new backup!','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4342,0,'en','vendor/backup','backup_successful_body','Great news, a new backup of :application_name was successfully created on the disk named :disk_name.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4343,0,'en','vendor/backup','cleanup_failed_subject','Cleaning up the backups of :application_name failed.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4344,0,'en','vendor/backup','cleanup_failed_body','An error occurred while cleaning up the backups of :application_name','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4345,0,'en','vendor/backup','cleanup_successful_subject','Clean up of :application_name backups successful','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4346,0,'en','vendor/backup','cleanup_successful_subject_title','Clean up of backups successful!','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4347,0,'en','vendor/backup','cleanup_successful_body','The clean up of the :application_name backups on the disk named :disk_name was successful.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4348,0,'en','vendor/backup','healthy_backup_found_subject','The backups for :application_name on disk :disk_name are healthy','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4349,0,'en','vendor/backup','healthy_backup_found_subject_title','The backups for :application_name are healthy','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4350,0,'en','vendor/backup','healthy_backup_found_body','The backups for :application_name are considered healthy. Good job!','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4351,0,'en','vendor/backup','unhealthy_backup_found_subject','Important: The backups for :application_name are unhealthy','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4352,0,'en','vendor/backup','unhealthy_backup_found_subject_title','Important: The backups for :application_name are unhealthy. :problem','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4353,0,'en','vendor/backup','unhealthy_backup_found_body','The backups for :application_name on disk :disk_name are unhealthy.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4354,0,'en','vendor/backup','unhealthy_backup_found_not_reachable','The backup destination cannot be reached. :error','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4355,0,'en','vendor/backup','unhealthy_backup_found_empty','There are no backups of this application at all.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4356,0,'en','vendor/backup','unhealthy_backup_found_old','The latest backup made on :date is considered too old.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4357,0,'en','vendor/backup','unhealthy_backup_found_unknown','Sorry, an exact reason cannot be determined.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(4358,0,'en','vendor/backup','unhealthy_backup_found_full','The backups are using too much storage. Current usage is :disk_usage which is higher than the allowed limit of :disk_limit.','2023-05-30 17:20:18','2023-05-30 17:24:15'),
(17723,0,'fr','app','addUnit','Ajouter une nouvelle unité','2023-06-04 06:27:02','2023-06-04 07:35:58'),
(17724,0,'fr','app','units','Unités','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17725,0,'fr','app','check','Vérifier','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17726,0,'fr','app','true','Vrai','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17727,0,'fr','app','false','FAUX','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17728,0,'fr','app','title','Titre','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17729,0,'fr','app','note','Note','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17730,0,'fr','app','save','Sauvegarder','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17731,0,'fr','app','update','Mise à jour','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17732,0,'fr','app','timer','Minuteur','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17733,0,'fr','app','back','Retour','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17734,0,'fr','app','reset','Réinitialiser','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17735,0,'fr','app','type','Type','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17736,0,'fr','app','lateHalfday','Demi-journée, Présent (Tard)','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17737,0,'fr','app','addNew','Ajouter nouveau','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17738,0,'fr','app','edit','Modifier','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17739,0,'fr','app','defaultStatus','Statut par défaut','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17740,0,'fr','app','id','Identifiant','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17741,0,'fr','app','hierarchy','Hiérarchie','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17742,0,'fr','app','dragAndDrop','Glisser-déposer','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17743,0,'fr','app','restructure','restructurer','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17744,0,'fr','app','name','Nom','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17745,0,'fr','app','email','E-mail','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17746,0,'fr','app','overwriteAttendance','Écraser la présence','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17747,0,'fr','app','slack','Mou','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17748,0,'fr','app','emptyCart','Panier vide','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17749,0,'fr','app','pushNotification','Notification push','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17750,0,'fr','app','password','Mot de passe','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17751,0,'fr','app','confirmPassword','Confirmez le mot de passe','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17752,0,'fr','app','phone','Téléphone','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17753,0,'fr','app','mobile','Mobile','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17754,0,'fr','app','createdAt','Créé','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17755,0,'fr','app','addedBy','Ajouté par','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17756,0,'fr','app','action','Action','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17757,0,'fr','app','search','Recherche','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17758,0,'fr','app','markRead','Marquer comme lu','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17759,0,'fr','app','deadline','Date limite','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17760,0,'fr','app','project','Projet','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17761,0,'fr','app','projectName','nom du projet','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17762,0,'fr','app','projects','Projets','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17763,0,'fr','app','completion','Achèvement','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17764,0,'fr','app','address','Adresse','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17765,0,'fr','app','completed','Complété','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17766,0,'fr','app','failed','Échoué','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17767,0,'fr','app','dueDate','Date d\'échéance','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17768,0,'fr','app','status','Statut','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17769,0,'fr','app','selectStatus','Sélectionnez le statut','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17770,0,'fr','app','task','Tâche','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17771,0,'fr','app','tasks','Tâches','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17772,0,'fr','app','client','Client','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17773,0,'fr','app','stop','Arrêt','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17774,0,'fr','app','remove','Retirer','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17775,0,'fr','app','description','Description','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17776,0,'fr','app','incomplete','Incomplet','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17777,0,'fr','app','invoice','Facture','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17778,0,'fr','app','date','Date','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17779,0,'fr','app','apply','Appliquer','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17780,0,'fr','app','change','Changement','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17781,0,'fr','app','employeeId','Identifiant de l\'employé','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17782,0,'fr','app','logout','Se déconnecter','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17783,0,'fr','app','active','Actif','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17784,0,'fr','app','clientName','Nom du client','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17785,0,'fr','app','lead','Mener','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17786,0,'fr','app','paymentOn','Paiement le','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17787,0,'fr','app','amount','Montant','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17788,0,'fr','app','gateway','passerelle','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17789,0,'fr','app','transactionId','Identifiant de transaction','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17790,0,'fr','app','timeLog','Journal de temps','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17791,0,'fr','app','time log','Journal de temps','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17792,0,'fr','app','selectTask','Sélectionnez la tâche','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17793,0,'fr','app','category','Catégorie','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17794,0,'fr','app','panel','Panneau','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17795,0,'fr','app','credit-note','Note de crédit','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17796,0,'fr','app','addCreditNote','Ajouter une note de crédit','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17797,0,'fr','app','mr','M','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17798,0,'fr','app','mrs','Mme','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17799,0,'fr','app','miss','Manquer','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17800,0,'fr','app','dr','Dr.','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17801,0,'fr','app','sir','Monsieur','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17802,0,'fr','app','madam','Madame','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17803,0,'fr','app','invoiceGenerate','Facture générée','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17804,0,'fr','app','leave','Partir','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17805,0,'fr','app','holiday','Jours fériés ( :name)','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17806,0,'fr','app','inProcess','En cours','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17807,0,'fr','app','overdue','En retard','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17808,0,'fr','app','clockInAt','Horloge à','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17809,0,'fr','app','clockin','Horloge d\'entrée','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17810,0,'fr','app','clockout','Horloge','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17811,0,'fr','app','attendanceof','Feuille de présence de','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17812,0,'fr','app','paypal','Pay Pal','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17813,0,'fr','app','stripe','Bande','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17814,0,'fr','app','razorpay','Razorpay','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17815,0,'fr','app','paystack','Pile de paie','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17816,0,'fr','app','mollie','Mollie','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17817,0,'fr','app','payfast','Paiement rapide','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17818,0,'fr','app','authorize','Autoriser.net','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17819,0,'fr','app','square','Carré','2023-06-04 06:27:03','2023-06-04 07:35:58'),
(17820,0,'fr','app','flutterwave','Flutterwave','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17821,0,'fr','app','offline','Hors ligne','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17822,0,'fr','app','lastTweleveMonths','12 derniers mois','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17823,0,'fr','app','googleMap','Google Map','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17824,0,'fr','app','fullTime','À temps plein','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17825,0,'fr','app','partTime','À temps partiel','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17826,0,'fr','app','onContract','Sous contrat','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17827,0,'fr','app','internship','Stage','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17828,0,'fr','app','trainee','Stagiaire','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17829,0,'fr','app','method','Méthode','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17830,0,'fr','app','passport','Passeport','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17831,0,'fr','app','visa','Visa','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17832,0,'fr','app','nationality','Nationalité','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17833,0,'fr','app','place','Lieu','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17834,0,'fr','app','months.January','Janvier','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17835,0,'fr','app','months.February','Février','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17836,0,'fr','app','months.March','Mars','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17837,0,'fr','app','months.April','Avril','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17838,0,'fr','app','months.May','Peut','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17839,0,'fr','app','months.June','Juin','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17840,0,'fr','app','months.July','Juillet','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17841,0,'fr','app','months.August','Août','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17842,0,'fr','app','months.September','Septembre','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17843,0,'fr','app','months.October','Octobre','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17844,0,'fr','app','months.November','Novembre','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17845,0,'fr','app','months.December','Décembre','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17846,0,'fr','app','menu.units','Unités','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17847,0,'fr','app','menu.prefixSettings','Paramètres de préfixe','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17848,0,'fr','app','menu.parent_id','Parent','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17849,0,'fr','app','menu.child_id','Enfant','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17850,0,'fr','app','menu.home','Menu','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17851,0,'fr','app','menu.myCalendar','Mon calendrier','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17852,0,'fr','app','menu.holiday','Jours fériés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17853,0,'fr','app','menu.dashboard','Tableau de bord','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17854,0,'fr','app','menu.knowledgebase','Base de connaissances','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17855,0,'fr','app','menu.clients','Clients','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17856,0,'fr','app','menu.employees','Employés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17857,0,'fr','app','menu.projects','Projets','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17858,0,'fr','app','menu.projectCalendar','Calendrier du projet','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17859,0,'fr','app','menu.taskCalendar','Calendrier des tâches','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17860,0,'fr','app','menu.calendar','Calendrier','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17861,0,'fr','app','menu.messages','messages','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17862,0,'fr','app','menu.customFields','Les champs personnalisés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17863,0,'fr','app','menu.Events','Événements','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17864,0,'fr','app','menu.products','Des produits','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17865,0,'fr','app','menu.orders','Ordres','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17866,0,'fr','app','menu.profileSettings','Paramètres de profil','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17867,0,'fr','app','menu.twoFactorAuthentication','Authentification à deux facteurs','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17868,0,'fr','app','menu.attendanceSettings','Paramètres de présence','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17869,0,'fr','app','menu.currencySettings','Paramètres de devise','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17870,0,'fr','app','menu.emailSettings','Paramètres de messagerie','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17871,0,'fr','app','menu.employeeDocs','Documents de l\'employé','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17872,0,'fr','app','menu.clientDocs','Documents clients','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17873,0,'fr','app','menu.financeReport','Rapport financier','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17874,0,'fr','app','menu.incomeVsExpenseReport','Revenu vs Dépense','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17875,0,'fr','app','menu.invoiceSettings','Paramètres de facturation','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17876,0,'fr','app','menu.invoiceTemplate','Modèle de facture','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17877,0,'fr','app','menu.settings','Paramètres','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17878,0,'fr','app','menu.leadFiles','Fichiers de plomb','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17879,0,'fr','app','menu.leadSource','Source principale','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17880,0,'fr','app','menu.leadStatus','Statut du prospect','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17881,0,'fr','app','menu.leaveReport','Rapport de congé','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17882,0,'fr','app','menu.leaveSettings','Paramètres des congés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17883,0,'fr','app','menu.leaveTypeSettings','Paramètres de type de congés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17884,0,'fr','app','menu.leaveGeneralSettings','Quitte les paramètres généraux','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17885,0,'fr','app','menu.timeLogSettings','Paramètres du journal de temps','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17886,0,'fr','app','menu.invoices','Factures','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17887,0,'fr','app','menu.issues','Questions','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17888,0,'fr','app','menu.timeLogs','Emploi du temps','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17889,0,'fr','app','menu.tasks','Tâches','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17890,0,'fr','app','menu.attendance','Présence','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17891,0,'fr','app','menu.estimates','Estimations','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17892,0,'fr','app','menu.expenses','Dépenses','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17893,0,'fr','app','menu.leaves','Congés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17894,0,'fr','app','menu.leavesQuota','Quota de congés','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17895,0,'fr','app','menu.noticeBoard','Tableau d\'affichage','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17896,0,'fr','app','menu.notes','Remarques','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17897,0,'fr','app','menu.notices','Avis','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17898,0,'fr','app','menu.payments','Paiements','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17899,0,'fr','app','menu.rolesPermission','Rôles et autorisations','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17900,0,'fr','app','menu.stickyNotes','Notes autocollantes','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17901,0,'fr','app','menu.teams','Département','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17902,0,'fr','app','menu.tickets','Ticket d\'assistance','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17903,0,'fr','app','menu.ticket','Ticket','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17904,0,'fr','app','menu.messageSettings','Paramètres des messages','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17905,0,'fr','app','menu.reports','Rapports','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17906,0,'fr','app','menu.taskReport','Rapport de tâche','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17907,0,'fr','app','menu.timeLogReport','Rapport de journal de temps','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17908,0,'fr','app','menu.timeSettings','Paramètres de temps','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17909,0,'fr','app','menu.accountSettings','Paramètres de l\'entreprise','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17910,0,'fr','app','menu.moduleSettings','Paramètres des modules','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17911,0,'fr','app','menu.moduleSettingsInstall','Installation/Mise à jour des modules','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17912,0,'fr','app','menu.contacts','Contacts','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17913,0,'fr','app','menu.paymentGatewayCredential','Identifiants de paiement','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17914,0,'fr','app','menu.projectTemplateMember','Membre du modèle de projet','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17915,0,'fr','app','menu.projectTemplate','Modèle de projet','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17916,0,'fr','app','menu.contractTemplate','Modèle de contrat','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17917,0,'fr','app','menu.projectTemplateTask','Tâche de modèle de projet','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17918,0,'fr','app','menu.pushNotifications','Notifications push','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17919,0,'fr','app','menu.slackSettings','Paramètres de marge','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17920,0,'fr','app','menu.storageSettings','Paramètres de stockage','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17921,0,'fr','app','menu.updates','Mettre à jour l\'application','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17922,0,'fr','app','menu.ticketSettings','Paramètres du ticket','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17923,0,'fr','app','menu.themeSettings','Réglage des thèmes','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17924,0,'fr','app','menu.ticketAgents','Agents de support','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17925,0,'fr','app','menu.ticketTypes','Types de tickets','2023-06-04 06:27:04','2023-06-04 07:35:58'),
(17926,0,'fr','app','menu.groupManage','Groupes de tickets','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17927,0,'fr','app','menu.group','Groupe','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17928,0,'fr','app','menu.ticketChannel','Canal de support','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17929,0,'fr','app','menu.replyTemplates','Modèles de réponse','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17930,0,'fr','app','menu.offlinePaymentMethod','Méthode de paiement hors ligne','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17931,0,'fr','app','menu.lead','Fils','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17932,0,'fr','app','menu.finance','Finance','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17933,0,'fr','app','menu.payroll','Paie','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17934,0,'fr','app','menu.employeeList','Liste des employés','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17935,0,'fr','app','menu.onlinePayment','Identifiant de paiement en ligne','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17936,0,'fr','app','menu.method','Méthode','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17937,0,'fr','app','menu.addProjectTemplate','Ajouter un modèle de projet','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17938,0,'fr','app','menu.addContractTemplate','Ajouter un modèle de contrat','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17939,0,'fr','app','menu.template','Modèle','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17940,0,'fr','app','menu.notificationSettings','Paramètres de notification','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17941,0,'fr','app','menu.viewArchive','Voir les archives','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17942,0,'fr','app','menu.clientModule','Paramètres du module client','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17943,0,'fr','app','menu.employeeModule','Paramètres du module Employé','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17944,0,'fr','app','menu.adminModule','Paramètres du module d\'administration','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17945,0,'fr','app','menu.documents','Documents','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17946,0,'fr','app','menu.attendanceReport','Rapport de présence','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17947,0,'fr','app','menu.projectSettings','Paramètres du projet','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17948,0,'fr','app','menu.financeSettings','Paramètres financiers','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17949,0,'fr','app','menu.taxSettings','Paramètres fiscaux','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17950,0,'fr','app','menu.credit-note','Note de crédit','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17951,0,'fr','app','menu.designation','Désignation','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17952,0,'fr','app','menu.help','Aider','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17953,0,'fr','app','menu.gdpr','RGPD','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17954,0,'fr','app','menu.customers','Clients','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17955,0,'fr','app','menu.sign','Signe','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17956,0,'fr','app','menu.subject','Sujet','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17957,0,'fr','app','menu.joining','Joindre','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17958,0,'fr','app','menu.attrition','Usure','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17959,0,'fr','app','menu.contracts','Contrats','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17960,0,'fr','app','menu.estimate','Estimation','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17961,0,'fr','app','menu.customLink','Lien personnalisé','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17962,0,'fr','app','menu.pusher.appId','Identifiant de l\'application','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17963,0,'fr','app','menu.pusher.appKey','Clé d\'application','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17964,0,'fr','app','menu.pusher.appSecret','Secret d\'application','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17965,0,'fr','app','menu.pusher.appCluster','Cluster d\'applications','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17966,0,'fr','app','menu.pusher.forceTLS','Forcer TLS','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17967,0,'fr','app','menu.content','Contenu','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17968,0,'fr','app','menu.decline','Déclin','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17969,0,'fr','app','menu.signed','Signé','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17970,0,'fr','app','menu.download','Télécharger','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17971,0,'fr','app','menu.applyToInvoice','Payer une facture à l\'aide d\'une note de crédit','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17972,0,'fr','app','menu.credit-notes.invoiceDate','Date de facturation','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17973,0,'fr','app','menu.credit-notes.invoiceAmount','Montant de la facture','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17974,0,'fr','app','menu.credit-notes.invoiceBalanceDue','Solde de la facture dû','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17975,0,'fr','app','menu.credit-notes.amountToCredit','Montant à créditer','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17976,0,'fr','app','menu.credit-notes.remainingAmount','Montant restant','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17977,0,'fr','app','menu.credit-notes.amountCredited','Montant crédité','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17978,0,'fr','app','menu.creditedInvoices','Factures créditées','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17979,0,'fr','app','menu.appliedCredits','Crédits appliqués','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17980,0,'fr','app','menu.ticketFiles','Fichiers de tickets','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17981,0,'fr','app','menu.file','Des dossiers','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17982,0,'fr','app','menu.addFile','Ajouter le fichier','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17983,0,'fr','app','menu.renew','Renouveler','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17984,0,'fr','app','menu.upload','Télécharger','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17985,0,'fr','app','menu.paymentReminder','Rappel de paiement','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17986,0,'fr','app','menu.leadAgent','Agent','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17987,0,'fr','app','menu.purchaseAllow','Le client peut acheter','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17988,0,'fr','app','menu.allowed','Autorisé','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17989,0,'fr','app','menu.notAllowed','Interdit','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17990,0,'fr','app','menu.purchase','Achat','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17991,0,'fr','app','menu.purchaseDate','date d\'achat','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17992,0,'fr','app','menu.product','Produit','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17993,0,'fr','app','menu.mark','Marquer','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17994,0,'fr','app','menu.exportPdf','Exporter vers PDF','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17995,0,'fr','app','menu.version','Version','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17996,0,'fr','app','menu.currentVersion','Version actuelle','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17997,0,'fr','app','menu.latestVersion','Dernière version','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17998,0,'fr','app','menu.module','Module','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(17999,0,'fr','app','menu.install','Installer','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18000,0,'fr','app','menu.verifyEnvato','Vérifier le code d\'achat','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18001,0,'fr','app','menu.copy','Copie','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18002,0,'fr','app','menu.copyAboveLink','Copier le lien ci-dessus','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18003,0,'fr','app','menu.used','Utilisé','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18004,0,'fr','app','menu.remaining','Restant','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18005,0,'fr','app','menu.adjustment','Ajustement','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18006,0,'fr','app','menu.reply','Répondre','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18007,0,'fr','app','menu.private','Privé','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18008,0,'fr','app','menu.public','Public','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18009,0,'fr','app','menu.today','Aujourd\'hui','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18010,0,'fr','app','menu.and','et','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18011,0,'fr','app','menu.selectTeam','Sélectionnez le département...','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18012,0,'fr','app','menu.previous','Précédent','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18013,0,'fr','app','menu.next','Suivant','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18014,0,'fr','app','menu.uploadNext','Télécharger et passer à l\'étape suivante','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18015,0,'fr','app','menu.projectAdmin','Administrateur de projet','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18016,0,'fr','app','menu.shippingAddress','adresse de livraison','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18017,0,'fr','app','menu.showShippingAddress','Afficher l\'adresse de livraison','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18018,0,'fr','app','menu.hideShippingAddress','Masquer l\'adresse de livraison','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18019,0,'fr','app','menu.addShippingAddress','Ajouter une adresse de livraison','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18020,0,'fr','app','menu.new','Nouveau','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18021,0,'fr','app','menu.share','Partager','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18022,0,'fr','app','menu.lastLogin','Dernière connexion à','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18023,0,'fr','app','menu.approve','Approuver','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18024,0,'fr','app','menu.hrs','heures','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18025,0,'fr','app','menu.mins','minutes','2023-06-04 06:27:05','2023-06-04 07:35:58'),
(18026,0,'fr','app','menu.receipt','Reçu','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18027,0,'fr','app','menu.callback','Rappeler','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18028,0,'fr','app','menu.socialAuthSettings.google','Google','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18029,0,'fr','app','menu.socialAuthSettings.facebook','Facebook','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18030,0,'fr','app','menu.socialAuthSettings.linkedin','Linkedin','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18031,0,'fr','app','menu.socialAuthSettings.twitter','Twitter','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18032,0,'fr','app','menu.socialAuthSettings.googleClientId','ID d\'application Google','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18033,0,'fr','app','menu.socialAuthSettings.facebookClientId','ID d\'application Facebook','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18034,0,'fr','app','menu.socialAuthSettings.twitterClientId','ID d\'application Twitter','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18035,0,'fr','app','menu.socialAuthSettings.linkedinClientId','ID d\'application Linkedin','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18036,0,'fr','app','menu.socialAuthSettings.googleSecret','Google secret','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18037,0,'fr','app','menu.socialAuthSettings.facebookSecret','Secret de Facebook','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18038,0,'fr','app','menu.socialAuthSettings.twitterSecret','Le secret de Twitter','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18039,0,'fr','app','menu.socialAuthSettings.linkedinSecret','Secret Linkedin','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18040,0,'fr','app','menu.saveSend','Enregistrer et envoyer','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18041,0,'fr','app','menu.saveDraft','Enregistrer comme brouillon','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18042,0,'fr','app','menu.send','Envoyer','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18043,0,'fr','app','menu.languageSetting','Paramètres de langue','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18044,0,'fr','app','menu.archive','Archive','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18045,0,'fr','app','menu.selectCurrency','Sélectionnez la devise','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18046,0,'fr','app','menu.currency','Monnaie','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18047,0,'fr','app','menu.draft','Brouillon','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18048,0,'fr','app','menu.label','Étiqueter','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18049,0,'fr','app','menu.labelName','Nom de l\'étiquette','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18050,0,'fr','app','menu.color','Couleur','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18051,0,'fr','app','menu.columnStatus','Statut','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18052,0,'fr','app','menu.hr','RH','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18053,0,'fr','app','menu.work','Travail','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18054,0,'fr','app','menu.contractType','Type de contrat','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18055,0,'fr','app','menu.contract','Contracter','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18056,0,'fr','app','menu.addContract','Ajouter un contrat','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18057,0,'fr','app','menu.taskFiles','Fichiers de tâche','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18058,0,'fr','app','menu.customModule','Modules personnalisés','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18059,0,'fr','app','menu.pusherSettings','Pousseur','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18060,0,'fr','app','menu.menuSetting','Paramètres des menus','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18061,0,'fr','app','menu.languageSettings','Paramètres de langue','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18062,0,'fr','app','menu.leadSettings','Paramètres des prospects','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18063,0,'fr','app','menu.taskSettings','Paramètres de tâche','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18064,0,'fr','app','menu.general','Général','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18065,0,'fr','app','menu.rightToDataPortability','Droit à la portabilité des données','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18066,0,'fr','app','menu.rightToErasure','Droit à l\'effacement','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18067,0,'fr','app','menu.rightToBeInformed','Droit d\'être informé','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18068,0,'fr','app','menu.rightOfRectification','Droit d\'accès/rectification','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18069,0,'fr','app','menu.consent','Consentement','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18070,0,'fr','app','menu.proposal','Proposition','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18071,0,'fr','app','menu.socialLogin','Paramètres de connexion sociale','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18072,0,'fr','app','menu.leads','Fils','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18073,0,'fr','app','menu.agentDashboard','Tableau de bord des agents','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18074,0,'fr','app','menu.taskLabel','Étiquettes de tâche','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18075,0,'fr','app','menu.projectDashboard','Tableau de bord du projet','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18076,0,'fr','app','menu.clientDashboard','Tableau de bord clients','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18077,0,'fr','app','menu.hrDashboard','Tableau de bord RH','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18078,0,'fr','app','menu.ticketDashboard','Tableau de bord des tickets','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18079,0,'fr','app','menu.financeDashboard','Tableau de bord des finances','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18080,0,'fr','app','menu.expensesRecurring','Dépenses récurrentes','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18081,0,'fr','app','menu.itemName','nom de l\'article','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18082,0,'fr','app','menu.appSettings','Paramètres de l\'application','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18083,0,'fr','app','menu.securitySettings','Les paramètres de sécurité','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18084,0,'fr','app','menu.projectRating','Évaluation du projet','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18085,0,'fr','app','menu.gdprSettings','Paramètres RGPD','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18086,0,'fr','app','menu.removalRequest','Demande de suppression (client)','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18087,0,'fr','app','menu.removalRequestLead','Demande de suppression (prospect)','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18088,0,'fr','app','menu.businessAddresses','Adresse d\'affaires','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18089,0,'fr','app','menu.googleCalendarSetting','Paramètres de Google Agenda','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18090,0,'fr','app','menu.databaseBackupSetting','Paramètres de sauvegarde de la base de données','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18091,0,'fr','app','menu.emailSync','Synchronisation des e-mails','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18092,0,'fr','app','menu.employeeShifts','Changements d\'employés','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18093,0,'fr','app','menu.shiftRoster','Tableau de quart','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18094,0,'fr','app','menu.department','Département','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18095,0,'fr','app','menu.expenseReport','Rapport de dépenses','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18096,0,'fr','app','menu.advanced','Avancé','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18097,0,'fr','app','menu.miroboard','Tableau Miro','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18098,0,'fr','app','menu.bankaccount','Compte bancaire','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18099,0,'fr','app','menu.award','Décerner','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18100,0,'fr','app','menu.appreciation','Appréciation','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18101,0,'fr','app','menu.consentSettings','Paramètres de consentement','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18102,0,'fr','app','menu.consentLists','Listes de consentement','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18103,0,'fr','app','menu.leadReport','Rapport sur les prospects','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18104,0,'fr','app','menu.quickBookSettings','Paramètres de QuickBooks','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18105,0,'fr','app','menu.customLinkSetting','Paramètres de lien personnalisés','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18106,0,'fr','app','menu.salesReport','Rapport des ventes','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18107,0,'fr','app','menu.addProducts','Ajouter des produits','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18108,0,'fr','app','menu.addHoliday','Ajouter un jour férié','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18109,0,'fr','app','menu.addShiftRoster','Ajouter une liste de quarts','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18110,0,'fr','app','menu.addConsent','Ajouter un consentement','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18111,0,'fr','app','menu.addReply','Ajouter une réponse','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18112,0,'fr','app','menu.addDesignation','Ajouter une désignation','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18113,0,'fr','app','menu.addTemplate','Ajouter un modèle','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18114,0,'fr','app','menu.privateDashboard','Tableau de bord privé','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18115,0,'fr','app','menu.advanceDashboard','Tableau de bord avancé','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18116,0,'fr','app','menu.contractSettings','Paramètres du contrat','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18117,0,'fr','app','menu.editDepartment','Modifier le département','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18118,0,'fr','app','menu.editdesignation','Modifier la désignation','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18119,0,'fr','app','menu.editConsent','Modifier le consentement','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18120,0,'fr','app','menu.editHoliday','Modifier les jours fériés','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18121,0,'fr','app','menu.editLeaves','Modifier les congés','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18122,0,'fr','app','menu.editProducts','Modifier les produits','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18123,0,'fr','app','menu.editEvents','Modifier les événements','2023-06-04 06:27:06','2023-06-04 07:35:58'),
(18124,0,'fr','app','menu.addBankAccount','Ajouter un compte bancaire','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18125,0,'fr','app','menu.selectProduct','Sélectionner un produit','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18126,0,'fr','app','menu.selectProductCategory','Sélectionnez la catégorie de produit','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18127,0,'fr','app','menu.listView','Affichage de liste','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18128,0,'fr','app','parentId','Parent','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18129,0,'fr','app','childId','Enfant','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18130,0,'fr','app','language','Langue','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18131,0,'fr','app','delete','Supprimer','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18132,0,'fr','app','pending','En attente','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18133,0,'fr','app','on-hold','En attente','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18134,0,'fr','app','processing','Traitement','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18135,0,'fr','app','refund','Remboursement','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18136,0,'fr','app','refunded','Remboursé','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18137,0,'fr','app','deactive','Inactif','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18138,0,'fr','app','inactive','Inactif','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18139,0,'fr','app','admin','Administrateur','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18140,0,'fr','app','employee','Employé','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18141,0,'fr','app','complete','Complet','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18142,0,'fr','app','approved','Approuvé','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18143,0,'fr','app','reject','Rejeter','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18144,0,'fr','app','preApprove','Pré-approuver','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18145,0,'fr','app','progress','Progrès','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18146,0,'fr','app','required','est requis','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18147,0,'fr','app','reason','Raison','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18148,0,'fr','app','yes','Oui','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18149,0,'fr','app','no','Non','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18150,0,'fr','app','all','Tous','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18151,0,'fr','app','exportExcel','Exporter','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18152,0,'fr','app','importExcel','Importer','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18153,0,'fr','app','columnName','Nom de colonne','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18154,0,'fr','app','datatable','//cdn.datatables.net/plug-ins/1.10.15/i18n/English.json','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18155,0,'fr','app','startDate','Date de début','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18156,0,'fr','app','endDate','Date de fin','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18157,0,'fr','app','cancel','Annuler','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18158,0,'fr','app','updateContactDetails','Mettre à jour les coordonnées','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18159,0,'fr','app','skills','Compétences','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18160,0,'fr','app','add','Ajouter','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18161,0,'fr','app','year','Année','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18162,0,'fr','app','gstIn','TPS DANS','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18163,0,'fr','app','close','Fermer','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18164,0,'fr','app','remark','Remarque','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18165,0,'fr','app','next_follow_up','Autoriser le suivi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18166,0,'fr','app','select','Sélectionner','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18167,0,'fr','app','accept','Accepter','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18168,0,'fr','app','optional','Facultatif','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18169,0,'fr','app','sampleFile','Exemple de fichier','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18170,0,'fr','app','inclusiveAllTaxes','toutes taxes comprises','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18171,0,'fr','app','team','Département','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18172,0,'fr','app','list','Liste','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18173,0,'fr','app','duration','Durée','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18174,0,'fr','app','days','Jours)','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18175,0,'fr','app','month','Mois','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18176,0,'fr','app','upcoming','A venir','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18177,0,'fr','app','disableCache','Désactiver le cache','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18178,0,'fr','app','refreshCache','Actualiser le cache','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18179,0,'fr','app','submit','Soumettre','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18180,0,'fr','app','manage','Gérer','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18181,0,'fr','app','open','Ouvert','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18182,0,'fr','app','resolved','Résolu','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18183,0,'fr','app','rememberMe','Rester connecté','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18184,0,'fr','app','forgotPassword','Mot de passe oublié?','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18185,0,'fr','app','forbiddenError','Erreur interdite','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18186,0,'fr','app','to','Pour','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18187,0,'fr','app','watchTutorial','Regarder le didacticiel','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18188,0,'fr','app','view','Voir','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18189,0,'fr','app','welcome','Bienvenue','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18190,0,'fr','app','role','Rôle d\'utilisateur','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18191,0,'fr','app','projectAdminPanel','Panneau d\'administration du projet','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18192,0,'fr','app','loginAsProjectAdmin','Se connecter en tant qu\'administrateur du projet','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18193,0,'fr','app','price','Prix','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18194,0,'fr','app','last','Dernier','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18195,0,'fr','app','income','Revenu','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18196,0,'fr','app','expense','Frais','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18197,0,'fr','app','total','Total','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18198,0,'fr','app','day','Jours)','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18199,0,'fr','app','week','Semaines)','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18200,0,'fr','app','filterBy','Filtrer par','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18201,0,'fr','app','others','Autres','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18202,0,'fr','app','value','Valeur','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18203,0,'fr','app','monday','Lundi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18204,0,'fr','app','tuesday','Mardi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18205,0,'fr','app','wednesday','Mercredi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18206,0,'fr','app','thursday','Jeudi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18207,0,'fr','app','friday','Vendredi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18208,0,'fr','app','saturday','Samedi','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18209,0,'fr','app','sunday','Dimanche','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18210,0,'fr','app','newNotifications','Nouvelles notifications','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18211,0,'fr','app','from','Depuis','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18212,0,'fr','app','low','Faible','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18213,0,'fr','app','Manage role','Gérer le rôle','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18214,0,'fr','app','Search:','Recherche:','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18215,0,'fr','app','rejected','Rejeté','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18216,0,'fr','app','selectFile','Choisir le dossier','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18217,0,'fr','app','login','Connexion','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18218,0,'fr','app','noPermission','Vous n\'êtes pas autorisé à y accéder.','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18219,0,'fr','app','recoverPassword','Récupérer mot de passe','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18220,0,'fr','app','resetPassword','réinitialiser le mot de passe','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18221,0,'fr','app','sendPasswordLink','Envoyer le lien de réinitialisation','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18222,0,'fr','app','enterEmailInstruction','Entrez votre e-mail et des instructions vous seront envoyées !','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18223,0,'fr','app','medium','Moyen','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18224,0,'fr','app','high','Haut','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18225,0,'fr','app','urgent','Urgent','2023-06-04 06:27:07','2023-06-04 07:35:58'),
(18226,0,'fr','app','male','Homme','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18227,0,'fr','app','female','Femme','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18228,0,'fr','app','source','Source','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18229,0,'fr','app','where','où','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18230,0,'fr','app','followUp','Suivi','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18231,0,'fr','app','createdOn','Créé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18232,0,'fr','app','updatedOn','Mis à jour le','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18233,0,'fr','app','notice','Avis','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18234,0,'fr','app','minutes','Minutes','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18235,0,'fr','app','onLeave','En congé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18236,0,'fr','app','present','Présent','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18237,0,'fr','app','presentlate','Présent (en retard)','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18238,0,'fr','app','enable','Activer','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18239,0,'fr','app','disable','Désactiver','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18240,0,'fr','app','absent','Absent','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18241,0,'fr','app','paid','Payé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18242,0,'fr','app','unpaid','Non payé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18243,0,'fr','app','partial','Partiel','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18244,0,'fr','app','earnings','Gains','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18245,0,'fr','app','latitude','Latitude','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18246,0,'fr','app','longitude','Longitude','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18247,0,'fr','app','generateKey','Générer la clé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18248,0,'fr','app','gstNumber','Numéro de TPS/TVA','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18249,0,'fr','app','showGst','Afficher le numéro de taxe sur la facture','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18250,0,'fr','app','showTaxCalculationMessage','Afficher le message de calcul des taxes','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18251,0,'fr','app','showProjectOnInvoice','Afficher le projet sur la facture','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18252,0,'fr','app','create','Créer','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18253,0,'fr','app','leaveStatus','Statut de congé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18254,0,'fr','app','leaveType','Type de congé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18255,0,'fr','app','leaveDate','Date de départ','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18256,0,'fr','app','thumbnail','Vignette','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18257,0,'fr','app','enableCache','Activer le cache','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18258,0,'fr','app','copied','Copié','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18259,0,'fr','app','webhook','URL du webhook','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18260,0,'fr','app','url','URL','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18261,0,'fr','app','hour','Heures)','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18262,0,'fr','app','minute','Minutes)','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18263,0,'fr','app','venue','Lieu','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18264,0,'fr','app','time','Temps','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18265,0,'fr','app','summary','Résumé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18266,0,'fr','app','estimate','Estimation','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18267,0,'fr','app','zero','Zéro','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18268,0,'fr','app','designation','Désignation','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18269,0,'fr','app','company_name','Nom de l\'entreprise','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18270,0,'fr','app','thanks','Merci','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18271,0,'fr','app','invoiceNumber','Numéro de facture','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18272,0,'fr','app','orderNumber','Numéro de commande','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18273,0,'fr','app','disabled','Désactivé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18274,0,'fr','app','enabled','Activé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18275,0,'fr','app','language_code','Code de langue','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18276,0,'fr','app','code','Code','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18277,0,'fr','app','viewInvoice','Afficher la facture associée','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18278,0,'fr','app','inProgress','En cours','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18279,0,'fr','app','onHold','En attente','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18280,0,'fr','app','notStarted','Pas commencé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18281,0,'fr','app','canceled','Annulé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18282,0,'fr','app','finished','Fini','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18283,0,'fr','app','customers','Clients','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18284,0,'fr','app','sign','Signe','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18285,0,'fr','app','subject','Sujet','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18286,0,'fr','app','joining','Joindre','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18287,0,'fr','app','attrition','Usure','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18288,0,'fr','app','contracts','Contrats','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18289,0,'fr','app','bankaccount','Compte bancaire','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18290,0,'fr','app','Changestatus','Statut du prospect','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18291,0,'fr','app','pusher.appId','Identifiant de l\'application','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18292,0,'fr','app','pusher.appKey','Clé d\'application','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18293,0,'fr','app','pusher.appSecret','Secret d\'application','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18294,0,'fr','app','pusher.appCluster','Cluster d\'applications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18295,0,'fr','app','pusher.forceTLS','Forcer TLS','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18296,0,'fr','app','content','Contenu','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18297,0,'fr','app','decline','Déclin','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18298,0,'fr','app','signed','Signé','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18299,0,'fr','app','download','Télécharger','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18300,0,'fr','app','applyToInvoice','Payer une facture à l\'aide d\'une note de crédit','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18301,0,'fr','app','credit-notes.invoiceDate','Date de facturation','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18302,0,'fr','app','credit-notes.invoiceAmount','Montant de la facture','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18303,0,'fr','app','credit-notes.invoiceBalanceDue','Solde de la facture dû','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18304,0,'fr','app','credit-notes.amountToCredit','Montant à créditer','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18305,0,'fr','app','credit-notes.remainingAmount','Montant restant','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18306,0,'fr','app','credit-notes.amountCredited','Montant crédité','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18307,0,'fr','app','onesignal.actionMessage','Nous aimerions vous montrer des notifications pour les dernières nouvelles et mises à jour.','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18308,0,'fr','app','onesignal.acceptButtonText','PERMETTRE','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18309,0,'fr','app','onesignal.cancelButtonText','NON MERCI','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18310,0,'fr','app','onesignal.tip.state.unsubscribed','Abonnez-vous aux notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18311,0,'fr','app','onesignal.tip.state.subscribed','Vous êtes abonné aux notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18312,0,'fr','app','onesignal.tip.state.blocked','Vous avez bloqué les notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18313,0,'fr','app','onesignal.message.prenotify','Cliquez pour vous abonner aux notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18314,0,'fr','app','onesignal.message.action.subscribed','Merci pour votre subscription!','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18315,0,'fr','app','onesignal.message.action.resubscribed','Vous êtes abonné aux notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18316,0,'fr','app','onesignal.message.action.unsubscribed','Vous ne recevrez plus de notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18317,0,'fr','app','onesignal.dialog.main.title','Gérer les notifications du site','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18318,0,'fr','app','onesignal.dialog.main.button.subscribe','S\'ABONNER','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18319,0,'fr','app','onesignal.dialog.main.button.unsubscribe','SE DÉSABONNER','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18320,0,'fr','app','onesignal.dialog.blocked.title','Débloquer les notifications','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18321,0,'fr','app','onesignal.dialog.blocked.message','Suivez ces instructions pour autoriser les notifications :','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18322,0,'fr','app','creditedInvoices','Factures créditées','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18323,0,'fr','app','appliedCredits','Crédits appliqués','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18324,0,'fr','app','ticketFiles','Fichiers de tickets','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18325,0,'fr','app','file','Des dossiers','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18326,0,'fr','app','renew','Renouveler','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18327,0,'fr','app','upload','Télécharger','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18328,0,'fr','app','paymentReminder','Rappel de paiement','2023-06-04 06:27:08','2023-06-04 07:35:58'),
(18329,0,'fr','app','leadAgent','Agent','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18330,0,'fr','app','purchaseAllow','Le client peut acheter','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18331,0,'fr','app','allowed','Autorisé','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18332,0,'fr','app','notAllowed','Interdit','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18333,0,'fr','app','purchase','Achat','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18334,0,'fr','app','purchaseDate','date d\'achat','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18335,0,'fr','app','product','Produit','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18336,0,'fr','app','mark','Marquer','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18337,0,'fr','app','exportPdf','Exporter vers PDF','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18338,0,'fr','app','version','Version','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18339,0,'fr','app','currentVersion','Version actuelle','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18340,0,'fr','app','latestVersion','Dernière version','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18341,0,'fr','app','module','Module','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18342,0,'fr','app','install','Installer','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18343,0,'fr','app','verifyEnvato','Vérifier le code d\'achat','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18344,0,'fr','app','copy','Copie','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18345,0,'fr','app','copyAboveLink','Copier le lien ci-dessus','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18346,0,'fr','app','used','Utilisé','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18347,0,'fr','app','remaining','Restant','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18348,0,'fr','app','adjustment','Ajustement','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18349,0,'fr','app','reply','Répondre','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18350,0,'fr','app','private','Privé','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18351,0,'fr','app','public','Public','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18352,0,'fr','app','today','Aujourd\'hui','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18353,0,'fr','app','and','et','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18354,0,'fr','app','selectTeam','Sélectionnez le département...','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18355,0,'fr','app','previous','Précédent','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18356,0,'fr','app','next','Suivant','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18357,0,'fr','app','uploadNext','Télécharger et passer à l\'étape suivante','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18358,0,'fr','app','collapseSidebar','Réduire la barre latérale','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18359,0,'fr','app','collapse','Effondrement','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18360,0,'fr','app','projectAdmin','Administrateur de projet','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18361,0,'fr','app','shippingAddress','adresse de livraison','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18362,0,'fr','app','showShippingAddress','Afficher l\'adresse de livraison','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18363,0,'fr','app','hideShippingAddress','Masquer l\'adresse de livraison','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18364,0,'fr','app','addShippingAddress','Ajouter une adresse de livraison','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18365,0,'fr','app','new','Nouveau','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18366,0,'fr','app','customerResponded','Le client a répondu','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18367,0,'fr','app','newResponse','Nouvelle réponse','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18368,0,'fr','app','share','Partager','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18369,0,'fr','app','expand','Développer','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18370,0,'fr','app','lastLogin','Dernière connexion à','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18371,0,'fr','app','approve','Approuver','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18372,0,'fr','app','hrs','heures','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18373,0,'fr','app','mins','minutes','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18374,0,'fr','app','receipt','Reçu','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18375,0,'fr','app','callback','Rappeler','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18376,0,'fr','app','socialAuthSettings.google','Google','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18377,0,'fr','app','socialAuthSettings.facebook','Facebook','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18378,0,'fr','app','socialAuthSettings.linkedin','Linkedin','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18379,0,'fr','app','socialAuthSettings.twitter','Twitter','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18380,0,'fr','app','socialAuthSettings.googleClientId','ID d\'application Google','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18381,0,'fr','app','socialAuthSettings.facebookClientId','ID d\'application Facebook','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18382,0,'fr','app','socialAuthSettings.twitterClientId','ID d\'application Twitter','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18383,0,'fr','app','socialAuthSettings.linkedinClientId','ID d\'application Linkedin','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18384,0,'fr','app','socialAuthSettings.googleSecret','Google secret','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18385,0,'fr','app','socialAuthSettings.facebookSecret','Secret de Facebook','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18386,0,'fr','app','socialAuthSettings.twitterSecret','Le secret de Twitter','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18387,0,'fr','app','socialAuthSettings.linkedinSecret','Secret Linkedin','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18388,0,'fr','app','saveSend','Enregistrer et envoyer','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18389,0,'fr','app','saveMark','Enregistrer et marquer comme envoyé','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18390,0,'fr','app','markSent','Marquer comme envoyé','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18391,0,'fr','app','saveDraft','Enregistrer comme brouillon','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18392,0,'fr','app','send','Envoyer','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18393,0,'fr','app','languageSetting','Paramètres de langue','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18394,0,'fr','app','archive','Archive','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18395,0,'fr','app','selectCurrency','Sélectionnez la devise','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18396,0,'fr','app','currency','Monnaie','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18397,0,'fr','app','draft','Brouillon','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18398,0,'fr','app','label','Étiqueter','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18399,0,'fr','app','labelName','Nom de l\'étiquette','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18400,0,'fr','app','color','Couleur','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18401,0,'fr','app','columnStatus','Statut','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18402,0,'fr','app','clientDashboard','Tableau de bord clients','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18403,0,'fr','app','financeDashboard','Tableau de bord des finances','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18404,0,'fr','app','signature','Signature','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18405,0,'fr','app','hrDashboard','Tableau de bord RH','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18406,0,'fr','app','completions','Achèvements','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18407,0,'fr','app','projectDashboard','Tableau de bord du projet','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18408,0,'fr','app','ticketDashboard','Tableau de bord des tickets','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18409,0,'fr','app','milestone','Jalon','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18410,0,'fr','app','goToCart','Aller au panier','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18411,0,'fr','app','toAllEmployee','Attribuer à tous les employés','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18412,0,'fr','app','projectMember','Membre du projet','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18413,0,'fr','app','notes','Remarques','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18414,0,'fr','app','daily','Quotidien','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18415,0,'fr','app','weekly','Hebdomadaire','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18416,0,'fr','app','bi-weekly','Bihebdomadaire','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18417,0,'fr','app','bi-week','Bi-semaine','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18418,0,'fr','app','monthly','Mensuel','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18419,0,'fr','app','halfday','Demi-journée','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18420,0,'fr','app','empdate','Employé / Date','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18421,0,'fr','app','quarterly','Trimestriel','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18422,0,'fr','app','quarter','Trimestre','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18423,0,'fr','app','half-yearly','Semestriel','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18424,0,'fr','app','half-year','Semestre','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18425,0,'fr','app','annually','Annuellement','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18426,0,'fr','app','member','Membre','2023-06-04 06:27:09','2023-06-04 07:35:58'),
(18427,0,'fr','app','bill','Facture','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18428,0,'fr','app','billableTask','Tâche facturable','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18429,0,'fr','app','priceDetail','Détail du prix','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18430,0,'fr','app','recurringDetail','Détail récurrent','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18431,0,'fr','app','infinite','Infini','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18432,0,'fr','app','completedExpense','Dépense terminée','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18433,0,'fr','app','pendingExpense','Dépense en attente','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18434,0,'fr','app','totalAmount','Montant total','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18435,0,'fr','app','recurring','Récurrent','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18436,0,'fr','app','info','Info','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18437,0,'fr','app','duplicate','Dupliquer','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18438,0,'fr','app','pin','Broche','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18439,0,'fr','app','removePinned','Supprimer l\'épingle','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18440,0,'fr','app','unpin','Détacher','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18441,0,'fr','app','pinnedItem','Projet épinglé','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18442,0,'fr','app','pinnedTask','Tâche épinglée','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18443,0,'fr','app','sorry','Désolé','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18444,0,'fr','app','about','À propos','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18445,0,'fr','app','todaysAttendance','La fréquentation d\'aujourd\'hui','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18446,0,'fr','app','pinned','Épinglé','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18447,0,'fr','app','invoiceRecurring','Facture récurrente','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18448,0,'fr','app','pendingInvoice','Facture en attente','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18449,0,'fr','app','completedInvoice','Facture complétée','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18450,0,'fr','app','recurringInvoices','Factures récurrentes','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18451,0,'fr','app','client_name','Nom du client','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18452,0,'fr','app','selectFollowUpDateRange','Sélectionnez la plage de dates de suivi','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18453,0,'fr','app','contractFiles','Dossiers contractuels','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18454,0,'fr','app','preview','Aperçu','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18455,0,'fr','app','fields','Champ','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18456,0,'fr','app','closed','Fermé','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18457,0,'fr','app','cancelEstimate','Annuler l\'estimation','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18458,0,'fr','app','enterYear','année à 4 chiffres','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18459,0,'fr','app','clearFilters','Clair','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18460,0,'fr','app','startTyping','Commencez à taper pour rechercher','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18461,0,'fr','app','selectAction','Pas d\'action','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18462,0,'fr','app','country','Pays','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18463,0,'fr','app','dragDrop','Choisissez un fichier','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18464,0,'fr','app','dragDropReplace','Déposez un fichier ou cliquez pour remplacer','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18465,0,'fr','app','largeFile','Désolé, le fichier est trop volumineux','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18466,0,'fr','app','filters','Filtres','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18467,0,'fr','app','moreFilters','Filtres','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18468,0,'fr','app','planned','Prévu','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18469,0,'fr','app','actual','Réel','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18470,0,'fr','app','overrun','Envahi','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18471,0,'fr','app','threshold','Seuil','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18472,0,'fr','app','default','Défaut','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18473,0,'fr','app','readBy','Lire par','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18474,0,'fr','app','unReadBy','En attente de lecture','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18475,0,'fr','app','viewPassword','Afficher/Masquer la valeur','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18476,0,'fr','app','contact','Contact','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18477,0,'fr','app','addContact','Ajouter le contact','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18478,0,'fr','app','other','Autre','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18479,0,'fr','app','rating','Notation','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18480,0,'fr','app','comment','Commentaire','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18481,0,'fr','app','cardDetails','Détails de la carte','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18482,0,'fr','app','proposal','Proposition','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18483,0,'fr','app','hsnSacCode','Code HSN/SAC','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18484,0,'fr','app','hsnSacCodeShow','Afficher le code Hsn/Sac','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18485,0,'fr','app','added','Ajoutée','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18486,0,'fr','app','owned','Possédé','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18487,0,'fr','app','both','Ajouté et détenu','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18488,0,'fr','app','none','Aucun','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18489,0,'fr','app','more','Plus','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18490,0,'fr','app','inviteMember','Inviter un membre à','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18491,0,'fr','app','darkTheme','Mode sombre','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18492,0,'fr','app','addToCart','Ajouter au panier','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18493,0,'fr','app','cart','Chariot','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18494,0,'fr','app','order','Commande','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18495,0,'fr','app','signUp','S\'inscrire','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18496,0,'fr','app','by','Par','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18497,0,'fr','app','after','Après','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18498,0,'fr','app','showAll','Afficher tout','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18499,0,'fr','app','rtlTheme','Activer le thème RTL (de droite à gauche)','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18500,0,'fr','app','invite','Inviter','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18501,0,'fr','app','last30Days','Les 30 derniers jours','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18502,0,'fr','app','thisMonth','Ce mois-ci','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18503,0,'fr','app','lastMonth','Le mois dernier','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18504,0,'fr','app','last90Days','90 derniers jours','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18505,0,'fr','app','last6Months','6 derniers mois','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18506,0,'fr','app','last1Year','1 dernier an','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18507,0,'fr','app','customRange','Gamme personnalisée','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18508,0,'fr','app','link','Lien','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18509,0,'fr','app','settings','Paramètres','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18510,0,'fr','app','lists','Listes','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18511,0,'fr','app','hsnSac','Hsn/Sac','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18512,0,'fr','app','sendReminderBefore','Envoyer un rappel avant','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18513,0,'fr','app','sendReminderAfter','Envoyer un rappel après','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18514,0,'fr','app','sendReminderEvery','Envoyer un rappel tous les','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18515,0,'fr','app','before','Avant','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18516,0,'fr','app','unarchive','Restaurer','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18517,0,'fr','app','accountSetup','Configuration du compte','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18518,0,'fr','app','saveLogin','Enregistrer et se connecter','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18519,0,'fr','app','sandbox','bac à sable','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18520,0,'fr','app','live','En direct','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18521,0,'fr','app','production','Production','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18522,0,'fr','app','test','Test','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18523,0,'fr','app','moveFilesToCloud','Déplacer des fichiers du stockage local vers le cloud','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18524,0,'fr','app','selectEnvironment','Sélectionnez l\'environnement','2023-06-04 06:27:10','2023-06-04 07:35:58'),
(18525,0,'fr','app','sandboxPaypalClientId','Identifiant client Paypal Sandbox','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18526,0,'fr','app','sandboxPaypalSecret','Bac à sable Paypal secret','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18527,0,'fr','app','livePaypalClientId','Identifiant client Paypal en direct','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18528,0,'fr','app','livePaypalSecret','Secret Paypal en direct','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18529,0,'fr','app','webhookUrlCopied','URL du webhook copiée','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18530,0,'fr','app','razorpayKey','Clé Razorpay','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18531,0,'fr','app','razorpaySecret','Le secret de Razorpay','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18532,0,'fr','app','stripePublishableKey','Clé publiable Stripe','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18533,0,'fr','app','stripeSecret','Secret de la rayure','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18534,0,'fr','app','stripeWebhookSecret','Secret de signature Stripe Webhook','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18535,0,'fr','app','storageSetting.selectStorage','Sélectionnez Stockage','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18536,0,'fr','app','storageSetting.local','Locale (par défaut)','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18537,0,'fr','app','storageSetting.aws','Stockage AWS S3 (Amazon Web Services S3)','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18538,0,'fr','app','storageSetting.awsKey','Clé AWS','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18539,0,'fr','app','storageSetting.awsSecret','Secret AWS','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18540,0,'fr','app','storageSetting.awsRegion','Région AWS','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18541,0,'fr','app','storageSetting.awsBucket','Compartiment AWS','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18542,0,'fr','app','storageSetting.digitalocean','Espaces DigitalOcean (stockage d\'objets cloud compatible S3)','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18543,0,'fr','app','storageSetting.digitaloceanKey','Clé Espaces Digitalocean','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18544,0,'fr','app','storageSetting.digitaloceanSecret','Le secret des espaces Digitalocean','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18545,0,'fr','app','storageSetting.digitaloceanRegion','Région Espaces Digitalocean','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18546,0,'fr','app','storageSetting.digitaloceanBucket','Seau d\'espaces Digitalocean','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18547,0,'fr','app','storageSetting.testDigitalocean','Testez le téléchargement des espaces Digitalocean','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18548,0,'fr','app','storageSetting.wasabiKey','Clé Wasabi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18549,0,'fr','app','storageSetting.wasabiSecret','Le secret du wasabi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18550,0,'fr','app','storageSetting.wasabiRegion','Région Wasabi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18551,0,'fr','app','storageSetting.wasabiBucket','Seau à wasabi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18552,0,'fr','app','storageSetting.testWasabi','Tester le téléchargement de wasabi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18553,0,'fr','app','storageSetting.viewFile','Voir la fiche','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18554,0,'fr','app','storageSetting.downloadFile','Télécharger un fichier','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18555,0,'fr','app','storageSetting.uploadFile','Téléchargez le fichier pour tester s\'il est téléchargé dans le compartiment','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18556,0,'fr','app','storageSetting.testAWSSetting','Tester les paramètres AWS','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18557,0,'fr','app','storageSetting.testDigitaloceanSetting','Tester les paramètres des espaces Digitalocean','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18558,0,'fr','app','storageSetting.testwasabiSetting','Tester les paramètres de stockage Wasabi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18559,0,'fr','app','storageSetting.testAws','Tester le téléchargement AWS S3','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18560,0,'fr','app','storageSetting.storageSuggestion','<b>Suggestion :</b> Envisagez d\'utiliser AWS S3, DigitalOcean Spaces ou Wasabi Storage pour une couche de sécurité supplémentaire','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18561,0,'fr','app','storageSetting.localStorageNote','signifie que les fichiers que vous téléchargez seront stockés sur votre propre serveur dans le répertoire <b>public/user-uploads</b>.','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18562,0,'fr','app','message','Message','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18563,0,'fr','app','verify','Vérifier','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18564,0,'fr','app','itemSelected','éléments sélectionnés','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18565,0,'fr','app','clientNote','Remarque client','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18566,0,'fr','app','membersSelected','membres sélectionnés','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18567,0,'fr','app','clientsSelected','clients sélectionnés','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18568,0,'fr','app','viewPublicPage','Afficher la page publique','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18569,0,'fr','app','creditnoteNumber','Numéro de note de crédit','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18570,0,'fr','app','enable2FA','Activer 2FA','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18571,0,'fr','app','disable2FA','Désactiver 2FA','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18572,0,'fr','app','recoveryCode','Code de récupération','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18573,0,'fr','app','twoFactorVerification','Vérification à deux facteurs','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18574,0,'fr','app','twoFactorCode','Code d\'authentification à deux facteurs','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18575,0,'fr','app','twoFactorCodeEmail','Code d\'authentification de messagerie à deux facteurs','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18576,0,'fr','app','twoFactorRecoveryCode','Code de récupération d\'authentification à deux facteurs','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18577,0,'fr','app','clickHere','Cliquez ici','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18578,0,'fr','app','itsYou','C\'est toi','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18579,0,'fr','app','withoutDueDate','Sans date d\'échéance','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18580,0,'fr','app','regenerate','Régénérer','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18581,0,'fr','app','authenticationRequired','Authentification requise','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18582,0,'fr','app','verifyUsingRecoveryCodes','Vérifier à l\'aide des codes de récupération','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18583,0,'fr','app','verifyUsingGoogleAuthenticatorCodes','Vérifier à l\'aide des codes Google Authenticator','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18584,0,'fr','app','verifyUsingEmail','Vérifier par e-mail','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18585,0,'fr','app','statistics','Statistiques','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18586,0,'fr','app','signUpAsClient','Inscrivez-vous en tant que client','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18587,0,'fr','app','dateFilterOn','Filtre de date activé','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18588,0,'fr','app','skipAll','Tout passer','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18589,0,'fr','app','showSkippedColumns','Afficher les colonnes ignorées','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18590,0,'fr','app','btnBack','Dos','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18591,0,'fr','app','btnSave','Sauvegarder','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18592,0,'fr','app','skip','Sauter','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18593,0,'fr','app','willNotBeImported','ne sera pas importé','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18594,0,'fr','app','selectAColumn','Sélectionnez une colonne','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18595,0,'fr','app','doNotCloseOrRefreshPage','Ne fermez pas ou n\'actualisez pas cette page tant que l\'importation n\'est pas terminée','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18596,0,'fr','app','importFailedJobs','Échec des entrées :failedJobs sur les entrées  :totalJobs lors de l\'importation.','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18597,0,'fr','app','importInProgress','Importation en cours...','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18598,0,'fr','app','pleaseWait','S\'il vous plaît, attendez...','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18599,0,'fr','app','importProcessedJobs',':processedJobs entrées traitées sur :totalJobs entrées lors de l\'importation.','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18600,0,'fr','app','importCompleted','Importation terminée','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18601,0,'fr','app','exceptions','Exceptions lors de l\'importation','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18602,0,'fr','app','importExcelInfo','Le format de date doit être au format Y-m-d (par exemple, 2022-04-21). Assurez-vous que le format de date est correct dans le fichier Excel.','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18603,0,'fr','app','importAttendanceExcelInfo','Le format DateHeure doit être au format Y-m-d H:i:s (par exemple, 2022-04-21 12:00:00). Assurez-vous que le format de date est correct dans le fichier Excel.','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18604,0,'fr','app','importProjectExcelInfo','Le format de date doit être au format Y-m-d (par exemple, 2022-04-21). Assurez-vous que le format de date est correct dans le fichier Excel.','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18605,0,'fr','app','backToEmployees','Retour aux employés','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18606,0,'fr','app','backToClient','Retour aux Clients','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18607,0,'fr','app','backToAttendance','Retour à la fréquentation','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18608,0,'fr','app','backToLead','Retour aux prospects','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18609,0,'fr','app','backToProject','Retour aux projets','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18610,0,'fr','app','unsyncedUsers','Utilisateurs non synchronisés','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18611,0,'fr','app','location','Emplacement','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18612,0,'fr','app','crop','Culture','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18613,0,'fr','app','cropImage','Recadrer l\'image','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18614,0,'fr','app','dragImage','Faire glisser l\'image','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18615,0,'fr','app','rotateLeftImage','Faire pivoter l\'image vers la gauche','2023-06-04 06:27:11','2023-06-04 07:35:58'),
(18616,0,'fr','app','rotateRightImage','Faire pivoter l\'image vers la droite','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18617,0,'fr','app','downloadable','Téléchargeable','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18618,0,'fr','app','downloadableFile','Fichier téléchargeable','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18619,0,'fr','app','unmatchedColumn','Colonne sans correspondance','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18620,0,'fr','app','tax','Impôt','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18621,0,'fr','app','rejectReason','Motif du refus','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18622,0,'fr','app','payment','Paiement','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18623,0,'fr','app','only','seul','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18624,0,'fr','app','relationship','Relation','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18625,0,'fr','app','details','Détails','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18626,0,'fr','app','profile','Profil','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18627,0,'fr','app','orderMarkAsComplete','Marquer comme complet','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18628,0,'fr','app','flowId','Identifiant de flux','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18629,0,'fr','app','smsTemplateCopied','Modèle de SMS copié','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18630,0,'fr','app','accepted','Accepté','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18631,0,'fr','app','waiting','En attendant','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18632,0,'fr','app','googleCalender','Activer Google Agenda','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18633,0,'fr','app','saveAddMore','Enregistrer et ajouter plus','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18634,0,'fr','app','department','Département','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18635,0,'fr','app','awardDate','Date d\'attribution','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18636,0,'fr','app','loading','Chargement...','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18637,0,'fr','app','createNew','Créer un nouveau','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18638,0,'fr','app','googleMapSettings','Paramètres de la carte Google','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18639,0,'fr','app','clientSignUpSettings','Paramètres d\'inscription du client','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18640,0,'fr','app','viewedOn','Vu le','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18641,0,'fr','app','at','à','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18642,0,'fr','app','using','En utilisant','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18643,0,'fr','app','viewPdf','Afficher le PDF','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18644,0,'fr','app','showAuthorisedSignatory','Afficher le signataire autorisé','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18645,0,'fr','app','showStatus','Afficher l\'état','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18646,0,'fr','app','every','Chaque','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18647,0,'fr','app','client_email','Courriel du client','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18648,0,'fr','app','single','Journée complète','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18649,0,'fr','app','general','Général','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18650,0,'fr','app','ticket','Ticket','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18651,0,'fr','app','contract','Contracter','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18652,0,'fr','app','text','Texte','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18653,0,'fr','app','number','Nombre','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18654,0,'fr','app','textarea','Zone de texte','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18655,0,'fr','app','radio','Radio','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18656,0,'fr','app','checkbox','Case à cocher','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18657,0,'fr','app','converted','Converti','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18658,0,'fr','app','google','Google','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18659,0,'fr','app','facebook','Facebook','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18660,0,'fr','app','friend','Ami','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18661,0,'fr','app','direct','Direct','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18662,0,'fr','app','tv','La télé','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18663,0,'fr','app','howItWorks','Comment ça fonctionne','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18664,0,'fr','app','signInToDifferentDomain','Connectez-vous à un domaine différent','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18665,0,'fr','app','addProject','Ajouter un projet','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18666,0,'fr','app','addTask','Ajouter une tâche','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18667,0,'fr','app','addClient','Ajouter un client','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18668,0,'fr','app','addLead','Ajouter un prospect','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18669,0,'fr','app','addPassport','Ajouter un passeport','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18670,0,'fr','app','addVisa','Ajouter Visa','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18671,0,'fr','app','addInvoiceRecurring','Ajouter une facture récurrente','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18672,0,'fr','app','addLanguage','Ajouter une langue','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18673,0,'fr','app','addEmployee','Ajouter un employé','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18674,0,'fr','app','addClientNote','Ajouter une note client','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18675,0,'fr','app','addLeadNote','Ajouter une note principale','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18676,0,'fr','app','addProjectNote','Ajouter une note de projet','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18677,0,'fr','app','editAddress','Modifier l\'adresse','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18678,0,'fr','app','editCurrency','Modifier la devise','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18679,0,'fr','app','editPassport','Modifier le passeport','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18680,0,'fr','app','editVisa','Modifier le visa','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18681,0,'fr','app','editFile','Modifier le fichier','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18682,0,'fr','app','editLanguage','Modifier la langue','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18683,0,'fr','app','editContact','Modifier le contact','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18684,0,'fr','app','editClientNote','Modifier la note du client','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18685,0,'fr','app','editLeadNote','Modifier la note principale','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18686,0,'fr','app','editProjectNote','Modifier la note du projet','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18687,0,'fr','app','editNote','Note éditée','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18688,0,'fr','app','downloadFile','Télécharger un fichier','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18689,0,'fr','app','completedOn','Terminé le','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18690,0,'fr','app','alternateShift','Il n\'y a pas d\'autre quart de travail pour cette date','2023-06-04 06:27:12','2023-06-04 07:35:58'),
(18691,0,'fr','auth','failed','Ces informations d\'identification ne correspondent pas à nos dossiers.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18692,0,'fr','auth','password','Le mot de passe fourni est incorrect.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18693,0,'fr','auth','throttle','Trop de tentatives de connexion. Veuillez réessayer dans :seconds secondes.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18694,0,'fr','auth','failedLoginDisabled','La connexion a été désactivée par votre administrateur.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18695,0,'fr','auth','failedBlocked','Votre compte est désactivé ! Veuillez contacter votre administrateur pour l\'activer.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18696,0,'fr','auth','recaptchaFailed','Recaptcha non validé.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18697,0,'fr','auth','sociaLoginFail','Votre compte n\'existe pas ! Inscrivez vous s\'il vous plait.','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18698,0,'fr','auth','signInGoogle','Connectez-vous avec Google','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18699,0,'fr','auth','signInFacebook','Connectez-vous avec Facebook','2023-06-04 06:27:12','2023-06-04 06:42:01'),
(18700,0,'fr','auth','signInLinkedin','Connectez-vous avec LinkedIn','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18701,0,'fr','auth','signInTwitter','Connectez-vous avec Twitter','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18702,0,'fr','auth','useEmail','ou, utilisez l\'adresse e-mail','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18703,0,'fr','auth','email','Adresse e-mail','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18704,0,'fr','auth','next','Suivant','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18705,0,'fr','email','newEvent.subject','Nouvel événement créé','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18706,0,'fr','email','newEvent.text','Nous sommes ravis d\'annoncer un nouvel événement qui a été créé et nous aimerions vous inviter à nous rejoindre. Pour vous faciliter la tâche de réserver la date, nous avons joint à cet e-mail un fichier ICS que vous pouvez télécharger et ajouter à votre calendrier.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18707,0,'fr','email','newEvent.action','Voir l\'événement','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18708,0,'fr','email','loginDashboard','Aller au tableau de bord','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18709,0,'fr','email','viewInvoice','Voir la facture','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18710,0,'fr','email','thankyouNote','Merci d\'utiliser notre application!','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18711,0,'fr','email','notificationAction','Action de notification','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18712,0,'fr','email','notificationIntro','L\'introduction à la notification.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18713,0,'fr','email','hello','Bonjour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18714,0,'fr','email','whoops','Oups','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18715,0,'fr','email','regards','Salutations','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18716,0,'fr','email','newExpense.subject','Nouvelle dépense soumise pour approbation','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18717,0,'fr','email','newExpense.action','Afficher les dépenses','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18718,0,'fr','email','newExpenseRecurring.subject','Nouvelle dépense récurrente soumise pour approbation','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18719,0,'fr','email','newExpenseRecurring.action','Afficher les dépenses récurrentes','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18720,0,'fr','email','expenseStatus.subject','État des dépenses mis à jour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18721,0,'fr','email','expenseStatus.text','Statut de vos dépenses mis à jour à','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18722,0,'fr','email','expenseStatus.action','Afficher les dépenses','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18723,0,'fr','email','expenseRecurringStatus.subject','État des dépenses récurrentes mis à jour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18724,0,'fr','email','expenseRecurringStatus.text','Le statut de vos dépenses récurrentes a été mis à jour à','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18725,0,'fr','email','expenseRecurringStatus.action','Afficher les dépenses récurrentes','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18726,0,'fr','email','newNotice.subject','Avis important : nouvelle mise à jour publiée','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18727,0,'fr','email','newNotice.text','Un nouvel avis a été publié. Connectez-vous pour voir l\'avis.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18728,0,'fr','email','newNotice.action','Afficher l\'avis','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18729,0,'fr','email','newProjectMember.subject','Mise à jour du projet : un nouveau projet vous a été attribué','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18730,0,'fr','email','newProjectMember.text','Vous avez été ajouté en tant que membre du projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18731,0,'fr','email','newProjectMember.action','Voir le projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18732,0,'fr','email','newProjectMember.mentionProject','Vous avez été mentionné sur un nouveau projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18733,0,'fr','email','newProjectMember.mentionText','Vous avez été mentionné sur le projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18734,0,'fr','email','newProjectMember.mentionProjectNote','Mise à jour du projet : vous avez été mentionné sur une nouvelle note de projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18735,0,'fr','email','newProjectMember.mentionNoteText','Vous avez été mentionné sur le projet Note','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18736,0,'fr','email','projectNote.mentionSubject','Vous avez été mentionné sur une nouvelle note de projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18737,0,'fr','email','projectNote.mentionText','Vous avez été mentionné sur la nouvelle note de projet','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18738,0,'fr','email','projectNote.text','Nouvelle note ajoutée pour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18739,0,'fr','email','projectNote.action','Afficher la note','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18740,0,'fr','email','projectNote.subject','Nouvelle note ajoutée pour Project','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18741,0,'fr','email','newProject.subject','Nouveau projet ajouté','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18742,0,'fr','email','newProject.text','Un nouveau projet ajouté avec le nom','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18743,0,'fr','email','newProject.withName','avec nom.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18744,0,'fr','email','newProject.loginNow','Connectez-vous maintenant pour voir le projet.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18745,0,'fr','email','newProjectStatus.subject','État du projet mis à jour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18746,0,'fr','email','newProjectStatus.text','Le statut du projet a été modifié','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18747,0,'fr','email','newProjectStatus.withName','avec nom.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18748,0,'fr','email','newProjectStatus.loginNow','Connectez-vous maintenant pour voir le projet.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18749,0,'fr','email','newTask.subject','Affectation de tâche : une nouvelle tâche vous a été affectée','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18750,0,'fr','email','newTask.mentionSubject','Mention sur la nouvelle tâche','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18751,0,'fr','email','newTask.mentionTask','Vous avez été mentionné dans une tâche','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18752,0,'fr','email','dueOn','Dû le','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18753,0,'fr','email','newTicket.subject','Nouveau ticket de support demandé','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18754,0,'fr','email','newTicket.text','Un nouveau ticket de support est demandé. Connectez-vous pour voir le ticket.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18755,0,'fr','email','newTicket.action','Voir le ticket','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18756,0,'fr','email','newUser.subject','Bienvenue à','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18757,0,'fr','email','newUser.text','Toutes nos félicitations! Votre compte a été créé avec succès. Vous pouvez maintenant vous connecter et commencer à utiliser notre service.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18758,0,'fr','email','newUser.action','Connectez-vous au tableau de bord','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18759,0,'fr','email','newUserViaLink.subject','Nouveau membre de l\'équipe : bienvenue dans l\'équipe !','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18760,0,'fr','email','newUserViaLink.text','Le nouveau compte a été créé avec succès via le lien d\'invitation. Voici les détails-','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18761,0,'fr','email','newUserViaLink.action','Afficher les détails de l\'utilisateur','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18762,0,'fr','email','leaves.subject','Nouvelle demande de congé reçue','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18763,0,'fr','email','leaves.statusSubject','Laisser le statut de la demande mis à jour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18764,0,'fr','email','leaves.multipleSubject','Nouvelle demande de congés multiples reçue par :user','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18765,0,'fr','email','leaves.action','Afficher les congés','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18766,0,'fr','email','taskComplete.subject','Tâche marquée comme terminée','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18767,0,'fr','email','taskComplete.action','Afficher la tâche','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18768,0,'fr','email','taskComplete.completedBy','Tâche terminée par','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18769,0,'fr','email','taskUpdate.subject','Tâche mise à jour','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18770,0,'fr','email','taskUpdate.action','Afficher la tâche','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18771,0,'fr','email','leave.approve','Demande de congé approuvée.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18772,0,'fr','email','leave.reject','Demande de congé rejetée.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18773,0,'fr','email','leave.applied','Laisser l\'application appliquée.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18774,0,'fr','email','leave.action','Voir la demande de congé','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18775,0,'fr','email','newClientTask.subject','Nouvelle tâche générée','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18776,0,'fr','email','newClientTask.content','Une nouvelle tâche a été créée dans Project','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18777,0,'fr','email','reminder.subject','Rappel pour la tâche assignée','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18778,0,'fr','email','invoices.paymentReceived','Paiement reçu : Confirmation','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18779,0,'fr','email','invoices.paymentReceivedForInvoice','Paiement reçu pour la facture','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18780,0,'fr','email','invoices.paymentReceivedForOrder','Paiement reçu pour la commande','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18781,0,'fr','email','invoices.action','Voir la facture','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18782,0,'fr','email','invoices.newPaymentReceived','Nouveau paiement reçu','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18783,0,'fr','email','invoices.paymentReminder','Rappel de paiement reçu','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18784,0,'fr','email','orders.action','Voir l\'ordre','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18785,0,'fr','email','orders.subject','Nouvelle commande reçue','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18786,0,'fr','email','eventReminder.subject','Rappel : Événement à venir - Réservez la date !','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18787,0,'fr','email','eventReminder.text','Ceci est pour vous rappeler l\'événement suivant. Connectez-vous pour plus de détails sur l\'événement.','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18788,0,'fr','email','eventReminder.action','Voir l\'événement','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18789,0,'fr','email','taskReminder.subject','Rappel de tâche urgent : la date limite approche','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18790,0,'fr','email','estimate.subject','Nouvelle estimation créée','2023-06-04 06:27:13','2023-06-04 06:42:01'),
(18791,0,'fr','email','estimate.text','Une nouvelle estimation a été créée. Veuillez cliquer sur le lien ci-dessous pour voir l\'estimation.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18792,0,'fr','email','estimate.loginDashboard','Approuver / Rejeter','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18793,0,'fr','email','invoice.subject','Nouvelle facture reçue','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18794,0,'fr','email','invoice.text','Une nouvelle facture a été reçue. Veuillez cliquer sur le lien ci-dessous pour afficher la facture.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18795,0,'fr','email','invoice.action','Voir la facture','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18796,0,'fr','email','invoice.updateSubject','Facture mise à jour','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18797,0,'fr','email','invoice.updateText','La facture a été mise à jour. Veuillez cliquer sur le lien ci-dessous pour afficher la facture.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18798,0,'fr','email','invoice.updateTextSms','La facture a été mise à jour. Veuillez vérifier la facture :invoice_number.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18799,0,'fr','email','order.subject','Nouvelle commande passée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18800,0,'fr','email','order.text','Une nouvelle commande a été passée. Veuillez cliquer sur le lien ci-dessous pour voir la commande.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18801,0,'fr','email','order.action','Voir l\'ordre','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18802,0,'fr','email','order.updateSubject','Commande mise à jour','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18803,0,'fr','email','order.updateText','La commande a été mise à jour. Veuillez cliquer sur le lien ci-dessous pour voir la commande.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18804,0,'fr','email','projectReminder.text','Ceci est pour vous rappeler la date d\'échéance des projets suivants qui est','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18805,0,'fr','email','projectReminder.subject','Rappel de projet','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18806,0,'fr','email','projectReminder.action','Voir les projets','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18807,0,'fr','email','messages.loginForMoreDetails','Connectez-vous pour plus de détails.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18808,0,'fr','email','messages.referenceMessage','J\'ai joint une copie de la facture pour votre référence.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18809,0,'fr','email','messages.confirmMessage','Je vous serais vraiment reconnaissant si vous pouviez confirmer que tout est en bonne voie pour le paiement.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18810,0,'fr','email','taskComment.subject','Nouveau commentaire sur la tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18811,0,'fr','email','taskComment.action','Afficher le commentaire de la tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18812,0,'fr','email','taskComment.mentionTask','Vous avez été mentionné dans un commentaire de tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18813,0,'fr','email','taskComment.mentionSubject','Mentionné en commentaire','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18814,0,'fr','email','taskNote.subject','Nouvelle note ajoutée pour la tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18815,0,'fr','email','taskNote.action','Afficher la note de tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18816,0,'fr','email','taskNote.mentionNote','Vous avez été mentionné dans la note de tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18817,0,'fr','email','taskNote.mentionSubject','Mentionné sur note','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18818,0,'fr','email','removalRequestAdmin.subject','Nouvelle demande de suppression','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18819,0,'fr','email','removalRequestAdmin.text','Une nouvelle demande de suppression a été reçue','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18820,0,'fr','email','removalRequestApprovedUser.subject','Approbation de la demande de suppression','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18821,0,'fr','email','removalRequestApprovedUser.text','Votre demande de suppression a été approuvée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18822,0,'fr','email','removalRequestRejectedUser.subject','Demande de suppression rejetée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18823,0,'fr','email','removalRequestRejectedUser.text','Votre demande de suppression a été rejetée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18824,0,'fr','email','removalRequestApprovedLead.subject','Approbation de la demande de suppression','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18825,0,'fr','email','removalRequestApprovedLead.text','Votre demande de suppression de prospect a été approuvée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18826,0,'fr','email','removalRequestRejectedLead.subject','Demande de suppression rejetée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18827,0,'fr','email','removalRequestRejectedLead.text','Votre demande de suppression de prospect a été rejetée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18828,0,'fr','email','paymentReminder.subject','Rappel de paiement','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18829,0,'fr','email','paymentReminder.content','Ceci est pour vous rappeler la date d\'échéance du paiement de la facture du projet suivant qui est','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18830,0,'fr','email','paymentReminder.smsText','Ceci est pour vous rappeler la date d\'échéance du paiement de la facture du projet suivant :invoice_number qui est :due_date.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18831,0,'fr','email','fileUpload.subject','Nouveau fichier téléchargé sur le projet :','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18832,0,'fr','email','fileUpload.action','Afficher les fichiers de projet','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18833,0,'fr','email','payment.subject','Paiement reçu!','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18834,0,'fr','email','payment.text','Un nouveau paiement a été effectué. Connectez-vous maintenant pour voir le paiement.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18835,0,'fr','email','payment.action','Afficher le paiement','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18836,0,'fr','email','payment.amount','Montant payé','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18837,0,'fr','email','payment.method','Mode de paiement','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18838,0,'fr','email','payment.invoiceNumber','Numéro de facture','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18839,0,'fr','email','payment.clientsubject','Succès du paiement','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18840,0,'fr','email','payment.clientName','Nom du client','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18841,0,'fr','email','payment.clientEmail','Courriel du client','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18842,0,'fr','email','payment.Project','Projet','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18843,0,'fr','email','ticketAgent.subject','Un ticket vous a été attribué','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18844,0,'fr','email','ticketAgent.text','Un nouveau ticket vous a été attribué.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18845,0,'fr','email','ticketAgent.action','Voir le ticket','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18846,0,'fr','email','subTaskComplete.subject','Sous-tâche marquée comme terminée','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18847,0,'fr','email','subTaskComplete.action','Afficher les sous-tâches','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18848,0,'fr','email','subTaskAssigneeAdded.subject','Sous-tâche qui vous est assignée.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18849,0,'fr','email','subTaskAssigneeAdded.text','Vous avez été ajouté en tant que responsable sur la tâche','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18850,0,'fr','email','subTaskAssigneeAdded.action','Afficher les sous-tâches','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18851,0,'fr','email','leadAgent.subject','Nouvelle piste reçue.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18852,0,'fr','email','leadAgent.action','Voir le prospect','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18853,0,'fr','email','subTaskCreated','Sous-tâche créée.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18854,0,'fr','email','discussionReply.subject','répondu à','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18855,0,'fr','email','discussionReply.text','Vous avez reçu une réponse sur','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18856,0,'fr','email','discussionReply.action','Afficher la discussion','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18857,0,'fr','email','discussion.subject','Une nouvelle discussion a commencé','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18858,0,'fr','email','discussion.action','Afficher la discussion','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18859,0,'fr','email','discussion.mentionSubject','Mentionné sur la discussion','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18860,0,'fr','email','discussion.mentionContent','Vous avez été mentionné sur la nouvelle discussion de projet','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18861,0,'fr','email','ticketReply.subject','Nouvelle réponse au ticket reçue','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18862,0,'fr','email','ticketReply.receivedText','Vous avez reçu une réponse sur ticket','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18863,0,'fr','email','ticketReply.repliedText','Vous avez répondu sur le ticket','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18864,0,'fr','email','ticketReply.action','Voir le ticket','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18865,0,'fr','email','contractSign.subject','Contrat signé','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18866,0,'fr','email','contractSign.text',':contract (contrat) est signé par :client.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18867,0,'fr','email','newContract.subject','Nouveau contrat créé !','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18868,0,'fr','email','newContract.text','Un nouveau contrat a été créé.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18869,0,'fr','email','newChat.subject','Nouveau message reçu','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18870,0,'fr','email','newChat.action','Voir message','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18871,0,'fr','email','noticeUpdate.subject','Une notice a été mise à jour','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18872,0,'fr','email','noticeUpdate.text','L\'avis a été mis à jour. Connectez-vous pour voir l\'avis.','2023-06-04 06:27:14','2023-06-04 06:42:01'),
(18873,0,'fr','email','noticeUpdate.action','Afficher l\'avis','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18874,0,'fr','email','payments.paymentReceived','Paiement reçu','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18875,0,'fr','email','estimateDeclined.subject','Estimation refusée','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18876,0,'fr','email','estimateDeclined.text','Une estimation a été refusée. Veuillez cliquer sur le lien ci-dessous pour vérifier l\'estimation.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18877,0,'fr','email','estimateDeclined.smsText','Une estimation a été refusée. Veuillez vérifier l\'estimation #:estimate_number','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18878,0,'fr','email','estimateDeclined.action','Voir l\'estimation','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18879,0,'fr','email','estimateAccepted.subject','Devis accepté','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18880,0,'fr','email','newMeeting.subject','Nouvelle réunion créée','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18881,0,'fr','email','newMeeting.text','Une nouvelle réunion a été créée. Téléchargez la pièce jointe pour ajouter une réunion à votre calendrier.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18882,0,'fr','email','removalRequestApproved.subject','Approbation de la demande de suppression','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18883,0,'fr','email','removalRequestApproved.text','Votre demande de suppression de prospect a été approuvée','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18884,0,'fr','email','removalRequestReject.subject','Refus de la demande de suppression','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18885,0,'fr','email','removalRequestReject.text','Votre demande de suppression de prospect a été rejetée','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18886,0,'fr','email','newTicketRequester.subject','Un nouveau ticket a été généré pour vous.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18887,0,'fr','email','newTicketRequester.text','Un nouveau ticket d\'assistance a été généré pour vous. Connectez-vous pour voir le ticket.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18888,0,'fr','email','newTicketRequester.action','Voir le ticket','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18889,0,'fr','email','newInvoiceRecurring.subject','Nouvelle facture récurrente soumise','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18890,0,'fr','email','newInvoiceRecurring.text','Une nouvelle facture récurrente a été soumise. Veuillez cliquer sur le lien ci-dessous pour afficher la facture.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18891,0,'fr','email','newInvoiceRecurring.smsText','Une nouvelle facture récurrente a été soumise.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18892,0,'fr','email','newInvoiceRecurring.action','Afficher la facture récurrente','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18893,0,'fr','email','invoiceRecurringStatus.subject','État de la facture récurrente mis à jour','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18894,0,'fr','email','invoiceRecurringStatus.text','Statut de votre facture récurrente mis à jour à','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18895,0,'fr','email','invoiceRecurringStatus.action','Afficher la facture récurrente','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18896,0,'fr','email','creditNote.subject','Nouvelle note de crédit reçue','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18897,0,'fr','email','creditNote.text','Une nouvelle note de crédit a été reçue. Connectez-vous maintenant pour voir la note de crédit.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18898,0,'fr','email','creditNote.action','Afficher la note de crédit','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18899,0,'fr','email','proposal.subject','Nouvelle proposition reçue','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18900,0,'fr','email','proposal.text','Une nouvelle proposition a été reçue. Connectez-vous maintenant pour voir la proposition.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18901,0,'fr','email','proposalSigned.subject','La proposition a été acceptée !','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18902,0,'fr','email','proposalSigned.text','Une nouvelle proposition a été acceptée et signée.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18903,0,'fr','email','proposalSigned.approve','Approuvé par','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18904,0,'fr','email','proposalRejected.subject','La proposition a été refusée par le prospect !','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18905,0,'fr','email','proposalRejected.text','Une nouvelle proposition a été refusée.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18906,0,'fr','email','proposalRejected.rejected','Rejeté','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18907,0,'fr','email','testMail.testMail','E-mail test','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18908,0,'fr','email','testMail.mailAddress','Entrez l\'adresse e-mail où le courrier de test doit être envoyé','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18909,0,'fr','email','invitation.subject','vous a invité à rejoindre','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18910,0,'fr','email','invitation.action','Accepter l\'invitation','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18911,0,'fr','email','invoiceReminder.subject','Rappel de facture','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18912,0,'fr','email','invoiceReminder.text','Ceci est pour vous rappeler la date d\'échéance de la facture suivante qui a été','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18913,0,'fr','email','invoiceReminder.action','Voir la facture','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18914,0,'fr','email','invoiceReminderAfter.subject','Rappel de facture','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18915,0,'fr','email','invoiceReminderAfter.text','Je voulais juste vous envoyer un petit mot pour vous rappeler que l\'échéance de paiement le','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18916,0,'fr','email','invoiceReminderAfter.action','Voir la facture','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18917,0,'fr','email','test.subject','Confirmer la réception : Tester l\'e-mail','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18918,0,'fr','email','test.text','Il s\'agit d\'un e-mail de test pour vérifier que les paramètres SMTP sont correctement configurés et que le système de messagerie fonctionne correctement. Si vous recevez ce message, cela signifie que la configuration SMTP fonctionne correctement.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18919,0,'fr','email','test.thankyouNote','Merci d\'utiliser notre application!','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18920,0,'fr','email','AttendanceReminder.subject','Action requise : marquer la présence d\'aujourd\'hui','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18921,0,'fr','email','AttendanceReminder.text','Cet e-mail est un rappel amical pour marquer votre présence pour aujourd\'hui. Nous avons remarqué que vous n\'avez pas encore pointé et nous voulions vous rappeler de le faire dès que possible pour éviter d\'être marqué comme absent.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18922,0,'fr','email','AttendanceReminder.action','Marquer la présence','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18923,0,'fr','email','BirthdayReminder.subject','les membres ont leur anniversaire aujourd\'hui','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18924,0,'fr','email','BirthdayReminder.text','Les membres de l\'équipe suivants fêtent leur anniversaire aujourd\'hui','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18925,0,'fr','email','BirthdayReminder.action','Aller au tableau de bord','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18926,0,'fr','email','BirthdayReminder.birthdayNotification','avoir un anniversaire','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18927,0,'fr','email','BirthdayReminder.birthdayNotificationText','d\'autres fêtent leur anniversaire','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18928,0,'fr','email','twoFactor.line1','Votre code d\'authentification à deux facteurs est','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18929,0,'fr','email','twoFactor.line2','Le code expirera dans 10 minutes','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18930,0,'fr','email','twoFactor.line3','Si vous n\'avez pas essayé de vous connecter, ignorez ce message.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18931,0,'fr','email','newCustomer.subject','Enregistrement d\'un nouveau client','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18932,0,'fr','email','newCustomer.text','Un nouveau client a été enregistré.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18933,0,'fr','email','footer','Si vous rencontrez des difficultés pour cliquer sur le bouton \":actionText\", veuillez copier et coller l\'URL ci-dessous dans votre navigateur Web :','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18934,0,'fr','email','productPurchase.subject','Achat d\'un nouveau produit','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18935,0,'fr','email','productPurchase.text','Un nouvel achat de produit a été effectué. Connectez-vous maintenant pour voir l\'achat.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18936,0,'fr','email','productPurchase.action','Voir la facture','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18937,0,'fr','email','followUpReminder.subject','Urgent : Rappel de suivi','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18938,0,'fr','email','followUpReminder.nextFollowUpDate','Prochaine date de suivi','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18939,0,'fr','email','followUpReminder.action','Afficher les détails du suivi','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18940,0,'fr','email','followUpReminder.nextFollowUpTime','Prochaine heure de suivi','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18941,0,'fr','email','followUpReminder.followUpLead','Nom du prospect de suivi','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18942,0,'fr','email','followUpReminder.followUpLeadText','Vous avez un nouveau suivi','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18943,0,'fr','email','shiftScheduled.subject','Mise à jour de l\'horaire : vos quarts de travail ont été attribués','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18944,0,'fr','email','shiftChange.subject','Nouvelle demande de changement d\'équipe reçue','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18945,0,'fr','email','shiftChange.action','Aller à la liste des équipes','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18946,0,'fr','email','shiftChange.text','La demande de changement d\'équipe est reçue.','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18947,0,'fr','email','shiftChangeStatus.subject','Réponse à la demande de changement d\'équipe','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18948,0,'fr','email','shiftChangeStatus.text','Votre demande de changement d\'équipe est','2023-06-04 06:27:15','2023-06-04 06:42:01'),
(18949,0,'fr','email','newAppreciation.subject','Félicitations : vous avez été récompensé','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18950,0,'fr','email','newAppreciation.text','Vous avez été récompensé :award sur :award_at','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18951,0,'fr','email','newAppreciation.action','Afficher les détails de la récompense','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18952,0,'fr','email','attendanceReport.subject','Rapport de présence pour le mois de','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18953,0,'fr','email','attendanceReport.text','Veuillez trouver le rapport de présence en pièce jointe.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18954,0,'fr','email','trackerReminder.subject','Rappel de suivi du temps','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18955,0,'fr','email','trackerReminder.text','Vous avez oublié de démarrer le suivi du temps.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18956,0,'fr','email','trackerReminder.action','Afficher les tâches','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18957,0,'fr','email','holidays.subject','Nouveau jour férié créé','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18958,0,'fr','email','dailyTimelogReport.subject','Rapport Timelog pour la date','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18959,0,'fr','email','dailyTimelogReport.text','Veuillez trouver le rapport de chronométrage en pièce jointe.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18960,0,'fr','installer_messages','title','Installateur Laravel','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18961,0,'fr','installer_messages','next','L\'étape suivante','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18962,0,'fr','installer_messages','finish','Installer','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18963,0,'fr','installer_messages','welcome.title','Bienvenue à l\'installateur','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18964,0,'fr','installer_messages','welcome.message','Bienvenue dans l\'assistant de configuration.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18965,0,'fr','installer_messages','requirements.title','Exigences du serveur','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18966,0,'fr','installer_messages','permissions.title','Autorisations','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18967,0,'fr','installer_messages','environment.title','Configuration de la base de données','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18968,0,'fr','installer_messages','environment.save','Enregistrer .env','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18969,0,'fr','installer_messages','environment.success','Les paramètres de votre fichier .env ont été enregistrés.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18970,0,'fr','installer_messages','environment.errors','Impossible d\'enregistrer le fichier .env, veuillez le créer manuellement.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18971,0,'fr','installer_messages','install','Installer','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18972,0,'fr','installer_messages','final.title','Fini','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18973,0,'fr','installer_messages','final.finished','L\'application a été installée avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18974,0,'fr','installer_messages','final.exit','Cliquez ici pour quitter','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18975,0,'fr','installer_messages','checkPermissionAgain','Vérifiez à nouveau l\'autorisation','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18976,0,'fr','messages','fetchChat','Récupération des détails du chat.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18977,0,'fr','messages','confirm','Confirmer','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18978,0,'fr','messages','projectCodeRequired','Le champ du code court du projet est obligatoire.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18979,0,'fr','messages','changeLeaveStatusConfirmation','Voulez-vous vraiment changer le statut des congés.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18980,0,'fr','messages','updateSuccess','Mis à jour avec succés.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18981,0,'fr','messages','recordSaved','Enregistrement enregistré avec succès','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18982,0,'fr','messages','deleteSuccess','Supprimé avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18983,0,'fr','messages','checkDayHoliday','Choisissez au moins 1.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18984,0,'fr','messages','selectOfflineMethod','La méthode hors ligne est requise si vous sélectionnez hors ligne.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18985,0,'fr','messages','invoicePaymentError','Veuillez entrer le montant.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18986,0,'fr','messages','selectGateway','Mode de paiement requis.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18987,0,'fr','messages','invoiceDateError','Veuillez entrer la date.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18988,0,'fr','messages','addItem','Ajoutez au moins 1 élément.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18989,0,'fr','messages','cartEmpty','Votre panier est vide avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18990,0,'fr','messages','quantityNumber','La quantité doit être un nombre','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18991,0,'fr','messages','unitPriceNumber','Le prix unitaire doit être un nombre','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18992,0,'fr','messages','amountNumber','Le montant doit être un nombre.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18993,0,'fr','messages','itemBlank','Le nom de l\'élément ne peut pas être vide.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18994,0,'fr','messages','invalidRequest','requête invalide','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18995,0,'fr','messages','fileUploadedSuccessfully','Fichier téléchargé avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18996,0,'fr','messages','fileUploadIssue','Fichier non téléchargé. Veuillez contacter l\'administrateur','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18997,0,'fr','messages','issueStatusChanged','L\'état du problème a bien été modifié.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18998,0,'fr','messages','newTaskAddedToTheProject','Nouvelle tâche ajoutée au projet.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(18999,0,'fr','messages','timerStoppedSuccessfully','La minuterie s\'est arrêtée avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19000,0,'fr','messages','attendanceSaveSuccess','Présence enregistrée avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19001,0,'fr','messages','leadClientChangeSuccess','Lead changé dans le client avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19002,0,'fr','messages','adminCannotDelete','L\'utilisateur administrateur ne peut pas être supprimé.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19003,0,'fr','messages','roleCannotChange','Pour modifier le rôle de cet utilisateur, vous devez attribuer le même rôle à un autre utilisateur, puis vous connecter en tant que cet utilisateur pour le modifier','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19004,0,'fr','messages','roleAssigned','Rôles attribués avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19005,0,'fr','messages','emptyCartMessage','Votre panier est vide avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19006,0,'fr','messages','overwriteAttendanceTooltip','Cela supprimera la présence existante et créera un nouveau record de présence pour la durée sélectionnée','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19007,0,'fr','messages','leaveAssignSuccess','Congé attribué avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19008,0,'fr','messages','leaveTypeAdded','Type de congé enregistré.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19009,0,'fr','messages','reasonForLeaveRejection','Raison du refus de congé','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19010,0,'fr','messages','reasonForLeaveApproval','Raison de l\'approbation du congé','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19011,0,'fr','messages','importSuccess','Fichier importé avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19012,0,'fr','messages','newFileUploadedToTheProject','Nouveau fichier chargé dans le projet.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19013,0,'fr','messages','isAddedAsProjectMember','est ajouté en tant que membre du projet.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19014,0,'fr','messages','memberRemovedFromProject','Membre supprimé du projet avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19015,0,'fr','messages','milestoneSuccess','Jalon enregistré avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19016,0,'fr','messages','addedAsNewProject','ajouté en tant que nouveau projet.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19017,0,'fr','messages','projectArchiveSuccessfully','Projet archivé avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19018,0,'fr','messages','projectRevertSuccessfully','Projet annulé avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19019,0,'fr','messages','noMemberAddedToProject','Aucun membre ajouté à ce projet.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19020,0,'fr','messages','ticketReplySuccess','Réponse envoyée avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19021,0,'fr','messages','timeLogAdded','Heure enregistrée avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19022,0,'fr','messages','timelogAlreadyExist','Le journal de temps existe déjà pour cet utilisateur.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19023,0,'fr','messages','noConversation','Aucune conversation trouvée.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19024,0,'fr','messages','noUser','Aucun utilisateur trouvé.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19025,0,'fr','messages','norecordSaved','Aucune méthode de paiement hors ligne ajoutée.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19026,0,'fr','messages','agentRemoveSuccess','Agent supprimé avec succès.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19027,0,'fr','messages','templateUpdateSuccess','Mise à jour du modèle réussie.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19028,0,'fr','messages','notAnAuthorisedDevice','Il ne s\'agit pas d\'un appareil autorisé pour le pointage d\'entrée ou de sortie','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19029,0,'fr','messages','notAnValidLocation','Votre emplacement actuel n\'est pas dans la plage d\'horloge','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19030,0,'fr','messages','unAuthorisedUser','Vous n\'êtes pas un utilisateur autorisé.','2023-06-04 06:27:16','2023-06-04 06:42:01'),
(19031,0,'fr','messages','updatedProfile','Profil mis à jour.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19032,0,'fr','messages','taskUpdated','A marqué la tâche comme','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19033,0,'fr','messages','timerStartedTask','Démarrage du chronomètre pour la tâche','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19034,0,'fr','messages','timerStartedSuccessfully','La minuterie a démarré avec succès.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19035,0,'fr','messages','timerAlreadyRunning','Le minuteur est déjà en cours d\'exécution pour une tâche.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19036,0,'fr','messages','notificationRead','Notification marquée comme lue.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19037,0,'fr','messages','atleastOneValidation','Sélectionnez au moins 1 membre','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19038,0,'fr','messages','chooseProject','Choisissez un projet.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19039,0,'fr','messages','noRecordFound','Aucun enregistrement trouvé.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19040,0,'fr','messages','currencyConvertApiKeyUrl','Obtenir la clé API par cette URL','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19041,0,'fr','messages','exchangeRateNote','Le taux de change est calculé à partir de votre devise par défaut. Modifiez la devise par défaut dans les paramètres de l\'application.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19042,0,'fr','messages','earningChartNote','Les gains sont mentionnés dans votre devise de base.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19043,0,'fr','messages','noPendingLeadFollowUps','Pas de suivi en attente.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19044,0,'fr','messages','employeeDocsAllowedFormat','Formats de fichiers autorisés : jpg, png, gif, doc, docx, xls, xlsx, pdf, txt.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19045,0,'fr','messages','noFileUploaded','Aucun fichier téléchargé.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19046,0,'fr','messages','noLeadSourceAdded','Aucune source de plomb ajoutée.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19047,0,'fr','messages','noLeadStatusAdded','Aucun statut de prospect ajouté.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19048,0,'fr','messages','selectMultipleDates','Vous pouvez sélectionner plusieurs dates.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19049,0,'fr','messages','sweetAlertTitle','Es-tu sûr?','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19050,0,'fr','messages','unArchiveMessage','Voulez-vous restaurer ce projet.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19051,0,'fr','messages','confirmRevert','Oui, restaurez-le!','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19052,0,'fr','messages','confirmNoArchive','Non, annulez s\'il vous plait !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19053,0,'fr','messages','confirmNo','Non je t\'en prie!','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19054,0,'fr','messages','archiveMessage','Voulez-vous archiver ce projet.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19055,0,'fr','messages','confirmArchive','Oui, archivez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19056,0,'fr','messages','noInvoice','Aucune facture créée.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19057,0,'fr','messages','noClientAddedToProject','Aucun client affecté au projet.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19058,0,'fr','messages','noAgentAdded','Aucun agent ajouté.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19059,0,'fr','messages','noTemplateFound','Aucun modèle trouvé.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19060,0,'fr','messages','noTicketTypeAdded','Aucun type de ticket ajouté.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19061,0,'fr','messages','pleaseEnterSomeData','Veuillez saisir quelques données pour enregistrer les paiements groupés.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19062,0,'fr','messages','paymentTypeNotFound','Type de paiement introuvable','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19063,0,'fr','messages','noSubTaskFound','Il semble qu\'aucune sous-tâche n\'existe dans la base de données. Veuillez d\'abord créer la sous-tâche','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19064,0,'fr','messages','noActivityByThisUser','Aucune activité de l\'utilisateur.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19065,0,'fr','messages','noClientAdded','Aucun client ajouté.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19066,0,'fr','messages','confirmDelete','Oui, supprimez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19067,0,'fr','messages','confirmRemove','Oui, supprimez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19068,0,'fr','messages','confirmSend','Oui, envoyez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19069,0,'fr','messages','creditText','Lors de la création d\'une note de crédit à partir d\'une facture non payée, le montant total de la facture sera crédité. Êtes-vous sûr de vouloir créer la note de crédit ?','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19070,0,'fr','messages','confirmCreate','Oui, créez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19071,0,'fr','messages','invoiceText','Voulez-vous annuler la facture ?','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19072,0,'fr','messages','recoverRecord','Vous ne pourrez pas récupérer l\'enregistrement supprimé !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19073,0,'fr','messages','confirmPin','Oui, épinglez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19074,0,'fr','messages','confirmUnpin','Oui, détachez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19075,0,'fr','messages','projectPin','Vous voulez épingler ce projet !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19076,0,'fr','messages','removeAgentText','Cela supprimera l\'agent de la liste.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19077,0,'fr','messages','removeChannelText','Cela supprimera le type de canal de la liste.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19078,0,'fr','messages','removeGroupText','Cela supprimera le groupe de la liste.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19079,0,'fr','messages','removeTemplateText','Cela supprimera le modèle de la liste.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19080,0,'fr','messages','removeTicketText','Cela supprimera le type de ticket de la liste.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19081,0,'fr','messages','ticketText','Vous ne pourrez pas récupérer le ticket supprimé !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19082,0,'fr','messages','removeFileText','Vous ne pourrez pas récupérer le fichier supprimé !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19083,0,'fr','messages','markHolidayTitle','Voulez-vous vraiment marquer les jours sélectionnés comme jours fériés ?','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19084,0,'fr','messages','noteHolidayText','Remarque : Cela marquera tous les jours sélectionnés tout au long de l\'année comme jours fériés. Vous devrez les supprimer manuellement une fois ajoutés.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19085,0,'fr','messages','confirmSave','Oui, enregistrez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19086,0,'fr','messages','deleteInvoice','Vous ne pourrez pas récupérer la facture récurrente supprimée !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19087,0,'fr','messages','removeLead','Cela supprimera le statut du prospect de la liste.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19088,0,'fr','messages','deleteLeave','Vous ne pourrez pas récupérer le congé supprimé !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19089,0,'fr','messages','deleteLeaveType','Vous ne pourrez pas récupérer le type de congé supprimé !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19090,0,'fr','messages','removeMethodText','Cela supprimera le mode de paiement de la liste','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19091,0,'fr','messages','deleteProduct','Vous ne pourrez pas récupérer le produit supprimé !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19092,0,'fr','messages','deleteTask','Vous ne pourrez pas récupérer la tâche supprimée !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19093,0,'fr','messages','markCompleteTask','Il y a une sous-tâche incomplète dans cette tâche que vous voulez marquer comme terminée !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19094,0,'fr','messages','sendReminder','Voulez-vous envoyer un rappel à l\'employé affecté ?','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19095,0,'fr','messages','completeIt','Oui, complétez-le !','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19096,0,'fr','messages','noCategoryAdded','Aucune catégorie ajoutée','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19097,0,'fr','messages','incorrectPassword','Mot de passe incorrect','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19098,0,'fr','messages','passwordMatched','Mot de passe correspondant','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19099,0,'fr','messages','departmentName','Le nom du département est requis','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19100,0,'fr','messages','departmentUniq','Le nom du département a déjà été pris.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19101,0,'fr','messages','unitTypeAdded','Type d\'unité ajouté avec succès','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19102,0,'fr','messages','estimateTemplateDeleted','Modèle d\'estimation supprimé','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19103,0,'fr','messages','estimateTemplateCreated','Modèle d\'estimation créé','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19104,0,'fr','messages','estimateTemplateUpdated','Modèle d\'estimation mis à jour','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19105,0,'fr','messages','clientFinanceCount','Ce client a :projectCount :project, :invoiceCount :invoice, :estimateCount :estimate, :paymentCount :payment .','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19106,0,'fr','messages','signatureAdded','Signature ajoutée avec succès','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19107,0,'fr','messages','endTimeAfterOrEqual','L\'heure de fin doit être postérieure ou égale à l\'heure de début.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19108,0,'fr','messages','atleastOneRole','Sélectionnez au moins 1 rôle.','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19109,0,'fr','messages','selectOccassion','Si l\'occasion n\'est pas sélectionnée, le nom du jour coché sera le nom de l\'occasion','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19110,0,'fr','messages','clientFilterVerification','Filtre client selon vérification','2023-06-04 06:27:17','2023-06-04 06:42:01'),
(19111,0,'fr','messages','welcome.message','Bienvenue dans l\'assistant de configuration','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19112,0,'fr','messages','welcome.title','Bienvenue dans l\'installateur','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19113,0,'fr','messages','title','Installateur Laravel','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19114,0,'fr','messages','next','Suivant','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19115,0,'fr','messages','finish','Installer','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19116,0,'fr','messages','final.title','Finalisé.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19117,0,'fr','messages','final.finished','L\'application a été installée avec succès !','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19118,0,'fr','messages','final.exit','Cliquez ici pour quitter.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19119,0,'fr','messages','currency.currencyPosition','Cela contrôle la position du symbole monétaire. comme 1 $ ou 1 $ ou 1 $ ou 1 $','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19120,0,'fr','messages','currency.thousandSeparator','Cela définit le séparateur de milliers des prix affichés. comme 10 000 $ ou 1 000 000 $','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19121,0,'fr','messages','currency.decimalSeparator','Cela définit le séparateur décimal des prix affichés. comme 10,00 $ ou 10,00 $','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19122,0,'fr','messages','currency.numberOfdecimals','Ceci définit le nombre de décimales affichées dans les prix affichés. comme 10,00 $ ou 10 000 $','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19123,0,'fr','messages','noGroupAdded','Aucun groupe ajouté.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19124,0,'fr','messages','noRoleFound','Aucun rôle trouvé.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19125,0,'fr','messages','noLeaveTypeAdded','Aucun type de congé ajouté.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19126,0,'fr','messages','updateAlert','Ne cliquez pas sur le bouton Mettre à jour maintenant si l\'application est personnalisée. Vos modifications seront perdues.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19127,0,'fr','messages','updateBackupNotice','Effectuez une sauvegarde des fichiers et de la base de données avant la mise à jour.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19128,0,'fr','messages','fieldBlank','Le champ ne peut pas être vide.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19129,0,'fr','messages','defaultRoleCantDelete','Le rôle par défaut ne peut pas être supprimé.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19130,0,'fr','messages','reminderMailSuccess','Courrier de rappel envoyé avec succès.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19131,0,'fr','messages','smtpError','Vos informations SMTP ne sont pas correctes. Veuillez mettre à jour pour corriger un','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19132,0,'fr','messages','smtpSuccess','Vos informations SMTP sont correctes','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19133,0,'fr','messages','smtpSecureEnabled','Pour la configuration SMTP de Gmail, veuillez suivre le lien suivant','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19134,0,'fr','messages','smtpNotSet','Vous n\'avez pas configuré les paramètres SMTP. Vous pouvez obtenir une erreur lors de l\'ajout d\'informations','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19135,0,'fr','messages','addStripeWebhookUrlHelpVisit1','Visitez <a href=\"https://dashboard.stripe.com/account/webhooks\" target=\"_blank\">Générer</a> Ajoutez un point de terminaison comme ci-dessus l\'url et entrez la clé webhook générée','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19136,0,'fr','messages','addStripeWebhookUrlHelpVisit2','Sélectionnez l\'événement <b>invoice.payment_failed, facture.payment_succeeded , payment_intent.succeeded</b> et <b>payment_intent.payment_failed</b> lors de la création du webhook.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19137,0,'fr','messages','addPaypalWebhookUrl','Ajoutez cette URL de webhook dans les paramètres de votre application paypal.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19138,0,'fr','messages','addFlutterwaveWebhookUrl','Ajoutez cette URL de webhook dans les paramètres de votre application Flutterwave.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19139,0,'fr','messages','addSquareWebhookUrl','Ajoutez cette URL de webhook dans les paramètres de votre application carrée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19140,0,'fr','messages','addRazorpayWebhookUrl','Ajoutez cette URL de webhook dans les paramètres de votre application razorpay.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19141,0,'fr','messages','addPaystackWebhookUrl','Ajoutez cette URL de webhook dans les paramètres de votre application Paystack.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19142,0,'fr','messages','addPaystackCallbackUrl','Ajoutez cette URL de rappel dans les paramètres de votre application Paystack.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19143,0,'fr','messages','gdprUpdated','Paramètre GDPR mis à jour avec succès','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19144,0,'fr','messages','invoiceCanNotDeleted','Demande invalide Vous ne pouvez pas supprimer cette facture','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19145,0,'fr','messages','addDiscussion','Message envoyé avec succès.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19146,0,'fr','messages','creditNoteAppliedSuccessfully','Note de crédit appliquée avec succès.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19147,0,'fr','messages','pleaseEnterCreditAmount','Entrez au moins un montant de crédit.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19148,0,'fr','messages','creditNoteCanNotDeleted','La note de crédit ne peut pas être supprimée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19149,0,'fr','messages','noLeadAgentAdded','Aucun agent principal ajouté.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19150,0,'fr','messages','selectProduct','Veuillez sélectionner au moins un produit.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19151,0,'fr','messages','noLeadAgent','Aucun agent principal trouvé','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19152,0,'fr','messages','noCommentFound','Aucun commentaire trouvé.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19153,0,'fr','messages','noNoteFound','Aucune note trouvée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19154,0,'fr','messages','leaveApplySuccess','Congé appliqué avec succès.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19155,0,'fr','messages','leaveApplyError','Congé déjà appliqué pour la date sélectionnée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19156,0,'fr','messages','holidayLeaveApplyError','Vous ne pouvez pas demander un congé un jours fériés.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19157,0,'fr','messages','errorOccured','Une erreur s\'est produite.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19158,0,'fr','messages','noNotification','pas de nouvelles notifications','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19159,0,'fr','messages','addGoogleCallback','Ajoutez cette URL de rappel dans les paramètres de votre application Google.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19160,0,'fr','messages','addFacebookCallback','Ajoutez cette URL de rappel dans les paramètres de votre application Facebook.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19161,0,'fr','messages','addLinkedinCallback','Ajoutez cette URL de rappel dans les paramètres de votre application LinkedIn.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19162,0,'fr','messages','addTwitterCallback','Ajoutez cette URL de rappel dans les paramètres de votre application Twitter.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19163,0,'fr','messages','clockOutTimeError','L\'heure de sortie ne peut pas être inférieure à l\'heure d\'arrivée','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19164,0,'fr','messages','leaveTypeValueError','Le nombre de congés doit être supérieur ou égal à zéro','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19165,0,'fr','messages','maxClockin','Nombre maximal d\'enregistrements atteint.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19166,0,'fr','messages','attendanceMarked','La présence a déjà été marquée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19167,0,'fr','messages','amountIsZero','Le montant doit être supérieur à ZÉRO pour le paiement','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19168,0,'fr','messages','taskAfterDateValidation','La date de fin de la tâche ne doit pas être inférieure à la date de début de la tâche','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19169,0,'fr','messages','taskBeforeDateValidation','La date de fin de la tâche ne doit pas être supérieure à la date de fin des jalons','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19170,0,'fr','messages','noProductSubCategoryAdded','Aucune sous-catégorie de produit ajoutée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19171,0,'fr','messages','pinnedSuccess','Épinglé avec succès','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19172,0,'fr','messages','noInvoiceFound','Il semble qu\'aucune facture n\'ait été générée.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19173,0,'fr','messages','noClientFound','Il semble qu\'aucun client n\'existe. Veuillez d\'abord créer le client','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19174,0,'fr','messages','noTaskFound','Il semble qu\'aucune tâche n\'existe. Veuillez d\'abord créer la tâche','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19175,0,'fr','messages','noTaskFilesFound','On dirait qu\'aucun fichier de tâche n\'a été téléchargé.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19176,0,'fr','messages','noEmployeesFound','Il semble qu\'aucun employé n\'existe. Veuillez d\'abord créer l\'employé','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19177,0,'fr','messages','noEstimatesFound','Il semble qu\'aucune estimation n\'existe. Veuillez d\'abord créer le devis','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19178,0,'fr','messages','noInvoicesFound','Il semble qu\'aucune facture n\'existe. Veuillez d\'abord créer la facture','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19179,0,'fr','messages','noExpensesFound','Il semble qu\'aucune dépense n\'existe. Veuillez d\'abord créer la dépense','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19180,0,'fr','messages','noTicketsFound','Il semble qu\'aucun ticket n\'existe.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19181,0,'fr','messages','noLeadFound','Il semble qu\'aucune piste n\'existe. Veuillez d\'abord créer les pistes','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19182,0,'fr','messages','noNoticeFound','Il semble qu\'aucun avis n\'existe.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19183,0,'fr','messages','noLeavesFound','Il semble qu\'aucune feuille n\'existe.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19184,0,'fr','messages','noProjectAssigned','Aucun projet ne vous est attribué.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19185,0,'fr','messages','noAttendanceDetailTOday','Pas de détail de fréquentation pour aujourd\'hui.','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19186,0,'fr','messages','noSpacePlease','Pas d\'espace s\'il vous plait !','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19187,0,'fr','messages','confirmation.createCreditNotes','Êtes-vous sûr de vouloir créer la note de crédit ?','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19188,0,'fr','messages','confirmation.orderStatusChange','Voulez-vous vraiment modifier le statut de la commande ?','2023-06-04 06:27:18','2023-06-04 06:42:01'),
(19189,0,'fr','messages','confirmation.rejectConfirm','Oui, rejeter','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19190,0,'fr','messages','invoiceSentSuccessfully','Facture envoyée avec succès','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19191,0,'fr','messages','invoiceMarkAsSent','Marquer la facture comme envoyée avec succès','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19192,0,'fr','messages','deleteField','Vous ne pourrez pas récupérer le champ supprimé !','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19193,0,'fr','messages','confirmCancel','Confirmer Annuler !','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19194,0,'fr','messages','estimateCancelText','Voulez-vous annuler cette estimation !','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19195,0,'fr','messages','selectAction','Sélectionnez l\'action','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19196,0,'fr','messages','notEnoughData','Pas assez de données','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19197,0,'fr','messages','newMilestoneCreated','Nouvelle étape créée','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19198,0,'fr','messages','milestoneUpdated','Jalon mis à jour','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19199,0,'fr','messages','milestoneDeleted','Jalon supprimé','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19200,0,'fr','messages','selectConversation','Sélectionnez une conversation pour envoyer un message','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19201,0,'fr','messages','discountExceed','La remise ne peut pas être supérieure au montant total.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19202,0,'fr','messages','proposalSendSuccess','Proposition envoyée avec succès.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19203,0,'fr','messages','proposalMarkAsSent','Marquer la proposition comme envoyée avec succès','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19204,0,'fr','messages','totalTimeZero','L\'heure de fin doit être supérieure à l\'heure de début.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19205,0,'fr','messages','contractRenewSuccess','Contrat renouvelé avec succès.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19206,0,'fr','messages','signatureRequired','La signature est requise.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19207,0,'fr','messages','estimateSigned','Devis accepté avec succès.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19208,0,'fr','messages','adminPermissionError','Les autorisations d\'administrateur ne peuvent pas être modifiées.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19209,0,'fr','messages','newEmployeeInfo','Selon date d\'adhésion.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19210,0,'fr','messages','leaveInfo','Selon date de congé.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19211,0,'fr','messages','employeeExitInfo','Selon date de sortie.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19212,0,'fr','messages','unresolveTicketInfo','Tickets avec le statut En attente ou Ouvert.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19213,0,'fr','messages','unassignTicketInfo','Tickets qui ne sont pas attribués à l\'agent.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19214,0,'fr','messages','themeChangesReset','Toutes les modifications de thème personnalisé seront réinitialisées.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19215,0,'fr','messages','permissionDenied','Permission refusée.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19216,0,'fr','messages','accessDenied','Accès refusé.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19217,0,'fr','messages','forbidden','Interdit','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19218,0,'fr','messages','pageNotFound','Page non trouvée.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19219,0,'fr','messages','404Title','Erreur 404 (introuvable)','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19220,0,'fr','messages','inviteEmailSuccess','Invitation envoyée avec succès.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19221,0,'fr','messages','acceptInviteError','Invitation invalide. Vous n\'êtes pas autorisé à vous inscrire.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19222,0,'fr','messages','signupSuccess','Inscrivez-vous avec succès. Vous serez redirigé vers votre tableau de bord dans un moment','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19223,0,'fr','messages','inviteLinkSuccess','Lien d\'invitation créé avec succès.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19224,0,'fr','messages','installingUpdateMessage','Installation... Veuillez patienter (cela peut prendre quelques minutes.)','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19225,0,'fr','messages','installedUpdateMessage','Installé avec succès. Recharger la page pour voir les changements.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19226,0,'fr','messages','consentOptIn','Acceptation du consentement réussie.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19227,0,'fr','messages','consentOptOut','Désactivation du consentement réussie.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19228,0,'fr','messages','inviteInfo','Les employés recevront un e-mail pour se connecter et mettre à jour leur profil via le portail en libre-service.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19229,0,'fr','messages','taskDependentDate','La date d\'échéance de la tâche dépendante ne peut pas être postérieure.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19230,0,'fr','messages','assignClientFirst','Vous devez affecter un client au projet.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19231,0,'fr','messages','invalidOrInactiveAccount','E-mail introuvable ou compte inactif. Merci de consulter vos emails.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19232,0,'fr','messages','viewKey','Cliquez ici pour voir la clé','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19233,0,'fr','messages','testMailSentSuccessfully','E-mail de test envoyé avec succès','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19234,0,'fr','messages','fileUploaded','Fichier téléchargé avec succès. Cliquez sur Afficher le fichier pour afficher le fichier téléchargé','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19235,0,'fr','messages','filesMoveToAwsSuccessfully','Fichiers déplacés avec succès vers AWS S3','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19236,0,'fr','messages','allFilesMovedtoAws','Tous les fichiers sont déjà déplacés vers AWS S3','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19237,0,'fr','messages','primaryColorRequired','La couleur primaire est requise.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19238,0,'fr','messages','settingModuleCannotBeDisabled','Le module de réglage ne peut pas être désactivé.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19239,0,'fr','messages','paymentSuccessful','Paiement réussi.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19240,0,'fr','messages','darkThemeRestrictionInfo','Les paramètres de couleur du thème ne fonctionneront pas lorsque le mode sombre est actif.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19241,0,'fr','messages','cronIsNotRunning','Il semble que votre tâche cron n\'a pas été exécutée au cours des dernières 48 heures. Veuillez vérifier qu\'il est correctement configuré. Ce message disparaîtra automatiquement une fois que la tâche cron fonctionnera à nouveau correctement.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19242,0,'fr','messages','resolveTicketInfo','Tickets avec le statut Fermé ou Résolu.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19243,0,'fr','messages','invoicePaymentExceedError','Le montant du paiement ne peut pas être supérieur au montant dû de la facture.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19244,0,'fr','messages','paymentFailed','Paiement échoué.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19245,0,'fr','messages','invalidPayload','Charge utile invalide.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19246,0,'fr','messages','invalidSignature','Signature non valide.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19247,0,'fr','messages','webhookHandled','Webhook géré.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19248,0,'fr','messages','projectDetailsNotAdded','Détails du projet non ajoutés.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19249,0,'fr','messages','inviteLinkCopied','Lien d\'invitation copié.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19250,0,'fr','messages','unsentInvoiceInfo','La facture ne peut pas être payée tant que la facture n\'est pas envoyée au client.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19251,0,'fr','messages','selectCustomerForBillingAddress','Sélectionnez le client pour afficher l\'adresse de facturation.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19252,0,'fr','messages','invoicesWidgetMessage','Les factures sont présentées sur la base de la date de création des factures.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19253,0,'fr','messages','estimatesWidgetMessage','Les estimations sont présentées sur la base de la date d\'échéance des estimations.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19254,0,'fr','messages','proposalsWidgetMessage','Les propositions sont présentées sur la base de la date de création.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19255,0,'fr','messages','holidayDataNotFound','Données introuvables pour marquer les jours fériés.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19256,0,'fr','messages','codeSent','Code de vérification à deux facteurs envoyé par e-mail.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19257,0,'fr','messages','codeNotMatch','Le code à deux facteurs que vous avez entré ne correspond pas.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19258,0,'fr','messages','resendCode','Vous avez reçu un e-mail contenant un code de connexion à deux facteurs. Si vous ne l\'avez pas reçu,','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19259,0,'fr','messages','noConsentFound','Aucun consentement trouvé.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19260,0,'fr','messages','proposalInfo','Les propositions sont pour les prospects. Si vous souhaitez créer pour des clients existants, créez une estimation.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19261,0,'fr','messages','twoFaAppInfo','Entrez le code de l\'application à deux facteurs sur votre appareil mobile. Si vous avez perdu votre appareil, vous pouvez saisir l\'un de vos codes de récupération.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19262,0,'fr','messages','sessionDeleteConfirmation','Tous les utilisateurs connectés seront déconnectés.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19263,0,'fr','messages','requiredForLogin','Ce champ est requis pour la connexion de l\'utilisateur.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19264,0,'fr','messages','showHidePurchaseCode','Afficher ou masquer le code d\'achat','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19265,0,'fr','messages','changePurchaseCode','Modifier le code d\'achat','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19266,0,'fr','messages','enable2FAUsingEmail','L\'activation de cette fonctionnalité enverra un code sur votre compte de messagerie <b>:email</b> pour vous connecter.','2023-06-04 06:27:19','2023-06-04 06:42:01'),
(19267,0,'fr','messages','enable2FAUsingAuthenticator','Utilisez l\'application Authenticator pour obtenir des codes de vérification gratuits, même lorsque votre téléphone est hors ligne. Disponible pour Androïd et iPhone.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19268,0,'fr','messages','approvalWarning','L\'utilisateur pourra accéder au compte.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19269,0,'fr','messages','invalid2FaCode','Code 2FA invalide.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19270,0,'fr','messages','downloadFilefromCodecanyon','Téléchargez le fichier zip de codecanyon et téléchargez-le ici. Seul le type de fichier .zip est autorisé pour le téléchargement.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19271,0,'fr','messages','phpUpdateRequired','La mise à jour de la version PHP est requise','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19272,0,'fr','messages','invalidEmailFormat','Format d\'email invalide.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19273,0,'fr','messages','calculateTaxBeforeDiscount','Remarque : La taxe est calculée avant la remise.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19274,0,'fr','messages','calculateTaxAfterDiscount','Remarque : la taxe est calculée après remise.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19275,0,'fr','messages','fileFormat.ImageFile','seuls les formats .jpg, .jpeg, .png, .svg sont autorisés.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19276,0,'fr','messages','fileFormat.multipleImageFile','seuls les formats .txt, .pdf, .doc, .xls, .xlsx, .docx, .rtf, .png, .jpg, .jpeg sont autorisés.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19277,0,'fr','messages','leaveFileMessage','Vous pouvez joindre le reçu de l\'ordonnance, de la visite chez le médecin ou du document de voyage, etc.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19278,0,'fr','messages','matchColumnMessage','Veuillez trier les données que vous avez téléchargées en faisant correspondre les colonnes du CSV aux champs des champs associés.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19279,0,'fr','messages','columnMatchSuccess','<strong>Bien joué !</strong> Vous avez réussi à faire correspondre toutes les colonnes. Veuillez cliquer sur soumettre pour enregistrer.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19280,0,'fr','messages','requiredColumnsUnmatched','Les champs suivants sont obligatoires et doivent correspondre : <strong>:columns</strong>','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19281,0,'fr','messages','unmatchedColumns','<span id=\"unmatchedCount\">:unmatchCount</span> colonnes sans correspondance.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19282,0,'fr','messages','pleaseSelectAColumn','Veuillez sélectionner une colonne ou cliquer sur sauter','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19283,0,'fr','messages','pleaseSelectCategory','Veuillez sélectionner une catégorie','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19284,0,'fr','messages','importUploadSuccess','Données téléchargées avec succès.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19285,0,'fr','messages','importProcessStart','Le processus d\'importation a commencé. S\'il vous plaît, attendez.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19286,0,'fr','messages','confirmResetPermission','Cela réinitialisera les autorisations pour tous les utilisateurs avec ce rôle. Voulez-vous réinitialiser ?','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19287,0,'fr','messages','invoiceDueOn','Facture due le','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19288,0,'fr','messages','googleCalendar.confirmRemove','Voulez-vous vraiment désactiver Google Agenda ?','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19289,0,'fr','messages','googleCalendar.yesRemove','Oui, supprimez-le !','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19290,0,'fr','messages','googleCalendar.removedSuccess','Google Agenda a bien été supprimé.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19291,0,'fr','messages','googleCalendar.AuthorizedRedirectURI','URI de redirection autorisés','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19292,0,'fr','messages','googleCalendar.AuthorizedRedirectURIInfoMessage','Les utilisateurs seront redirigés vers ce chemin après s\'être authentifiés auprès de Google. Le chemin sera ajouté avec le code d\'autorisation d\'accès et doit avoir un protocole. Il ne peut pas contenir de fragments d\'URL, de chemins relatifs ou de caractères génériques, et ne peut pas être une adresse IP publique.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19293,0,'fr','messages','googleCalendar.addGoogleCalendarUrl','Ajoutez cet URI de redirection à votre console Google','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19294,0,'fr','messages','googleCalendar.notificationTitle','Paramètres de notification','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19295,0,'fr','messages','googleCalendar.verifiedSuccess','Les paramètres de l\'agenda Google ont bien été vérifiés.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19296,0,'fr','messages','googleCalendar.updatedSuccess','Les paramètres du calendrier Google ont été mis à jour avec succès.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19297,0,'fr','messages','databasebackup.note','Remarque : En raison du temps d\'exécution limité et de la mémoire disponible pour PHP, la sauvegarde de bases de données très volumineuses peut ne pas être possible. Si votre base de données est très volumineuse, vous devrez peut-être effectuer une sauvegarde directement à partir de votre serveur SQL via la ligne de commande, ou demander à votre administrateur de serveur de le faire pour vous si vous ne disposez pas des privilèges root.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19298,0,'fr','messages','databasebackup.backupNotExist','Le fichier de sauvegarde n\'existe pas.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19299,0,'fr','messages','databasebackup.backupDeleted','Sauvegarde supprimée avec succès !','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19300,0,'fr','messages','databasebackup.backedupSuccessful','La sauvegarde de la base de données a été ajoutée à la file d\'attente. Il commencera à apparaître ici une fois que la prochaine tâche cron aura été exécutée avec succès.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19301,0,'fr','messages','databasebackup.databaseError','erreur de la base de données','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19302,0,'fr','messages','databasebackup.createDatabaseBackupAlert','Voulez-vous vraiment créer une sauvegarde de base de données !','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19303,0,'fr','messages','databasebackup.confirmCreateDatabaseBackup','Oui, créez-le !','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19304,0,'fr','messages','databasebackup.info','Remarque : Créer une sauvegarde tous les :everyDayCount jours à :time, supprimer automatiquement les sauvegardes de plus de :olderDayCount jours (définir -1 pour désactiver)','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19305,0,'fr','messages','notAllowedToAssignAdminPermission','Vous n\'êtes pas autorisé à attribuer un rôle d\'administrateur.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19306,0,'fr','messages','downloadable','Le produit téléchargeable donne accès à un fichier lors de l\'achat','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19307,0,'fr','messages','invalidData','Données invalides :','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19308,0,'fr','messages','invalidDate','Format de date non valide :','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19309,0,'fr','messages','duplicateEntryForEmail','Entrée en double pour l\'e-mail :','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19310,0,'fr','messages','duplicateEntryForEmployeeId','Entrée en double pour l\'ID d\'employé :','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19311,0,'fr','messages','employeeNotFound','Employé introuvable','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19312,0,'fr','messages','dragDropScreenInfo','Le glisser-déposer ne fonctionnera que sur les appareils de bureau.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19313,0,'fr','messages','timerPausedSuccessfully','La minuterie s\'est interrompue avec succès.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19314,0,'fr','messages','orderStatusChanged','Le statut de la commande a bien été modifié.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19315,0,'fr','messages','orderStatus.pending','La commande en attente est prête à percevoir le paiement.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19316,0,'fr','messages','orderStatus.onHold','La commande en attente attend le paiement ou le paiement est en attente.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19317,0,'fr','messages','orderStatus.failed','La commande échouée n\'a pas pu percevoir le paiement.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19318,0,'fr','messages','orderStatus.processing','La commande de traitement est en cours.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19319,0,'fr','messages','orderStatus.completed','La commande complétée créera la facture et le paiement de la commande.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19320,0,'fr','messages','orderStatus.canceled','La commande annulée est annulée et ne peut pas être traitée.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19321,0,'fr','messages','orderStatus.refunded','La commande remboursée créera un avoir de la commande.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19322,0,'fr','messages','employeeEmergencyContact','Contact d\'urgence enregistré avec succès.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19323,0,'fr','messages','sameCurrencyInvoiceNote','Seules les factures dans la même devise s\'afficheront ici.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19324,0,'fr','messages','alreadySigned','Déjà signé','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19325,0,'fr','messages','invoiceAlreadyPaid','Facture déjà payée','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19326,0,'fr','messages','currencyExchangeKeyNotFound','Clé du convertisseur de devises introuvable','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19327,0,'fr','messages','noUnpaidInvoiceFound','Aucune facture impayée trouvée.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19328,0,'fr','messages','leaveLimitError','Limite de congé dépassée pour le type de congé sélectionné.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19329,0,'fr','messages','remainingLeaveError','Seulement :leave congé restant pour le type de congé sélectionné.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19330,0,'fr','messages','multipleRemainingLeaveError','Seulement :leaves congés restantes pour le type de congé sélectionné.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19331,0,'fr','messages','monthlyLeaveLimitError','Limite de congé mensuel dépassée pour le type de congé sélectionné.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19332,0,'fr','messages','employeeShiftAdded','Quart de travail de l\'employé enregistré.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19333,0,'fr','messages','removeShiftText','Tous les employés liés à ce quart de travail seront déplacés vers le quart de travail par défaut.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19334,0,'fr','messages','defaultLanguageCantChange','Pour modifier la langue par défaut, veuillez naviguer vers le :appsettings. La langue actuelle est définie par défaut.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19335,0,'fr','messages','defaultEnLanguageCantChange','La modification de la langue anglaise n\'est pas autorisée, mais peut être activée/désactivée.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19336,0,'fr','messages','requestSubmitSuccess','Demande soumise avec succès.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19337,0,'fr','messages','existingShiftOverride','Le décalage existant sera remplacé.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19338,0,'fr','messages','leadFollowUpRestricted','Le suivi est désactivé pour cet utilisateur.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19339,0,'fr','messages','clockInNotAllowed','Horloge non autorisée.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19340,0,'fr','messages','roleNotAssigned','Le rôle n\'est pas attribué.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19341,0,'fr','messages','archivedTaskNotWork','Vous ne pourrez pas effectuer d\'action sur les tâches de projet archivées.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19342,0,'fr','messages','totalEmployeeInfo','Nombre total d\'employés dans l\'entreprise. Filtre de date non appliqué.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19343,0,'fr','messages','dateFilterNotApplied','Filtre de date non appliqué.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19344,0,'fr','messages','youAreOnLeave','Vous êtes en congé aujourd\'hui.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19345,0,'fr','messages','holidayToday','Aujourd\'hui est un jour ferié.','2023-06-04 06:27:20','2023-06-04 06:42:01'),
(19346,0,'fr','messages','languageEnabledAlertMessage','Le simple fait d\'activer un paramètre de langue ne changera pas automatiquement la langue. Pour changer efficacement de langue, vous devez également disposer de traductions disponibles dans cette langue spécifique.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19347,0,'fr','messages','mailSettingSelectMessage','Nous vous recommandons d\'utiliser <b>SMTP</b>. Les paramètres de messagerie peuvent ne pas fonctionner sur tous les serveurs, ce qui entraîne également l\'arrivée d\'e-mails dans le SPAM. Veuillez également vérifier l\'e-mail de test si votre serveur de messagerie fonctionne ou non','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19348,0,'fr','messages','customPermissionError','Les autorisations ont été personnalisées pour cet utilisateur.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19349,0,'fr','messages','congratulationNewAward','Félicitations pour le prix :award','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19350,0,'fr','messages','appreciationPhoto','Photo prise lors de la remise du prix','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19351,0,'fr','messages','disableIt','Il inactif','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19352,0,'fr','messages','recoverAwardRecord','Vous avez :employeeCount employés récompensés par ce prix. Vous ne pourrez pas récupérer l\'enregistrement des employés supprimés !','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19353,0,'fr','messages','loginDetailsEmailed','Les informations de connexion seront envoyées par e-mail à cet e-mail','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19354,0,'fr','messages','notAllowedToDeleteCurrency','Vous n\'êtes pas autorisé à supprimer cette devise car elle a été utilisée ailleurs.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19355,0,'fr','messages','appNameToolTip','Cela sera visible en haut de la barre latérale gauche et sur la page de connexion','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19356,0,'fr','messages','brandingStyleToolTip','Le style de marque ci-dessous fonctionnera pour le haut de la barre latérale gauche et sur la page de connexion.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19357,0,'fr','messages','darkThemeLogoTooltip','Ce logo s\'affichera lorsque vous changerez le thème en mode sombre','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19358,0,'fr','messages','lightThemeLogoTooltip','Ce logo s\'affichera lorsque vous changerez le thème en mode clair','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19359,0,'fr','messages','configureCurrencyConverterKey','Vous devez d\'abord configurer la clé du convertisseur de devises pour récupérer le dernier taux de change. :link pour ajouter la clé','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19360,0,'fr','messages','noticePeriodMessage','La période de préavis se termine le','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19361,0,'fr','messages','probationMessage','La probation se termine le','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19362,0,'fr','messages','internshipMessage','Le stage se termine le','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19363,0,'fr','messages','contractMessage','Le contrat se termine le','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19364,0,'fr','messages','probationEndDate','Entrez la date de fin à laquelle la période d\'essai de l\'employé va se terminer et il/elle va faire partie de l\'entreprise de façon permanente','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19365,0,'fr','messages','noticePeriodStartDate','Entrez la date de début à laquelle un employé sera dans la période de préavis avant de quitter l\'entreprise','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19366,0,'fr','messages','noticePeriodEndDate','Entrez la date de fin à laquelle un employé sera en période de préavis avant de quitter l\'entreprise','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19367,0,'fr','messages','googleMapMessage','Vous devez ajouter Google Map Key pour voir les cartes ici et localiser votre emplacement directement sur la carte. Visite','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19368,0,'fr','messages','googleMapRemove','Laisser vide pour supprimer la clé de carte Google','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19369,0,'fr','messages','googleMapTooltip','Vous pouvez ajouter l\'emplacement sur la carte dans <b>:route</b> une fois que le paramètre Google Map est configuré','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19370,0,'fr','messages','googleMapLocationAddedTooltip','Latitude et longitude ajoutées pour cette adresse','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19371,0,'fr','messages','invoiceLogoTooltip','Ce logo apparaîtra sur les factures (seuls les formats .jpg, .jpeg, .png sont autorisés)','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19372,0,'fr','messages','companyNameTooltip','Ajoutez le nom complet de votre entreprise. Le nom de l\'entreprise visible dans la barre latérale gauche sera modifié à partir du paramètre de thème','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19373,0,'fr','messages','defaultAddressInfo','Les modules de présence et autres utilisent l\'adresse professionnelle par défaut, mais lors de la création d\'enregistrements, vous avez la possibilité de sélectionner une adresse différente comme adresse par défaut.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19374,0,'fr','messages','bankTransactionSuccess','Succès de la transaction bancaire','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19375,0,'fr','messages','selectDate','Sélectionner une date','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19376,0,'fr','messages','pusherError','Les détails de votre poussoir ne sont pas corrects. Veuillez mettre à jour pour corriger un','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19377,0,'fr','messages','pusherSuccess','Les détails de votre Pusher sont corrects','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19378,0,'fr','messages','authorisedSignatorySignatureTooltip','Cette signature apparaîtra sur les factures payées (seuls les formats .jpg, .jpeg, .png sont autorisés). Cochez Afficher le signataire autorisé en bas de la page de configuration de la facture','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19379,0,'fr','messages','invoiceStatusShowTooltip','Cela affichera le statut de la facture (payé/non payé/partiellement payé) sur la facture pdf','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19380,0,'fr','messages','invoiceAuthorisedSignatoryShowTooltip','Cela montrera le signataire autorisé sur la facture pdf si la signature est téléchargée et que le statut de la facture est payé.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19381,0,'fr','messages','projectCopiedSuccessfully','Projet copié avec succès','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19382,0,'fr','messages','quickBooksCredentialsIncorrect','Les identifiants QuickBooks sont incorrects.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19383,0,'fr','messages','quickBooksConnectSuccess','Le compte QuickBooks est connecté.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19384,0,'fr','messages','cacheClear','Le cache a été effacé avec succès.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19385,0,'fr','messages','leadStatusChangeSuccess','Changement de statut du prospect réussi','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19386,0,'fr','messages','calculateTaskProgress','Nous calculons la progression à l\'achèvement de la tâche','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19387,0,'fr','messages','emailCannotChange','L\'e-mail ne peut pas être modifié car il est également enregistré auprès d\'autres sociétés.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19388,0,'fr','messages','accessDeniedMessage','Nous sommes désolés, mais il semble que le lien auquel vous tentiez d\'accéder a expiré. Cela peut être dû à diverses raisons, telles que le contenu supprimé ou mis à jour, le lien désactivé ou le lien ayant un délai d\'accès limité.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19389,0,'fr','messages','markSentInfo','Le client ne recevra aucun e-mail.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19390,0,'fr','messages','enableClientModule','Activez le module client pour accéder à cette section.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19391,0,'fr','messages','leave.allowedNotice','Cochez cette case si vous souhaitez autoriser les employés en <b>période de préavis</b> à demander des congés de ce type.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19392,0,'fr','messages','leave.allowedProbation','Cochez cette case si vous souhaitez autoriser les employés en <b>probation</b> à demander des congés de ce type.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19393,0,'fr','messages','leave.unusedLeave','Détermine comment les congés non utilisés sont traités à la fin de l\'année.<br><br><b>Report</b> : les congés non utilisés seront ajoutés aux congés de l\'année suivante.<br><br><b>Déchéance </b> : les congés non utilisés expireront simplement et aucune mesure ne sera prise.<br><br><b>Payé</b> : l\'employé recevra un salaire équivalent au nombre de jours de congés non utilisés.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19394,0,'fr','messages','leave.effectiveAfter','Ce type de congé sera effectif après le nombre de jours ou le nombre de mois d\'adhésion du salarié. <br><br>Laissez vide pour permettre à partir de la date d\'adhésion.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19395,0,'fr','messages','leave.gender','Le type de congé ne peut être utilisé que par les employés <b>Sexe</b> sélectionnés et les autres employés ne pourront pas demander de congé avec ce type de congé','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19396,0,'fr','messages','leave.maritalStatus','Le type de congé ne peut être utilisé que par les employés sélectionnés sous <b>état civil</b> et les autres employés ne pourront pas demander de congé avec ce type de congé','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19397,0,'fr','messages','leave.department','Le type de congé ne peut être utilisé que par les employés sélectionnés du <b>service</b> et les autres employés ne pourront pas demander de congé avec ce type de congé','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19398,0,'fr','messages','leave.designation','Le type de congé ne peut être utilisé que par les employés de <b>désignation</b> sélectionnés et les autres employés ne pourront pas demander de congé avec ce type de congé','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19399,0,'fr','messages','leave.role','Le type de congé ne peut être utilisé que par le <b>rôle</b> sélectionné et un autre rôle ne pourra pas postuler pour des congés avec ce type de congé','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19400,0,'fr','messages','leave.noOfLeaves','Nombre de congés de ce type accordés à chaque salarié par an. Par exemple, votre entreprise peut accorder 10 arrêts maladie par an','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19401,0,'fr','messages','leave.monthlyLimit','Le nombre maximum de congés de ce type qu\'un employé peut prendre par mois.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19402,0,'fr','messages','leave.paidStatus','Ce type de congé sera payé ou non payé pour tous les employés','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19403,0,'fr','messages','unitDeleteError','Vous ne pouvez pas supprimer cette unité car elle est associée à des éléments financiers et de produit. Dissociez l\'unité de tous les éléments et réessayez.','2023-06-04 06:27:21','2023-06-04 06:42:01'),
(19404,0,'fr','modules','dashboard.totalClients','Nombre total de clients','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19405,0,'fr','modules','dashboard.newClients','Nouveaux clients','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19406,0,'fr','modules','dashboard.totalEmployees','Total des employés','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19407,0,'fr','modules','dashboard.totalProjects','Projets totaux','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19408,0,'fr','modules','dashboard.newProjects','De nouveaux projets','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19409,0,'fr','modules','dashboard.totalPaidInvoices','Factures payées','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19410,0,'fr','modules','dashboard.totalTickets','Ticket d\'assistance','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19411,0,'fr','modules','dashboard.totalOpenTickets','Tickets ouverts','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19412,0,'fr','modules','dashboard.openTickets','Tickets ouverts','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19413,0,'fr','modules','dashboard.totalHoursLogged','Heures enregistrées','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19414,0,'fr','modules','dashboard.totalPendingTasks','Tâches en attente','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19415,0,'fr','modules','dashboard.totalCompletedTasks','Tâches terminées','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19416,0,'fr','modules','dashboard.totalPendingIssues','Nombre total de problèmes en attente','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19417,0,'fr','modules','dashboard.totalPaidAmount','Montant payé','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19418,0,'fr','modules','dashboard.totalOutstandingAmount','Encours','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19419,0,'fr','modules','dashboard.recentEarnings','Revenus récents','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19420,0,'fr','modules','dashboard.overdueTasks','Tâches en retard','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19421,0,'fr','modules','dashboard.pendingClientIssues','Questions en suspens','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19422,0,'fr','modules','dashboard.projectActivityTimeline','Chronologie des activités du projet','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19423,0,'fr','modules','dashboard.userActivityTimeline','Chronologie de l\'activité de l\'utilisateur','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19424,0,'fr','modules','dashboard.dueDate','Date d\'échéance','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19425,0,'fr','modules','dashboard.weatherSetLocation','Définir l\'emplacement actuel pour voir la météo','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19426,0,'fr','modules','dashboard.totalTodayAttendance','Présence aujourd\'hui','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19427,0,'fr','modules','dashboard.newTickets','Tickets ouverts','2023-06-04 06:27:21','2023-06-05 07:31:08'),
(19428,0,'fr','modules','dashboard.totalUnpaidInvoices','Factures dues','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19429,0,'fr','modules','dashboard.followUpDate','Date de suivi','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19430,0,'fr','modules','dashboard.pendingFollowUp','Suivi en attente','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19431,0,'fr','modules','dashboard.totalLeads','Nombre total de prospects','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19432,0,'fr','modules','dashboard.newLead','Nouvelle piste','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19433,0,'fr','modules','dashboard.newproduct','Nouveau produit','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19434,0,'fr','modules','dashboard.addNewproduct','Ajouter un nouveau produit','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19435,0,'fr','modules','dashboard.totalConvertedClient','Conversion totale de clients','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19436,0,'fr','modules','dashboard.totalPendingFollowUps','Suivi en attente','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19437,0,'fr','modules','dashboard.nextFollowUp','Suivi suivant','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19438,0,'fr','modules','dashboard.holidayCheck','Aujourd\'hui c\'est férié pour','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19439,0,'fr','modules','dashboard.totalArchiveProjects','Projets archivés','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19440,0,'fr','modules','dashboard.freeEmployees','Ne travaille pas sur le projet','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19441,0,'fr','modules','dashboard.dashboardWidgets','Widgets du tableau de bord','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19442,0,'fr','modules','dashboard.totalResolvedTickets','Tickets résolus','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19443,0,'fr','modules','dashboard.totalUnresolvedTickets','Tickets non résolus','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19444,0,'fr','modules','dashboard.clientFeedback','Commentaires des clients','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19445,0,'fr','modules','dashboard.totalActiveClients','Clients actifs','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19446,0,'fr','modules','dashboard.totalContractsSigned','Contrats signés','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19447,0,'fr','modules','dashboard.totalContractsGenerated','Contrats générés','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19448,0,'fr','modules','dashboard.totalLeadConversions','Conversions de prospects','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19449,0,'fr','modules','dashboard.latestClient','Derniers clients','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19450,0,'fr','modules','dashboard.recentLoginActivities','Activités de connexion récentes','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19451,0,'fr','modules','dashboard.clientWiseEarnings','Bénéfices avisés du client','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19452,0,'fr','modules','dashboard.clientWiseTimelogs','Journaux Client Wise','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19453,0,'fr','modules','dashboard.leadVsStatus','Nombre de prospects par statut','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19454,0,'fr','modules','dashboard.leadVsSource','Nombre de prospects par source','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19455,0,'fr','modules','dashboard.totalExpenses','Dépenses totales','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19456,0,'fr','modules','dashboard.totalEarnings','Total des gains','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19457,0,'fr','modules','dashboard.totalProfit','Bénéfice total','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19458,0,'fr','modules','dashboard.totalPendingAmount','Montant total en attente','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19459,0,'fr','modules','dashboard.earningsByClient','Gains par client','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19460,0,'fr','modules','dashboard.earningsByProjects','Gains par projets','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19461,0,'fr','modules','dashboard.lastReceivedPayments','Derniers paiements reçus','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19462,0,'fr','modules','dashboard.invoiceTab','Factures','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19463,0,'fr','modules','dashboard.estimateTab','Estimations','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19464,0,'fr','modules','dashboard.expenseTab','Dépenses','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19465,0,'fr','modules','dashboard.paymentTab','Paiements','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19466,0,'fr','modules','dashboard.duePaymentsTab','Paiements dus','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19467,0,'fr','modules','dashboard.proposalTab','Les propositions','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19468,0,'fr','modules','dashboard.invoiceOverview','Aperçu de la facture','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19469,0,'fr','modules','dashboard.invoiceDraft','Brouillon','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19470,0,'fr','modules','dashboard.invoiceNotSent','Pas envoyé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19471,0,'fr','modules','dashboard.invoiceUnpaid','Non payé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19472,0,'fr','modules','dashboard.invoicePartiallyPaid','Partiellement payé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19473,0,'fr','modules','dashboard.invoiceOverdue','En retard','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19474,0,'fr','modules','dashboard.invoicePaid','Payé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19475,0,'fr','modules','dashboard.estimateOverview','Aperçu de l\'estimation','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19476,0,'fr','modules','dashboard.estimateDraft','Brouillon','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19477,0,'fr','modules','dashboard.estimateNotSent','Pas envoyé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19478,0,'fr','modules','dashboard.estimateSent','Envoyé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19479,0,'fr','modules','dashboard.estimateExpired','Expiré','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19480,0,'fr','modules','dashboard.estimateDeclined','Diminué','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19481,0,'fr','modules','dashboard.estimateAccepted','Accepté','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19482,0,'fr','modules','dashboard.proposalOverview','Présentation de la proposition','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19483,0,'fr','modules','dashboard.proposalWaiting','En attendant','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19484,0,'fr','modules','dashboard.proposalConverted','Converti','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19485,0,'fr','modules','dashboard.proposalDeclined','Diminué','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19486,0,'fr','modules','dashboard.proposalAccepted','Accepté','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19487,0,'fr','modules','dashboard.proposalExpired','Expiré','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19488,0,'fr','modules','dashboard.totalNewEmployee','Nouveaux employés','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19489,0,'fr','modules','dashboard.totalEmployeeExits','Départs des employés','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19490,0,'fr','modules','dashboard.departmentWiseEmployee','Employé sage du département','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19491,0,'fr','modules','dashboard.designationWiseEmployee','Désignation Employé avisé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19492,0,'fr','modules','dashboard.genderWiseEmployee','Employé sensible au genre','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19493,0,'fr','modules','dashboard.roleWiseEmployee','Employé avisé','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19494,0,'fr','modules','dashboard.averageAttendance','Fréquentation moyenne','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19495,0,'fr','modules','dashboard.lateAttendanceMark','Présence tardive','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19496,0,'fr','modules','dashboard.lateMark','Marque tardive','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19497,0,'fr','modules','dashboard.totalProject','Projets totaux','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19498,0,'fr','modules','dashboard.totalOverdueProject','Projet en retard total','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19499,0,'fr','modules','dashboard.statusWiseProject','Projets d\'état d\'avancement','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19500,0,'fr','modules','dashboard.pendingMilestone','Jalon en attente','2023-06-04 06:27:22','2023-06-05 07:31:08'),
(19501,0,'fr','modules','dashboard.totalUnassignedTicket','Nombre total de tickets non attribués','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19502,0,'fr','modules','dashboard.typeWiseTicket','Billet Type Wise','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19503,0,'fr','modules','dashboard.statusWiseTicket','Statuts de ticket','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19504,0,'fr','modules','dashboard.channelWiseTicket','Billet Channel Wise','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19505,0,'fr','modules','dashboard.thisMonth','Ce mois-ci','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19506,0,'fr','modules','dashboard.timelogs','Journaux','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19507,0,'fr','modules','dashboard.privateTaskInfo','Tâches privées non incluses','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19508,0,'fr','modules','dashboard.verificationPending','Vérification du compte en attente','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19509,0,'fr','modules','dashboard.verificationPendingInfo','La vérification de votre compte est en attente par le propriétaire.','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19510,0,'fr','modules','dashboard.birthday','Anniversaires','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19511,0,'fr','modules','dashboard.inDays','dans :days jours','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19512,0,'fr','modules','dashboard.inDay','en :days jour','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19513,0,'fr','modules','dashboard.profile','Profil','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19514,0,'fr','modules','dashboard.shiftSchedule','Horaire de travail','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19515,0,'fr','modules','dashboard.notices','Avis','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19516,0,'fr','modules','dashboard.tasks','Tâches','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19517,0,'fr','modules','dashboard.projects','Projets','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19518,0,'fr','modules','dashboard.myTask','Mes tâches','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19519,0,'fr','modules','dashboard.myCalender','Mon calendrier','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19520,0,'fr','modules','dashboard.weekTimelog','Journaux hebdomadaires','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19521,0,'fr','modules','dashboard.lead','Fils','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19522,0,'fr','modules','dashboard.workFromHome','Sur le travail à domicile aujourd\'hui','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19523,0,'fr','modules','dashboard.fullDay','Journée complète','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19524,0,'fr','modules','dashboard.headcount','Effectif','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19525,0,'fr','modules','dashboard.appreciation','Appréciations','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19526,0,'fr','modules','dashboard.joiningVsAttrition','Rejoindre Vs Attrition','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19527,0,'fr','modules','dashboard.workAnniversary','Anniversaire de travail','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19528,0,'fr','modules','dashboard.joinedToday','Rejoint aujourd\'hui','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19529,0,'fr','modules','dashboard.ticket','Ticket d\'assistance','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19530,0,'fr','modules','dashboard.noticePeriodDuration','Durée de la période de préavis','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19531,0,'fr','modules','dashboard.probationDate','Date d\'essai','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19532,0,'fr','modules','dashboard.internshipDate','Date du stage','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19533,0,'fr','modules','dashboard.contractDate','Date de contrat','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19534,0,'fr','modules','dashboard.dashboardWidgetsSettings','Paramètres des widgets du tableau de bord','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19535,0,'fr','modules','client.createNote','Ajouter une note','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19536,0,'fr','modules','client.noteTitle','Titre de la remarque','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19537,0,'fr','modules','client.noteType','Type de note','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19538,0,'fr','modules','client.noteDetail','Détail de la note','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19539,0,'fr','modules','client.visibleToClient','Visible par le client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19540,0,'fr','modules','client.askToReenterPassword','Demander de ressaisir le mot de passe','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19541,0,'fr','modules','client.createTitle','Ajouter des informations sur le client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19542,0,'fr','modules','client.companyDetails','Détails de l\'entreprise','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19543,0,'fr','modules','client.companyName','Nom de l\'entreprise','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19544,0,'fr','modules','client.website','Site officiel','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19545,0,'fr','modules','client.address','Adresse','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19546,0,'fr','modules','client.clientDetails','Détails du client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19547,0,'fr','modules','client.clientBasicDetails','Détails de base du client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19548,0,'fr','modules','client.clientOtherDetails','Autres détails','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19549,0,'fr','modules','client.clientName','Nom du client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19550,0,'fr','modules','client.clientEmail','Courriel du client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19551,0,'fr','modules','client.clientPhone','Téléphone du client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19552,0,'fr','modules','client.emailNote','Le client se connectera à l\'aide de cet e-mail et des notifications par e-mail seront envoyées à cet e-mail.','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19553,0,'fr','modules','client.password','Mot de passe','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19554,0,'fr','modules','client.passwordNote','Le client se connectera en utilisant ce mot de passe.','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19555,0,'fr','modules','client.passwordUpdateNote','Laissez vide pour conserver le mot de passe actuel.','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19556,0,'fr','modules','client.mobile','Mobile','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19557,0,'fr','modules','client.updateTitle','Mettre à jour les informations client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19558,0,'fr','modules','client.addNewClient','Ajouter un nouveau client','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19559,0,'fr','modules','client.viewDetails','Voir les détails','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19560,0,'fr','modules','client.projectName','nom du projet','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19561,0,'fr','modules','client.startedOn','Commencé le','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19562,0,'fr','modules','client.deadline','Date limite','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19563,0,'fr','modules','client.generateRandomPassword','Générer un mot de passe aléatoire','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19564,0,'fr','modules','client.offline','Hors ligne','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19565,0,'fr','modules','client.online','En ligne','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19566,0,'fr','modules','client.all','Tous','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19567,0,'fr','modules','client.sendCredentials','Envoyer les informations d\'identification','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19568,0,'fr','modules','client.sendCredentialsMessage','Voulez-vous envoyer des informations d\'identification par e-mail au client ?','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19569,0,'fr','modules','client.assignProject','Attribuer un projet','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19570,0,'fr','modules','client.cell','Cellule','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19571,0,'fr','modules','client.officePhoneNumber','Numéro de téléphone du bureau','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19572,0,'fr','modules','client.addedOn','Ajouté le','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19573,0,'fr','modules','client.clientCategory','Catégorie de clients','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19574,0,'fr','modules','client.clientSubCategory','Sous-catégorie de clients','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19575,0,'fr','modules','client.profileInfo','Informations sur le profil','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19576,0,'fr','modules','client.clientCanLogin','Connexion autorisée ?','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19577,0,'fr','modules','client.salutation','Salutation','2023-06-04 06:27:23','2023-06-05 07:31:08'),
(19578,0,'fr','modules','credit-notes.currency','Monnaie','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19579,0,'fr','modules','credit-notes.creditNoteDate','Date de la note de crédit','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19580,0,'fr','modules','credit-notes.isRecurringPayment','Est-ce un paiement récurrent ?','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19581,0,'fr','modules','credit-notes.item','Article','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19582,0,'fr','modules','credit-notes.qty','Quantité','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19583,0,'fr','modules','credit-notes.unitPrice','Prix ​​unitaire','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19584,0,'fr','modules','credit-notes.tax','Impôt','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19585,0,'fr','modules','credit-notes.amount','Montant','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19586,0,'fr','modules','credit-notes.addItem','Ajouter un item','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19587,0,'fr','modules','credit-notes.subTotal','Sous-total','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19588,0,'fr','modules','credit-notes.discount','Rabais','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19589,0,'fr','modules','credit-notes.total','Total','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19590,0,'fr','modules','credit-notes.addCreditNote','Ajouter une note de crédit','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19591,0,'fr','modules','credit-notes.billingFrequency','Fréquence de facturation','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19592,0,'fr','modules','credit-notes.billingInterval','Intervalle de facturation','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19593,0,'fr','modules','credit-notes.billingCycle','Cycle de facturation','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19594,0,'fr','modules','credit-notes.billedTo','Facturé à','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19595,0,'fr','modules','credit-notes.generatedBy','Généré par','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19596,0,'fr','modules','credit-notes.price','Prix','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19597,0,'fr','modules','credit-notes.downloadPdf','Télécharger le PDF','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19598,0,'fr','modules','credit-notes.creditAmountTotal','Montant total du crédit','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19599,0,'fr','modules','credit-notes.creditAmountRemaining','Crédits restants','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19600,0,'fr','modules','credit-notes.creditAmountUsed','Montant du crédit utilisé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19601,0,'fr','modules','credit-notes.applyToInvoice','Appliquer des crédits à la facture','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19602,0,'fr','modules','credit-notes.closed','Fermé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19603,0,'fr','modules','credit-notes.open','Ouvrir','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19604,0,'fr','modules','credit-notes.paid','Payé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19605,0,'fr','modules','credit-notes.unpaid','Non payé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19606,0,'fr','modules','credit-notes.partial','Partiel','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19607,0,'fr','modules','credit-notes.uploadInvoice','Télécharger la facture','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19608,0,'fr','modules','credit-notes.addTtax','Ajouter une taxe','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19609,0,'fr','modules','contacts.addContact','Ajouter le contact','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19610,0,'fr','modules','contacts.contactName','Nom du contact','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19611,0,'fr','modules','employees.addNewEmployee','Ajouter un nouvel employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19612,0,'fr','modules','employees.createTitle','Ajouter des informations sur l\'employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19613,0,'fr','modules','employees.employeeName','Nom de l\'employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19614,0,'fr','modules','employees.employeeEmail','Courriel de l\'employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19615,0,'fr','modules','employees.emailNote','L\'employé se connectera à l\'aide de cet e-mail.','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19616,0,'fr','modules','employees.employeePassword','Mot de passe','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19617,0,'fr','modules','employees.passwordNote','L\'employé se connectera à l\'aide de ce mot de passe.','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19618,0,'fr','modules','employees.jobTitle','Titre d\'emploi','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19619,0,'fr','modules','employees.hourlyRate','Taux horaire','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19620,0,'fr','modules','employees.updateTitle','mettre à jour les informations sur l\'employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19621,0,'fr','modules','employees.updatePasswordNote','L\'employé se connectera à l\'aide de ce mot de passe. (Laissez vide pour conserver le mot de passe actuel)','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19622,0,'fr','modules','employees.tasksDone','Tâches effectuées','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19623,0,'fr','modules','employees.hoursLogged','Heures enregistrées','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19624,0,'fr','modules','employees.activity','Activité','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19625,0,'fr','modules','employees.profile','Profil','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19626,0,'fr','modules','employees.fullName','Nom et prénom','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19627,0,'fr','modules','employees.startTime','Heure de début','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19628,0,'fr','modules','employees.endTime','Heure de fin','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19629,0,'fr','modules','employees.totalHours','Heures totales','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19630,0,'fr','modules','employees.totalMinutes','Minutes totales','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19631,0,'fr','modules','employees.memo','Note','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19632,0,'fr','modules','employees.slackUsername','ID de membre Slack','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19633,0,'fr','modules','employees.joiningDate','Date d\'entrée en fonction','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19634,0,'fr','modules','employees.workAnniversary','Anniversaire de travail','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19635,0,'fr','modules','employees.joineeAndWorkAnniversary','Anniversaire d\'adhésion et de travail d\'aujourd\'hui','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19636,0,'fr','modules','employees.gender','Genre','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19637,0,'fr','modules','employees.title','Sélectionnez l\'employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19638,0,'fr','modules','employees.role','Rôle','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19639,0,'fr','modules','employees.lastDate','Date de sortie','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19640,0,'fr','modules','employees.employeeId','ID d\'employé','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19641,0,'fr','modules','employees.chooseDepartment','Choisissez le département','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19642,0,'fr','modules','employees.chooseDesignation','Choisissez la désignation','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19643,0,'fr','modules','employees.chooseStatus','Choisissez le statut','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19644,0,'fr','modules','employees.pendingTasks','Tâches en attente','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19645,0,'fr','modules','employees.department','Département','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19646,0,'fr','modules','employees.designation','Désignation','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19647,0,'fr','modules','employees.status','Statut','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19648,0,'fr','modules','employees.employeeIdInfo','L\'identifiant de l\'employé est l\'identifiant unique distribué aux employés','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19649,0,'fr','modules','employees.employeeIdHelp','<p>Identifiant unique que vous utilisez pour identifier les employés de votre organisation.</p><p>Pour les employés créés via <b>Inviter</b>, un identifiant d\'employé est automatiquement généré, que vous pouvez modifier ultérieurement.</p >','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19650,0,'fr','modules','employees.accountDetails','Détails du compte','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19651,0,'fr','modules','employees.inviteLink','Inviter par lien','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19652,0,'fr','modules','employees.inviteEmail','Inviter par email','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19653,0,'fr','modules','employees.sendInvite','Envoyer une invitation','2023-06-04 06:27:24','2023-06-05 07:31:08'),
(19654,0,'fr','modules','employees.createLink','Créer un lien','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19655,0,'fr','modules','employees.createLinkLabel','Créez un lien d\'invitation pour que les membres puissent vous rejoindre.','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19656,0,'fr','modules','employees.allowAnyEmail','Autoriser n\'importe quelle adresse e-mail','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19657,0,'fr','modules','employees.onlyAllow','Autoriser uniquement les adresses e-mail avec domaine','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19658,0,'fr','modules','employees.message','Ajouter un message (facultatif)','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19659,0,'fr','modules','employees.exEmployee','Ex employé','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19660,0,'fr','modules','employees.dateOfBirth','Date de naissance','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19661,0,'fr','modules','employees.reportingTo','Rapport à','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19662,0,'fr','modules','employees.reportingTeam','Équipe de signalement','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19663,0,'fr','modules','employees.probationEndDate','Date de fin de probation','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19664,0,'fr','modules','employees.noticePeriodStartDate','Date de début de la période de préavis','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19665,0,'fr','modules','employees.noticePeriodEndDate','Date de fin de la période de préavis','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19666,0,'fr','modules','employees.internshipEndDate','Date de fin de stage','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19667,0,'fr','modules','employees.contractEndDate','Date de fin du contrat','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19668,0,'fr','modules','employees.maritalStatus','État civil','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19669,0,'fr','modules','employees.marriageAnniversaryDate','Date d\'anniversaire de mariage','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19670,0,'fr','modules','employees.employmentType','Type d\'emploi','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19671,0,'fr','modules','employees.immigration','Immigration','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19672,0,'fr','modules','employees.passportDetails','Informations du passeport','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19673,0,'fr','modules','employees.passportNumber','Numéro de passeport','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19674,0,'fr','modules','employees.visaNumber','Numéro de visa','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19675,0,'fr','modules','employees.issueDate','Date d\'émission','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19676,0,'fr','modules','employees.expiryDate','Date d\'expiration','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19677,0,'fr','modules','employees.scanCopy','Numérisation Copie','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19678,0,'fr','modules','employees.visaDetails','Détails du visa','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19679,0,'fr','modules','projects.addNewProject','Ajouter un nouveau projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19680,0,'fr','modules','projects.projectName','nom du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19681,0,'fr','modules','projects.projectMembers','Membres du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19682,0,'fr','modules','projects.createTitle','Ajouter un projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19683,0,'fr','modules','projects.selectClient','Sélectionnez Client','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19684,0,'fr','modules','projects.startDate','Date de début','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19685,0,'fr','modules','projects.deadline','Date limite','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19686,0,'fr','modules','projects.projectSummary','Résumé du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19687,0,'fr','modules','projects.projectDetails','détails du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19688,0,'fr','modules','projects.updateTitle','Mettre à jour les détails du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19689,0,'fr','modules','projects.projectCategory','Catégorie de projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19690,0,'fr','modules','projects.manageProjectCategory','Gérer la catégorie','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19691,0,'fr','modules','projects.clientFeedback','Commentaires des clients','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19692,0,'fr','modules','projects.projectCompletionStatus','Statut d\'achèvement du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19693,0,'fr','modules','projects.overview','Aperçu','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19694,0,'fr','modules','projects.members','Membres','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19695,0,'fr','modules','projects.files','Des dossiers','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19696,0,'fr','modules','projects.activeTimers','Minuteries actives','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19697,0,'fr','modules','projects.whoWorking','Qui travaille','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19698,0,'fr','modules','projects.activeSince','Actif depuis','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19699,0,'fr','modules','projects.openTasks','Tâches ouvertes','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19700,0,'fr','modules','projects.daysLeft','Jours restants','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19701,0,'fr','modules','projects.hoursLogged','Heures enregistrées','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19702,0,'fr','modules','projects.issuesPending','Problèmes en attente','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19703,0,'fr','modules','projects.activityTimeline','Chronologie des activités','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19704,0,'fr','modules','projects.addMemberTitle','Ajouter des membres au projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19705,0,'fr','modules','projects.uploadFile','Téléverser un fichier','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19706,0,'fr','modules','projects.dropFile','Déposez les fichiers ici OU cliquez pour télécharger','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19707,0,'fr','modules','projects.updateSuccess','détails du projet mis à jour.','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19708,0,'fr','modules','projects.calculateTasksProgress','Calculer la progression des tâches','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19709,0,'fr','modules','projects.viewGanttChart','Diagramme de Gantt','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19710,0,'fr','modules','projects.clientViewTask','Le client peut gérer les tâches de ce projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19711,0,'fr','modules','projects.manualTimelog','Autoriser les journaux de temps manuels','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19712,0,'fr','modules','projects.clientTaskNotification','Envoyer une notification de tâche au client','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19713,0,'fr','modules','projects.selectPayment','La passerelle de paiement est requise lorsque le statut de paiement est Activer','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19714,0,'fr','modules','projects.allProject','Tous les projets','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19715,0,'fr','modules','projects.withoutDeadline','Il n\'y a pas de date limite de projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19716,0,'fr','modules','projects.pause','Pause','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19717,0,'fr','modules','projects.resume','CV','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19718,0,'fr','modules','projects.cancel','Annuler','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19719,0,'fr','modules','projects.activate','Activer','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19720,0,'fr','modules','projects.projectInfo','Informations sur le projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19721,0,'fr','modules','projects.clientInfo','Informations client','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19722,0,'fr','modules','projects.budgetInfo','Informations budgétaires','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19723,0,'fr','modules','projects.projectBudget','Budget du projet','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19724,0,'fr','modules','projects.hours_allocated','Estimation des heures (en heures)','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19725,0,'fr','modules','projects.milestones','Jalons','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19726,0,'fr','modules','projects.createMilestone','Créer un jalon','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19727,0,'fr','modules','projects.editMilestone','Modifier le jalon','2023-06-04 06:27:25','2023-06-05 07:31:08'),
(19728,0,'fr','modules','projects.milestoneCost','Coût d\'étape','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19729,0,'fr','modules','projects.milestoneTitle','Titre de l\'étape','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19730,0,'fr','modules','projects.milestoneSummary','Résumé des jalons','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19731,0,'fr','modules','projects.milestoneStartDate','Date de début du jalon','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19732,0,'fr','modules','projects.milestoneEndDate','Date de fin du jalon','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19733,0,'fr','modules','projects.projectEarningInfo','Calculé à partir du module de paiement','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19734,0,'fr','modules','projects.otherInfo','Autre info','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19735,0,'fr','modules','projects.expenses_total','Dépenses','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19736,0,'fr','modules','projects.projectExpenseInfo','Calculé à partir du module des dépenses','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19737,0,'fr','modules','projects.addFileLink','Ajouter un lien de fichier','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19738,0,'fr','modules','projects.selfAssignAsProjectMember','Ajoutez-moi comme membre du projet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19739,0,'fr','modules','projects.viewPublicGanttChart','Diagramme de Gantt public','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19740,0,'fr','modules','projects.burndownChart','Tableau de combustion','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19741,0,'fr','modules','projects.fileName','Nom de fichier','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19742,0,'fr','modules','projects.discussion','Discussion','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19743,0,'fr','modules','projects.rating','Notation','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19744,0,'fr','modules','projects.addCostProjectBudget','Ajouter un coût au budget du projet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19745,0,'fr','modules','projects.chooseMembers','Choisissez les membres','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19746,0,'fr','modules','projects.chooseDepartment','Choisissez le département','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19747,0,'fr','modules','projects.hideFinishedProjects','Masquer les projets terminés','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19748,0,'fr','modules','projects.projectProgress','L\'avancement du projet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19749,0,'fr','modules','projects.note','Remarques','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19750,0,'fr','modules','projects.visibleRatingToMembers','Évaluation visible pour les membres','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19751,0,'fr','modules','projects.noRatingAvailable','Aucune évaluation disponible','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19752,0,'fr','modules','projects.createPublicProject','Créer un projet public','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19753,0,'fr','modules','projects.createPrivateProject','Changer en projet privé','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19754,0,'fr','modules','projects.changeToPublicProject','Passer au projet public','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19755,0,'fr','modules','projects.projectAdminInfo','L\'administrateur du projet peut ajouter un membre du projet, des tâches, des discussions, des notes, des fichiers, des jalons','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19756,0,'fr','modules','projects.enableMiroboard','Activer la carte Miro','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19757,0,'fr','modules','projects.miroBoardId','ID de carte Miro','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19758,0,'fr','modules','projects.clientMiroAccess','Le client peut accéder à Miro','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19759,0,'fr','modules','projects.projectClient','Détails du client du projet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19760,0,'fr','modules','projects.projectDoNotHaveClient','Ce projet ne contient aucun client','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19761,0,'fr','modules','projects.projectStatusSettings','Paramètres d\'état du projet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19762,0,'fr','modules','projects.sameAssignee','Copier les mêmes destinataires','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19763,0,'fr','modules','tasks.noSubTaskFound','Aucune sous-tâche trouvée','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19764,0,'fr','modules','tasks.selectProject','Sélectionnez un projet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19765,0,'fr','modules','tasks.hideCompletedTask','Masquer la tâche terminée','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19766,0,'fr','modules','tasks.newTask','Nouvelle tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19767,0,'fr','modules','tasks.myTask','Mes tâches','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19768,0,'fr','modules','tasks.changeStatus','Modifier le statut','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19769,0,'fr','modules','tasks.lastCreated','Dernière création','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19770,0,'fr','modules','tasks.dueSoon','Dû bientôt','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19771,0,'fr','modules','tasks.dueDate','Date d\'échéance','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19772,0,'fr','modules','tasks.assignTo','Assigné à','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19773,0,'fr','modules','tasks.high','Haut','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19774,0,'fr','modules','tasks.medium','Moyen','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19775,0,'fr','modules','tasks.low','Faible','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19776,0,'fr','modules','tasks.priority','Priorité','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19777,0,'fr','modules','tasks.selectPriority','Sélectionnez la priorité','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19778,0,'fr','modules','tasks.updateTask','Mettre à jour la tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19779,0,'fr','modules','tasks.chooseAssignee','Choisissez le cessionnaire','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19780,0,'fr','modules','tasks.taskDetail','Détail de la tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19781,0,'fr','modules','tasks.taskBoard','Tableau des tâches','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19782,0,'fr','modules','tasks.addBoardColumn','Ajouter une colonne de statut','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19783,0,'fr','modules','tasks.boardColumn','Colonne du Conseil','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19784,0,'fr','modules','tasks.columnName','Nom de colonne','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19785,0,'fr','modules','tasks.labelColor','Couleur de l\'étiquette','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19786,0,'fr','modules','tasks.tasksTable','Tableau des tâches','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19787,0,'fr','modules','tasks.position','Position de la colonne du tableau','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19788,0,'fr','modules','tasks.subTask','Sous-tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19789,0,'fr','modules','tasks.comment','Commentaire','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19790,0,'fr','modules','tasks.taskCategory','Catégorie de tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19791,0,'fr','modules','tasks.selectTaskCategory','Sélectionnez la catégorie de tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19792,0,'fr','modules','tasks.noTaskCategory','Aucune catégorie de tâche disponible','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19793,0,'fr','modules','tasks.category','Catégorie','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19794,0,'fr','modules','tasks.assignBy','Assigné par','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19795,0,'fr','modules','tasks.markComplete','Marquer comme complet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19796,0,'fr','modules','tasks.markIncomplete','Marquer comme incomplet','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19797,0,'fr','modules','tasks.reminder','Envoyer un rappel','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19798,0,'fr','modules','tasks.sectionVisibleClient','Section visible pour le client','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19799,0,'fr','modules','tasks.moveToBoard','Déplacer vers le tableau','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19800,0,'fr','modules','tasks.deleteRecurringTasks','Supprimer avec des tâches récurrentes','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19801,0,'fr','modules','tasks.dependent','La tâche dépend d\'une autre tâche','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19802,0,'fr','modules','tasks.dependentTask','Tâche dépendante','2023-06-04 06:27:26','2023-06-05 07:31:08'),
(19803,0,'fr','modules','tasks.chooseTask','Choisissez la tâche','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19804,0,'fr','modules','tasks.uplodedFiles','Fichiers téléchargés','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19805,0,'fr','modules','tasks.cyclesToolTip','Nombre de fois à répéter','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19806,0,'fr','modules','tasks.preDeadlineReminder','Envoyer un rappel de tâche <strong>avant</strong> X jours de la date d\'échéance','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19807,0,'fr','modules','tasks.onDeadlineReminder','Envoyer un rappel de tâche le jour de la date d\'échéance','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19808,0,'fr','modules','tasks.postDeadlineReminder','Envoyer un rappel de tâche <strong>après</strong> X jours de la date d\'échéance','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19809,0,'fr','modules','tasks.makePrivate','Rendre privé','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19810,0,'fr','modules','tasks.privateInfo','Les tâches privées ne sont visibles que pour l\'administrateur, le cédant et le cessionnaire.','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19811,0,'fr','modules','tasks.createActivity','La tâche est créée par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19812,0,'fr','modules','tasks.updateActivity','Les détails de la tâche sont mis à jour par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19813,0,'fr','modules','tasks.statusActivity','État de la tâche modifié par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19814,0,'fr','modules','tasks.commentActivity','Commentaire ajouté par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19815,0,'fr','modules','tasks.fileActivity','Le fichier est téléchargé par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19816,0,'fr','modules','tasks.subTaskCreateActivity','La sous-tâche est créée par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19817,0,'fr','modules','tasks.subTaskUpdateActivity','La sous-tâche est mise à jour par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19818,0,'fr','modules','tasks.history','Histoire','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19819,0,'fr','modules','tasks.defaultTaskStatus','État de la tâche par défaut','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19820,0,'fr','modules','tasks.billable','Facturable','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19821,0,'fr','modules','tasks.billableInfo','Une facture peut être générée pour le journal de temps de cette tâche.','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19822,0,'fr','modules','tasks.assigned','Attribué','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19823,0,'fr','modules','tasks.taskLabel','Libellé de la tâche','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19824,0,'fr','modules','tasks.assignMe','Attribuez-moi','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19825,0,'fr','modules','tasks.setTimeEstimate','Estimation du temps','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19826,0,'fr','modules','tasks.users','Utilisateurs','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19827,0,'fr','modules','tasks.taskInfo','Infos sur la tâche','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19828,0,'fr','modules','tasks.loadMore','Charger plus','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19829,0,'fr','modules','tasks.taskboardDefaultLength','Longueur par défaut du tableau des tâches','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19830,0,'fr','modules','tasks.timerStartedTask','Démarrage du chronomètre pour la tâche','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19831,0,'fr','modules','tasks.timerStartedBy','Minuterie démarrée','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19832,0,'fr','modules','tasks.timerStartedProject','Démarrage du minuteur pour le projet','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19833,0,'fr','modules','tasks.timerStoppedBy','Minuterie arrêtée','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19834,0,'fr','modules','tasks.copyTaskLink','Copier le lien de la tâche','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19835,0,'fr','modules','tasks.timerPausedBy','Minuterie en pause','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19836,0,'fr','modules','tasks.unassigned','Non attribué','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19837,0,'fr','modules','tasks.like','Comme','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19838,0,'fr','modules','tasks.dislike','Ne pas aimer','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19839,0,'fr','modules','tasks.you','Toi','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19840,0,'fr','modules','tasks.likeUser',':user a réagi avec le pouce levé','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19841,0,'fr','modules','tasks.dislikeUser',':user a réagi avec le pouce vers le bas','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19842,0,'fr','modules','tasks.repeatInfo','La tâche sera créée automatiquement tous les X jours.','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19843,0,'fr','modules','tasks.leaveMessage','Un ou plusieurs cessionnaires sont en congé aux dates sélectionnées.','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19844,0,'fr','modules','tasks.leaveOn','est en congé','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19845,0,'fr','modules','tasks.editSubTask','Modifier la sous-tâche','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19846,0,'fr','modules','invoices.addInvoice','Créer une facture','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19847,0,'fr','modules','invoices.receivedPayment','j\'ai reçu le paiement','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19848,0,'fr','modules','invoices.paid','Payé','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19849,0,'fr','modules','invoices.unpaid','Non payé','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19850,0,'fr','modules','invoices.pending','En attente','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19851,0,'fr','modules','invoices.dueDate','Date d\'échéance','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19852,0,'fr','modules','invoices.on-hold','En attente','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19853,0,'fr','modules','invoices.failed','Échoué','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19854,0,'fr','modules','invoices.processing','Traitement','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19855,0,'fr','modules','invoices.completed','Complété','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19856,0,'fr','modules','invoices.refunded','Remboursé','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19857,0,'fr','modules','invoices.currency','Monnaie','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19858,0,'fr','modules','invoices.invoiceDate','Date de facturation','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19859,0,'fr','modules','invoices.projectName','nom du projet','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19860,0,'fr','modules','invoices.item','Article','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19861,0,'fr','modules','invoices.qty','Quantité','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19862,0,'fr','modules','invoices.unitPrice','Prix ​​unitaire','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19863,0,'fr','modules','invoices.amount','Montant','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19864,0,'fr','modules','invoices.addItem','Ajouter un item','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19865,0,'fr','modules','invoices.subTotal','Sous-total','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19866,0,'fr','modules','invoices.discount','Rabais','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19867,0,'fr','modules','invoices.tax','Impôt','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19868,0,'fr','modules','invoices.total','Total','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19869,0,'fr','modules','invoices.billedTo','Facturé à','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19870,0,'fr','modules','invoices.billedFrom','Facturé à partir de','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19871,0,'fr','modules','invoices.generatedBy','Généré par','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19872,0,'fr','modules','invoices.price','Prix','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19873,0,'fr','modules','invoices.type','Type','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19874,0,'fr','modules','invoices.payPaypal','Payer via Paypal','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19875,0,'fr','modules','invoices.payPaystack','Payer via Paystack','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19876,0,'fr','modules','invoices.payFlutterwave','Payer via Flutterwave','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19877,0,'fr','modules','invoices.payMollie','Payer via Mollie','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19878,0,'fr','modules','invoices.payPayfast','Payer via Payfast','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19879,0,'fr','modules','invoices.payAuthorize','Payer via Autoriser','2023-06-04 06:27:27','2023-06-05 07:31:08'),
(19880,0,'fr','modules','invoices.paySquare','Payer via Square','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19881,0,'fr','modules','invoices.downloadPdf','Télécharger le PDF','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19882,0,'fr','modules','invoices.isRecurringPayment','Est-ce un paiement récurrent ?','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19883,0,'fr','modules','invoices.billingCycle','Cycle de facturation','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19884,0,'fr','modules','invoices.billingFrequency','Fréquence de facturation','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19885,0,'fr','modules','invoices.billingInterval','Intervalle de facturation','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19886,0,'fr','modules','invoices.recurringPayments','Paiement récurrent','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19887,0,'fr','modules','invoices.recurringInvoiceInfo','Informations sur la facture récurrente','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19888,0,'fr','modules','invoices.payNow','Payez maintenant','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19889,0,'fr','modules','invoices.payStripe','Payer via Stripe','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19890,0,'fr','modules','invoices.taxName','Nom fiscal','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19891,0,'fr','modules','invoices.rate','Taux','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19892,0,'fr','modules','invoices.payOffline','Payer hors ligne','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19893,0,'fr','modules','invoices.partial','Partiellement payé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19894,0,'fr','modules','invoices.due','Exigible','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19895,0,'fr','modules','invoices.uploadInvoice','Télécharger la facture','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19896,0,'fr','modules','invoices.project','Projet','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19897,0,'fr','modules','invoices.payRazorpay','Payer via Razorpay','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19898,0,'fr','modules','invoices.copyPaymentLink','Copier le lien de paiement','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19899,0,'fr','modules','invoices.appliedCredits','Crédits appliqués','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19900,0,'fr','modules','invoices.amountDue','Montant dû','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19901,0,'fr','modules','invoices.amountPaid','Le montant payé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19902,0,'fr','modules','invoices.markCancel','Marquer comme annulé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19903,0,'fr','modules','invoices.showShippingAddress','Afficher l\'adresse de livraison','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19904,0,'fr','modules','invoices.showShippingAddressInfo','Afficher l\'adresse de livraison sur les factures','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19905,0,'fr','modules','invoices.notSent','Pas envoyé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19906,0,'fr','modules','invoices.draft','Brouillon','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19907,0,'fr','modules','invoices.buy','Acheter','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19908,0,'fr','modules','invoices.infinite','Pour des dépenses infinies','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19909,0,'fr','modules','invoices.assignMe','Attribuez-moi','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19910,0,'fr','modules','invoices.totalUnpaidInvoice','Total des factures impayées','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19911,0,'fr','modules','invoices.to','Pour','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19912,0,'fr','modules','invoices.paymentMethod','Mode de paiement','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19913,0,'fr','modules','invoices.paidOn','Payé le','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19914,0,'fr','modules','invoices.invoiceNumber','Numéro de facture','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19915,0,'fr','modules','invoices.billingAddress','adresse de facturation','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19916,0,'fr','modules','invoices.shippingAddress','adresse de livraison','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19917,0,'fr','modules','invoices.note','note pour le destinataire','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19918,0,'fr','modules','invoices.placeOrder','Passer la commande','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19919,0,'fr','modules','invoices.cardInfo','Informations sur la carte','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19920,0,'fr','modules','invoices.canceled','Annulé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19921,0,'fr','modules','invoices.calculateTax','Calculer la taxe','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19922,0,'fr','modules','invoices.afterDiscount','Après remise','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19923,0,'fr','modules','invoices.beforeDiscount','Avant Remise','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19924,0,'fr','modules','invoices.unitType','Type d\'unité','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19925,0,'fr','modules','invoices.noOfBillingCycle','Nombre de cycles de facturation à facturer (fixer -1 pour des cycles infinis)','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19926,0,'fr','modules','invoices.totalCount','Le compte total','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19927,0,'fr','modules','invoices.customerCharged','Le client sera facturé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19928,0,'fr','modules','invoices.description','Description','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19929,0,'fr','modules','invoices.invoiceBalanceDue','Solde de la facture dû','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19930,0,'fr','modules','invoices.invoiceValue','Montant de la facture','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19931,0,'fr','modules','invoices.taxableValue','Valeur imposable','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19932,0,'fr','modules','invoices.editTax','Modifier la taxe','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19933,0,'fr','modules','invoices.paymentDescription','Description de paiement','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19934,0,'fr','modules','invoices.sameIp','C\'est la même IP que vous avez.','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19935,0,'fr','modules','issues.pending','En attente','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19936,0,'fr','modules','issues.addIssue','Ajouter un problème','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19937,0,'fr','modules','issues.updateIssue','Problème de mise à jour','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19938,0,'fr','modules','issues.resolved','Résolu','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19939,0,'fr','modules','issues.markPending','Marquer en attente','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19940,0,'fr','modules','issues.markResolved','Marquer résolu','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19941,0,'fr','modules','issues.reportedOn','Signalé le','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19942,0,'fr','modules','timeLogs.whoLogged','Qui s\'est connecté','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19943,0,'fr','modules','timeLogs.startTime','Heure de début','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19944,0,'fr','modules','timeLogs.endTime','Heure de fin','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19945,0,'fr','modules','timeLogs.totalHours','Heures totales','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19946,0,'fr','modules','timeLogs.totalMinutes','Minutes totales','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19947,0,'fr','modules','timeLogs.memo','Note','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19948,0,'fr','modules','timeLogs.lastUpdatedBy','Dernière mise à jour par','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19949,0,'fr','modules','timeLogs.employeeName','Nom de l\'employé','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19950,0,'fr','modules','timeLogs.startDate','Date de début','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19951,0,'fr','modules','timeLogs.endDate','Date de fin','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19952,0,'fr','modules','timeLogs.logTime','Heure du journal','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19953,0,'fr','modules','timeLogs.startTimer','Démarrer la minuterie','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19954,0,'fr','modules','timeLogs.stopTimer','Arrêter la minuterie','2023-06-04 06:27:28','2023-06-05 07:31:08'),
(19955,0,'fr','modules','timeLogs.selectProject','Sélectionnez un projet','2023-06-04 06:27:29','2023-06-05 07:31:08'),
(19956,0,'fr','modules','timeLogs.selectTask','Sélectionnez la tâche','2023-06-04 06:27:29','2023-06-05 07:31:08'),
(19957,0,'fr','modules','timeLogs.task','Tâche','2023-06-04 06:27:29','2023-06-05 07:31:08'),
(19958,0,'fr','modules','timeLogs.whenLogged','une fois connecté','2023-06-04 06:27:29','2023-06-05 07:31:08'),
(19959,0,'fr','modules','timeLogs.timeLogFrom','Heure du journal de','2023-06-04 06:27:29','2023-06-